/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class TaxLineSummary
extends SvrProcess {
    private int p_AD_Client_ID;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_AD_Org_ID = 0;
    private boolean p_IsSOTrx = true;
    private String p_Posted = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                    this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("Posted")) {
                    this.p_Posted = para[i].getParameterAsString();
                } else if (name.equals("IsSOTrx")) {
                    this.p_IsSOTrx = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String DateFrom = this.p_DateAcct_From.toString();
        String DateTo = this.p_DateAcct_To.toString();
        StringBuilder DateValue_from = new StringBuilder("TO_DATE('").append(DateFrom.substring(0, 10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS')");
        StringBuilder DateValue_to = new StringBuilder("TO_DATE('").append(DateTo.substring(0, 10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS') + CAST('1Day' AS INTERVAL)");
        StringBuilder sql = new StringBuilder("INSERT INTO T_TaxLineSumJP ").append("(AD_PInstance_ID, DateAcct, AD_Client_ID, AD_Org_ID,C_DocType_ID,IsSOTrx ,C_Tax_ID, C_Currency_ID, DocStatus, JP_Posted, TaxbaseAmt, TaxAmt)").append(" SELECT ").append(this.getAD_PInstance_ID()).append(", ").append(DateValue_from.toString()).append(", AD_Client_ID, AD_Org_ID,C_DocType_ID,IsSOTrx ,C_Tax_ID, C_Currency_ID, DocStatus, Posted, SUM(taxbaseamt),SUM(taxamt)").append(" FROM JP_TaxLine ").append(" WHERE AD_Client_ID = " + this.p_AD_Client_ID).append(" AND DateAcct >=" + DateValue_from.toString()).append(" AND DateAcct < " + DateValue_to.toString());
        if (this.p_AD_Org_ID != 0) {
            sql = sql.append(" AND AD_Org_ID=").append(this.p_AD_Org_ID);
        }
        sql = this.p_IsSOTrx ? sql.append(" AND IsSOTrx='Y'") : sql.append(" AND IsSOTrx='N'");
        if (!Util.isEmpty((String)this.p_Posted)) {
            sql = sql.append(" AND Posted='" + this.p_Posted + "'");
        }
        sql = sql.append(" GROUP BY AD_Client_ID, AD_Org_ID,C_DocType_ID,IsSOTrx,C_Tax_ID, C_Currency_ID,DocStatus, Posted ;");
        int InsertRecords = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Inserted Records=" + InsertRecords);
        }
        return "Inserted Records=" + InsertRecords;
    }
}

