/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Service;
import org.adempiere.model.GenericPO;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MPeriod;
import org.compiere.model.MRefList;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class Reposting
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Table_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private boolean p_IsSuccessLogJP = false;
    private boolean p_IsCloseLogJP = false;
    private String success = null;
    private String failure = null;
    private String skip = null;
    private String close = null;
    private int successNum = 0;
    private int errorNum = 0;
    private int skipNum = 0;
    private IProcessUI processUI = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("AD_Table_ID")) {
                    this.p_AD_Table_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = para[i].getParameterAsTimestamp();
                    this.p_DateAcct_To = para[i].getParameter_ToAsTimestamp();
                } else if (name.equals("IsSuccessLogJP")) {
                    this.p_IsSuccessLogJP = para[i].getParameterAsBoolean();
                } else if (name.equals("IsCloseLogJP")) {
                    this.p_IsCloseLogJP = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        this.success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        this.failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        this.skip = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfSkipRecords");
        this.close = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_Period_ID")) + " " + MRefList.getListName((Properties)this.getCtx(), (int)177, (String)"C");
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE t.IsView='N'";
        if (this.p_AD_Table_ID > 0) {
            sql = String.valueOf(sql) + " AND t.AD_Table_ID=" + this.p_AD_Table_ID;
        }
        sql = String.valueOf(sql) + " AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND c.IsActive='Y')";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int AD_Table_ID = rs.getInt(1);
                    String TableName = rs.getString(2);
                    this.reposting(AD_Table_ID, TableName);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + "(" + this.success + " : " + this.successNum + " / " + this.failure + " : " + this.errorNum + " / " + this.skip + " : " + this.skipNum + ")";
    }

    private void reposting(int AD_Table_ID, String TableName) {
        ArrayList<Integer> list;
        block24: {
            list = new ArrayList<Integer>();
            String sql = "SELECT DISTINCT Record_ID FROM Fact_Acct WHERE AD_Table_ID = ?";
            if (this.p_DateAcct_From != null) {
                sql = String.valueOf(sql) + " AND DateAcct >= ? AND DateAcct <= ?";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, AD_Table_ID);
                    if (this.p_DateAcct_From != null) {
                        pstmt.setTimestamp(2, this.p_DateAcct_From);
                        pstmt.setTimestamp(3, this.p_DateAcct_To);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(rs.getInt(1));
                    }
                }
                catch (SQLException sQLException) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block24;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        int[] records = new int[list.size()];
        int i = 0;
        while (i < records.length) {
            records[i] = (Integer)list.get(i);
            ++i;
        }
        GenericPO po = null;
        String docIdentifier = null;
        boolean isOpenPeriod = false;
        String error = null;
        int i2 = 0;
        while (i2 < records.length) {
            error = null;
            isOpenPeriod = MPeriod.isOpen((Properties)this.getCtx(), (int)AD_Table_ID, (int)records[i2], (String)this.get_TrxName());
            if (isOpenPeriod) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.p_AD_Client_ID, (int)AD_Table_ID, (int)records[i2], (boolean)true, (String)this.get_TrxName());
            }
            po = null;
            List factoryList = Service.locator().list(IModelFactory.class).getServices();
            if (factoryList != null) {
                for (IModelFactory factory : factoryList) {
                    po = factory.getPO(TableName, records[i2], this.get_TrxName());
                    if (po == null) continue;
                    if (po.get_ID() == records[i2] || records[i2] <= 0) break;
                    po = null;
                }
            }
            if (po == null && (po = new GenericPO(TableName, this.getCtx(), records[i2], this.get_TrxName())).get_ID() != records[i2] && records[i2] > 0) {
                po = null;
            }
            if (po != null) {
                docIdentifier = po.get_ColumnIndex("DocumentNo") > 0 ? po.get_Value("DocumentNo").toString() : (po.get_ColumnIndex("Name") > 0 ? po.get_Value("Name").toString() : String.valueOf(TableName) + "[" + records[i2] + "]");
                if (isOpenPeriod) {
                    if (Util.isEmpty((String)error)) {
                        if (this.processUI != null) {
                            this.processUI.statusUpdate(String.valueOf(this.success) + " : " + docIdentifier);
                        }
                        if (this.p_IsSuccessLogJP) {
                            this.addLog(0, null, null, String.valueOf(this.success) + " : " + docIdentifier, AD_Table_ID, records[i2]);
                        }
                        ++this.successNum;
                    } else {
                        if (this.processUI != null) {
                            this.processUI.statusUpdate(String.valueOf(this.failure) + " : " + docIdentifier);
                        }
                        this.addLog(0, null, null, String.valueOf(this.failure) + " : " + docIdentifier, AD_Table_ID, records[i2]);
                        ++this.errorNum;
                    }
                } else {
                    if (this.processUI != null) {
                        this.processUI.statusUpdate(String.valueOf(this.close) + " : " + docIdentifier);
                    }
                    if (this.p_IsCloseLogJP) {
                        this.addBufferLog(0, null, null, String.valueOf(this.close) + " : " + docIdentifier, AD_Table_ID, records[i2]);
                    }
                    ++this.skipNum;
                }
            }
            ++i2;
        }
    }
}

