/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.List;
import java.util.Properties;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PaymentBatchReverse
extends SvrProcess {
    private int C_PaymentBatch_ID = 0;

    protected void prepare() {
        this.C_PaymentBatch_ID = this.getProcessInfo().getRecord_ID();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String doIt() throws Exception {
        MPaymentBatch paymentBatch = new MPaymentBatch(this.getCtx(), this.C_PaymentBatch_ID, this.get_TrxName());
        if (paymentBatch.get_ColumnIndex("JP_BankStatement_ID") != -1 && paymentBatch.get_ValueAsInt("JP_BankStatement_ID") > 0) {
            MBankStatement m_BankStatement = new MBankStatement(this.getCtx(), paymentBatch.get_ValueAsInt("JP_BankStatement_ID"), this.get_TrxName());
            if (m_BankStatement.getDocStatus().equals("CO")) {
                if (!m_BankStatement.processIt("VO")) throw new Exception(m_BankStatement.getProcessMsg());
                m_BankStatement.saveEx(this.get_TrxName());
            } else if (m_BankStatement.getDocStatus().equals("DR") || m_BankStatement.getDocStatus().equals("IP")) {
                if (!m_BankStatement.processIt("VO")) throw new Exception(m_BankStatement.getProcessMsg());
                m_BankStatement.saveEx(this.get_TrxName());
            } else if (!m_BankStatement.getDocStatus().equals("VO") && !m_BankStatement.getDocStatus().equals("RE")) {
                if (!m_BankStatement.getDocStatus().equals("CL")) throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CannotVoid")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_BankStatement_ID") + " : " + m_BankStatement.getDocumentNo());
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CannotVoid")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_BankStatement_ID") + " : " + m_BankStatement.getDocumentNo());
            }
        }
        int successPayment = 0;
        int skipPayment = 0;
        int successInvoice = 0;
        int skipInvoice = 0;
        String whereClause = "C_PaymentBatch_ID = ?";
        String orderClause = "DocumentNo";
        List list = new Query(this.getCtx(), "C_Payment", whereClause, this.get_TrxName()).setParameters(new Object[]{this.C_PaymentBatch_ID}).setOrderBy(orderClause).list();
        for (MPayment m_Payment : list) {
            if (m_Payment.isReconciled()) {
                this.addBufferLog(0, null, null, "Skip - " + m_Payment.getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Reconciled"), m_Payment.get_Table_ID(), m_Payment.getC_Payment_ID());
                continue;
            }
            if (m_Payment.getDocStatus().equals("DR") || m_Payment.getDocStatus().equals("IP")) {
                if (!m_Payment.processIt("VO")) throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CannotVoid")) + " - " + m_Payment.getDocumentNo() + " : " + m_Payment.getProcessMsg());
                m_Payment.saveEx(this.get_TrxName());
                ++successPayment;
                continue;
            }
            if (m_Payment.getDocStatus().equals("CO")) {
                if (!m_Payment.processIt("RC")) throw new Exception(String.valueOf(m_Payment.getDocumentNo()) + " : " + m_Payment.getProcessMsg());
                m_Payment.saveEx(this.get_TrxName());
                ++successPayment;
                continue;
            }
            ++skipPayment;
            this.addBufferLog(0, null, null, "Skip - " + m_Payment.getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus") + " : " + MRefList.getListName((Properties)this.getCtx(), (int)131, (String)m_Payment.getDocStatus()), m_Payment.get_Table_ID(), m_Payment.getC_Payment_ID());
        }
        if (successPayment > 0) {
            paymentBatch.setProcessed(true);
            paymentBatch.saveEx(this.get_TrxName());
        }
        String returnMsg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_Payment_ID", (boolean)paymentBatch.get_ValueAsBoolean("IsReceiptJP"))) + " ( " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success") + " : " + successPayment + " , " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure") + " : " + skipPayment + " ) ";
        boolean isReverse = MSysConfig.getBooleanValue((String)"JP_REVERSE_BANK_TRANSFER_FEE_INVOICE", (boolean)true, (int)paymentBatch.getAD_Client_ID(), (int)paymentBatch.getAD_Org_ID());
        if (!isReverse) {
            return returnMsg;
        }
        whereClause = "JP_PaymentBatch_ID = ?";
        List m_PaySelectionList = new Query(this.getCtx(), "C_PaySelection", whereClause, this.get_TrxName()).setParameters(new Object[]{this.C_PaymentBatch_ID}).list();
        if (m_PaySelectionList.size() > 0) {
            if (m_PaySelectionList.size() > 1) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError")) + " : C_PaySelection.JP_PaymentBatch_ID is Duplicated.");
            }
            MPaySelection paySelection = (MPaySelection)m_PaySelectionList.get(0);
            if (!paySelection.get_ValueAsBoolean("IsReceiptJP")) {
                MPaySelectionLine[] paySelectionLines;
                MPaySelectionLine[] mPaySelectionLineArray = paySelectionLines = paySelection.getLines(true);
                int n = paySelectionLines.length;
                int n2 = 0;
                while (n2 < n) {
                    MPaySelectionLine line = mPaySelectionLineArray[n2];
                    boolean IsAutoCalBankTransferfeeJP = line.get_ValueAsBoolean("IsAutoCalBankTransferfeeJP");
                    if (IsAutoCalBankTransferfeeJP) {
                        MInvoice m_Invoice = new MInvoice(Env.getCtx(), line.getC_Invoice_ID(), this.get_TrxName());
                        if (m_Invoice.isPaid()) {
                            ++skipInvoice;
                            this.addBufferLog(0, null, null, "Skip - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Reverse_Bank_Transfer_Fee_Invoice") + " : " + m_Invoice.getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus") + " : " + MRefList.getListName((Properties)this.getCtx(), (int)131, (String)m_Invoice.getDocStatus()), m_Invoice.get_Table_ID(), m_Invoice.getC_Invoice_ID());
                        } else if (m_Invoice.getDocStatus().equals("DR") || m_Invoice.getDocStatus().equals("IP")) {
                            if (!m_Invoice.processIt("VO")) throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CannotVoid")) + " - " + m_Invoice.getDocumentNo() + " : " + m_Invoice.getProcessMsg());
                            m_Invoice.saveEx(this.get_TrxName());
                            ++successInvoice;
                        } else if (m_Invoice.getDocStatus().equals("CO")) {
                            boolean isOK = m_Invoice.processIt("RC");
                            if (!isOK) throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Reverse_Bank_Transfer_Fee_Invoice")) + " : " + m_Invoice.getDocumentNo() + " : " + m_Invoice.getProcessMsg());
                            ++successInvoice;
                            m_Invoice.saveEx(this.get_TrxName());
                        } else {
                            ++skipInvoice;
                            this.addBufferLog(0, null, null, "Skip - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Reverse_Bank_Transfer_Fee_Invoice") + " : " + m_Invoice.getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus") + " : " + MRefList.getListName((Properties)this.getCtx(), (int)131, (String)m_Invoice.getDocStatus()), m_Invoice.get_Table_ID(), m_Invoice.getC_Invoice_ID());
                        }
                    }
                    ++n2;
                }
            }
        }
        if (skipInvoice != 0 || successInvoice != 0) {
            returnMsg = String.valueOf(returnMsg) + " / " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Reverse_Bank_Transfer_Fee_Invoice") + " ( " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success") + " : " + successInvoice + " , " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure") + " : " + skipInvoice + " ) ";
        }
        if (skipPayment != 0 || skipInvoice != 0) return returnMsg;
        this.addBufferLog(0, null, null, Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success"), 0, 0);
        return returnMsg;
    }
}

