/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MPPDoc;
import jpiere.base.plugin.org.adempiere.model.MPPFact;
import jpiere.base.plugin.org.adempiere.model.MPPPlan;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFProcess;

public class PPPlanProcessAfterComplete
extends SvrProcess {
    private int p_JP_PP_Plan_ID = 0;

    protected void prepare() {
        this.p_JP_PP_Plan_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String msg = "@OK@";
        MPPPlan ppPlan = new MPPPlan(this.getCtx(), this.p_JP_PP_Plan_ID, this.get_TrxName());
        if (!ppPlan.getDocStatus().equals("CO")) {
            msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Not_Completed_Document");
            this.addBufferLog(0, null, null, String.valueOf(msg) + " - " + ppPlan.getDocumentNo(), MPPFact.Table_ID, ppPlan.getJP_PP_Plan_ID());
            return msg;
        }
        MPPDoc parent = ppPlan.getParent();
        if (parent.isCompleteAutoJP()) {
            MPPPlan[] ppPlans = parent.getPPPlans(true, null);
            boolean isAllProcessed = true;
            MPPPlan[] mPPPlanArray = ppPlans;
            int n = ppPlans.length;
            int n2 = 0;
            while (n2 < n) {
                MPPPlan plan = mPPPlanArray[n2];
                if (!plan.isProcessed()) {
                    isAllProcessed = false;
                    break;
                }
                ++n2;
            }
            if (isAllProcessed) {
                String wfStatus;
                Timestamp now = Timestamp.valueOf(LocalDateTime.now());
                if (parent.getJP_PP_Start() == null) {
                    parent.setJP_PP_Start(now);
                    parent.setJP_PP_StartProcess("Y");
                }
                if (parent.getJP_PP_End() == null) {
                    parent.setJP_PP_End(now);
                    parent.setJP_PP_EndProcess("Y");
                }
                if (Util.isEmpty((String)(wfStatus = MWFActivity.getActiveInfo((Properties)Env.getCtx(), (int)MPPDoc.Table_ID, (int)parent.getJP_PP_Doc_ID())))) {
                    ProcessInfo pInfo = this.getProcessInfo();
                    pInfo.setPO((PO)parent);
                    pInfo.setRecord_ID(parent.getJP_PP_Doc_ID());
                    pInfo.setTable_ID(MPPDoc.Table_ID);
                    MColumn docActionColumn = MColumn.get((Properties)this.getCtx(), (String)"JP_PP_Doc", (String)"DocAction");
                    MProcess process = MProcess.get((int)docActionColumn.getAD_Process_ID());
                    MWFProcess wfProcess = ProcessUtil.startWorkFlow((Properties)Env.getCtx(), (ProcessInfo)pInfo, (int)process.getAD_Workflow_ID());
                    if (wfProcess.getWFState().equals("CT")) {
                        msg = wfProcess.getTextMsg();
                        this.addLog(msg);
                    }
                    return msg;
                }
                msg = Msg.getMsg((Properties)this.getCtx(), (String)"WFActiveForRecord");
                this.addLog(msg);
                return msg;
            }
        }
        return msg;
    }
}

