/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MPPDocT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineTQT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanT;
import org.compiere.model.MLocator;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Base;
import org.compiere.model.MTree_Node;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PPCreateTemplateByCopy
extends SvrProcess {
    private int p_JP_PP_DocT_From_ID = 0;
    private int p_JP_PP_DocT_To_ID = 0;
    private BigDecimal p_CoefficientQty = Env.ZERO;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("JP_PP_DocT_ID")) {
                    this.p_JP_PP_DocT_From_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if ("QtyEntered".equals(name)) {
                    this.p_CoefficientQty = para[i].getParameterAsBigDecimal();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_JP_PP_DocT_To_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_JP_PP_DocT_From_ID == this.p_JP_PP_DocT_To_ID) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_SameTemplate"));
        }
        if (this.p_CoefficientQty == null) {
            this.p_CoefficientQty = Env.ZERO;
        }
        MPPDocT m_PPDocT_From = new MPPDocT(this.getCtx(), this.p_JP_PP_DocT_From_ID, this.get_TrxName());
        MPPDocT m_PPDocT_To = new MPPDocT(this.getCtx(), this.p_JP_PP_DocT_To_ID, this.get_TrxName());
        MPPPlanT[] ppPlanT_Froms = m_PPDocT_From.getPPPlanTs();
        MPPPlanLineT[] ppPlanLineT_Froms = null;
        MPPPlanT ppPlanT_To = null;
        MPPPlanLineT ppPlanLineT_To = null;
        int M_Locator_ID = 0;
        MPPPlanT[] mPPPlanTArray = ppPlanT_Froms;
        int n = ppPlanT_Froms.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlanT ppPlanT_From = mPPPlanTArray[n2];
            ppPlanT_To = m_PPDocT_To.getPPPlanT(ppPlanT_From.getSeqNo(), ppPlanT_From.getM_Product_ID(), ppPlanT_From.getValue());
            if (ppPlanT_To != null) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Unique_Constraint_PPPlan"));
            }
            ppPlanT_To = new MPPPlanT(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)m_PPDocT_From, (PO)m_PPDocT_To);
            ppPlanT_To.setJP_PP_DocT_ID(m_PPDocT_To.getJP_PP_DocT_ID());
            ppPlanT_To.setAD_Org_ID(m_PPDocT_To.getAD_Org_ID());
            ppPlanT_To.setSeqNo(ppPlanT_From.getSeqNo());
            ppPlanT_To.setIsActive(true);
            ppPlanT_To.setIsSummary(ppPlanT_From.isSummary());
            ppPlanT_To.setM_Product_ID(ppPlanT_From.getM_Product_ID());
            if (m_PPDocT_To.getAD_Org_ID() == ppPlanT_From.getAD_Org_ID()) {
                ppPlanT_To.setM_Locator_ID(ppPlanT_From.getM_Locator_ID());
            } else {
                MOrgInfo oInfo = MOrgInfo.get((int)m_PPDocT_To.getAD_Org_ID());
                if (oInfo.getM_Warehouse_ID() > 0) {
                    MLocator loc;
                    MWarehouse wh = MWarehouse.get((int)oInfo.getM_Warehouse_ID());
                    MLocator[] locs = wh.getLocators(false);
                    boolean isOK = false;
                    MLocator[] mLocatorArray = locs;
                    int n3 = locs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        loc = mLocatorArray[n4];
                        if (loc.isDefault()) {
                            M_Locator_ID = loc.getM_Locator_ID();
                            ppPlanT_To.setM_Locator_ID(M_Locator_ID);
                            isOK = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!isOK) {
                        MLocator[] mLocatorArray2 = locs;
                        if (locs.length != 0) {
                            loc = mLocatorArray2[0];
                            M_Locator_ID = loc.getM_Locator_ID();
                            ppPlanT_To.setM_Locator_ID(M_Locator_ID);
                            isOK = true;
                        }
                    }
                    if (!isOK) {
                        throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotFoundLocatorCopyTemplate"));
                    }
                } else {
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotFoundLocatorCopyTemplate"));
                }
            }
            ppPlanT_To.setC_DocType_ID(ppPlanT_From.getC_DocType_ID());
            ppPlanT_To.setC_DocTypeTarget_ID(ppPlanT_From.getC_DocTypeTarget_ID());
            ppPlanT_To.setValue(ppPlanT_From.getValue());
            ppPlanT_To.setJP_Name(ppPlanT_From.getJP_Name());
            ppPlanT_To.setName(ppPlanT_From.getJP_Name());
            ppPlanT_To.setIsSplitWhenDifferenceJP(ppPlanT_From.isSplitWhenDifferenceJP());
            ppPlanT_To.setIsCompleteAutoJP(ppPlanT_From.isCompleteAutoJP());
            ppPlanT_To.setIsCreatePPFactJP(ppPlanT_From.isCreatePPFactJP());
            ppPlanT_To.setProductionQty(this.p_CoefficientQty.multiply(ppPlanT_From.getProductionQty()));
            ppPlanT_To.setJP_ProductionDays(ppPlanT_From.getJP_ProductionDays());
            ppPlanT_To.setJP_DayOffset(ppPlanT_From.getJP_DayOffset());
            ppPlanT_To.setJP_PP_Workload_Plan(ppPlanT_From.getJP_PP_Workload_Plan());
            ppPlanT_To.setJP_PP_Workload_UOM_ID(ppPlanT_From.getJP_PP_Workload_UOM_ID());
            ppPlanT_To.setJP_Processing1("N");
            ppPlanT_To.setJP_Processing2("N");
            ppPlanT_To.setJP_Processing3("N");
            ppPlanT_To.setJP_Processing4("N");
            ppPlanT_To.setJP_Processing5("N");
            ppPlanT_To.setJP_Processing6("N");
            ppPlanLineT_Froms = ppPlanT_From.getPPPlanLineTs();
            if (ppPlanLineT_Froms.length > 0) {
                ppPlanT_To.setIsCreated("Y");
            } else {
                ppPlanT_To.setIsCreated("N");
            }
            ppPlanT_To.saveEx(this.get_TrxName());
            MPPPlanLineT[] isOK = ppPlanLineT_Froms;
            int locs = ppPlanLineT_Froms.length;
            int wh = 0;
            while (wh < locs) {
                MPPPlanLineT ppPlanLineT_From = isOK[wh];
                ppPlanLineT_To = new MPPPlanLineT(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)ppPlanLineT_From, (PO)ppPlanLineT_To);
                ppPlanLineT_To.setJP_PP_PlanT_ID(ppPlanT_To.getJP_PP_PlanT_ID());
                ppPlanLineT_To.setAD_Org_ID(m_PPDocT_To.getAD_Org_ID());
                ppPlanLineT_To.setLine(ppPlanLineT_From.getLine());
                ppPlanLineT_To.setM_Product_ID(ppPlanLineT_From.getM_Product_ID());
                ppPlanLineT_To.setM_AttributeSetInstance_ID(ppPlanLineT_From.getM_AttributeSetInstance_ID());
                ppPlanLineT_To.setC_UOM_ID(ppPlanLineT_From.getC_UOM_ID());
                ppPlanLineT_To.setIsEndProduct(ppPlanLineT_From.isEndProduct());
                ppPlanLineT_To.setIsCreated("Y");
                ppPlanLineT_To.setPlannedQty(this.p_CoefficientQty.multiply(ppPlanLineT_From.getPlannedQty()));
                if (ppPlanLineT_To.isEndProduct()) {
                    ppPlanLineT_To.setQtyUsed(null);
                } else {
                    ppPlanLineT_To.setQtyUsed(this.p_CoefficientQty.multiply(ppPlanLineT_From.getQtyUsed()));
                }
                ppPlanLineT_To.setMovementQty(this.p_CoefficientQty.multiply(ppPlanLineT_From.getMovementQty()));
                if (m_PPDocT_To.getAD_Org_ID() == ppPlanT_From.getAD_Org_ID()) {
                    ppPlanLineT_To.setM_Locator_ID(ppPlanLineT_From.getM_Locator_ID());
                } else {
                    ppPlanLineT_To.setM_Locator_ID(M_Locator_ID);
                }
                ppPlanLineT_To.setJP_Processing1("N");
                ppPlanLineT_To.setJP_Processing2("N");
                ppPlanLineT_To.setJP_Processing3("N");
                ppPlanLineT_To.saveEx(this.get_TrxName());
                if (ppPlanLineT_To.isEndProduct()) {
                    MPPPlanLineTQT[] qts_From = ppPlanLineT_From.getPPPlanLineTQTs(true, null);
                    MPPPlanLineTQT qt_To = null;
                    MPPPlanLineTQT[] mPPPlanLineTQTArray = qts_From;
                    int n5 = qts_From.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        MPPPlanLineTQT qt_From = mPPPlanLineTQTArray[n6];
                        qt_To = new MPPPlanLineTQT(this.getCtx(), 0, this.get_TrxName());
                        PO.copyValues((PO)qt_From, (PO)qt_To);
                        qt_To.setJP_PP_PlanLineT_ID(ppPlanLineT_To.getJP_PP_PlanLineT_ID());
                        qt_To.setAD_Org_ID(ppPlanLineT_To.getAD_Org_ID());
                        qt_To.setSeqNo(qt_From.getSeqNo());
                        qt_To.setM_QualityTest_ID(qt_From.getM_QualityTest_ID());
                        qt_To.setExpectedResult(qt_From.getExpectedResult());
                        qt_To.setIsActive(true);
                        qt_To.saveEx(this.get_TrxName());
                        ++n6;
                    }
                }
                ++wh;
            }
            ++n2;
        }
        int p_AD_TreeFrom_ID = MTree.getDefaultAD_Tree_ID((int)this.getAD_Client_ID(), (String)"JP_PP_PlanT_ID");
        int p_AD_TreeTo_ID = MTree.getDefaultAD_Tree_ID((int)this.getAD_Client_ID(), (String)"JP_PP_PlanT_ID");
        MTree treeFrom = new MTree(this.getCtx(), p_AD_TreeFrom_ID, this.get_TrxName());
        MTree treeTo = new MTree(this.getCtx(), p_AD_TreeTo_ID, this.get_TrxName());
        MTree_Node nodeTo = null;
        MTree_Node nodeFrom = null;
        MPPPlanT[] ppPlanT_Tos = m_PPDocT_To.getPPPlanTs(true, null);
        int i = 0;
        while (i < ppPlanT_Tos.length) {
            nodeTo = MTree_Node.get((MTree_Base)treeTo, (int)ppPlanT_Tos[i].getJP_PP_PlanT_ID());
            int j = 0;
            while (j < ppPlanT_Froms.length) {
                if (ppPlanT_Tos[i].getSeqNo() == ppPlanT_Froms[j].getSeqNo() && ppPlanT_Tos[i].getM_Product_ID() == ppPlanT_Froms[j].getM_Product_ID() && ppPlanT_Tos[i].getValue().equals(ppPlanT_Froms[j].getValue())) {
                    nodeFrom = MTree_Node.get((MTree_Base)treeFrom, (int)ppPlanT_Froms[j].getJP_PP_PlanT_ID());
                    if (nodeFrom.getParent_ID() == 0) {
                        nodeTo.setParent_ID(0);
                        nodeTo.setSeqNo(nodeFrom.getSeqNo());
                        nodeTo.save(this.get_TrxName());
                        break;
                    }
                    boolean isOK = false;
                    int k = 0;
                    while (j < ppPlanT_Froms.length) {
                        if (nodeFrom.getParent_ID() == ppPlanT_Froms[k].getJP_PP_PlanT_ID()) {
                            isOK = true;
                            int m = 0;
                            while (m < ppPlanT_Tos.length) {
                                if (ppPlanT_Tos[m].getSeqNo() == ppPlanT_Froms[k].getSeqNo() && ppPlanT_Tos[m].getM_Product_ID() == ppPlanT_Froms[k].getM_Product_ID() && ppPlanT_Tos[m].getValue().equals(ppPlanT_Froms[k].getValue())) {
                                    nodeTo.setParent_ID(ppPlanT_Tos[m].getJP_PP_PlanT_ID());
                                    nodeTo.setSeqNo(nodeFrom.getSeqNo());
                                    nodeTo.save(this.get_TrxName());
                                    break;
                                }
                                ++m;
                            }
                            if (isOK) break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

