/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MPPFact;
import jpiere.base.plugin.org.adempiere.model.MPPFactLine;
import jpiere.base.plugin.org.adempiere.model.MPPPlan;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLine;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanT;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class PPCreateLineFromBom
extends SvrProcess {
    private int p_Record_ID = 0;
    private MTable m_Table = null;
    private boolean p_Recreate = true;
    private BigDecimal p_ProductionQty = Env.ZERO;
    private int p_PP_Product_BOM_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if ("Recreate".equals(name)) {
                this.p_Recreate = para[i].getParameterAsBoolean();
            } else if ("ProductionQty".equals(name)) {
                this.p_ProductionQty = (BigDecimal)para[i].getParameter();
            } else if ("PP_Product_BOM_ID".equals(name)) {
                this.p_PP_Product_BOM_ID = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_Record_ID = this.getRecord_ID();
        this.m_Table = MTable.get((int)this.getTable_ID());
    }

    protected String doIt() throws Exception {
        PO doc;
        String msg = null;
        PO po = this.m_Table.getPO(this.p_Record_ID, this.get_TrxName());
        if (!this.p_Recreate && "Y".equalsIgnoreCase(po.get_ValueAsString("IsCreated"))) {
            throw new AdempiereUserError(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DocLineCreated"));
        }
        if (this.p_Recreate && !Util.isEmpty((String)(msg = this.deleteLine(po)))) {
            return msg;
        }
        if (po instanceof MPPPlan ? (doc = (MPPPlan)po).getPPPlanLines().length > 0 : (po instanceof MPPPlanT ? (doc = (MPPPlanT)po).getPPPlanLineTs().length > 0 : po instanceof MPPFact && (doc = (MPPFact)po).getPPFactLines().length > 0)) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_LinesThere"));
        }
        String sql = "UPDATE " + this.m_Table.getTableName() + " SET ProductionQty=?, IsCreated=? " + " WHERE " + this.m_Table.getTableName() + "_ID=?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{this.p_ProductionQty, "Y", po.get_ID()}, (boolean)false, (String)this.get_TrxName(), (int)0);
        if (no != 1) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"DBExecuteError")) + " : " + sql);
        }
        PO poLine = this.createLine(po);
        int line = 10;
        MProduct product = MProduct.get((int)po.get_ValueAsInt("M_Product_ID"));
        poLine.setAD_Org_ID(po.getAD_Org_ID());
        poLine.set_ValueNoCheck("Line", (Object)line);
        poLine.set_ValueNoCheck("M_Product_ID", (Object)product.getM_Product_ID());
        poLine.set_ValueNoCheck("M_Locator_ID", po.get_Value("M_Locator_ID"));
        poLine.set_ValueNoCheck("IsEndProduct", (Object)true);
        poLine.set_ValueNoCheck("PlannedQty", (Object)this.p_ProductionQty);
        poLine.set_ValueNoCheck("MovementQty", (Object)this.p_ProductionQty);
        poLine.saveEx(this.get_TrxName());
        MPPProductBOM bom = null;
        bom = this.p_PP_Product_BOM_ID == 0 ? MPPProductBOM.getDefault((MProduct)product, (String)this.get_TrxName()) : new MPPProductBOM(this.getCtx(), this.p_PP_Product_BOM_ID, this.get_TrxName());
        if (bom != null) {
            MPPProductBOMLine[] mPPProductBOMLineArray = bom.getLines();
            int n = mPPProductBOMLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPPProductBOMLine bomLine = mPPProductBOMLineArray[n2];
                poLine = this.createLine(po);
                poLine.setAD_Org_ID(po.getAD_Org_ID());
                poLine.set_ValueNoCheck("Line", (Object)(line += 10));
                poLine.set_ValueNoCheck("M_Product_ID", (Object)bomLine.getM_Product_ID());
                poLine.set_ValueNoCheck("M_Locator_ID", po.get_Value("M_Locator_ID"));
                poLine.set_ValueNoCheck("IsEndProduct", (Object)false);
                poLine.set_ValueNoCheck("PlannedQty", (Object)this.p_ProductionQty.multiply(bomLine.getQtyBOM()));
                poLine.set_ValueNoCheck("QtyUsed", (Object)this.p_ProductionQty.multiply(bomLine.getQtyBOM()));
                poLine.set_ValueNoCheck("MovementQty", (Object)this.p_ProductionQty.multiply(bomLine.getQtyBOM()).negate());
                poLine.set_ValueNoCheck("IsCreated", (Object)"N");
                poLine.saveEx(this.get_TrxName());
                ++n2;
            }
        }
        return "@Success@";
    }

    private String deleteLine(PO po) {
        String tableName = null;
        if (this.m_Table.getTableName().equals("JP_PP_PlanT")) {
            tableName = "JP_PP_PlanLineT";
        } else if (this.m_Table.getTableName().equals("JP_PP_Plan")) {
            tableName = "JP_PP_PlanLine";
        } else if (this.m_Table.getTableName().equals("JP_PP_Fact")) {
            tableName = "JP_PP_FactLine";
        }
        List list = new Query(Env.getCtx(), tableName, String.valueOf(this.m_Table.getTableName()) + "_ID = ?", this.get_TrxName()).setOnlyActiveRecords(false).setApplyAccessFilter(false).setClient_ID().setParameters(new Object[]{po.get_ID()}).list();
        for (PO poLine : list) {
            poLine.deleteEx(false);
        }
        return "";
    }

    private PO createLine(PO po) {
        PO poLine = null;
        if (this.m_Table.getTableName().equals("JP_PP_PlanT")) {
            poLine = new MPPPlanLineT(this.getCtx(), 0, this.get_TrxName());
            poLine.set_ValueNoCheck("JP_PP_PlanT_ID", po.get_ValueAsInt("JP_PP_PlanT_ID"));
        } else if (this.m_Table.getTableName().equals("JP_PP_Plan")) {
            poLine = new MPPPlanLine(this.getCtx(), 0, this.get_TrxName());
            poLine.set_ValueNoCheck("JP_PP_Plan_ID", po.get_ValueAsInt("JP_PP_Plan_ID"));
        } else if (this.m_Table.getTableName().equals("JP_PP_Fact")) {
            poLine = new MPPFactLine(this.getCtx(), 0, this.get_TrxName());
            poLine.set_ValueNoCheck("JP_PP_Fact_ID", po.get_ValueAsInt("JP_PP_Fact_ID"));
        }
        return poLine;
    }
}

