/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MPPDoc;
import jpiere.base.plugin.org.adempiere.model.MPPDocT;
import jpiere.base.plugin.org.adempiere.model.MPPPlan;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLine;
import jpiere.base.plugin.org.adempiere.model.MPPPlanLineT;
import jpiere.base.plugin.org.adempiere.model.MPPPlanT;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MTable;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Base;
import org.compiere.model.MTree_Node;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_NonBusinessDay;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class PPCreateDocFromTemplate
extends SvrProcess {
    private int p_Record_ID = 0;
    private int p_JP_PP_DocT_ID = 0;
    private BigDecimal p_CoefficientQty = Env.ZERO;
    private Timestamp p_JP_PP_ScheduledStart = null;
    private String p_Value = null;
    private String p_Name = null;
    private MTable m_Table = null;
    private int default_M_Locator_ID = 0;
    private MPPDoc m_PPDoc = null;
    private MPPDocT m_PPDocT = null;
    private LocalDateTime local_ScheduledStart = null;
    private TreeSet<Timestamp> nonBusinessDaysSet = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if ("JP_PP_DocT_ID".equals(name)) {
                this.p_JP_PP_DocT_ID = para[i].getParameterAsInt();
            } else if ("QtyEntered".equals(name)) {
                this.p_CoefficientQty = para[i].getParameterAsBigDecimal();
            } else if ("JP_PP_ScheduledStart".equals(name)) {
                this.p_JP_PP_ScheduledStart = para[i].getParameterAsTimestamp();
            } else if ("Value".equals(name)) {
                this.p_Value = para[i].getParameterAsString();
            } else if ("Name".equals(name)) {
                this.p_Name = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_Record_ID = this.getRecord_ID();
        this.m_Table = MTable.get((int)this.getTable_ID());
    }

    protected String doIt() throws Exception {
        if (this.m_Table.getTableName().equals("C_OrderLine")) {
            int C_OrderLine_ID = this.getRecord_ID();
            if (Util.isEmpty((String)this.p_Value)) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"Value"));
            }
            MPPDoc ppd = MPPDoc.get(this.getCtx(), this.p_Value, this.get_TrxName());
            if (ppd != null) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Unique_Constraint_Value"));
            }
            this.createPPDoc();
            this.createPlan();
            this.updateTree();
            MOrderLine oLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.get_TrxName());
            this.m_PPDoc.setC_BPartner_ID(oLine.getParent().getC_BPartner_ID());
            this.m_PPDoc.setC_Order_ID(oLine.getC_Order_ID());
            this.m_PPDoc.setPOReference(oLine.getParent().getPOReference());
            this.m_PPDoc.save(this.get_TrxName());
            this.addBufferLog(0, null, null, this.m_PPDoc.getDocumentInfo(), MPPDoc.Table_ID, this.m_PPDoc.getJP_PP_Doc_ID());
        } else if (this.m_Table.getTableName().equals("JP_PP_DocT")) {
            this.p_JP_PP_DocT_ID = this.p_Record_ID;
            if (Util.isEmpty((String)this.p_Value)) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"Value"));
            }
            MPPDoc ppd = MPPDoc.get(this.getCtx(), this.p_Value, this.get_TrxName());
            if (ppd != null) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Unique_Constraint_Value"));
            }
            this.createPPDoc();
            this.createPlan();
            this.updateTree();
            this.addBufferLog(0, null, null, this.m_PPDoc.getDocumentInfo(), MPPDoc.Table_ID, this.m_PPDoc.getJP_PP_Doc_ID());
        } else if (this.m_Table.getTableName().equals("JP_PP_Doc")) {
            this.m_PPDoc = new MPPDoc(this.getCtx(), this.p_Record_ID, this.get_TrxName());
            if (this.m_PPDoc.getProductionQty().compareTo(Env.ZERO) == 0) {
                throw new Exception(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"ProductionQty")) + " = 0");
            }
            this.p_CoefficientQty = this.m_PPDoc.getProductionQty();
            this.p_JP_PP_ScheduledStart = this.m_PPDoc.getJP_PP_ScheduledStart();
            if (this.p_JP_PP_DocT_ID == 0) {
                this.p_JP_PP_DocT_ID = this.m_PPDoc.getJP_PP_DocT_ID();
            }
            if (this.p_JP_PP_DocT_ID == 0) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_DocT_ID"));
            }
            if (this.p_JP_PP_DocT_ID != this.m_PPDoc.getJP_PP_DocT_ID()) {
                this.m_PPDoc.setJP_PP_DocT_ID(this.p_JP_PP_DocT_ID);
                this.m_PPDoc.saveEx(this.get_TrxName());
            }
            this.m_PPDocT = new MPPDocT(this.getCtx(), this.p_JP_PP_DocT_ID, this.get_TrxName());
            MPPPlanT[] ppPlanTs = this.m_PPDocT.getPPPlanTs();
            MPPPlan[] ppPlans = this.m_PPDoc.getPPPlans();
            MPPPlanT[] mPPPlanTArray = ppPlanTs;
            int n = ppPlanTs.length;
            int n2 = 0;
            while (n2 < n) {
                MPPPlanT ppPlanT = mPPPlanTArray[n2];
                MPPPlan[] mPPPlanArray = ppPlans;
                int n3 = ppPlans.length;
                int n4 = 0;
                while (n4 < n3) {
                    MPPPlan ppPlan = mPPPlanArray[n4];
                    if (ppPlanT.getJP_PP_PlanT_ID() == ppPlan.getJP_PP_PlanT_ID()) {
                        throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_TemplateInUse"));
                    }
                    ++n4;
                }
                ++n2;
            }
            this.createPlan();
            this.updateTree();
        } else if (this.m_Table.getTableName().equals("JP_PP_Plan")) {
            MPPPlan ppPlan = new MPPPlan(this.getCtx(), this.p_Record_ID, this.get_TrxName());
            if (ppPlan.getJP_PP_PlanT_ID() == 0) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PP_PlanT_ID"));
            }
            if (ppPlan.getProductionQty().compareTo(Env.ZERO) == 0) {
                throw new Exception(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"ProductionQty")) + " = 0");
            }
            if (ppPlan.getPPPlanLines().length > 0) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_LinesThere"));
            }
            MPPPlanT ppPlanT = new MPPPlanT(this.getCtx(), ppPlan.getJP_PP_PlanT_ID(), this.get_TrxName());
            if (ppPlan.getM_Product_ID() != ppPlanT.getM_Product_ID()) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_PP_Plan_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_PP_PlanT_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                throw new Exception(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
            }
            if (ppPlanT.getPPPlanLineTs().length == 0) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_LineT_NotThere"));
            }
            BigDecimal planQty = ppPlan.getProductionQty();
            BigDecimal templateQty = ppPlanT.getProductionQty();
            BigDecimal rate = Env.ONE;
            if (templateQty != null && templateQty.compareTo(Env.ZERO) != 0) {
                rate = planQty.divide(templateQty, 4, RoundingMode.HALF_UP);
            }
            this.p_CoefficientQty = rate;
            this.createPlanLine(ppPlan, ppPlanT);
            ppPlan.setIsCreated("Y");
            ppPlan.saveEx(this.get_TrxName());
        }
        return "@OK@";
    }

    private MPPDoc createPPDoc() {
        this.m_PPDoc = new MPPDoc(this.getCtx(), 0, this.get_TrxName());
        this.m_PPDocT = new MPPDocT(this.getCtx(), this.p_JP_PP_DocT_ID, this.get_TrxName());
        PO.copyValues((PO)this.m_PPDocT, (PO)this.m_PPDoc);
        this.m_PPDoc.setJP_PP_DocT_ID(this.p_JP_PP_DocT_ID);
        this.m_PPDoc.setAD_Org_ID(this.m_PPDocT.getAD_Org_ID());
        this.m_PPDoc.setM_Product_ID(this.m_PPDocT.getM_Product_ID());
        this.m_PPDoc.setQtyEntered(this.p_CoefficientQty);
        this.m_PPDoc.setC_UOM_ID(this.m_PPDocT.getC_UOM_ID());
        this.m_PPDoc.setProductionQty(this.p_CoefficientQty.multiply(this.m_PPDocT.getProductionQty()));
        this.m_PPDoc.setC_DocType_ID(this.m_PPDocT.getC_DocType_ID());
        this.m_PPDoc.setValue(this.p_Value);
        this.m_PPDoc.setName(this.p_Name);
        this.m_PPDoc.setDocStatus("DR");
        this.m_PPDoc.setDocAction("CO");
        this.m_PPDoc.setJP_PP_Status("NY");
        this.m_PPDoc.setJP_Processing1("N");
        this.m_PPDoc.setJP_Processing2("N");
        this.m_PPDoc.setJP_Processing3("N");
        this.m_PPDoc.setJP_Processing4("N");
        this.m_PPDoc.setJP_Processing5("N");
        this.m_PPDoc.setJP_Processing6("N");
        LocalDateTime toDay = this.p_JP_PP_ScheduledStart.toLocalDateTime();
        while (this.isNonBusinessDay(toDay)) {
            toDay = toDay.plusDays(1L);
        }
        this.local_ScheduledStart = toDay;
        this.m_PPDoc.setJP_PP_ScheduledStart(Timestamp.valueOf(this.local_ScheduledStart));
        int JP_ProductionDays = this.m_PPDocT.getJP_ProductionDays();
        while (JP_ProductionDays > 1) {
            if (!this.isBusinessDay(toDay = toDay.plusDays(1L))) continue;
            --JP_ProductionDays;
        }
        this.m_PPDoc.setJP_PP_ScheduledEnd(Timestamp.valueOf(toDay));
        this.m_PPDoc.setDateAcct(Timestamp.valueOf(toDay));
        this.m_PPDoc.saveEx(this.get_TrxName());
        return this.m_PPDoc;
    }

    private MPPPlan createPlan() throws Exception {
        MPPPlanT[] ppPlanTs = this.m_PPDocT.getPPPlanTs(true, null);
        MPPPlan ppPlan = null;
        MPPPlanT[] mPPPlanTArray = ppPlanTs;
        int n = ppPlanTs.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlanT ppPlanT = mPPPlanTArray[n2];
            ppPlan = this.m_PPDoc.getPPPlan(ppPlanT.getSeqNo(), ppPlanT.getM_Product_ID(), ppPlanT.getValue());
            if (ppPlan != null) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Unique_Constraint_PPPlan"));
            }
            ppPlan = new MPPPlan(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)ppPlanT, (PO)ppPlan);
            ppPlan.setJP_PP_Doc_ID(this.m_PPDoc.getJP_PP_Doc_ID());
            ppPlan.setAD_Org_ID(this.m_PPDoc.getAD_Org_ID());
            ppPlan.setDocumentNo(null);
            ppPlan.setJP_PP_PlanT_ID(ppPlanT.getJP_PP_PlanT_ID());
            ppPlan.setSeqNo(ppPlanT.getSeqNo());
            ppPlan.setIsSummary(ppPlanT.isSummary());
            ppPlan.setM_Product_ID(ppPlanT.getM_Product_ID());
            ppPlan.setC_DocType_ID(ppPlanT.getC_DocType_ID());
            ppPlan.setValue(ppPlanT.getValue());
            ppPlan.setJP_Name(ppPlanT.getJP_Name());
            ppPlan.setName(ppPlanT.getJP_Name());
            ppPlan.setProductionQty(this.p_CoefficientQty.multiply(ppPlanT.getProductionQty()));
            ppPlan.setJP_ProductionQtyFact(Env.ZERO);
            ppPlan.setC_UOM_ID(ppPlanT.getC_UOM_ID());
            ppPlan.setJP_PP_Workload_Plan(ppPlanT.getJP_PP_Workload_Plan());
            ppPlan.setJP_PP_Workload_UOM_ID(ppPlanT.getJP_PP_Workload_UOM_ID());
            ppPlan.setDocStatus("DR");
            ppPlan.setDocAction("CO");
            ppPlan.setJP_PP_Status("NY");
            ppPlan.setIsCreated("Y");
            ppPlan.setJP_Processing1("N");
            ppPlan.setJP_Processing2("N");
            ppPlan.setJP_Processing3("N");
            ppPlan.setJP_Processing4("N");
            ppPlan.setJP_Processing5("N");
            ppPlan.setJP_Processing6("N");
            if (ppPlan.getAD_Org_ID() == ppPlanT.getAD_Org_ID()) {
                ppPlan.setM_Locator_ID(ppPlanT.getM_Locator_ID());
            } else if (this.default_M_Locator_ID != 0) {
                ppPlan.setM_Locator_ID(this.default_M_Locator_ID);
            } else {
                this.default_M_Locator_ID = this.searchLocator(ppPlan.getAD_Org_ID());
                if (this.default_M_Locator_ID > 0) {
                    ppPlan.setM_Locator_ID(this.default_M_Locator_ID);
                } else {
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotFoundLocatorCopyTemplate"));
                }
            }
            int offset = ppPlanT.getJP_DayOffset();
            if (this.local_ScheduledStart == null) {
                this.local_ScheduledStart = this.m_PPDoc.getJP_PP_ScheduledStart().toLocalDateTime();
            }
            LocalDateTime startDay = this.local_ScheduledStart;
            while (offset >= 0) {
                if (this.isBusinessDay(startDay)) {
                    if (offset != 0) {
                        startDay = startDay.plusDays(1L);
                    }
                    --offset;
                    continue;
                }
                startDay = startDay.plusDays(1L);
            }
            if (ppPlanT.getJP_PP_ScheduledStartTime() == null) {
                ppPlan.setJP_PP_ScheduledStart(Timestamp.valueOf(startDay));
            } else {
                LocalTime localTime = ppPlanT.getJP_PP_ScheduledStartTime().toLocalDateTime().toLocalTime();
                LocalDateTime localDateTime = LocalDateTime.of(startDay.toLocalDate(), localTime);
                ppPlan.setJP_PP_ScheduledStart(Timestamp.valueOf(localDateTime));
            }
            int JP_ProductionDays = ppPlanT.getJP_ProductionDays();
            while (JP_ProductionDays > 1) {
                if (!this.isBusinessDay(startDay = startDay.plusDays(1L))) continue;
                --JP_ProductionDays;
            }
            if (ppPlanT.getJP_PP_ScheduledEndTime() == null) {
                ppPlan.setJP_PP_ScheduledEnd(Timestamp.valueOf(startDay));
                ppPlan.setDateAcct(Timestamp.valueOf(startDay));
            } else {
                ppPlan.setDateAcct(Timestamp.valueOf(startDay));
                LocalTime localTime = ppPlanT.getJP_PP_ScheduledEndTime().toLocalDateTime().toLocalTime();
                LocalDateTime localDateTime = LocalDateTime.of(startDay.toLocalDate(), localTime);
                ppPlan.setJP_PP_ScheduledEnd(Timestamp.valueOf(localDateTime));
            }
            ppPlan.saveEx(this.get_TrxName());
            this.createPlanLine(ppPlan, ppPlanT);
            ++n2;
        }
        return ppPlan;
    }

    private int searchLocator(int AD_Org_ID) {
        MOrgInfo oInfo = MOrgInfo.get((int)AD_Org_ID);
        if (oInfo.getM_Warehouse_ID() > 0) {
            MLocator loc;
            MWarehouse wh = MWarehouse.get((int)oInfo.getM_Warehouse_ID());
            MLocator[] locs = wh.getLocators(false);
            boolean isOK = false;
            MLocator[] mLocatorArray = locs;
            int n = locs.length;
            int n2 = 0;
            while (n2 < n) {
                loc = mLocatorArray[n2];
                if (loc.isDefault()) {
                    this.default_M_Locator_ID = loc.getM_Locator_ID();
                    return this.default_M_Locator_ID;
                }
                ++n2;
            }
            if (!isOK) {
                MLocator[] mLocatorArray2 = locs;
                if (locs.length != 0) {
                    loc = mLocatorArray2[0];
                    this.default_M_Locator_ID = loc.getM_Locator_ID();
                    return this.default_M_Locator_ID;
                }
            }
        }
        return 0;
    }

    private boolean createPlanLine(MPPPlan ppPlan, MPPPlanT ppPlanT) throws Exception {
        String msg;
        MPPPlanLineT[] ppPlanLineTs = ppPlanT.getPPPlanLineTs(true, null);
        MPPPlanLine ppPlanLine = null;
        MPPPlanLineT[] mPPPlanLineTArray = ppPlanLineTs;
        int n = ppPlanLineTs.length;
        int n2 = 0;
        while (n2 < n) {
            MPPPlanLineT ppPlanLineT = mPPPlanLineTArray[n2];
            ppPlanLine = new MPPPlanLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)ppPlanLineT, (PO)ppPlanLine);
            ppPlanLine.setAD_Org_ID(ppPlan.getAD_Org_ID());
            ppPlanLine.setJP_PP_Plan_ID(ppPlan.getJP_PP_Plan_ID());
            ppPlanLine.setJP_PP_PlanLineT_ID(ppPlanLineT.getJP_PP_PlanLineT_ID());
            ppPlanLine.setLine(ppPlanLineT.getLine());
            ppPlanLine.setM_Product_ID(ppPlanLineT.getM_Product_ID());
            ppPlanLine.setM_AttributeSetInstance_ID(ppPlanLineT.getM_AttributeSetInstance_ID());
            ppPlanLine.setIsEndProduct(ppPlanLineT.isEndProduct());
            ppPlanLine.setPlannedQty(this.p_CoefficientQty.multiply(ppPlanLineT.getPlannedQty()));
            ppPlanLine.setC_UOM_ID(ppPlanLineT.getC_UOM_ID());
            if (ppPlanLineT.isEndProduct()) {
                ppPlanLine.setQtyUsed(null);
                ppPlanLine.setJP_QtyUsedFact(null);
            } else {
                ppPlanLine.setQtyUsed(this.p_CoefficientQty.multiply(ppPlanLineT.getQtyUsed()));
                ppPlanLine.setJP_QtyUsedFact(Env.ZERO);
            }
            ppPlanLine.setMovementQty(this.p_CoefficientQty.multiply(ppPlanLineT.getMovementQty()));
            ppPlanLine.setJP_Processing1("N");
            ppPlanLine.setJP_Processing2("N");
            ppPlanLine.setJP_Processing3("N");
            ppPlanLine.setIsCreated("N");
            if (ppPlanLine.getAD_Org_ID() == ppPlanLineT.getAD_Org_ID()) {
                ppPlanLine.setM_Locator_ID(ppPlanLineT.getM_Locator_ID());
            } else if (this.default_M_Locator_ID != 0) {
                ppPlanLine.setM_Locator_ID(this.default_M_Locator_ID);
            } else {
                this.default_M_Locator_ID = this.searchLocator(ppPlanLine.getAD_Org_ID());
                if (this.default_M_Locator_ID > 0) {
                    ppPlanLine.setM_Locator_ID(this.default_M_Locator_ID);
                } else {
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_PP_NotFoundLocatorCopyTemplate"));
                }
            }
            ppPlanLine.saveEx(this.get_TrxName());
            ++n2;
        }
        if (ppPlanT.isCreatePPFactJP() && !Util.isEmpty((String)(msg = ppPlan.createFact(this.get_TrxName())))) {
            throw new Exception(msg);
        }
        return true;
    }

    private boolean updateTree() {
        int p_AD_TreeFrom_ID = MTree.getDefaultAD_Tree_ID((int)this.getAD_Client_ID(), (String)"JP_PP_PlanT_ID");
        int p_AD_TreeTo_ID = MTree.getDefaultAD_Tree_ID((int)this.getAD_Client_ID(), (String)"JP_PP_Plan_ID");
        MTree treeFrom = new MTree(this.getCtx(), p_AD_TreeFrom_ID, this.get_TrxName());
        MTree treeTo = new MTree(this.getCtx(), p_AD_TreeTo_ID, this.get_TrxName());
        MPPPlan[] ppPlans = this.m_PPDoc.getPPPlans(true, null);
        int i = 0;
        while (i < ppPlans.length) {
            MTree_Node nodeTo = MTree_Node.get((MTree_Base)treeTo, (int)ppPlans[i].getJP_PP_Plan_ID());
            MTree_Node nodeFrom = MTree_Node.get((MTree_Base)treeFrom, (int)ppPlans[i].getJP_PP_PlanT_ID());
            int j = 0;
            while (j < ppPlans.length) {
                if (nodeFrom.getParent_ID() == 0) {
                    nodeTo.setParent_ID(0);
                    nodeTo.setSeqNo(nodeFrom.getSeqNo());
                    nodeTo.save(this.get_TrxName());
                    break;
                }
                if (nodeFrom.getParent_ID() == ppPlans[j].getJP_PP_PlanT_ID()) {
                    nodeTo.setParent_ID(ppPlans[j].getJP_PP_Plan_ID());
                    nodeTo.setSeqNo(nodeFrom.getSeqNo());
                    nodeTo.save(this.get_TrxName());
                    break;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean isNonBusinessDay(LocalDateTime toDay) {
        this.getNonBusinessDays(toDay);
        return this.nonBusinessDaysSet.contains(Timestamp.valueOf(toDay));
    }

    private boolean isBusinessDay(LocalDateTime toDay) {
        this.getNonBusinessDays(toDay);
        return !this.nonBusinessDaysSet.contains(Timestamp.valueOf(toDay));
    }

    private TreeSet<Timestamp> getNonBusinessDays(LocalDateTime toDay) {
        if (this.nonBusinessDaysSet == null) {
            this.nonBusinessDaysSet = new TreeSet();
            if (this.m_PPDocT.getJP_NonBusinessDayCalendar_ID() > 0) {
                List list_NonBusinessDays = null;
                StringBuilder whereClause = null;
                StringBuilder orderClause = null;
                ArrayList<Comparable<Integer>> list_parameters = new ArrayList<Comparable<Integer>>();
                Object[] parameters = null;
                LocalDateTime toDayMin = LocalDateTime.of(toDay.toLocalDate(), LocalTime.MIN);
                whereClause = new StringBuilder(" AD_Client_ID=? ");
                list_parameters.add(Integer.valueOf(Env.getAD_Client_ID((Properties)this.getCtx())));
                whereClause = whereClause.append(" AND C_Calendar_ID = ? ");
                list_parameters.add(Integer.valueOf(this.m_PPDocT.getJP_NonBusinessDayCalendar_ID()));
                whereClause = whereClause.append(" AND Date1 >= ? AND IsActive='Y' ");
                list_parameters.add(Timestamp.valueOf(toDayMin));
                if (this.m_PPDocT.getC_Country_ID() == 0) {
                    whereClause = whereClause.append(" AND C_Country_ID IS NULL ");
                } else {
                    whereClause = whereClause.append(" AND ( C_Country_ID IS NULL OR C_Country_ID = ? ) ");
                    list_parameters.add(Integer.valueOf(this.m_PPDocT.getC_Country_ID()));
                }
                parameters = list_parameters.toArray(new Object[list_parameters.size()]);
                orderClause = new StringBuilder("Date1");
                list_NonBusinessDays = new Query(Env.getCtx(), "C_NonBusinessDay", whereClause.toString(), null).setParameters(parameters).setOrderBy(orderClause.toString()).list();
                LocalDateTime nonBusinessDayMin = null;
                for (X_C_NonBusinessDay m_NonBusinessDays : list_NonBusinessDays) {
                    nonBusinessDayMin = LocalDateTime.of(m_NonBusinessDays.getDate1().toLocalDateTime().toLocalDate(), LocalTime.MIN);
                    this.nonBusinessDaysSet.add(Timestamp.valueOf(nonBusinessDayMin));
                }
            }
        }
        return this.nonBusinessDaysSet;
    }
}

