/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.util.JPierePaymentUtil;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class OpenAmtPaymentListPointOfTime
extends SvrProcess {
    private int p_AD_PInstance_ID = 0;
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private Timestamp p_JP_PointOfTime = null;
    private int p_C_BPartner_ID = 0;
    private int p_JP_Corporation_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private MAcctSchema m_MAcctSchema = null;
    private int p_Account_ID = 0;
    private boolean p_IsReceipt = false;
    private int p_C_BankAccount_ID = 0;

    protected void prepare() {
        this.p_AD_PInstance_ID = this.getAD_PInstance_ID();
        this.p_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_PointOfTime")) {
                    this.p_JP_PointOfTime = para[i].getParameterAsTimestamp();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_Corporation_ID")) {
                    this.p_JP_Corporation_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("Account_ID")) {
                    this.p_Account_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsReceipt")) {
                    this.p_IsReceipt = para[i].getParameterAsString().equals("Y");
                } else if (name.equals("C_BankAccount_ID")) {
                    this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_MAcctSchema = MAcctSchema.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID);
    }

    protected String doIt() throws Exception {
        block54: {
            ArrayList<OpemAmtPayment> list;
            block52: {
                block50: {
                    list = new ArrayList<OpemAmtPayment>();
                    StringBuilder sql1 = new StringBuilder("SELECT dt.DocBaseType,bp.JP_Corporation_ID,vc1.Account_ID AS Account_ID,vc2.Account_ID AS PrepayAccount_ID,p.* FROM C_Payment p  INNER JOIN C_DocType dt ON (dt.C_DocType_ID = p.C_DocType_ID) INNER JOIN C_BPartner bp ON (bp.C_BPartner_ID = p.C_BPartner_ID)");
                    if (this.p_IsReceipt) {
                        sql1.append(" INNER JOIN C_BankAccount_Acct baa ON (baa.C_BankAccount_ID = p.C_BankAccount_ID AND baa.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc1 ON (baa.B_UnallocatedCash_Acct = vc1.C_ValidCombination_ID)");
                    } else {
                        sql1.append(" INNER JOIN C_BankAccount_Acct baa ON (baa.C_BankAccount_ID = p.C_BankAccount_ID AND baa.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc1 ON (baa.B_PaymentSelect_Acct = vc1.C_ValidCombination_ID)");
                    }
                    if (this.p_IsReceipt) {
                        sql1.append(" INNER JOIN C_BP_Customer_Acct bpca ON (bp.C_BPartner_ID = bpca.C_BPartner_ID AND bpca.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc2 ON (bpca.C_Prepayment_Acct = vc2.C_ValidCombination_ID)");
                    } else {
                        sql1.append(" INNER JOIN C_BP_Vendor_Acct bpva ON (bp.C_BPartner_ID = bpva.C_BPartner_ID AND bpva.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc2 ON (bpva.V_Prepayment_Acct = vc2.C_ValidCombination_ID)");
                    }
                    sql1.append(" WHERE p.IsAllocated='N' AND p.AD_Client_ID = ?  AND p.DocStatus IN ('CO','CL','VO','RE')  AND p.DateAcct <= ? AND p.IsReceipt = ?");
                    if (this.p_AD_Org_ID > 0) {
                        sql1.append(" AND p.AD_Org_ID= ? ");
                    }
                    if (this.p_C_BPartner_ID > 0) {
                        sql1.append(" AND p.C_BPartner_ID= ? ");
                    }
                    if (this.p_JP_Corporation_ID > 0) {
                        sql1.append(" AND bp.JP_Corporation_ID= ? ");
                    }
                    if (this.p_C_BankAccount_ID > 0) {
                        sql1.append(" AND p.C_BankAccount_ID= ? ");
                    }
                    CPreparedStatement pstmt1 = null;
                    ResultSet rs1 = null;
                    try {
                        try {
                            pstmt1 = DB.prepareStatement((String)sql1.toString(), (String)this.get_TrxName());
                            pstmt1.setInt(1, this.p_C_AcctSchema_ID);
                            pstmt1.setInt(2, this.p_C_AcctSchema_ID);
                            pstmt1.setInt(3, this.p_AD_Client_ID);
                            pstmt1.setTimestamp(4, this.p_JP_PointOfTime);
                            pstmt1.setString(5, this.p_IsReceipt ? "Y" : "N");
                            int i = 5;
                            if (this.p_AD_Org_ID > 0) {
                                pstmt1.setInt(++i, this.p_AD_Org_ID);
                            }
                            if (this.p_C_BPartner_ID > 0) {
                                pstmt1.setInt(++i, this.p_C_BPartner_ID);
                            }
                            if (this.p_JP_Corporation_ID > 0) {
                                pstmt1.setInt(++i, this.p_JP_Corporation_ID);
                            }
                            if (this.p_C_BankAccount_ID > 0) {
                                pstmt1.setInt(++i, this.p_C_BankAccount_ID);
                            }
                            rs1 = pstmt1.executeQuery();
                            MPayment payment = null;
                            int account_ID = 0;
                            int prepayAccount_ID = 0;
                            while (rs1.next()) {
                                payment = new MPayment(this.getCtx(), rs1, this.get_TrxName());
                                account_ID = rs1.getInt(3);
                                prepayAccount_ID = rs1.getInt(4);
                                if (this.p_Account_ID != 0 && account_ID != this.p_Account_ID && prepayAccount_ID != this.p_Account_ID) continue;
                                list.add(new OpemAmtPayment(payment, rs1.getString(1), rs1.getInt(2), account_ID, prepayAccount_ID));
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql1.toString(), (Throwable)e);
                            DB.close(rs1, (Statement)pstmt1);
                            rs1 = null;
                            pstmt1 = null;
                            break block50;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs1, pstmt1);
                        rs1 = null;
                        pstmt1 = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs1, (Statement)pstmt1);
                    rs1 = null;
                    pstmt1 = null;
                }
                StringBuilder sql2 = new StringBuilder("SELECT DISTINCT  dt.DocBaseType,bp.JP_Corporation_ID,vc1.Account_ID AS Account_ID,vc2.Account_ID AS PrepayAccount_ID ,p.*  FROM C_Payment p  INNER JOIN C_AllocationLine al ON (p.C_Payment_ID = al.C_Payment_ID) INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID = a.C_AllocationHdr_ID) INNER JOIN C_DocType dt ON (dt.C_DocType_ID = p.C_DocType_ID) INNER JOIN C_BPartner bp ON (bp.C_BPartner_ID = p.C_BPartner_ID)");
                if (this.p_IsReceipt) {
                    sql2.append(" INNER JOIN C_BankAccount_Acct baa ON (baa.C_BankAccount_ID = p.C_BankAccount_ID AND baa.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc1 ON (baa.B_UnallocatedCash_Acct = vc1.C_ValidCombination_ID)");
                } else {
                    sql2.append(" INNER JOIN C_BankAccount_Acct baa ON (baa.C_BankAccount_ID = p.C_BankAccount_ID AND baa.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc1 ON (baa.B_PaymentSelect_Acct = vc1.C_ValidCombination_ID)");
                }
                if (this.p_IsReceipt) {
                    sql2.append(" INNER JOIN C_BP_Customer_Acct bpca ON (bp.C_BPartner_ID = bpca.C_BPartner_ID AND bpca.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc2 ON (bpca.C_Prepayment_Acct = vc2.C_ValidCombination_ID)");
                } else {
                    sql2.append(" INNER JOIN C_BP_Vendor_Acct bpva ON (bp.C_BPartner_ID = bpva.C_BPartner_ID AND bpva.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc2 ON (bpva.V_Prepayment_Acct = vc2.C_ValidCombination_ID)");
                }
                sql2.append(" WHERE p.IsAllocated='Y' AND p.AD_Client_ID = ?  AND p.DocStatus IN ('CO','CL','VO','RE')  AND p.DateAcct <= ? AND a.DateAcct > ? AND p.IsReceipt = ?");
                if (this.p_AD_Org_ID > 0) {
                    sql2.append(" AND p.AD_Org_ID= ? ");
                }
                if (this.p_C_BPartner_ID > 0) {
                    sql2.append(" AND p.C_BPartner_ID= ? ");
                }
                if (this.p_JP_Corporation_ID > 0) {
                    sql2.append(" AND bp.JP_Corporation_ID= ? ");
                }
                if (this.p_C_BankAccount_ID > 0) {
                    sql2.append(" AND p.C_BankAccount_ID= ? ");
                }
                CPreparedStatement pstmt2 = null;
                ResultSet rs2 = null;
                try {
                    try {
                        pstmt2 = DB.prepareStatement((String)sql2.toString(), (String)this.get_TrxName());
                        pstmt2.setInt(1, this.p_C_AcctSchema_ID);
                        pstmt2.setInt(2, this.p_C_AcctSchema_ID);
                        pstmt2.setInt(3, this.p_AD_Client_ID);
                        pstmt2.setTimestamp(4, this.p_JP_PointOfTime);
                        pstmt2.setTimestamp(5, this.p_JP_PointOfTime);
                        pstmt2.setString(6, this.p_IsReceipt ? "Y" : "N");
                        int i = 6;
                        if (this.p_AD_Org_ID > 0) {
                            pstmt2.setInt(++i, this.p_AD_Org_ID);
                        }
                        if (this.p_C_BPartner_ID > 0) {
                            pstmt2.setInt(++i, this.p_C_BPartner_ID);
                        }
                        if (this.p_JP_Corporation_ID > 0) {
                            pstmt2.setInt(++i, this.p_JP_Corporation_ID);
                        }
                        if (this.p_C_BankAccount_ID > 0) {
                            pstmt2.setInt(++i, this.p_C_BankAccount_ID);
                        }
                        rs2 = pstmt2.executeQuery();
                        OpemAmtPayment openAmtPayment = null;
                        MPayment payment2 = null;
                        int account_ID2 = 0;
                        int prepayAccount_ID2 = 0;
                        while (rs2.next()) {
                            payment2 = new MPayment(this.getCtx(), rs2, this.get_TrxName());
                            account_ID2 = rs2.getInt(3);
                            prepayAccount_ID2 = rs2.getInt(4);
                            if (this.p_Account_ID != 0 && account_ID2 != this.p_Account_ID && prepayAccount_ID2 != this.p_Account_ID || (openAmtPayment = new OpemAmtPayment(payment2, rs2.getString(1), rs2.getInt(2), account_ID2, prepayAccount_ID2)).getJP_OpenAmtPointOfTime().compareTo(Env.ZERO) == 0) continue;
                            list.add(openAmtPayment);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql2.toString(), (Throwable)e);
                        DB.close(rs2, (Statement)pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                        break block52;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs2, (Statement)pstmt2);
                rs2 = null;
                pstmt2 = null;
            }
            StringBuilder sql3 = new StringBuilder("INSERT INTO T_OpenPaymentPointOfTimeJP(AD_Pinstance_ID, C_Payment_ID, C_Order_ID, AD_Client_ID, AD_Org_ID, AD_OrgTrx_ID, C_BPartner_ID, JP_Corporation_ID, C_Currency_ID, C_AcctSchema_ID, Account_ID, C_Doctype_ID, DocBasetype, Documentno, DocStatus, DateTrx, DateAcct, IsAllocated, IsReceipt, PayAmt, OpenAmt, JP_OpenAmtPointOfTime, JP_CurrencyTo_ID, JP_ExchangedPayAmt, JP_ExchangedOpenAmt, JP_ExchangedOpenAmtPOT, Rate, JP_PointOfTime, C_BankAccount_ID)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            CPreparedStatement pstmt3 = null;
            Object rs3 = null;
            try {
                try {
                    pstmt3 = DB.prepareStatement((String)sql3.toString(), (String)this.get_TrxName());
                    for (OpemAmtPayment openAmtPayment : list) {
                        pstmt3.setInt(1, this.p_AD_PInstance_ID);
                        pstmt3.setInt(2, openAmtPayment.getPayment().getC_Payment_ID());
                        if (openAmtPayment.getPayment().getC_Order_ID() > 0) {
                            pstmt3.setInt(3, openAmtPayment.getPayment().getC_Order_ID());
                        } else {
                            pstmt3.setNull(3, 4);
                        }
                        pstmt3.setInt(4, this.p_AD_Client_ID);
                        pstmt3.setInt(5, openAmtPayment.getPayment().getAD_Org_ID());
                        if (openAmtPayment.getPayment().getAD_OrgTrx_ID() > 0) {
                            pstmt3.setInt(6, openAmtPayment.getPayment().getAD_OrgTrx_ID());
                        } else {
                            pstmt3.setNull(6, 4);
                        }
                        pstmt3.setInt(7, openAmtPayment.getPayment().getC_BPartner_ID());
                        if (openAmtPayment.getJP_Corporation_ID() > 0) {
                            pstmt3.setInt(8, openAmtPayment.getJP_Corporation_ID());
                        } else {
                            pstmt3.setNull(8, 4);
                        }
                        pstmt3.setInt(9, openAmtPayment.getPayment().getC_Currency_ID());
                        pstmt3.setInt(10, this.p_C_AcctSchema_ID);
                        pstmt3.setInt(11, openAmtPayment.getAccount_ID());
                        pstmt3.setInt(12, openAmtPayment.getPayment().getC_DocType_ID());
                        pstmt3.setString(13, openAmtPayment.getDocBaseType());
                        pstmt3.setString(14, openAmtPayment.getPayment().getDocumentNo());
                        pstmt3.setString(15, openAmtPayment.getPayment().getDocStatus());
                        pstmt3.setTimestamp(16, openAmtPayment.getPayment().getDateTrx());
                        pstmt3.setTimestamp(17, openAmtPayment.getPayment().getDateAcct());
                        pstmt3.setString(18, openAmtPayment.getPayment().isAllocated() ? "Y" : "N");
                        pstmt3.setString(19, openAmtPayment.getPayment().isReceipt() ? "Y" : "N");
                        if (openAmtPayment.getPayment().isReceipt()) {
                            pstmt3.setBigDecimal(20, openAmtPayment.getPayment().getPayAmt());
                        } else {
                            pstmt3.setBigDecimal(20, openAmtPayment.getPayment().getPayAmt().negate());
                        }
                        pstmt3.setBigDecimal(21, openAmtPayment.getOpenAmt());
                        pstmt3.setBigDecimal(22, openAmtPayment.getJP_OpenAmtPointOfTime());
                        pstmt3.setInt(23, this.m_MAcctSchema.getC_Currency_ID());
                        if (openAmtPayment.getPayment().isReceipt()) {
                            pstmt3.setBigDecimal(24, openAmtPayment.getJP_ExchangedPayAmt());
                        } else {
                            pstmt3.setBigDecimal(24, openAmtPayment.getJP_ExchangedPayAmt().negate());
                        }
                        pstmt3.setBigDecimal(25, openAmtPayment.getJP_ExchangedOpenAmt());
                        pstmt3.setBigDecimal(26, openAmtPayment.getJP_ExchangedOpenAmtPOT());
                        pstmt3.setBigDecimal(27, openAmtPayment.getRate());
                        pstmt3.setTimestamp(28, this.p_JP_PointOfTime);
                        pstmt3.setInt(29, openAmtPayment.getPayment().getC_BankAccount_ID());
                        pstmt3.executeUpdate();
                    }
                }
                catch (Exception exception) {
                    DB.close(rs3, pstmt3);
                    rs3 = null;
                    pstmt3 = null;
                    break block54;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs3, pstmt3);
                rs3 = null;
                pstmt3 = null;
                throw throwable;
            }
            DB.close(rs3, (Statement)pstmt3);
            rs3 = null;
            pstmt3 = null;
        }
        return "OK";
    }

    private class OpemAmtPayment {
        private MPayment payment = null;
        private String DocBaseType = null;
        private int JP_Corporation_ID = 0;
        private int Account_ID = 0;
        private int PrepayAccount_ID = 0;
        private BigDecimal OpenAmt = Env.ZERO;
        private BigDecimal JP_OpenAmtPointOfTime = Env.ZERO;
        private BigDecimal JP_ExchangedPayAmt = Env.ZERO;
        private BigDecimal JP_ExchangedOpenAmt = Env.ZERO;
        private BigDecimal JP_ExchangedOpenAmtPOT = Env.ZERO;
        private BigDecimal Rate = Env.ONE;

        public OpemAmtPayment(MPayment payment, String DocBaseType, int JP_Corporation_ID, int Account_ID, int PrepayAccount_ID) {
            this.payment = payment;
            this.DocBaseType = DocBaseType;
            this.JP_Corporation_ID = JP_Corporation_ID;
            this.Account_ID = Account_ID;
            this.PrepayAccount_ID = PrepayAccount_ID;
            this.OpenAmt = JPierePaymentUtil.getOpenAmtNow(OpenAmtPaymentListPointOfTime.this.getCtx(), payment, OpenAmtPaymentListPointOfTime.this.get_TrxName());
            this.JP_OpenAmtPointOfTime = JPierePaymentUtil.getOpenAmtPointOfTime(OpenAmtPaymentListPointOfTime.this.getCtx(), payment, OpenAmtPaymentListPointOfTime.this.p_JP_PointOfTime, OpenAmtPaymentListPointOfTime.this.get_TrxName());
            if (payment.getC_Currency_ID() == OpenAmtPaymentListPointOfTime.this.m_MAcctSchema.getC_Currency_ID()) {
                this.JP_ExchangedPayAmt = payment.getPayAmt();
                this.JP_ExchangedOpenAmt = this.OpenAmt;
                this.JP_ExchangedOpenAmtPOT = this.JP_OpenAmtPointOfTime;
            } else {
                this.JP_ExchangedPayAmt = MConversionRate.convert((Properties)OpenAmtPaymentListPointOfTime.this.getCtx(), (BigDecimal)payment.getPayAmt(), (int)payment.getC_Currency_ID(), (int)OpenAmtPaymentListPointOfTime.this.m_MAcctSchema.getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
                this.JP_ExchangedOpenAmt = MConversionRate.convert((Properties)OpenAmtPaymentListPointOfTime.this.getCtx(), (BigDecimal)this.OpenAmt, (int)payment.getC_Currency_ID(), (int)OpenAmtPaymentListPointOfTime.this.m_MAcctSchema.getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
                this.JP_ExchangedOpenAmtPOT = MConversionRate.convert((Properties)OpenAmtPaymentListPointOfTime.this.getCtx(), (BigDecimal)this.JP_OpenAmtPointOfTime, (int)payment.getC_Currency_ID(), (int)OpenAmtPaymentListPointOfTime.this.m_MAcctSchema.getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
                this.Rate = MConversionRate.getRate((int)payment.getC_Currency_ID(), (int)OpenAmtPaymentListPointOfTime.this.m_MAcctSchema.getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID());
            }
        }

        public MPayment getPayment() {
            return this.payment;
        }

        public String getDocBaseType() {
            return this.DocBaseType;
        }

        public int getJP_Corporation_ID() {
            return this.JP_Corporation_ID;
        }

        public int getAccount_ID() {
            if (this.payment.isPrepayment()) {
                return this.PrepayAccount_ID;
            }
            return this.Account_ID;
        }

        public BigDecimal getOpenAmt() {
            return this.OpenAmt;
        }

        public BigDecimal getJP_OpenAmtPointOfTime() {
            return this.JP_OpenAmtPointOfTime;
        }

        public BigDecimal getJP_ExchangedPayAmt() {
            return this.JP_ExchangedPayAmt;
        }

        public BigDecimal getJP_ExchangedOpenAmt() {
            return this.JP_ExchangedOpenAmt;
        }

        public BigDecimal getJP_ExchangedOpenAmtPOT() {
            return this.JP_ExchangedOpenAmtPOT;
        }

        public BigDecimal getRate() {
            return this.Rate;
        }
    }
}

