/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Msg;

public class JPierePaySelectionCreateCheck
extends SvrProcess {
    private String p_PaymentRule = null;
    private int p_C_PaySelection_ID = 0;
    private boolean p_onepaymentPerInvoice = false;
    private ArrayList<MPaySelectionCheck> m_list = new ArrayList();
    private static final String JP_BP_BANKkACCOUNT_ID = "JP_BP_BankAccount_ID";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("PaymentRule")) {
                    this.p_PaymentRule = (String)para[i].getParameter();
                } else if (name.equalsIgnoreCase("IsOnePaymentPerInvoice")) {
                    this.p_onepaymentPerInvoice = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_C_PaySelection_ID = this.getRecord_ID();
        if (this.p_PaymentRule != null && this.p_PaymentRule.equals("D")) {
            this.p_PaymentRule = null;
        }
    }

    protected String doIt() throws Exception {
        MPaySelection psel;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_PaySelection_ID=" + this.p_C_PaySelection_ID + ", PaymentRule=" + this.p_PaymentRule);
        }
        if ((psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName())).get_ID() == 0) {
            throw new IllegalArgumentException("Not found C_PaySelection_ID=" + this.p_C_PaySelection_ID);
        }
        if (psel.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        MPaySelectionLine[] lines = psel.getLines(false);
        if (lines.length == 0) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NoInvoiceToPaymentBatch"));
        }
        int i = 0;
        while (i < lines.length) {
            MPaySelectionLine line = lines[i];
            if (line.isActive() && !line.isProcessed()) {
                this.createCheck(line);
            }
            ++i;
        }
        psel.setProcessed(true);
        psel.saveEx();
        String returnMsg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelectionCheck_ID")) + " : " + this.m_list.size();
        this.addBufferLog(0, null, null, returnMsg, 0, 0);
        return Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
    }

    private void createCheck(MPaySelectionLine line) throws Exception {
        MPaySelectionCheck check;
        if (!this.p_onepaymentPerInvoice) {
            int i = 0;
            while (i < this.m_list.size()) {
                check = this.m_list.get(i);
                if (check.getC_BPartner_ID() == line.getInvoice().getC_BPartner_ID() && check.getC_BP_BankAccount_ID() == line.get_ValueAsInt(JP_BP_BANKkACCOUNT_ID)) {
                    check.addLine(line);
                    if (!check.save()) {
                        throw new IllegalStateException("Cannot save MPaySelectionCheck");
                    }
                    line.setC_PaySelectionCheck_ID(check.getC_PaySelectionCheck_ID());
                    line.setProcessed(true);
                    if (!line.save()) {
                        throw new IllegalStateException("Cannot save MPaySelectionLine");
                    }
                    return;
                }
                ++i;
            }
        }
        String PaymentRule = line.getPaymentRule();
        if (this.p_PaymentRule != null && !"D".equals(PaymentRule)) {
            PaymentRule = this.p_PaymentRule;
        }
        if (!(check = new MPaySelectionCheck(line, PaymentRule)).isValid()) {
            int C_BPartner_ID = check.getC_BPartner_ID();
            MBPartner bp = MBPartner.get((Properties)this.getCtx(), (int)C_BPartner_ID);
            StringBuilder msg = new StringBuilder("@NotFound@ @C_BP_BankAccount@: ").append(bp.getName());
            throw new AdempiereUserError(msg.toString());
        }
        check.setC_BP_BankAccount_ID(line.get_ValueAsInt(JP_BP_BANKkACCOUNT_ID));
        if (!check.save()) {
            throw new IllegalStateException("Cannot save MPaySelectionCheck");
        }
        line.setC_PaySelectionCheck_ID(check.getC_PaySelectionCheck_ID());
        line.setProcessed(true);
        if (!line.save()) {
            throw new IllegalStateException("Cannot save MPaySelectionLine");
        }
        this.m_list.add(check);
    }
}

