/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_TableColumnJP;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MEntityType;
import org.compiere.model.MLanguage;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.ModelValidationEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class JPiereImportTableAndColumn
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private IProcessUI processMonitor = null;
    private String message = null;
    private static String BLANK = "blank";
    private boolean p_IsElementUpdateJP = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("IsElementUpdateJP")) {
                this.p_IsElementUpdateJP = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_TableColumnJP ").append("WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Table_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Table_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Window_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Window_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PO_Window_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupPO_Window_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Element_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Element_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Column_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Column_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Reference_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Reference_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Reference_Value_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Reference_Value_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Val_Rule_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Val_Rule_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Process_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Process_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Chart_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Chart_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PA_DashboardContent_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupPA_DashboardContent_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_TableColumnJP WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY AD_Table_ID,TableName, AD_Column_ID, ColumnName ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNum = 0;
        int failureNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                String preTableName = null;
                int preAD_Table_ID = 0;
                X_I_TableColumnJP impData = null;
                while (rs.next()) {
                    impData = new X_I_TableColumnJP(this.getCtx(), rs, this.get_TrxName());
                    ++recordsNum;
                    if (Util.isEmpty((String)impData.getColumnName()) && impData.getAD_Element_ID() == 0) {
                        impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Element_ID"));
                        impData.setI_IsImported(false);
                        impData.setProcessed(false);
                        impData.saveEx(this.get_TrxName());
                        continue;
                    }
                    if (!Util.isEmpty((String)impData.getColumnName()) && impData.getAD_Element_ID() == 0) {
                        if (!this.createElement(impData)) {
                            ++failureNum;
                            continue;
                        }
                    } else if (this.p_IsElementUpdateJP) {
                        this.updateElement(impData, null);
                    }
                    if (impData.getAD_Element_ID() == 0) {
                        ++failureNum;
                        impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Element_ID"));
                        impData.setI_IsImported(false);
                        impData.setProcessed(false);
                        impData.saveEx(this.get_TrxName());
                        continue;
                    }
                    if (!Util.isEmpty((String)impData.getTableName()) && impData.getAD_Table_ID() == 0) {
                        if (!impData.getTableName().equals(preTableName)) {
                            this.insertTable(impData);
                            preTableName = impData.getTableName();
                            preAD_Table_ID = impData.getAD_Table_ID();
                        } else {
                            impData.setAD_Table_ID(preAD_Table_ID);
                        }
                    } else if (impData.getAD_Table_ID() > 0 && impData.getAD_Table_ID() != preAD_Table_ID) {
                        this.updateTable(impData);
                        preAD_Table_ID = impData.getAD_Table_ID();
                    }
                    if (Util.isEmpty((String)impData.getTableName()) && impData.getAD_Table_ID() == 0) {
                        ++successNum;
                        impData.setI_IsImported(true);
                        impData.setProcessed(true);
                        impData.saveEx(this.get_TrxName());
                        continue;
                    }
                    if (impData.getAD_Table_ID() == 0) {
                        ++failureNum;
                        impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Table_ID"));
                        impData.setI_IsImported(false);
                        impData.setProcessed(false);
                        impData.saveEx(this.get_TrxName());
                        continue;
                    }
                    if (this.createUpdateColumn(impData)) {
                        ++successNum;
                        impData.setI_IsImported(true);
                        impData.setProcessed(true);
                    } else {
                        ++failureNum;
                        impData.setI_IsImported(false);
                        impData.setProcessed(false);
                    }
                    impData.saveEx(this.get_TrxName());
                    this.commitEx();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(records) + recordsNum + "( " + success + " : " + successNum + "  /  " + failure + " : " + failureNum + " )";
    }

    public String getImportTableName() {
        return "I_TableColumnJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private boolean createElement(X_I_TableColumnJP impData) {
        M_Element element;
        block23: {
            element = null;
            if (impData.getAD_Element_ID() == 0) {
                String sql = "SELECT * FROM AD_Element WHERE ColumnName=? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)"SELECT * FROM AD_Element WHERE ColumnName=? ", (String)this.get_TrxName());
                        pstmt.setString(1, impData.getColumnName());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            element = new M_Element(this.getCtx(), rs, this.get_TrxName());
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "SELECT * FROM AD_Element WHERE ColumnName=? ", (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            } else {
                element = new M_Element(this.getCtx(), impData.getAD_Element_ID(), this.get_TrxName());
            }
        }
        if (element == null) {
            element = new M_Element(this.getCtx(), 0, this.get_TrxName());
            element.setColumnName(impData.getColumnName());
            if (!Util.isEmpty((String)impData.getAD_Element_UU())) {
                element.setAD_Element_UU(impData.getAD_Element_UU());
            }
            if (Util.isEmpty((String)impData.getJP_Element_Name())) {
                element.setName(element.getColumnName());
            } else {
                element.setName(impData.getJP_Element_Name());
            }
            if (Util.isEmpty((String)impData.getJP_Element_PrintName())) {
                element.setPrintName(element.getName());
            } else {
                element.setPrintName(impData.getJP_Element_PrintName());
            }
            element.setDescription(impData.getJP_Element_Description());
            element.setHelp(impData.getJP_Element_Help());
            element.setPO_Name(impData.getJP_Element_PO_Name());
            element.setPO_PrintName(impData.getJP_Element_PO_PrintName());
            element.setPO_Description(impData.getJP_Element_PO_Description());
            element.setPO_Help(impData.getJP_Element_PO_Help());
            if (Util.isEmpty((String)impData.getJP_Element_EntityType())) {
                element.setEntityType("U");
            } else {
                MEntityType entityTye = MEntityType.get((Properties)this.getCtx(), (String)impData.getJP_Element_EntityType());
                if (entityTye == null) {
                    element.setEntityType("U");
                } else if (entityTye.getAD_EntityType_ID() == 0) {
                    element.setEntityType("U");
                } else {
                    element.setEntityType(impData.getJP_Element_EntityType());
                }
            }
            try {
                element.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Element_ID") + " : " + e.toString());
                impData.setI_IsImported(false);
                impData.setProcessed(false);
                impData.saveEx(this.get_TrxName());
                return false;
            }
        } else {
            impData.setAD_Element_ID(element.getAD_Element_ID());
            return this.updateElement(impData, element);
        }
        impData.setAD_Element_ID(element.getAD_Element_ID());
        this.updateElementTrl(impData, element);
        return true;
    }

    private boolean updateElement(X_I_TableColumnJP impData, M_Element element) {
        MEntityType entityTye;
        boolean isUpdate;
        block42: {
            isUpdate = false;
            if (element == null) {
                String sql = "SELECT * FROM AD_Element WHERE AD_Element_ID=? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)"SELECT * FROM AD_Element WHERE AD_Element_ID=? ", (String)this.get_TrxName());
                        pstmt.setInt(1, impData.getAD_Element_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            element = new M_Element(this.getCtx(), rs, this.get_TrxName());
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "SELECT * FROM AD_Element WHERE AD_Element_ID=? ", (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        if (!Util.isEmpty((String)impData.getAD_Element_UU()) && !impData.getAD_Element_UU().equals(element.getAD_Element_UU())) {
            element.setAD_Element_UU(impData.getAD_Element_UU());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getJP_Element_Name()) && !impData.getJP_Element_Name().equals(element.getName())) {
            element.setName(impData.getJP_Element_Name());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getJP_Element_PrintName()) && !impData.getJP_Element_PrintName().equals(element.getPrintName())) {
            element.setPrintName(impData.getJP_Element_PrintName());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Element_Description())) {
            if (element.getDescription() != null) {
                element.setDescription(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Element_Description()) && !impData.getJP_Element_Description().equals(element.getDescription())) {
            element.setDescription(impData.getJP_Element_Description());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Element_Help())) {
            if (element.getHelp() != null) {
                element.setHelp(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Element_Help()) && !impData.getJP_Element_Help().equals(element.getHelp())) {
            element.setHelp(impData.getJP_Element_Help());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Element_PO_Name())) {
            if (element.getPO_Name() != null) {
                element.setPO_Name(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Element_PO_Name()) && !impData.getJP_Element_PO_Name().equals(element.getPO_Name())) {
            element.setPO_Name(impData.getJP_Element_PO_Name());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Element_PO_PrintName())) {
            if (element.getPO_PrintName() != null) {
                element.setPO_PrintName(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Element_PO_PrintName()) && !impData.getJP_Element_PO_PrintName().equals(element.getPO_PrintName())) {
            element.setPO_PrintName(impData.getJP_Element_PO_PrintName());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Element_PO_Description())) {
            if (element.getPO_Description() != null) {
                element.setPO_Description(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Element_PO_Description()) && !impData.getJP_Element_PO_Description().equals(element.getPO_Description())) {
            element.setPO_Description(impData.getJP_Element_PO_Description());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Element_PO_Help())) {
            if (element.getPO_Help() != null) {
                element.setPO_Help(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Element_PO_Help()) && !impData.getJP_Element_PO_Help().equals(element.getPO_Help())) {
            element.setPO_Help(impData.getJP_Element_PO_Help());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Element_Placeholder())) {
            if (element.getPlaceholder() != null) {
                element.setPlaceholder(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Element_Placeholder()) && !impData.getJP_Element_Placeholder().equals(element.getPlaceholder())) {
            element.setPlaceholder(impData.getJP_Element_Placeholder());
            isUpdate = true;
        }
        if (!(Util.isEmpty((String)impData.getJP_Element_EntityType()) || impData.getJP_Element_EntityType().equals(element.getEntityType()) || "D".equals(element.getEntityType()) || (entityTye = MEntityType.get((Properties)this.getCtx(), (String)impData.getJP_Element_EntityType())) == null || entityTye.getAD_EntityType_ID() == 0)) {
            element.setEntityType(impData.getJP_Element_EntityType());
            isUpdate = true;
        }
        if (isUpdate) {
            try {
                element.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Element_ID") + " : " + e.toString());
                impData.setI_IsImported(false);
                impData.setProcessed(false);
                impData.saveEx(this.get_TrxName());
                return false;
            }
        }
        this.updateElementTrl(impData, element);
        return true;
    }

    private void updateElementTrl(X_I_TableColumnJP impData, M_Element element) {
        block56: {
            if (Util.isEmpty((String)impData.getAD_Language())) {
                return;
            }
            MLanguage lang = MLanguage.get((Properties)this.getCtx(), (String)impData.getAD_Language());
            if (lang == null) {
                impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Language"));
                return;
            }
            if (lang.getAD_Language_ID() == 0) {
                impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Language"));
                return;
            }
            boolean isUpdate = false;
            StringBuilder sql = new StringBuilder("UPDATE AD_Element_Trl SET ");
            int i = 0;
            if (!Util.isEmpty((String)impData.getJP_Element_Trl_Name()) && !impData.getJP_Element_Trl_Name().equals(element.get_Translation("Name"))) {
                sql = sql.append("Name='").append(impData.getJP_Element_Trl_Name()).append("'");
                isUpdate = true;
                ++i;
            }
            if (!Util.isEmpty((String)impData.getAD_Element_Trl_UU())) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("AD_Element_Trl_UU='").append(impData.getAD_Element_Trl_UU()).append("'");
                isUpdate = true;
                ++i;
            }
            if (!Util.isEmpty((String)impData.getJP_Element_Trl_PrintName()) && !impData.getJP_Element_Trl_PrintName().equals(element.get_Translation("PrintName"))) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("PrintName='").append(impData.getJP_Element_Trl_PrintName()).append("'");
                isUpdate = true;
                ++i;
            }
            if (BLANK.equalsIgnoreCase(impData.getJP_Element_Trl_Description())) {
                if (!Util.isEmpty((String)element.get_Translation("Description", impData.getAD_Language(), true, false))) {
                    if (i > 0) {
                        sql = sql.append(",");
                    }
                    sql = sql.append("Description=null");
                    isUpdate = true;
                    ++i;
                }
            } else if (!Util.isEmpty((String)impData.getJP_Element_Trl_Description()) && !impData.getJP_Element_Trl_Description().equals(element.get_Translation("Description"))) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("Description='").append(impData.getJP_Element_Trl_Description()).append("'");
                isUpdate = true;
                ++i;
            }
            if (BLANK.equalsIgnoreCase(impData.getJP_Element_Trl_Help())) {
                if (!Util.isEmpty((String)element.get_Translation("Help", impData.getAD_Language(), true, false))) {
                    if (i > 0) {
                        sql = sql.append(",");
                    }
                    sql = sql.append("Help=null");
                    isUpdate = true;
                    ++i;
                }
            } else if (!Util.isEmpty((String)impData.getJP_Element_Trl_Help()) && !impData.getJP_Element_Trl_Help().equals(element.get_Translation("Help"))) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("Help='").append(impData.getJP_Element_Trl_Help()).append("'");
                isUpdate = true;
                ++i;
            }
            if (BLANK.equalsIgnoreCase(impData.getJP_Element_Trl_PO_Name())) {
                if (!Util.isEmpty((String)element.get_Translation("PO_Name", impData.getAD_Language(), true, false))) {
                    if (i > 0) {
                        sql = sql.append(",");
                    }
                    sql = sql.append("PO_Name=null");
                    isUpdate = true;
                    ++i;
                }
            } else if (!Util.isEmpty((String)impData.getJP_Element_Trl_PO_Name()) && !impData.getJP_Element_Trl_PO_Name().equals(element.get_Translation("PO_Name"))) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("PO_Name='").append(impData.getJP_Element_Trl_PO_Name()).append("'");
                isUpdate = true;
                ++i;
            }
            if (BLANK.equalsIgnoreCase(impData.getJP_Element_Trl_PO_PrintName())) {
                if (!Util.isEmpty((String)element.get_Translation("PO_PrintName", impData.getAD_Language(), true, false))) {
                    if (i > 0) {
                        sql = sql.append(",");
                    }
                    sql = sql.append("PO_PrintName=null");
                    isUpdate = true;
                    ++i;
                }
            } else if (!Util.isEmpty((String)impData.getJP_Element_Trl_PO_PrintName()) && !impData.getJP_Element_Trl_PO_PrintName().equals(element.get_Translation("PO_PrintName"))) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("PO_PrintName='").append(impData.getJP_Element_Trl_PO_PrintName()).append("'");
                isUpdate = true;
                ++i;
            }
            if (BLANK.equalsIgnoreCase(impData.getJP_Element_Trl_PO_Description())) {
                if (!Util.isEmpty((String)element.get_Translation("PO_Description", impData.getAD_Language(), true, false))) {
                    if (i > 0) {
                        sql = sql.append(",");
                    }
                    sql = sql.append("PO_Description=null");
                    isUpdate = true;
                    ++i;
                }
            } else if (!Util.isEmpty((String)impData.getJP_Element_Trl_PO_Description()) && !impData.getJP_Element_Trl_PO_Description().equals(element.get_Translation("PO_Description"))) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("PO_Description='").append(impData.getJP_Element_Trl_PO_Description()).append("'");
                isUpdate = true;
                ++i;
            }
            if (BLANK.equalsIgnoreCase(impData.getJP_Element_Trl_PO_Help())) {
                if (!Util.isEmpty((String)element.get_Translation("PO_Help", impData.getAD_Language(), true, false))) {
                    if (i > 0) {
                        sql = sql.append(",");
                    }
                    sql = sql.append("PO_Help=null");
                    isUpdate = true;
                    ++i;
                }
            } else if (!Util.isEmpty((String)impData.getJP_Element_Trl_PO_Help()) && !impData.getJP_Element_Trl_PO_Help().equals(element.get_Translation("PO_Help"))) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("PO_Help='").append(impData.getJP_Element_Trl_PO_Help()).append("'");
                isUpdate = true;
                ++i;
            }
            if (BLANK.equalsIgnoreCase(impData.getJP_Element_Trl_PO_Help())) {
                if (!Util.isEmpty((String)element.get_Translation("Placeholder", impData.getAD_Language(), true, false))) {
                    if (i > 0) {
                        sql = sql.append(",");
                    }
                    sql = sql.append("Placeholder=null");
                    isUpdate = true;
                    ++i;
                }
            } else if (!Util.isEmpty((String)impData.getJP_Element_Trl_Placeholder()) && !impData.getJP_Element_Trl_Placeholder().equals(element.get_Translation("Placeholder"))) {
                if (i > 0) {
                    sql = sql.append(",");
                }
                sql = sql.append("Placeholder='").append(impData.getJP_Element_Trl_PO_Help()).append("'");
                isUpdate = true;
                ++i;
            }
            if (isUpdate) {
                sql = sql.append(" WHERE AD_Element_ID= ? AND AD_Language=?");
                CPreparedStatement pstmt = null;
                Object rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                        pstmt.setInt(1, impData.getAD_Element_ID());
                        pstmt.setString(2, impData.getAD_Language());
                        pstmt.executeUpdate();
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block56;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
    }

    private boolean insertTable(X_I_TableColumnJP imp) {
        MTable table = new MTable(this.getCtx(), 0, this.get_TrxName());
        table.setTableName(imp.getTableName());
        if (!Util.isEmpty((String)imp.getAD_Table_UU())) {
            table.setAD_Table_UU(imp.getAD_Table_UU());
        }
        if (Util.isEmpty((String)imp.getJP_Table_Name())) {
            table.setName(imp.getTableName());
        } else {
            table.setName(imp.getJP_Table_Name());
        }
        if (!Util.isEmpty((String)imp.getJP_Table_Description())) {
            table.setDescription(imp.getJP_Table_Description());
        }
        if (!Util.isEmpty((String)imp.getJP_Table_Help())) {
            table.setHelp(imp.getJP_Table_Help());
        }
        if (Util.isEmpty((String)imp.getAccessLevel())) {
            table.setAccessLevel("7");
        } else {
            table.setAccessLevel(imp.getAccessLevel());
        }
        if (!Util.isEmpty((String)imp.getIsView())) {
            table.setIsView("Y".equals(imp.getIsView()));
        }
        if (!Util.isEmpty((String)imp.getIsChangeLog())) {
            table.setIsChangeLog("Y".equals(imp.getIsChangeLog()));
        }
        if (!Util.isEmpty((String)imp.getIsDeleteable())) {
            table.setIsDeleteable("Y".equals(imp.getIsDeleteable()));
        }
        if (!Util.isEmpty((String)imp.getIsHighVolume())) {
            table.setIsHighVolume("Y".equals(imp.getIsHighVolume()));
        }
        if (imp.getAD_Window_ID() > 0) {
            table.setAD_Window_ID(imp.getAD_Window_ID());
        }
        if (imp.getPO_Window_ID() > 0) {
            table.setPO_Window_ID(imp.getPO_Window_ID());
        }
        if (Util.isEmpty((String)imp.getJP_Table_EntityType())) {
            table.setEntityType("U");
        } else {
            MEntityType entityTye = MEntityType.get((Properties)this.getCtx(), (String)imp.getJP_Table_EntityType());
            if (entityTye == null) {
                table.setEntityType("U");
            } else if (entityTye.getAD_EntityType_ID() == 0) {
                table.setEntityType("U");
            } else {
                table.setEntityType(imp.getJP_Table_EntityType());
            }
        }
        try {
            table.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            imp.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Table_ID") + " : " + e.toString());
            imp.setI_IsImported(false);
            imp.setProcessed(false);
            imp.saveEx(this.get_TrxName());
            return false;
        }
        imp.setAD_Table_ID(table.getAD_Table_ID());
        return true;
    }

    private boolean updateTable(X_I_TableColumnJP imp) {
        MEntityType entityTye;
        MTable table = new MTable(this.getCtx(), imp.getAD_Table_ID(), this.get_TrxName());
        boolean isUpdate = false;
        if (!Util.isEmpty((String)imp.getAD_Table_UU()) && !imp.getAD_Table_UU().equals(table.getAD_Table_UU())) {
            table.setAD_Table_UU(imp.getAD_Table_UU());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)imp.getJP_Table_Name()) && !imp.getJP_Table_Name().equals(table.getName())) {
            table.setName(imp.getJP_Table_Name());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(imp.getJP_Table_Description())) {
            if (table.getDescription() != null) {
                table.setDescription(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)imp.getJP_Table_Description()) && !imp.getJP_Table_Description().equals(table.getDescription())) {
            table.setDescription(imp.getJP_Table_Description());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(imp.getJP_Table_Help())) {
            if (table.getHelp() != null) {
                table.setHelp(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)imp.getJP_Table_Help()) && !imp.getJP_Table_Help().equals(table.getHelp())) {
            table.setHelp(imp.getJP_Table_Help());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)imp.getAccessLevel()) && !imp.getAccessLevel().equals(table.getAccessLevel())) {
            table.setAccessLevel(imp.getAccessLevel());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)imp.getIsView()) && "Y".equals(imp.getIsView()) != table.isView()) {
            table.setIsView("Y".equals(imp.getIsView()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)imp.getIsChangeLog()) && "Y".equals(imp.getIsChangeLog()) != table.isChangeLog()) {
            table.setIsChangeLog("Y".equals(imp.getIsChangeLog()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)imp.getIsDeleteable()) && "Y".equals(imp.getIsDeleteable()) != table.isDeleteable()) {
            table.setIsDeleteable("Y".equals(imp.getIsDeleteable()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)imp.getIsHighVolume()) && "Y".equals(imp.getIsHighVolume()) != table.isHighVolume()) {
            table.setIsHighVolume("Y".equals(imp.getIsHighVolume()));
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(imp.getJP_Window_Name())) {
            if (table.getAD_Window_ID() > 0) {
                table.setAD_Window_ID(0);
                isUpdate = true;
            }
        } else if (imp.getAD_Window_ID() > 0 && imp.getAD_Window_ID() != table.getAD_Window_ID()) {
            table.setAD_Window_ID(imp.getAD_Window_ID());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(imp.getJP_PO_Window_Name())) {
            if (table.getPO_Window_ID() > 0) {
                table.setPO_Window_ID(0);
                isUpdate = true;
            }
        } else if (imp.getPO_Window_ID() > 0 && imp.getPO_Window_ID() != table.getPO_Window_ID()) {
            table.setPO_Window_ID(imp.getPO_Window_ID());
            isUpdate = true;
        }
        if (!(Util.isEmpty((String)imp.getJP_Table_EntityType()) || imp.getJP_Table_EntityType().equals(table.getEntityType()) || "D".equals(table.getEntityType()) || (entityTye = MEntityType.get((Properties)this.getCtx(), (String)imp.getJP_Table_EntityType())) == null || entityTye.getAD_EntityType_ID() == 0)) {
            table.setEntityType(imp.getJP_Table_EntityType());
            isUpdate = true;
        }
        if (isUpdate) {
            try {
                table.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                imp.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Table_ID") + " : " + e.toString());
                imp.setI_IsImported(false);
                imp.setProcessed(false);
                imp.saveEx(this.get_TrxName());
                return false;
            }
        }
        return true;
    }

    private boolean createUpdateColumn(X_I_TableColumnJP impData) {
        MEntityType entityTye;
        MColumn column = null;
        boolean isUpdate = false;
        boolean isColumnSync = false;
        if (impData.getAD_Column_ID() > 0) {
            column = new MColumn(this.getCtx(), impData.getAD_Column_ID(), this.get_TrxName());
        } else {
            MTable table = new MTable(this.getCtx(), impData.getAD_Table_ID(), this.get_TrxName());
            MColumn[] columns = table.getColumns(true);
            int i = 0;
            while (i < columns.length) {
                if (columns[i].getColumnName().equalsIgnoreCase(impData.getColumnName())) {
                    column = columns[i];
                    break;
                }
                ++i;
            }
            if (column == null) {
                column = new MColumn(this.getCtx(), 0, this.get_TrxName());
                isUpdate = true;
                isColumnSync = true;
            }
            if (impData.getAD_Element_ID() == 0) {
                impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Element_ID"));
                return false;
            }
            column.setColumnName(impData.getAD_Element().getColumnName());
        }
        if (column.getAD_Column_ID() == 0) {
            column.setAD_Table_ID(impData.getAD_Table_ID());
            column.setAD_Element_ID(impData.getAD_Element_ID());
        }
        if (!Util.isEmpty((String)impData.getAD_Column_UU()) && !impData.getAD_Column_UU().equals(column.getAD_Column_UU())) {
            column.setAD_Column_UU(impData.getAD_Column_UU());
            isUpdate = true;
        }
        if (column.getAD_Column_ID() == 0 && Util.isEmpty((String)impData.getJP_Column_Name())) {
            column.setName(impData.getAD_Element().getName());
        } else if (!Util.isEmpty((String)impData.getJP_Column_Name()) && !impData.getJP_Column_Name().equals(column.getName())) {
            column.setName(impData.getJP_Column_Name());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Column_Description())) {
            if (column.getDescription() != null) {
                column.setDescription(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Column_Description()) && !impData.getJP_Column_Description().equals(column.getDescription())) {
            column.setDescription(impData.getJP_Column_Description());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Column_Help())) {
            if (column.getHelp() != null) {
                column.setHelp(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Column_Help()) && !impData.getJP_Column_Help().equals(column.getHelp())) {
            column.setHelp(impData.getJP_Column_Help());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Column_Placeholder())) {
            if (column.getPlaceholder() != null) {
                column.setPlaceholder(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Column_Placeholder()) && !impData.getJP_Column_Placeholder().equals(column.getPlaceholder())) {
            column.setPlaceholder(impData.getJP_Column_Placeholder());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getColumnSQL())) {
            if (column.getColumnSQL() != null) {
                column.setColumnSQL(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getColumnSQL()) && !impData.getColumnSQL().equals(column.getColumnSQL())) {
            column.setColumnSQL(impData.getColumnSQL());
            isUpdate = true;
        }
        if (impData.getVersion() != null && impData.getVersion().compareTo(Env.ZERO) != 0 && impData.getVersion() != column.getVersion()) {
            column.setVersion(impData.getVersion());
            isUpdate = true;
        }
        if (column.getAD_Column_ID() == 0 && impData.getAD_Reference_ID() == 0) {
            impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Reference_ID"));
            return false;
        }
        if (impData.getAD_Reference_ID() > 0 && impData.getAD_Reference_ID() != column.getAD_Reference_ID()) {
            column.setAD_Reference_ID(impData.getAD_Reference_ID());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Reference_Value_Name())) {
            if (column.getAD_Reference_Value_ID() > 0) {
                column.setAD_Reference_Value_ID(0);
                isUpdate = true;
            }
        } else if (impData.getAD_Reference_Value_ID() > 0 && impData.getAD_Reference_Value_ID() != column.getAD_Reference_Value_ID()) {
            column.setAD_Reference_Value_ID(impData.getAD_Reference_Value_ID());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Val_Rule_Name())) {
            if (column.getAD_Val_Rule_ID() > 0) {
                column.setAD_Val_Rule_ID(0);
                isUpdate = true;
            }
        } else if (impData.getAD_Val_Rule_ID() > 0 && impData.getAD_Val_Rule_ID() != column.getAD_Val_Rule_ID()) {
            column.setAD_Val_Rule_ID(impData.getAD_Val_Rule_ID());
            isUpdate = true;
        }
        if (impData.getFieldLength() != 0 && impData.getFieldLength() != column.getFieldLength()) {
            column.setFieldLength(impData.getFieldLength());
            isUpdate = true;
            isColumnSync = true;
        }
        if (!Util.isEmpty((String)impData.getIsKey()) && "Y".equals(impData.getIsKey()) != column.isKey()) {
            column.setIsKey("Y".equals(impData.getIsKey()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsParent()) && "Y".equals(impData.getIsParent()) != column.isParent()) {
            column.setIsParent("Y".equals(impData.getIsParent()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsMandatory()) && "Y".equals(impData.getIsMandatory()) != column.isMandatory()) {
            column.setIsMandatory("Y".equals(impData.getIsMandatory()));
            isUpdate = true;
            isColumnSync = true;
        }
        if (!Util.isEmpty((String)impData.getIsUpdateable()) && "Y".equals(impData.getIsUpdateable()) != column.isUpdateable()) {
            column.setIsUpdateable("Y".equals(impData.getIsUpdateable()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsAlwaysUpdateable()) && "Y".equals(impData.getIsAlwaysUpdateable()) != column.isAlwaysUpdateable()) {
            column.setIsAlwaysUpdateable("Y".equals(impData.getIsAlwaysUpdateable()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsIdentifier()) && "Y".equals(impData.getIsIdentifier()) != column.isIdentifier()) {
            column.setIsIdentifier("Y".equals(impData.getIsIdentifier()));
            isUpdate = true;
        }
        if (impData.getSeqNo() != 0 && impData.getSeqNo() != column.getSeqNo()) {
            column.setSeqNo(impData.getSeqNo());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsSelectionColumn()) && "Y".equals(impData.getIsSelectionColumn()) != column.isSelectionColumn()) {
            column.setIsSelectionColumn("Y".equals(impData.getIsSelectionColumn()));
            isUpdate = true;
        }
        if (impData.getSeqNoSelection() != 0 && impData.getSeqNoSelection() != column.getSeqNoSelection()) {
            column.setSeqNoSelection(impData.getSeqNoSelection());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getVFormat())) {
            if (column.getVFormat() != null) {
                column.setVFormat(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getVFormat()) && !impData.getVFormat().equals(column.getVFormat())) {
            column.setVFormat(impData.getVFormat());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getFormatPattern())) {
            if (column.getFormatPattern() != null) {
                column.setFormatPattern(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getFormatPattern()) && !impData.getFormatPattern().equals(column.getFormatPattern())) {
            column.setFormatPattern(impData.getFormatPattern());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getValueMin())) {
            if (column.getValueMin() != null) {
                column.setValueMin(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getValueMin()) && !impData.getValueMin().equals(column.getValueMin())) {
            column.setValueMin(impData.getValueMin());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getValueMax())) {
            if (column.getValueMax() != null) {
                column.setValueMax(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getValueMax()) && !impData.getValueMax().equals(column.getValueMax())) {
            column.setValueMax(impData.getValueMax());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Process_Value())) {
            if (column.getAD_Process_ID() > 0) {
                column.setAD_Process_ID(0);
                isUpdate = true;
            }
        } else if (impData.getAD_Process_ID() != column.getAD_Process_ID()) {
            column.setAD_Process_ID(impData.getAD_Process_ID());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsToolbarButton()) && !impData.getIsToolbarButton().equals(column.getIsToolbarButton())) {
            column.setIsToolbarButton(impData.getIsToolbarButton());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Chart_Name())) {
            if (column.getAD_Chart_ID() > 0) {
                column.setAD_Chart_ID(0);
                isUpdate = true;
            }
        } else if (impData.getAD_Chart_ID() != column.getAD_Chart_ID()) {
            column.setAD_Chart_ID(impData.getAD_Chart_ID());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_DashboardContent_Name())) {
            if (column.getPA_DashboardContent_ID() > 0) {
                column.setPA_DashboardContent_ID(0);
                isUpdate = true;
            }
        } else if (impData.getPA_DashboardContent_ID() != column.getPA_DashboardContent_ID()) {
            column.setPA_DashboardContent_ID(impData.getPA_DashboardContent_ID());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getFKConstraintName()) && !impData.getFKConstraintName().equals(column.getFKConstraintName())) {
            column.setFKConstraintName(impData.getFKConstraintName());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getFKConstraintType()) && !impData.getFKConstraintType().equals(column.getFKConstraintType())) {
            column.setFKConstraintType(impData.getFKConstraintType());
            isUpdate = true;
            isColumnSync = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getJP_Column_Placeholder())) {
            if (column.getPlaceholder() != null) {
                column.setPlaceholder(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getJP_Column_Placeholder()) && !impData.getJP_Column_Placeholder().equals(column.getPlaceholder())) {
            column.setPlaceholder(impData.getJP_Column_Placeholder());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getDefaultValue())) {
            if (column.getDefaultValue() != null) {
                column.setDefaultValue(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getDefaultValue()) && !impData.getDefaultValue().equals(column.getDefaultValue())) {
            column.setDefaultValue(impData.getDefaultValue());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getReadOnlyLogic())) {
            if (column.getReadOnlyLogic() != null) {
                column.setReadOnlyLogic(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getReadOnlyLogic()) && !impData.getReadOnlyLogic().equals(column.getReadOnlyLogic())) {
            column.setReadOnlyLogic(impData.getReadOnlyLogic());
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getMandatoryLogic())) {
            if (column.getMandatoryLogic() != null) {
                column.setMandatoryLogic(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getMandatoryLogic()) && !impData.getMandatoryLogic().equals(column.getMandatoryLogic())) {
            column.setMandatoryLogic(impData.getMandatoryLogic());
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsAutocomplete()) && "Y".equals(impData.getIsAutocomplete()) != column.isAutocomplete()) {
            column.setIsAutocomplete("Y".equals(impData.getIsAutocomplete()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsAllowCopy()) && "Y".equals(impData.getIsAllowCopy()) != column.isAllowCopy()) {
            column.setIsAllowCopy("Y".equals(impData.getIsAllowCopy()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsAllowLogging()) && "Y".equals(impData.getIsAllowLogging()) != column.isAllowLogging()) {
            column.setIsAllowLogging("Y".equals(impData.getIsAllowLogging()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsSecure()) && "Y".equals(impData.getIsSecure()) != column.isSecure()) {
            column.setIsSecure("Y".equals(impData.getIsSecure()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsHtml()) && "Y".equals(impData.getIsHtml()) != column.isHtml()) {
            column.setIsHtml("Y".equals(impData.getIsHtml()));
            isUpdate = true;
        }
        if (!Util.isEmpty((String)impData.getIsTranslated()) && "Y".equals(impData.getIsTranslated()) != column.isTranslated()) {
            column.setIsTranslated("Y".equals(impData.getIsTranslated()));
            isUpdate = true;
        }
        if (BLANK.equalsIgnoreCase(impData.getCallout())) {
            if (column.getCallout() != null) {
                column.setCallout(null);
                isUpdate = true;
            }
        } else if (!Util.isEmpty((String)impData.getCallout()) && !impData.getCallout().equals(column.getCallout())) {
            column.setCallout(impData.getCallout());
            isUpdate = true;
        }
        if (column.getAD_Column_ID() == 0) {
            if (Util.isEmpty((String)impData.getJP_Table_EntityType())) {
                column.setEntityType("U");
            } else {
                entityTye = MEntityType.get((Properties)this.getCtx(), (String)impData.getJP_Column_EntityType());
                if (entityTye == null) {
                    column.setEntityType("U");
                } else if (entityTye.getAD_EntityType_ID() == 0) {
                    column.setEntityType("U");
                } else {
                    column.setEntityType(impData.getJP_Column_EntityType());
                }
            }
        } else if (!(Util.isEmpty((String)impData.getJP_Column_EntityType()) || impData.getJP_Column_EntityType().equals(column.getEntityType()) || "D".equals(column.getEntityType()) || (entityTye = MEntityType.get((Properties)this.getCtx(), (String)impData.getJP_Column_EntityType())) == null || entityTye.getAD_EntityType_ID() == 0)) {
            column.setEntityType(impData.getJP_Column_EntityType());
            isUpdate = true;
        }
        if (isUpdate) {
            try {
                column.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Column_ID") + " : " + e.toString());
                impData.setI_IsImported(false);
                impData.setProcessed(false);
                impData.saveEx(this.get_TrxName());
                return false;
            }
        }
        if (impData.getAD_Column_ID() == 0) {
            impData.setAD_Column_ID(column.getAD_Column_ID());
        }
        if (isColumnSync) {
            if (impData.getAD_Table().isView()) {
                return true;
            }
            if (!Util.isEmpty((String)column.getColumnSQL())) {
                return true;
            }
            if (column.getAD_Reference_ID() == 53370) {
                return true;
            }
            ProcessInfo pi = new ProcessInfo("Synchronize Column", 0);
            pi.setClassName("org.compiere.process.ColumnSync");
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
            pi.setRecord_ID(column.getAD_Column_ID());
            ProcessInfoParameter[] pars = new ProcessInfoParameter[]{};
            pi.setParameter(pars);
            boolean success = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI);
            if (!success) {
                impData.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessFailed")) + " : Synchronize Column");
            }
        }
        return true;
    }

    private boolean reverseLookupAD_Table_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table p").append(" WHERE Upper(i.TableName)=Upper(p.TableName) AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.AD_Table_ID IS NULL AND i.TableName IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Reverese Look up  AD_Table_ID From Name =#" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Window_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Window_ID=(SELECT AD_Window_ID FROM AD_Window p").append(" WHERE i.JP_Window_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.AD_Window_ID IS NULL AND i.JP_Window_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Reverse lookup AD_Window_ID From JP_Window_Namee =#" + no + ":" + sql.toString());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql.toString());
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Window_Name");
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE AD_Window_ID IS NULL AND JP_Window_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Reverse lookup AD_Window_ID From JP_Window_Namee =#" + no + ":" + sql.toString());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupPO_Window_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET PO_Window_ID=(SELECT AD_Window_ID FROM AD_Window p").append(" WHERE i.JP_PO_Window_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.PO_Window_ID IS NULL AND i.JP_PO_Window_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PO_Window_Name");
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE PO_Window_ID IS NULL AND JP_PO_Window_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Element_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Element_ID=(SELECT AD_Element_ID FROM AD_Element p").append(" WHERE Upper(i.ColumnName)=Upper(p.ColumnName) AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.AD_Element_ID IS NULL AND i.ColumnName IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Column_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Column_ID=(SELECT AD_Column_ID FROM AD_Column p").append(" WHERE Upper(i.ColumnName)=Upper(p.ColumnName) AND i.AD_Client_ID=p.AD_Client_ID AND i.AD_Table_ID = p.AD_Table_ID ) ").append("WHERE i.AD_Column_ID IS NULL AND i.ColumnName IS NOT NULL ").append(" AND i.I_IsImported<>'Y' ").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Reference_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Reference_ID=(SELECT AD_Reference_ID FROM AD_Reference p").append(" WHERE i.JP_Reference_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID AND p.validationType='D') ").append("WHERE i.AD_Reference_ID IS NULL AND i.JP_Reference_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Reference_Name");
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE AD_Reference_ID IS NULL AND JP_Reference_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Reference_Value_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Reference_Value_ID=(SELECT AD_Reference_ID FROM AD_Reference p").append(" WHERE i.JP_Reference_Value_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID AND p.validationType IN ('L','T') ) ").append("WHERE i.AD_Reference_Value_ID IS NULL AND i.JP_Reference_Value_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Reference_Value_Name");
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE AD_Reference_Value_ID IS NULL AND JP_Reference_Value_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Val_Rule_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Val_Rule_ID=(SELECT AD_Val_Rule_ID FROM AD_Val_Rule p").append(" WHERE i.JP_Val_Rule_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.AD_Val_Rule_ID IS NULL AND i.JP_Val_Rule_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Val_Rule_Name");
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE AD_Val_Rule_ID IS NULL AND JP_Val_Rule_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Process_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Process_ID=(SELECT AD_Process_ID FROM AD_Process p").append(" WHERE i.JP_Process_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.AD_Process_ID IS NULL AND i.JP_Process_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Process_Value");
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE AD_Process_ID IS NULL AND JP_Process_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Chart_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET AD_Chart_ID=(SELECT AD_Chart_ID FROM AD_Chart p").append(" WHERE i.JP_Chart_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.AD_Chart_ID IS NULL AND i.JP_Chart_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Chart_Name");
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE AD_Chart_ID IS NULL AND JP_Chart_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupPA_DashboardContent_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_TableColumnJP i ").append("SET PA_DashboardContent_ID=(SELECT PA_DashboardContent_ID FROM PA_DashboardContent p").append(" WHERE i.JP_DashboardContent_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.PA_DashboardContent_ID IS NULL AND i.JP_DashboardContent_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.message) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_DashboardContent_Name");
        sql = new StringBuilder("UPDATE I_TableColumnJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE PA_DashboardContent_ID IS NULL AND JP_DashboardContent_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }
}

