/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_CostJP;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MCost;
import org.compiere.model.ModelValidationEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereImportProductCost
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private String message = null;
    private IProcessUI processMonitor = null;
    private long startTime = System.currentTimeMillis();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_CostJP ").append("WHERE I_IsImported='Y'").append(clientCheck);
            try {
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Product_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_CostType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_CostType_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_CostElement_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_CostElement_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_AcctSchema_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_CostJP WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY AD_Org_ID, C_AcctSchema_ID, M_CostType_ID, M_CostElement_ID, M_Product_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                MCost updateCost = null;
                X_I_CostJP importCost = null;
                while (rs.next()) {
                    ++recordsNum;
                    importCost = new X_I_CostJP(this.getCtx(), rs, this.get_TrxName());
                    updateCost = MCost.get((Properties)this.getCtx(), (int)importCost.getAD_Client_ID(), (int)importCost.getAD_Org_ID(), (int)importCost.getM_Product_ID(), (int)importCost.getM_CostType_ID(), (int)importCost.getC_AcctSchema_ID(), (int)importCost.getM_CostElement_ID(), (int)0, (String)this.get_TrxName());
                    if (updateCost == null) {
                        importCost.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound"));
                        importCost.save(this.get_TrxName());
                        this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " / " + failure + " : " + ++failureUpdateNum);
                        this.commitEx();
                        continue;
                    }
                    if (importCost.getCurrentCostPrice() != null && importCost.getCurrentCostPrice().compareTo(Env.ZERO) != 0) {
                        updateCost.setCurrentCostPrice(importCost.getCurrentCostPrice());
                    }
                    if (importCost.getFutureCostPrice() != null && importCost.getFutureCostPrice().compareTo(Env.ZERO) != 0) {
                        updateCost.setFutureCostPrice(importCost.getFutureCostPrice());
                    }
                    if (importCost.getCurrentCostPriceLL() != null && importCost.getCurrentCostPriceLL().compareTo(Env.ZERO) != 0) {
                        updateCost.setCurrentCostPriceLL(importCost.getCurrentCostPriceLL());
                    }
                    if (importCost.getFutureCostPriceLL() != null && importCost.getFutureCostPriceLL().compareTo(Env.ZERO) != 0) {
                        updateCost.setFutureCostPriceLL(importCost.getFutureCostPrice());
                    }
                    if (importCost.getCurrentQty() != null && importCost.getCurrentQty().compareTo(Env.ZERO) != 0) {
                        updateCost.setCurrentQty(importCost.getCurrentQty());
                    }
                    updateCost.setIsCostFrozen(importCost.isCostFrozen());
                    if (importCost.getCumulatedQty() != null && importCost.getCumulatedQty().compareTo(Env.ZERO) != 0) {
                        updateCost.setCumulatedQty(importCost.getCumulatedQty());
                    }
                    if (importCost.getCumulatedAmt() != null && importCost.getCumulatedAmt().compareTo(Env.ZERO) != 0) {
                        updateCost.setCumulatedAmt(importCost.getCumulatedAmt());
                    }
                    try {
                        updateCost.saveEx(this.get_TrxName());
                    }
                    catch (Exception e) {
                        importCost.setI_ErrorMsg(e.toString());
                        importCost.save(this.get_TrxName());
                        ++failureUpdateNum;
                    }
                    importCost.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
                    importCost.setI_IsImported(true);
                    importCost.setProcessed(true);
                    importCost.saveEx(this.get_TrxName());
                    this.commitEx();
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " / " + failure + " : " + failureUpdateNum);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        long endTime = System.currentTimeMillis();
        long time = endTime - this.startTime;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timeFormatted = formatter.format(time);
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + "  " + timeFormatted + " ( " + records + " : " + recordsNum + " / " + failure + " : " + failureUpdateNum + " )";
    }

    public String getImportTableName() {
        return "I_CostJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_CostJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID IS Null ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_Product_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_CostJP i ").append("SET M_Product_ID=(SELECT M_Product_ID FROM M_Product p").append(" WHERE i.JP_Product_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.M_Product_ID IS NULL AND i.JP_Product_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Product_Value");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Product_Value IS NOT NULL AND M_Product_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        if (no > 0) {
            return false;
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Product_Value");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Product_Value IS NULL AND M_Product_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_AcctSchema_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        int no = 0;
        sql = new StringBuilder("UPDATE I_CostJP i ").append("SET C_AcctSchema_ID=(SELECT C_AcctSchema_ID FROM C_AcctSchema p").append(" WHERE i.JP_AcctSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        if (no > 0) {
            return false;
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_AcctSchema_Name IS NULL AND C_AcctSchema_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_CostType_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_CostJP i ").append("SET M_CostType_ID=(SELECT M_CostType_ID FROM M_CostType p").append(" WHERE i.JP_CostType_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_CostType_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_CostType_Name");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_CostType_Name IS NOT NULL AND M_CostType_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        if (no > 0) {
            return false;
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") + Msg.getElement((Properties)this.getCtx(), (String)"JP_CostType_Name");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_CostType_Name IS NULL AND M_CostType_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_CostElement_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_CostJP i ").append("SET M_CostElement_ID=(SELECT M_CostElement_ID FROM M_CostElement p").append(" WHERE i.JP_CostElement_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_CostElement_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_CostElement_Name");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_CostElement_Name IS NOT NULL AND M_CostElement_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        if (no > 0) {
            return false;
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") + Msg.getElement((Properties)this.getCtx(), (String)"JP_CostElement_Name");
        sql = new StringBuilder("UPDATE I_CostJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_CostElement_Name IS NULL AND M_CostElement_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }
}

