/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_ProductJP;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MColumn;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportProduct
extends SvrProcess
implements ImportProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private String p_JP_ImportSalesRepIdentifier = "VN";
    private IProcessUI processMonitor = null;
    private String message = null;
    private long startTime = System.currentTimeMillis();

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("JP_ImportSalesRepIdentifier")) {
                this.p_JP_ImportSalesRepIdentifier = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_ProductJP ").append("WHERE I_IsImported='Y' AND Processed='Y' ").append(clientCheck);
            try {
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Delete Old Imported =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Product_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_Category_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Product_Category_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_TaxCategory_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_TaxCategory_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_UOM_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_UOM_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_FreightCategory_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_FreightCategory_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_PartType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_PartType_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"S_ExpenseType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupS_ExpenseType_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"S_Resource_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupS_Resource_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_AttributeSet_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_AttributeSet_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"SalesRep_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupSalesRep_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"R_MailText_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupR_MailText_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Locator_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Locator_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Currency_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Currency_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Register")) + " & " + Msg.getMsg((Properties)this.getCtx(), (String)"Update") + " " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        sql = new StringBuilder("SELECT * FROM I_ProductJP WHERE I_IsImported='N' OR Processed='N' ").append(clientCheck).append(" ORDER BY Value ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                String lastValue = "";
                MProduct product = null;
                boolean isNew = true;
                while (rs.next()) {
                    X_I_ProductJP imp = new X_I_ProductJP(this.getCtx(), rs, this.get_TrxName());
                    if (imp.getM_Product_ID() != 0) {
                        product = new MProduct(this.getCtx(), imp.getM_Product_ID(), this.get_TrxName());
                        if (Util.isEmpty((String)product.getValue())) {
                            isNew = true;
                            lastValue = imp.getValue();
                        } else {
                            isNew = false;
                            lastValue = product.getValue();
                        }
                    } else if (lastValue.equals(imp.getValue())) {
                        isNew = false;
                    } else {
                        isNew = true;
                        lastValue = imp.getValue();
                    }
                    if (isNew) {
                        product = new MProduct(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewProduct(imp, product)) {
                            ++successNewNum;
                            imp.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
                            imp.setI_IsImported(true);
                            imp.setProcessed(true);
                            imp.saveEx(this.get_TrxName());
                        } else {
                            ++failureNewNum;
                            this.rollback();
                            imp.setI_ErrorMsg(this.message);
                            imp.setI_IsImported(false);
                            imp.setProcessed(false);
                            imp.saveEx(this.get_TrxName());
                        }
                    } else if (this.updateProduct(imp, product)) {
                        ++successUpdateNum;
                        imp.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                        imp.saveEx(this.get_TrxName());
                    } else {
                        ++failureUpdateNum;
                        this.rollback();
                        imp.setI_ErrorMsg(this.message);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        long endTime = System.currentTimeMillis();
        long time = endTime - this.startTime;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timeFormatted = formatter.format(time);
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + "  " + timeFormatted + "  " + records + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    public String getImportTableName() {
        return "I_ProductJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
        return msgreturn.toString();
    }

    private boolean reverseLookupM_Product_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET M_Product_ID=(SELECT M_Product_ID FROM M_Product p").append(" WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.M_Product_ID IS NULL AND i.Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET M_Product_ID=(SELECT M_Product_ID FROM M_Product p").append(" WHERE i.UPC=p.UPC AND i.AD_Client_ID=p.AD_Client_ID) ").append(" WHERE i.UPC IS NOT NULL AND i.M_Product_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.reverseLookupC_BPartner_ID();
        sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET M_Product_ID=(SELECT M_Product_ID FROM M_Product_po p").append(" WHERE i.C_BPartner_ID=p.C_BPartner_ID").append(" AND i.VendorProductNo=p.VendorProductNo AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.VendorProductNo IS NOT NULL AND i.M_Product_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") + Msg.getElement((Properties)this.getCtx(), (String)"Value");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE Value IS NULL AND M_Product_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private void reverseLookupC_BPartner_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"BPartner_Value");
        sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.BPartner_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_BPartner_ID IS NULL AND i.BPartner_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Found Business Partner =" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"BPartner_Value");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + msg + "'").append("WHERE C_BPartner_ID IS NULL AND BPartner_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
        this.commitEx();
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_Product_Category_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET M_Product_Category_ID=(SELECT M_Product_Category_ID FROM M_Product_Category p").append(" WHERE i.ProductCategory_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.ProductCategory_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"ProductCategory_Value");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE ProductCategory_Value IS NOT NULL AND M_Product_Category_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        if (no > 0) {
            return false;
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_Category_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"IsDefault");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET ProductCategory_Value=(SELECT MAX(Value) FROM M_Product_Category").append(" WHERE IsDefault='Y' AND AD_Client_ID=").append(this.p_AD_Client_ID).append(") ").append("WHERE ProductCategory_Value IS NULL AND M_Product_Category_ID IS NULL").append(" AND M_Product_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupC_TaxCategory_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET C_TaxCategory_ID=(SELECT C_TaxCategory_ID FROM C_TaxCategory p").append(" WHERE i.JP_TaxCategory_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_TaxCategory_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxCategory_Name");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_TaxCategory_Name IS NOT NULL AND C_TaxCategory_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_UOM_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET C_UOM_ID=(SELECT C_UOM_ID FROM C_UOM p").append(" WHERE i.X12DE355=p.X12DE355 AND (i.AD_Client_ID=p.AD_Client_ID OR p.AD_Client_ID = 0) ) ").append("WHERE X12DE355 IS NOT NULL").append(" AND I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"X12DE355");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE X12DE355 IS NOT NULL AND C_UOM_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_FreightCategory_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET M_FreightCategory_ID=(SELECT M_FreightCategory_ID FROM M_FreightCategory p").append(" WHERE i.JP_FreightCategory_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_FreightCategory_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_FreightCategory_Value");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_FreightCategory_Value IS NOT NULL AND M_FreightCategory_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_PartType_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET M_PartType_ID=(SELECT M_PartType_ID FROM M_PartType p").append(" WHERE i.JP_PartType_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_PartType_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_PartType_Name");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_PartType_Name IS NOT NULL AND M_PartType_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupS_ExpenseType_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET S_ExpenseType_ID=(SELECT S_ExpenseType_ID FROM S_ExpenseType p").append(" WHERE i.JP_ExpenseType_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_ExpenseType_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_ExpenseType_Value");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_ExpenseType_Value IS NOT NULL AND S_ExpenseType_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupS_Resource_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET S_Resource_ID=(SELECT S_Resource_ID FROM S_Resource p").append(" WHERE i.JP_Resource_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_Resource_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Resource_Value");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Resource_Value IS NOT NULL AND S_Resource_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_AttributeSet_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET M_AttributeSet_ID=(SELECT M_AttributeSet_ID FROM M_AttributeSet p").append(" WHERE i.JP_AttributeSet_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_AttributeSet_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_AttributeSet_Name");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_AttributeSet_Name IS NOT NULL AND M_AttributeSet_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupSalesRep_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportSalesRepIdentifier) || this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        int no = 0;
        if (this.p_JP_ImportSalesRepIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_User_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_User_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_EMail=p.EMail  AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Reverse Look up SalesRep_ID From JP_User_Value =#" + no + ":" + sql);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
            }
            sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_User_Value=p.Value AND p.EMail IS NULL  AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_EMail IS NULL AND i.SalesRep_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name  AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name AND i.JP_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL AND i.JP_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
            }
            sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name AND p.EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL AND i.JP_User_EMail IS NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupR_MailText_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET R_MailText_ID=(SELECT R_MailText_ID FROM R_MailText p").append(" WHERE i.JP_MailText_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_MailText_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_MailText_Name");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_MailText_Name IS NOT NULL AND R_MailText_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_Locator_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET M_Locator_ID=(SELECT M_Locator_ID FROM M_Locator p").append(" WHERE i.JP_Locator_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_Locator_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Locator_Value");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Locator_Value IS NOT NULL AND M_Locator_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Currency_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_ProductJP i ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency p").append(" WHERE i.ISO_Code=p.ISO_Code AND (p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0) ) ").append(" WHERE i.C_Currency_ID IS NULL AND ISO_Code IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"ISO_Code");
        sql = new StringBuilder("UPDATE I_ProductJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_Currency_ID IS NULL AND ISO_Code IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean createNewProduct(X_I_ProductJP importProduct, MProduct newProduct) throws SQLException {
        newProduct.setAD_Org_ID(importProduct.getAD_Org_ID());
        if (Util.isEmpty((String)importProduct.getValue())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            return false;
        }
        if (Util.isEmpty((String)importProduct.getName())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            return false;
        }
        if (importProduct.getM_Product_Category_ID() == 0) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_Category_ID")};
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            return false;
        }
        if (importProduct.getC_TaxCategory_ID() == 0) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_TaxCategory_ID")};
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            return false;
        }
        if (importProduct.getC_UOM_ID() == 0) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_UOM_ID")};
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            return false;
        }
        if (Util.isEmpty((String)importProduct.getProductType())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"ProductType")};
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importProduct, (PO)newProduct, 30);
        PO.copyValues((PO)importProduct, (PO)newProduct);
        if (!Util.isEmpty((String)importProduct.getJP_User_Value()) && importProduct.getSalesRep_ID() == 0) {
            this.setSalesRep_ID(importProduct, newProduct);
        }
        newProduct.setIsActive(importProduct.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importProduct, (PO)newProduct, 40);
        try {
            newProduct.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
            return false;
        }
        importProduct.setM_Product_ID(newProduct.getM_Product_ID());
        return importProduct.getC_BPartner_ID() <= 0 || this.createProductPOInfo(importProduct, newProduct.getM_Product_ID());
    }

    private boolean updateProduct(X_I_ProductJP importProduct, MProduct updateProduct) throws SQLException {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importProduct, (PO)updateProduct, 30);
        MTable M_Product_Table = MTable.get((Properties)this.getCtx(), (int)208, (String)this.get_TrxName());
        MColumn[] M_Product_Columns = M_Product_Table.getColumns(true);
        MTable I_ProductJP_Table = MTable.get((Properties)this.getCtx(), (int)X_I_ProductJP.Table_ID, (String)this.get_TrxName());
        MColumn[] I_ProductJP_Columns = I_ProductJP_Table.getColumns(true);
        MColumn i_Column = null;
        int i = 0;
        while (i < M_Product_Columns.length) {
            i_Column = M_Product_Columns[i];
            if (!(i_Column.isVirtualColumn() || i_Column.isKey() || i_Column.isUUIDColumn() || i_Column.getColumnName().equals("IsActive") || i_Column.getColumnName().equals("IsStocked") || i_Column.getColumnName().equals("ProductType") || i_Column.getColumnName().equals("C_UOM_ID") || i_Column.getColumnName().equals("AD_Client_ID") || i_Column.getColumnName().equals("Value") || i_Column.getColumnName().equals("Processing") || i_Column.getColumnName().equals("Created") || i_Column.getColumnName().equals("CreatedBy") || i_Column.getColumnName().equals("Updated") || i_Column.getColumnName().equals("UpdatedBy"))) {
                MColumn j_Column = null;
                Object importValue = null;
                int j = 0;
                while (j < I_ProductJP_Columns.length) {
                    j_Column = I_ProductJP_Columns[j];
                    if (i_Column.getColumnName().equals(j_Column.getColumnName())) {
                        importValue = importProduct.get_Value(j_Column.getColumnName());
                        if (j_Column.getColumnName().equals("SalesRep_ID") && importValue == null && !Util.isEmpty((String)importProduct.getJP_User_Value())) {
                            this.setSalesRep_ID(importProduct, updateProduct);
                        }
                        if (importValue == null) break;
                        if (importValue instanceof BigDecimal) {
                            BigDecimal bigDecimal_Value = (BigDecimal)importValue;
                            if (bigDecimal_Value.compareTo(Env.ZERO) == 0) {
                                break;
                            }
                        } else {
                            Integer p_key;
                            if (j_Column.getAD_Reference_ID() == 10) {
                                String string_Value = (String)importValue;
                                if (Util.isEmpty((String)string_Value)) break;
                                updateProduct.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                                break;
                            }
                            if (j_Column.getColumnName().endsWith("_ID") && (p_key = (Integer)importValue) <= 0) break;
                        }
                        if (importValue == null) break;
                        try {
                            updateProduct.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                            break;
                        }
                        catch (Exception e) {
                            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " Column = " + i_Column.getColumnName() + " & " + "Value = " + importValue.toString() + " -> " + e.toString();
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!importProduct.isI_IsActiveJP()) {
            updateProduct.setIsActive(importProduct.isI_IsActiveJP());
        }
        if (importProduct.getM_Product_ID() == 0) {
            importProduct.setM_Product_ID(updateProduct.getM_Product_ID());
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importProduct, (PO)updateProduct, 40);
        try {
            updateProduct.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID") + " :  " + e.toString();
            return false;
        }
        if (importProduct.getC_BPartner_ID() > 0) {
            MProductPO[] productPOs = this.getProductPO(this.getCtx(), importProduct.getM_Product_ID(), this.get_TrxName());
            boolean isNew = true;
            int i2 = 0;
            while (i2 < productPOs.length) {
                if (productPOs[i2].getC_BPartner_ID() == importProduct.getC_BPartner_ID()) {
                    if (!this.updateProductPOInfo(importProduct, productPOs[i2])) {
                        return false;
                    }
                    isNew = false;
                    break;
                }
                ++i2;
            }
            if (isNew && !this.createProductPOInfo(importProduct, importProduct.getM_Product_ID())) {
                return false;
            }
        }
        return true;
    }

    private boolean createProductPOInfo(X_I_ProductJP importProduct, int M_Product_ID) {
        MProductPO newProductPO = new MProductPO(this.getCtx(), 0, this.get_TrxName());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importProduct, (PO)newProductPO, 30);
        PO.copyValues((PO)importProduct, (PO)newProductPO);
        newProductPO.setAD_Org_ID(importProduct.getAD_Org_ID());
        newProductPO.setC_BPartner_ID(importProduct.getC_BPartner_ID());
        newProductPO.setM_Product_ID(importProduct.getM_Product_ID());
        newProductPO.setUPC(importProduct.getJP_VendorUPC());
        newProductPO.setC_UOM_ID(importProduct.getJP_VendorUOM_ID());
        newProductPO.setIsActive(importProduct.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importProduct, (PO)newProductPO, 40);
        try {
            newProductPO.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + "Product PO Info : " + e.toString();
            return false;
        }
        return true;
    }

    private boolean updateProductPOInfo(X_I_ProductJP importProduct, MProductPO updateProductPO) {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importProduct, (PO)updateProductPO, 30);
        MTable M_ProductPO_Table = MTable.get((Properties)this.getCtx(), (int)210, (String)this.get_TrxName());
        MColumn[] M_ProductPO_Columns = M_ProductPO_Table.getColumns(true);
        MTable I_ProductJP_Table = MTable.get((Properties)this.getCtx(), (int)X_I_ProductJP.Table_ID, (String)this.get_TrxName());
        MColumn[] I_ProductJP_Columns = I_ProductJP_Table.getColumns(true);
        MColumn i_Column = null;
        int i = 0;
        while (i < M_ProductPO_Columns.length) {
            i_Column = M_ProductPO_Columns[i];
            if (!(i_Column.isVirtualColumn() || i_Column.isKey() || i_Column.isUUIDColumn() || i_Column.getColumnName().equals("IsActive") || i_Column.getColumnName().equals("Value") || i_Column.getColumnName().equals("Processing") || i_Column.getColumnName().equals("Created") || i_Column.getColumnName().equals("CreatedBy") || i_Column.getColumnName().equals("Updated") || i_Column.getColumnName().equals("UpdatedBy"))) {
                MColumn j_Column = null;
                Object importValue = null;
                int j = 0;
                while (j < I_ProductJP_Columns.length) {
                    j_Column = I_ProductJP_Columns[j];
                    if (i_Column.getColumnName().equals(j_Column.getColumnName())) {
                        importValue = importProduct.get_Value(j_Column.getColumnName());
                        if (importValue == null) break;
                        if (importValue instanceof BigDecimal) {
                            BigDecimal number = (BigDecimal)importProduct.get_Value(j_Column.getColumnName());
                            if (number.compareTo(Env.ZERO) == 0) {
                                break;
                            }
                        } else {
                            Integer p_key;
                            if (j_Column.getAD_Reference_ID() == 10) {
                                String string_Value = (String)importValue;
                                if (Util.isEmpty((String)string_Value)) break;
                                updateProductPO.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                                break;
                            }
                            if (i_Column.getColumnName().endsWith("_ID") && (p_key = (Integer)importProduct.get_Value(j_Column.getColumnName())) <= 0) break;
                        }
                        if (importValue == null) break;
                        try {
                            updateProductPO.set_ValueNoCheck(i_Column.getColumnName(), importProduct.get_Value(j_Column.getColumnName()));
                            break;
                        }
                        catch (Exception e) {
                            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " Column = " + i_Column.getColumnName() + " & " + "Value = " + importValue.toString() + " -> " + e.toString();
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        updateProductPO.setIsActive(importProduct.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importProduct, (PO)updateProductPO, 40);
        try {
            updateProductPO.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"Product PO Info") + " -> " + e.toString();
            return false;
        }
        return true;
    }

    private void setSalesRep_ID(X_I_ProductJP importProduct, MProduct m_Product) {
        String JP_User_Value = importProduct.getJP_User_Value();
        int[] AD_User_IDs = PO.getAllIDs((String)"AD_User", (String)("Value='" + JP_User_Value + "'" + " AND (AD_Client_ID=" + this.p_AD_Client_ID + " OR AD_Client_ID=0) "), (String)this.get_TrxName());
        MUser m_SalesRep = null;
        if (AD_User_IDs != null) {
            int i = 0;
            while (i < AD_User_IDs.length) {
                m_SalesRep = new MUser(this.getCtx(), AD_User_IDs[i], this.get_TrxName());
                if (m_SalesRep.getAD_Client_ID() == this.p_AD_Client_ID && m_SalesRep.getAD_Org_ID() == 0) break;
                ++i;
            }
        }
        if (m_SalesRep != null) {
            m_Product.setSalesRep_ID(m_SalesRep.getAD_User_ID());
        } else {
            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_User_Value");
            if (Util.isEmpty((String)importProduct.getI_ErrorMsg())) {
                importProduct.setI_ErrorMsg(msg);
            } else {
                importProduct.setI_ErrorMsg(String.valueOf(importProduct.getI_ErrorMsg()) + " : " + msg);
            }
        }
    }

    private MProductPO[] getProductPO(Properties ctx, int M_Product_ID, String trxName) {
        String whereClause = "M_Product_ID=?";
        List list = new Query(ctx, "M_Product_PO", "M_Product_ID=?", trxName).setParameters(new Object[]{M_Product_ID}).setOnlyActiveRecords(false).setOrderBy("IsCurrentVendor DESC").list();
        return list.toArray(new MProductPO[list.size()]);
    }
}

