/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_OrgJP;
import jpiere.base.plugin.util.JPiereLocationUtil;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportOrg
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private IProcessUI processMonitor = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.getAD_Client_ID());
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_OrgJP ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            try {
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        sql = new StringBuilder("UPDATE I_OrgJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.reverseLookupAD_Org_ID();
        this.reverseLookupAD_OrgType_ID();
        this.reverseLookupC_Location_ID();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_OrgJP WHERE I_IsImported='N'").append((CharSequence)clientCheck);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_I_OrgJP imp = new X_I_OrgJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (imp.getAD_Org_ID() != 0) {
                        isNew = false;
                    }
                    if (isNew) {
                        MOrg newOrg = new MOrg(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewOrg(imp, newOrg)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else {
                        if (Util.isEmpty((String)imp.getValue())) {
                            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
                            imp.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
                            imp.setI_IsImported(false);
                            imp.setProcessed(false);
                            imp.saveEx(this.get_TrxName());
                            this.commitEx();
                            continue;
                        }
                        MOrg updateOrg = new MOrg(this.getCtx(), imp.getAD_Org_ID(), this.get_TrxName());
                        if (this.updateOrg(imp, updateOrg)) {
                            ++successUpdateNum;
                        } else {
                            ++failureUpdateNum;
                        }
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(records) + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    public String getImportTableName() {
        return "I_OrgJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private void reverseLookupAD_Org_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Value");
        sql = new StringBuilder("UPDATE I_OrgJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE AD_Org_ID = '0' AND Value IS NOT NULL").append(" AND I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord");
        sql = new StringBuilder("UPDATE I_OrgJP ").append("SET AD_Org_ID=0").append(" WHERE AD_Org_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"Value");
        sql = new StringBuilder("UPDATE I_OrgJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE Value IS NULL AND AD_Org_ID = 0 ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupAD_OrgType_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_OrgType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_OrgType_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_OrgType_Name");
        sql = new StringBuilder("UPDATE I_OrgJP i ").append(" SET AD_OrgType_ID=(SELECT t.AD_OrgType_ID FROM AD_OrgType t").append(" WHERE t.Name=i.JP_OrgType_Name AND t.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_OrgType_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_OrgType_Name");
        sql = new StringBuilder("UPDATE I_OrgJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE JP_OrgType_Name IS NOT NULL AND AD_OrgType_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_Location_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Location_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Location_Label");
        sql = new StringBuilder("UPDATE I_OrgJP i ").append("SET C_Location_ID=(SELECT C_Location_ID FROM C_Location p").append(" WHERE i.JP_Location_Label= p.JP_Location_Label AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_Location_ID IS NULL AND JP_Location_Label IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
    }

    private boolean createNewOrg(X_I_OrgJP importOrg, MOrg newOrg) throws SQLException {
        if (Util.isEmpty((String)importOrg.getValue())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
            importOrg.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            importOrg.setI_IsImported(false);
            importOrg.setProcessed(false);
            importOrg.saveEx(this.get_TrxName());
            return false;
        }
        if (Util.isEmpty((String)importOrg.getName())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            importOrg.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            importOrg.setI_IsImported(false);
            importOrg.setProcessed(false);
            importOrg.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importOrg, (PO)newOrg, 30);
        newOrg.setValue(importOrg.getValue());
        newOrg.setName(importOrg.getName());
        newOrg.setDescription(importOrg.getDescription());
        newOrg.setIsActive(importOrg.isI_IsActiveJP());
        newOrg.setIsSummary(importOrg.isSummary());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importOrg, (PO)newOrg, 40);
        try {
            newOrg.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importOrg.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID"));
            importOrg.setI_IsImported(false);
            importOrg.setProcessed(false);
            importOrg.saveEx(this.get_TrxName());
            return false;
        }
        importOrg.setAD_Org_ID(newOrg.getAD_Org_ID());
        if (this.updateOrgInfo(importOrg, newOrg)) {
            importOrg.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
            importOrg.setI_IsImported(true);
            importOrg.setProcessed(true);
            importOrg.saveEx(this.get_TrxName());
            return true;
        }
        importOrg.setI_IsImported(true);
        importOrg.setProcessed(false);
        importOrg.saveEx(this.get_TrxName());
        return false;
    }

    private boolean updateOrg(X_I_OrgJP importOrg, MOrg updateOrg) throws SQLException {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importOrg, (PO)updateOrg, 30);
        updateOrg.setName(importOrg.getName());
        updateOrg.setDescription(importOrg.getDescription());
        updateOrg.setIsActive(importOrg.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importOrg, (PO)updateOrg, 40);
        try {
            updateOrg.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importOrg.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " :  " + e.toString());
            importOrg.setI_IsImported(false);
            importOrg.setProcessed(false);
            importOrg.saveEx(this.get_TrxName());
            return false;
        }
        if (this.updateOrgInfo(importOrg, updateOrg)) {
            importOrg.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
            importOrg.setI_IsImported(true);
            importOrg.setProcessed(true);
            importOrg.saveEx(this.get_TrxName());
            return true;
        }
        importOrg.setI_IsImported(true);
        importOrg.setProcessed(false);
        importOrg.saveEx(this.get_TrxName());
        return false;
    }

    private boolean updateOrgInfo(X_I_OrgJP importOrg, MOrg org) {
        int C_Location_ID;
        MOrgInfo orgInfo = MOrgInfo.getCopy((Properties)this.getCtx(), (int)org.getAD_Org_ID(), (String)this.get_TrxName());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importOrg, (PO)orgInfo, 30);
        if (importOrg.getAD_OrgType_ID() > 0) {
            orgInfo.setAD_OrgType_ID(importOrg.getAD_OrgType_ID());
        }
        if (!Util.isEmpty((String)importOrg.getDUNS())) {
            orgInfo.setDUNS(importOrg.getDUNS());
        }
        if (!Util.isEmpty((String)importOrg.getTaxID())) {
            orgInfo.setTaxID(importOrg.getTaxID());
        }
        if (!Util.isEmpty((String)importOrg.getPhone())) {
            orgInfo.setPhone(importOrg.getPhone());
        }
        if (!Util.isEmpty((String)importOrg.getPhone2())) {
            orgInfo.setPhone2(importOrg.getPhone2());
        }
        if (!Util.isEmpty((String)importOrg.getFax())) {
            orgInfo.setFax(importOrg.getFax());
        }
        if (!Util.isEmpty((String)importOrg.getEMail())) {
            orgInfo.setEMail(importOrg.getEMail());
        }
        if ((C_Location_ID = importOrg.getC_Location_ID()) > 0) {
            orgInfo.setC_Location_ID(C_Location_ID);
        } else if (!Util.isEmpty((String)importOrg.getJP_Location_Label())) {
            C_Location_ID = JPiereLocationUtil.searchLocationByLabel(this.getCtx(), importOrg.getJP_Location_Label(), this.get_TrxName());
            if (C_Location_ID <= 0) {
                C_Location_ID = JPiereLocationUtil.createLocation(this.getCtx(), "0", importOrg.getJP_Location_Label(), importOrg.getComments(), importOrg.getCountryCode(), importOrg.getPostal(), importOrg.getPostal_Add(), importOrg.getJP_Region_Name(), importOrg.getRegionName(), importOrg.getJP_City_Name(), importOrg.getCity(), importOrg.getAddress1(), importOrg.getAddress2(), importOrg.getAddress3(), importOrg.getAddress4(), importOrg.getAddress5(), this.get_TrxName());
            }
            orgInfo.setC_Location_ID(C_Location_ID);
            importOrg.setC_Location_ID(C_Location_ID);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importOrg, (PO)orgInfo, 40);
        try {
            orgInfo.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importOrg.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_OrgInfo_ID") + " :  " + e.toString());
            return false;
        }
        return true;
    }
}

