/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_BPartnerJP;
import jpiere.base.plugin.org.adempiere.model.X_I_OrderJP;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class JPiereImportOrder
extends SvrProcess
implements ImportProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private String p_docAction = "PR";
    private Timestamp p_DateValue = null;
    private String message = null;
    private String p_JP_ImportSalesRepIdentifier = "VA";
    private String p_JP_ImportUserIdentifier = "NA";
    private String p_JP_ImportDropShipUserIdentifier = "NA";
    private String p_JP_ImportInvoiceUserIdentifier = "NA";
    private IProcessUI processMonitor = null;
    private boolean p_IsHistoricalDataMigration = false;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i].getParameter();
            } else if (name.equals("JP_ImportSalesRepIdentifier")) {
                this.p_JP_ImportSalesRepIdentifier = para[i].getParameterAsString();
            } else if (name.equals("JP_ImportUserIdentifier")) {
                this.p_JP_ImportUserIdentifier = para[i].getParameterAsString();
            } else if (name.equals("JP_ImportDropSpUserIdentifier")) {
                this.p_JP_ImportDropShipUserIdentifier = para[i].getParameterAsString();
            } else if (name.equals("JP_ImportInvoiceUserIdentifier")) {
                this.p_JP_ImportInvoiceUserIdentifier = para[i].getParameterAsString();
            } else if (name.equals("IsHistoricalDataMigration")) {
                this.p_IsHistoricalDataMigration = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.p_DateValue == null) {
            this.p_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_OrderJP ").append("WHERE I_IsImported='Y' ").append(this.getWhereClause());
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y' ").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Order_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_DocType_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"SalesRep_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupSalesRep_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_Location_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_User_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Warehouse_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Locator_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Locator_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Shipper_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Shipper_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DropShip_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupDropShip_BPartner_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DropShip_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupDropShip_Location_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DropShip_User_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupDropShip_User_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_PriceList_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_PaymentTerm_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_PaymentTerm_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Bill_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupBill_BPartner_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"BillTo_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupBill_Location_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Bill_User_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupBill_User_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Project_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Project_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Campaign_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Campaign_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Activity_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Activity_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_OrgTrx_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_OrgTrx_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"User1_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupUser1_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"User2_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupUser2_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_OrderSource_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_OrderSource_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Product_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Charge_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Charge_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_UOM_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_UOM_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Tax_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Tax_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Project_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_Project_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Campaign_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_Campaign_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Activity_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_Activity_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_OrgTrx_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_OrgTrx_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_User1_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_User1_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"User2_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_User2_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"CreateNew")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.createBPartner()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"CreateNew")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Order_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        sql = new StringBuilder("SELECT * FROM I_OrderJP ").append("WHERE I_IsImported='N'").append(this.getWhereClause()).append(" ORDER BY DateOrdered, C_BPartner_ID, BillTo_ID, C_BPartner_Location_ID, DocumentNo, I_OrderJP_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int skipNum = 0;
        int errorNum = 0;
        int successNum = 0;
        int successCreateDocHeader = 0;
        int successCreateDocLine = 0;
        int failureCreateDocHeader = 0;
        int failureCreateDocLine = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String skipRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfSkipRecords");
        String errorRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfUnexpectedErrorRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String createHeader = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateHeader");
        String createLine = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateLine");
        String detail = Msg.getMsg((Properties)this.getCtx(), (String)"JP_DetailLog");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                int lastC_BPartner_ID = 0;
                int lastBillTo_ID = 0;
                int lastC_BPartner_Location_ID = 0;
                String lastDocumentNo = "";
                MOrder order = null;
                MOrderLine line = null;
                X_I_OrderJP imp = null;
                int lineNo = 0;
                boolean isCreateHeader = true;
                while (rs.next()) {
                    ++recordsNum;
                    imp = new X_I_OrderJP(this.getCtx(), rs, this.get_TrxName());
                    if (imp.getC_Order_ID() > 0) {
                        ++skipNum;
                        String msg = Msg.getMsg((Properties)this.getCtx(), (String)"AlreadyExists");
                        imp.setI_ErrorMsg(msg);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        continue;
                    }
                    String cmpDocumentNo = imp.getDocumentNo();
                    if (cmpDocumentNo == null) {
                        cmpDocumentNo = "";
                    }
                    isCreateHeader = true;
                    if (lastC_BPartner_ID != imp.getC_BPartner_ID() || lastC_BPartner_Location_ID != imp.getC_BPartner_Location_ID() || lastBillTo_ID != imp.getBillTo_ID() || !lastDocumentNo.equals(cmpDocumentNo)) {
                        if (order != null) {
                            if (this.p_IsHistoricalDataMigration) {
                                order.setDocStatus("CL");
                                order.setDocAction("--");
                                order.setProcessed(true);
                                order.setPosted(true);
                            } else if (!order.getDocAction().equals("--") && !order.processIt(order.getDocAction())) {
                                this.rollback();
                                this.message = "Order Process Failed: " + order.getProcessMsg();
                                order = null;
                                imp.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message);
                                imp.saveEx(this.get_TrxName());
                                this.commitEx();
                            }
                            if (order != null) {
                                order.saveEx(this.get_TrxName());
                                order = null;
                                this.commitEx();
                            }
                        }
                        lastC_BPartner_ID = imp.getC_BPartner_ID();
                        lastC_BPartner_Location_ID = imp.getC_BPartner_Location_ID();
                        lastBillTo_ID = imp.getBillTo_ID();
                        lastDocumentNo = imp.getDocumentNo();
                        if (lastDocumentNo == null) {
                            lastDocumentNo = "";
                        }
                    } else {
                        isCreateHeader = false;
                    }
                    if (isCreateHeader) {
                        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                        lineNo = 0;
                        if (this.createOrderHeader(imp, order)) {
                            ++successCreateDocHeader;
                        } else {
                            this.rollback();
                            order = null;
                            ++failureCreateDocHeader;
                            ++errorNum;
                            imp.setI_ErrorMsg(this.message);
                            imp.setI_IsImported(false);
                            imp.setProcessed(false);
                            imp.saveEx(this.get_TrxName());
                            this.commitEx();
                            continue;
                        }
                    }
                    if (order == null) {
                        this.rollback();
                        ++errorNum;
                        String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                        imp.setI_ErrorMsg(msg);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        continue;
                    }
                    imp.setC_Order_ID(order.getC_Order_ID());
                    line = new MOrderLine(order);
                    if (this.addOrderLine(imp, order, line, lineNo += 10)) {
                        ++successCreateDocLine;
                        ++successNum;
                    } else {
                        this.rollback();
                        order = null;
                        ++failureCreateDocLine;
                        ++errorNum;
                        imp.setI_ErrorMsg(this.message);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        continue;
                    }
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                }
                if (order != null) {
                    if (this.p_IsHistoricalDataMigration) {
                        order.setDocStatus("CL");
                        order.setDocAction("--");
                        order.setProcessed(true);
                        order.setPosted(true);
                    } else if (!order.processIt(order.getDocAction())) {
                        this.rollback();
                        this.message = "Order Process Failed: " + order.getProcessMsg();
                        order = null;
                        imp.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                    }
                    if (order != null) {
                        order.saveEx(this.get_TrxName());
                        order = null;
                        this.commitEx();
                    }
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.message = String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]";
        return this.message;
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
        return msgreturn.toString();
    }

    public String getImportTableName() {
        return "I_OrderJP";
    }

    private boolean reverseLookupC_Order_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET C_Order_ID=(SELECT MAX(C_Order_ID) FROM C_Order p").append(" WHERE i.DocumentNo=p.DocumentNo AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.DocumentNo IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Reverse Lookup C_Order_ID = #" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID = 0 ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_DocType_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName").append(" AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName").append(" AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName").append(" AND d.DocBaseType IN ('SOO','POO') AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"DocTypeName");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL  ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        if (no > 0) {
            return false;
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType IN('SOO','POO') AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") + Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_DocType_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o SET IsSOTrx='Y' ").append("WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID)").append(" AND C_DocType_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o SET IsSOTrx='N' ").append("WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID)").append(" AND C_DocType_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupSalesRep_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportSalesRepIdentifier) || this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        if (this.p_JP_ImportSalesRepIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_EMail IS NULL l AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_EMail IS NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name  AND i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL AND i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND i.JP_SalesRep_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL AND i.JP_SalesRep_EMail IS NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupM_PriceList_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.Name=o.JP_PriceList_Name AND o.AD_Client_ID=p.AD_Client_ID) ").append(" WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM M_PriceList p ").append(" WHERE p.M_PriceList_ID=o.M_PriceList_ID ) ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y'").append(" AND p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y'").append(" AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE M_PriceList_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Project_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET C_Project_ID=(SELECT C_Project_ID FROM C_Project p").append(" WHERE i.JP_Project_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Project_ID IS NULL AND i.JP_Project_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Project_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Project_ID IS NULL AND JP_Project_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_Project_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET JP_Line_Project_ID=(SELECT C_Project_ID FROM C_Project p").append(" WHERE i.JP_Line_Project_Value=p.Value AND  (i.AD_Client_ID=p.AD_Client_ID or p.AD_Client_ID = 0) ) ").append("WHERE i.JP_Line_Project_ID IS NULL AND i.JP_Line_Project_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Project_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_Project_ID IS NULL AND JP_Line_Project_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Campaign_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET C_Campaign_ID=(SELECT C_Campaign_ID FROM C_Campaign p").append(" WHERE i.JP_Campaign_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Campaign_ID IS NULL AND i.JP_Campaign_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Campaign_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Campaign_ID IS NULL AND JP_Campaign_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_Campaign_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET JP_Line_Campaign_ID=(SELECT C_Campaign_ID FROM C_Campaign p").append(" WHERE i.JP_Line_Campaign_Value=p.Value AND  (i.AD_Client_ID=p.AD_Client_ID or p.AD_Client_ID = 0) ) ").append("WHERE i.JP_Line_Campaign_ID IS NULL AND i.JP_Line_Campaign_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Campaign_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_Campaign_ID IS NULL AND JP_Line_Campaign_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_Activity_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET JP_Line_Activity_ID=(SELECT C_Activity_ID FROM C_Activity p").append(" WHERE i.JP_Line_Activity_Value=p.Value AND  (i.AD_Client_ID=p.AD_Client_ID or p.AD_Client_ID = 0) ) ").append("WHERE i.JP_Line_Activity_ID IS NULL AND i.JP_Line_Activity_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Activity_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_Activity_ID IS NULL AND JP_Line_Activity_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Activity_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET C_Activity_ID=(SELECT C_Activity_ID FROM C_Activity p").append(" WHERE i.JP_Activity_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Activity_ID IS NULL AND i.JP_Activity_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Activity_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Activity_ID IS NULL AND JP_Activity_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAD_OrgTrx_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_OrgTrx_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_OrgTrx_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_OrgTrx_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_OrgTrx_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_OrgTrx_ID IS NULL AND JP_OrgTrx_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_OrgTrx_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET JP_Line_OrgTrx_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Line_OrgTrx_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_Line_OrgTrx_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_OrgTrx_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Line_OrgTrx_ID IS NULL AND JP_Line_OrgTrx_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupUser1_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET User1_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_UserElement1_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.User1_ID IS NULL AND i.JP_UserElement1_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_UserElement1_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE User1_ID IS NULL AND JP_UserElement1_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_User1_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET JP_Line_User1_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_Line_UserElement1_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.JP_Line_User1_ID IS NULL AND i.JP_Line_UserElement1_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_UserElement1_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_User1_ID IS NULL AND JP_Line_UserElement1_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupUser2_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET User2_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_UserElement2_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.User2_ID IS NULL AND i.JP_UserElement2_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_UserElement2_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE User2_ID IS NULL AND JP_UserElement2_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_User2_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET JP_Line_User2_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_Line_UserElement2_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.JP_Line_User2_ID IS NULL AND i.JP_Line_UserElement2_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_UserElement2_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_User2_ID IS NULL AND JP_Line_UserElement2_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_OrderSource_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_OrderSource_ID=(SELECT C_OrderSource_ID FROM C_OrderSource p").append(" WHERE o.C_OrderSourceValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_OrderSource_ID IS NULL AND C_OrderSourceValue IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"C_OrderSourceValue");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_OrderSource_ID IS NULL AND C_OrderSourceValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_PaymentTerm_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p").append(" WHERE o.PaymentTermValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_PaymentTerm_ID IS NULL AND PaymentTermValue IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_PaymentTerm_ID=(SELECT MAX(C_PaymentTerm_ID) FROM C_PaymentTerm p").append(" WHERE p.IsDefault='Y' AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_PaymentTerm_ID IS NULL AND o.PaymentTermValue IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"C_PaymentTerm_ID");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_PaymentTerm_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupBill_BPartner_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.Bill_BPValue=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.Bill_BPartner_ID IS NULL AND i.Bill_BPValue IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"Bill_BPValue");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE Bill_BPartner_ID IS NULL AND Bill_BPValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupBill_Location_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET BillTo_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location p").append(" WHERE i.JP_Bill_BP_Location_Name=p.Name AND i.Bill_BPartner_ID=p.C_BPartner_ID) ").append("WHERE i.BillTo_ID IS NULL AND i.JP_Bill_BP_Location_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Bill_BP_Location_Name");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE BillTo_ID IS NULL AND JP_Bill_BP_Location_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupBill_User_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportInvoiceUserIdentifier) || this.p_JP_ImportInvoiceUserIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        if (this.p_JP_ImportInvoiceUserIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_Bill_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.Bill_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_Bill_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportInvoiceUserIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_Bill_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.Bill_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_Bill_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportInvoiceUserIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_Bill_User_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.Bill_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_Bill_User_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportInvoiceUserIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_Bill_User_Value=p.Value AND i.JP_Bill_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.Bill_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_Bill_User_Value IS NOT NULL AND i.JP_Bill_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_Bill_User_Value=p.Value AND i.JP_Bill_User_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.Bill_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_Bill_User_Value IS NOT NULL AND i.JP_Bill_User_EMail IS NULL AND Bill_User_ID IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportInvoiceUserIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_Bill_User_Value=p.Value AND i.JP_Bill_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.Bill_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_Bill_User_Value IS NOT NULL AND i.JP_Bill_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportInvoiceUserIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_Bill_User_Value=p.Value AND i.JP_Bill_User_Name=p.Name  AND i.JP_Bill_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.Bill_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_Bill_User_Value IS NOT NULL AND i.JP_Bill_User_Name IS NOT NULL AND i.JP_Bill_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET Bill_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_Bill_User_Value=p.Value AND i.JP_Bill_User_Name=p.Name  AND i.JP_Bill_User_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.Bill_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_Bill_User_Value IS NOT NULL AND i.JP_Bill_User_Name IS NOT NULL AND i.JP_Bill_User_EMail IS NULL AND Bill_User_ID IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportInvoiceUserIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupM_Warehouse_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Warehouse w").append(" WHERE o.JP_Warehouse_Value=w.Value AND o.AD_Org_ID=w.AD_Org_ID) ").append(" WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_Warehouse_ID=(SELECT MAX(M_Warehouse_ID) FROM M_Warehouse w").append(" WHERE o.AD_Client_ID=w.AD_Client_ID AND o.AD_Org_ID=w.AD_Org_ID) ").append("WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Warehouse w").append(" WHERE o.AD_Client_ID=w.AD_Client_ID) ").append("WHERE M_Warehouse_ID IS NULL").append(" AND EXISTS (SELECT AD_Client_ID FROM M_Warehouse w WHERE w.AD_Client_ID=o.AD_Client_ID GROUP BY AD_Client_ID HAVING COUNT(*)=1)").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE M_Warehouse_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Locator_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET JP_Locator_ID=(SELECT M_Locator_ID FROM M_Locator p").append(" WHERE i.JP_Locator_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append(" WHERE i.JP_Locator_ID IS NULL AND i.JP_Locator_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Locator_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Locator_ID IS NULL AND JP_Locator_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_Shipper_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET M_Shipper_ID=(SELECT M_Shipper_ID FROM M_Shipper p").append(" WHERE i.JP_Shipper_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append(" WHERE i.M_Shipper_ID IS NULL AND i.JP_Shipper_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Shipper_Name");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE M_Shipper_ID IS NULL AND JP_Shipper_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupDropShip_BPartner_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.JP_DropShip_BP_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.DropShip_BPartner_ID IS NULL AND i.JP_DropShip_BP_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_DropShip_BP_Value");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE DropShip_BPartner_ID IS NULL AND JP_DropShip_BP_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupDropShip_Location_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location p").append(" WHERE i.JP_DropShip_BP_Location_Name=p.Name AND i.DropShip_BPartner_ID=p.C_BPartner_ID) ").append(" WHERE i.DropShip_Location_ID IS NULL AND i.JP_DropShip_BP_Location_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_DropShip_BP_Location_Name");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE DropShip_Location_ID IS NULL AND JP_DropShip_BP_Location_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupDropShip_User_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportDropShipUserIdentifier) || this.p_JP_ImportDropShipUserIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        if (this.p_JP_ImportDropShipUserIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_DropShip_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.DropShip_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_DropShip_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportDropShipUserIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_DropShip_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.DropShip_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_DropShip_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportDropShipUserIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_DropShip_User_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.DropShip_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_DropShip_User_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportDropShipUserIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_DropShip_User_Value=p.Value AND i.JP_DropShip_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.DropShip_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_DropShip_User_Value IS NOT NULL AND i.JP_DropShip_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_DropShip_User_Value=p.Value AND i.JP_DropShip_User_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.DropShip_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_DropShip_User_Value IS NOT NULL AND i.JP_DropShip_User_EMail IS NULL AND DropShip_User_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportDropShipUserIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_DropShip_User_Value=p.Value AND i.JP_Bill_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.DropShip_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_DropShip_User_Value IS NOT NULL AND i.JP_DropShip_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportDropShipUserIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_DropShip_User_Value=p.Value AND i.JP_Bill_User_Name=p.Name  AND i.JP_Bill_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.DropShip_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_DropShip_User_Value IS NOT NULL AND i.JP_DropShip_User_Name IS NOT NULL AND i.JP_DropShip_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET DropShip_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_DropShip_User_Value=p.Value AND i.JP_Bill_User_Name=p.Name  AND i.JP_Bill_User_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.DropShip_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_DropShip_User_Value IS NOT NULL AND i.JP_DropShip_User_Name IS NOT NULL AND i.JP_DropShip_User_EMail IS NULL AND DropShip_User_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportDropShipUserIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupC_BPartner_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.BPartnerValue=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_BPartner_ID IS NULL AND i.BPartnerValue IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Reverse Lookup C_BPartner_ID = #" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupC_BPartner_Location_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET C_BPartner_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location p").append(" WHERE i.JP_BPartner_Location_Name=p.Name AND i.C_BPartner_ID=p.C_BPartner_ID) ").append("WHERE i.C_BPartner_Location_ID IS NULL AND i.JP_BPartner_Location_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Reverse Lookup C_BPartner_Location_ID = 1#" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET C_BPartner_Location_ID=(SELECT max(C_BPartner_Location_ID) FROM C_BPartner_Location p").append(" WHERE i.C_BPartner_ID=p.C_BPartner_ID AND i.Phone = p.phone) ").append(" WHERE i.C_BPartner_Location_ID IS NULL AND i.JP_BPartner_Location_Name IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Reverse Lookup C_BPartner_Location_ID = 2#" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_User_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier) || this.p_JP_ImportUserIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        if (this.p_JP_ImportUserIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.ContactName=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.ContactName IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.EMail IS NULL AND i.AD_User_ID IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.ContactName=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.ContactName IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.ContactName=p.Name  AND i.EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.ContactName IS NOT NULL AND i.EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.ContactName=p.Name  AND i.EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.ContactName IS NOT NULL AND i.EMail IS NULL AND i.AD_User_ID IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportUserIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupM_Product_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE o.ProductValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE o.UPC=p.UPC AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND UPC IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE o.SKU=p.SKU AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND SKU IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL)").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Charge_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_Charge_ID=(SELECT C_Charge_ID FROM C_Charge c").append(" WHERE o.ChargeName=c.Name AND o.AD_Client_ID=c.AD_Client_ID) ").append("WHERE C_Charge_ID IS NULL AND ChargeName IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"ChargeName");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_Charge_ID IS NULL AND ChargeName IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_UOM_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP i ").append("SET C_UOM_ID=(SELECT C_UOM_ID FROM C_UOM p").append(" WHERE i.X12DE355=p.X12DE355 AND (i.AD_Client_ID=p.AD_Client_ID OR p.AD_Client_ID = 0) ) ").append("WHERE X12DE355 IS NOT NULL").append(" AND I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"X12DE355");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE X12DE355 IS NOT NULL AND C_UOM_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Tax_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_OrderJP o ").append("SET C_Tax_ID=(SELECT MAX(C_Tax_ID) FROM C_Tax t").append(" WHERE o.TaxIndicator=t.TaxIndicator AND o.AD_Client_ID=t.AD_Client_ID) ").append("WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"TaxIndicator");
        sql = new StringBuilder("UPDATE I_OrderJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean createBPartner() throws Exception {
        ArrayList<X_I_OrderJP> orderlist;
        block18: {
            orderlist = new ArrayList<X_I_OrderJP>();
            String sql = "SELECT * FROM I_OrderJP WHERE I_IsImported<>'Y' AND C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL " + this.getWhereClause() + " ORDER BY BPartnerValue ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    String preValue = "";
                    X_I_OrderJP impOrder = null;
                    while (rs.next()) {
                        impOrder = new X_I_OrderJP(this.getCtx(), rs, this.get_TrxName());
                        if (preValue != null && preValue.equals(impOrder.getBPartnerValue())) continue;
                        orderlist.add(impOrder);
                        preValue = impOrder.getBPartnerValue();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        X_I_BPartnerJP i_BP = null;
        for (X_I_OrderJP i_order : orderlist) {
            i_BP = new X_I_BPartnerJP(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)i_order, (PO)i_BP);
            i_BP.setJP_Org_Value(i_order.getJP_BP_Org_Value());
            i_BP.setValue(i_order.getBPartnerValue());
            if (Util.isEmpty((String)i_order.getJP_BPartner_Location_Name())) {
                i_BP.setJP_BPartner_Location_Name(i_order.getName());
            }
            if (Util.isEmpty((String)i_order.getJP_Location_Label())) {
                i_BP.setJP_Location_Label(i_BP.getJP_BPartner_Location_Name());
            }
            if (Util.isEmpty((String)i_order.getContactName())) {
                i_BP.setContactName(i_order.getName());
            }
            if (i_order.isSOTrx()) {
                i_BP.setIsCustomer(true);
                i_BP.setIsVendor(false);
                i_BP.setIsEmployee(false);
                i_BP.setIsSalesRep(false);
            } else {
                i_BP.setIsCustomer(false);
                i_BP.setIsVendor(true);
                i_BP.setIsEmployee(false);
                i_BP.setIsSalesRep(false);
            }
            i_BP.saveEx(this.get_TrxName());
            this.commitEx();
            ProcessInfo pi = new ProcessInfo("CreateBPartner", 0);
            String className = "jpiere.base.plugin.org.adempiere.process.JPiereImportBPartner";
            pi.setClassName(className);
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
            pi.setRecord_ID(0);
            ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
            list.add(new ProcessInfoParameter("DeleteOldImported", (Object)false, null, null, null));
            list.add(new ProcessInfoParameter("IsValidateOnly", (Object)false, null, null, null));
            list.add(new ProcessInfoParameter("JP_ImportUserIdentifier", (Object)this.p_JP_ImportUserIdentifier, null, null, null));
            list.add(new ProcessInfoParameter("I_BPartnerJP_ID", (Object)i_BP.getI_BPartnerJP_ID(), null, null, null));
            ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
            list.toArray(pars);
            pi.setParameter(pars);
            if (ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI)) continue;
            this.message = Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError");
            return false;
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_ID()) {
            return false;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_Location_ID()) {
            return false;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_UserID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_User_ID()) {
            return false;
        }
        this.commitEx();
        return true;
    }

    private boolean createOrderHeader(X_I_OrderJP impOrder, MOrder order) {
        MUser[] users;
        MBPartnerLocation[] locations;
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impOrder, (PO)order, 30);
        PO.copyValues((PO)impOrder, (PO)order);
        order.setC_Order_ID(0);
        order.setClientOrg(impOrder.getAD_Client_ID(), impOrder.getAD_Org_ID());
        order.setC_DocTypeTarget_ID(impOrder.getC_DocType_ID());
        order.setIsSOTrx(impOrder.isSOTrx());
        if (impOrder.getDateOrdered() == null) {
            impOrder.setDateOrdered(this.p_DateValue);
            order.setDateOrdered(this.p_DateValue);
        }
        if (impOrder.getDateAcct() == null) {
            impOrder.setDateAcct(this.p_DateValue);
            order.setDateAcct(this.p_DateValue);
        }
        if (impOrder.getDatePromised() == null) {
            impOrder.setDatePromised(this.p_DateValue);
            order.setDatePromised(this.p_DateValue);
        }
        MBPartner bp = null;
        if (impOrder.getC_BPartner_ID() > 0) {
            bp = MBPartner.get((Properties)this.getCtx(), (int)impOrder.getC_BPartner_ID());
        } else if (!Util.isEmpty((String)impOrder.getBPartnerValue())) {
            bp = MBPartner.get((Properties)this.getCtx(), (String)impOrder.getBPartnerValue(), (String)this.get_TrxName());
            impOrder.setC_BPartner_ID(bp.getC_BPartner_ID());
            order.setC_BPartner_ID(bp.getC_BPartner_ID());
        } else {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
            impOrder.setI_ErrorMsg(this.message);
            return false;
        }
        if (impOrder.getC_BPartner_Location_ID() <= 0 && (locations = bp.getLocations(false)) != null && locations.length == 1) {
            impOrder.setC_BPartner_Location_ID(locations[0].getC_BPartner_Location_ID());
            order.setC_BPartner_Location_ID(locations[0].getC_BPartner_Location_ID());
        }
        if (impOrder.getAD_User_ID() <= 0 && (users = MUser.getOfBPartner((Properties)this.getCtx(), (int)impOrder.getC_BPartner_ID(), (String)this.get_TrxName())) != null && users.length == 1) {
            impOrder.setAD_User_ID(users[0].getAD_User_ID());
            order.setAD_User_ID(users[0].getAD_User_ID());
        }
        if (Util.isEmpty((String)impOrder.getDeliveryRule())) {
            if (Util.isEmpty((String)bp.getDeliveryRule())) {
                impOrder.setDeliveryRule("A");
                order.setDeliveryRule("A");
            } else {
                impOrder.setDeliveryRule(bp.getDeliveryRule());
                order.setDeliveryRule(bp.getDeliveryRule());
            }
        }
        if (Util.isEmpty((String)impOrder.getPriorityRule())) {
            impOrder.setPriorityRule("5");
            order.setPriorityRule("5");
        }
        if (Util.isEmpty((String)impOrder.getDeliveryViaRule())) {
            if (Util.isEmpty((String)bp.getDeliveryViaRule())) {
                impOrder.setDeliveryViaRule("P");
                order.setDeliveryViaRule("P");
            } else {
                impOrder.setDeliveryViaRule(bp.getDeliveryViaRule());
                order.setDeliveryViaRule(bp.getDeliveryViaRule());
            }
        }
        if (Util.isEmpty((String)impOrder.getFreightCostRule())) {
            if (Util.isEmpty((String)bp.getFreightCostRule())) {
                impOrder.setFreightCostRule("F");
                order.setFreightCostRule("F");
            } else {
                impOrder.setFreightCostRule(bp.getFreightCostRule());
                order.setFreightCostRule(bp.getFreightCostRule());
            }
        }
        if (impOrder.getM_PriceList_ID() == 0 && bp.getM_PriceList_ID() != 0) {
            impOrder.setM_PriceList_ID(bp.getM_PriceList_ID());
            order.setM_PriceList_ID(bp.getM_PriceList_ID());
        }
        if (Util.isEmpty((String)impOrder.getInvoiceRule())) {
            if (Util.isEmpty((String)bp.getInvoiceRule())) {
                impOrder.setInvoiceRule("I");
                order.setInvoiceRule("I");
            } else {
                impOrder.setInvoiceRule(bp.getInvoiceRule());
                order.setInvoiceRule(bp.getInvoiceRule());
            }
        }
        if (Util.isEmpty((String)impOrder.getPaymentRule())) {
            if (Util.isEmpty((String)bp.getPaymentRule())) {
                impOrder.setPaymentRule("P");
                order.setPaymentRule("P");
            } else {
                impOrder.setPaymentRule(bp.getPaymentRule());
                order.setPaymentRule(bp.getPaymentRule());
            }
        }
        if (impOrder.getC_PaymentTerm_ID() == 0 && bp.getC_PaymentTerm_ID() != 0) {
            impOrder.setC_PaymentTerm_ID(bp.getC_PaymentTerm_ID());
            order.setC_PaymentTerm_ID(bp.getC_PaymentTerm_ID());
        }
        if (Util.isEmpty((String)impOrder.getDocStatus())) {
            order.setDocStatus("DR");
            impOrder.setDocStatus("DR");
        } else {
            order.setDocStatus(impOrder.getDocStatus());
        }
        if (Util.isEmpty((String)impOrder.getDocAction())) {
            if (this.p_docAction != null && this.p_docAction.length() > 0) {
                if (this.p_docAction.equals("--")) {
                    if (impOrder.getDocStatus().equals("CL") || impOrder.getDocStatus().equals("VO") || impOrder.getDocStatus().equals("RE")) {
                        order.setDocAction("--");
                        impOrder.setDocAction("--");
                    } else if (impOrder.getDocStatus().equals("CO")) {
                        order.setDocAction("CL");
                        impOrder.setDocAction("--");
                    } else {
                        order.setDocAction("CO");
                        impOrder.setDocAction("--");
                    }
                } else {
                    order.setDocAction(this.p_docAction);
                    impOrder.setDocAction(this.p_docAction);
                }
            } else {
                order.setDocAction("CO");
                impOrder.setDocAction("--");
            }
        } else if (impOrder.getDocAction().equals("--")) {
            if (impOrder.getDocStatus().equals("CL") || impOrder.getDocStatus().equals("VO") || impOrder.getDocStatus().equals("RE")) {
                order.setDocAction("--");
            } else if (impOrder.getDocStatus().equals("CO")) {
                order.setDocAction("CL");
            } else {
                order.setDocAction("CO");
            }
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impOrder, (PO)order, 40);
        try {
            order.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_Order_ID") + " : " + e.toString();
            return false;
        }
        impOrder.setC_Order_ID(order.getC_Order_ID());
        return true;
    }

    private boolean addOrderLine(X_I_OrderJP impOrder, MOrder order, MOrderLine line, int lineNo) {
        block22: {
            ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impOrder, (PO)line, 30);
            PO.copyValues((PO)impOrder, (PO)line);
            line.setC_Order_ID(order.getC_Order_ID());
            if (impOrder.getLine() == 0) {
                line.setLine(lineNo);
            } else {
                line.setLine(impOrder.getLine());
            }
            if (!Util.isEmpty((String)impOrder.getLineDescription())) {
                line.setDescription(impOrder.getLineDescription());
            }
            if (line.getQtyEntered().compareTo(Env.ZERO) == 0 && line.getQtyOrdered().compareTo(Env.ZERO) != 0) {
                line.setQtyEntered(line.getQtyOrdered());
            } else if (line.getQtyEntered().compareTo(Env.ZERO) != 0 && line.getQtyOrdered().compareTo(Env.ZERO) == 0) {
                line.setQtyOrdered(line.getQtyEntered());
            }
            if (impOrder.getJP_Line_OrgTrx_ID() > 0) {
                line.setAD_OrgTrx_ID(impOrder.getJP_Line_OrgTrx_ID());
            } else {
                line.setAD_OrgTrx_ID(0);
            }
            if (impOrder.getJP_Line_Project_ID() > 0) {
                line.setC_Project_ID(impOrder.getJP_Line_Project_ID());
            } else {
                line.setC_Project_ID(0);
            }
            if (impOrder.getJP_Line_Activity_ID() > 0) {
                line.setC_Activity_ID(impOrder.getJP_Line_Activity_ID());
            } else {
                line.setC_Activity_ID(0);
            }
            if (impOrder.getJP_Line_Campaign_ID() > 0) {
                line.setC_Campaign_ID(impOrder.getJP_Line_Campaign_ID());
            } else {
                line.setC_Campaign_ID(0);
            }
            if (impOrder.getJP_Line_User1_ID() > 0) {
                line.setUser1_ID(impOrder.getJP_Line_User1_ID());
            } else {
                line.setUser1_ID(0);
            }
            if (impOrder.getJP_Line_User2_ID() > 0) {
                line.setUser2_ID(impOrder.getJP_Line_User2_ID());
            } else {
                line.setUser2_ID(0);
            }
            if (this.p_IsHistoricalDataMigration) {
                line.setQtyDelivered(line.getQtyOrdered());
                line.setQtyInvoiced(line.getQtyOrdered());
                line.setQtyReserved(Env.ZERO);
                if (line.get_ColumnIndex("JP_QtyRecognized") > 0) {
                    line.set_ValueNoCheck("JP_QtyRecognized", (Object)line.getQtyOrdered());
                }
            }
            ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impOrder, (PO)line, 40);
            try {
                line.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                if (this.isEntryToPriceList(order, line)) break block22;
                this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_OrderLine_ID") + " : " + e.toString();
                return false;
            }
        }
        impOrder.setC_OrderLine_ID(line.getC_OrderLine_ID());
        impOrder.setI_IsImported(true);
        impOrder.setProcessed(true);
        impOrder.saveEx(this.get_TrxName());
        return true;
    }

    private boolean isEntryToPriceList(MOrder order, MOrderLine line) {
        if (order.getM_PriceList_ID() <= 0 || line.getM_Product_ID() <= 0) {
            return false;
        }
        MPriceList m_PriceList = new MPriceList(this.getCtx(), order.getM_PriceList_ID(), this.get_TrxName());
        MPriceListVersion m_PriceListVersion = m_PriceList.getPriceListVersion(order.getDateOrdered());
        MProductPrice m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)m_PriceListVersion.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
        if (m_ProductPrice == null) {
            m_ProductPrice = new MProductPrice(this.getCtx(), m_PriceListVersion.getM_PriceList_Version_ID(), line.getM_Product_ID(), this.get_TrxName());
            try {
                m_ProductPrice.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        try {
            line.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

