/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_LocationJP;
import jpiere.base.plugin.util.JPiereLocationUtil;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MLocation;
import org.compiere.model.ModelValidationEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class JPiereImportLocation
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        block15: {
            StringBuilder sql = null;
            int no = 0;
            StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.getAD_Client_ID());
            if (this.p_deleteOldImported) {
                sql = new StringBuilder("DELETE FROM I_LocationJP ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
            this.reverseLookupAD_Org_ID();
            this.reverseLookupC_Location_ID();
            ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
            this.commitEx();
            if (this.p_IsValidateOnly) {
                return "Validated";
            }
            sql = new StringBuilder("SELECT * FROM I_LocationJP WHERE I_IsImported='N'").append((CharSequence)clientCheck);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_I_LocationJP imp = new X_I_LocationJP(this.getCtx(), rs, this.get_TrxName());
                        boolean isNew = true;
                        if (imp.getC_Location_ID() != 0) {
                            isNew = false;
                        }
                        if (isNew) {
                            int C_Location_ID = JPiereLocationUtil.createLocation(this.getCtx(), imp.getAD_Org_ID(), imp.getJP_Location_Label(), imp.getComments(), imp.getCountryCode(), imp.getPostal(), imp.getPostal_Add(), imp.getJP_Region_Name(), imp.getRegionName(), imp.getJP_City_Name(), imp.getCity(), imp.getAddress1(), imp.getAddress2(), imp.getAddress3(), imp.getAddress4(), imp.getAddress5(), this.get_TrxName());
                            if (!imp.isI_IsActiveJP()) {
                                MLocation location = new MLocation(this.getCtx(), C_Location_ID, this.get_TrxName());
                                location.setIsActive(false);
                                location.saveEx(this.get_TrxName());
                                this.commitEx();
                            }
                            imp.setC_Location_ID(C_Location_ID);
                            imp.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
                            imp.setI_IsImported(true);
                            imp.setProcessed(true);
                        } else {
                            boolean isOk = JPiereLocationUtil.updateLocation(this.getCtx(), imp.getC_Location_ID(), imp.getAD_Org_ID(), imp.getComments(), imp.getCountryCode(), imp.getPostal(), imp.getPostal_Add(), imp.getJP_Region_Name(), imp.getRegionName(), imp.getJP_City_Name(), imp.getCity(), imp.getAddress1(), imp.getAddress2(), imp.getAddress3(), imp.getAddress4(), imp.getAddress5(), imp.isI_IsActiveJP(), this.get_TrxName());
                            if (!isOk) {
                                imp.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotUpdate"));
                                imp.setI_IsImported(false);
                                imp.setProcessed(false);
                            } else {
                                imp.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
                                imp.setI_IsImported(true);
                                imp.setProcessed(true);
                            }
                        }
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return "OK";
    }

    public String getImportTableName() {
        return "I_LocationJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private void reverseLookupAD_Org_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_LocationJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_LocationJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_Location_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Location_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Location_Label");
        sql = new StringBuilder("UPDATE I_LocationJP i ").append("SET C_Location_ID=(SELECT C_Location_ID FROM C_Location p").append(" WHERE i.JP_Location_Label= p.JP_Location_Label AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_Location_ID IS NULL AND JP_Location_Label IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
    }
}

