/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.I_C_DocType;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MCost;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_I_Inventory;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.ValueNamePair;

@Process
public class JPiereImportInventory
extends SvrProcess
implements ImportProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_JP_PhysicalWarehouse_ID = 0;
    private int p_M_Locator_ID = 0;
    private Timestamp p_MovementDate = null;
    private boolean p_DeleteOldImported = false;
    private boolean p_UpdateCosting = false;
    private int p_C_AcctSchema_ID = 0;
    MAcctSchema acctSchema = null;
    private int p_M_CostType_ID = 0;
    private int p_M_CostElement_ID = 0;
    private int p_AD_OrgTrx_ID = 0;
    private String m_docAction = null;
    private MInventory costingDoc = null;
    private int p_C_DocType_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("JP_PhysicalWarehouse_ID")) {
                    this.p_JP_PhysicalWarehouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Locator_ID")) {
                    this.p_M_Locator_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("MovementDate")) {
                    this.p_MovementDate = (Timestamp)para[i].getParameter();
                } else if (name.equals("DeleteOldImported")) {
                    this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
                } else if (name.equals("IsUpdateCosting")) {
                    this.p_UpdateCosting = "Y".equals(para[i].getParameter());
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_CostType_ID")) {
                    this.p_M_CostType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_CostElement_ID")) {
                    this.p_M_CostElement_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_OrgTrx_ID")) {
                    this.p_AD_OrgTrx_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DocAction")) {
                    this.m_docAction = (String)para[i].getParameter();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.WARNING, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder msglog = new StringBuilder("M_Locator_ID=").append(this.p_M_Locator_ID).append(",MovementDate=").append(this.p_MovementDate);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(msglog.toString());
        }
        if (this.p_UpdateCosting) {
            if (this.p_C_AcctSchema_ID <= 0) {
                throw new IllegalArgumentException("Accounting Schema required!");
            }
            if (this.p_M_CostType_ID <= 0) {
                throw new IllegalArgumentException("Cost Type required!");
            }
            if (this.p_M_CostElement_ID <= 0) {
                throw new IllegalArgumentException("Cost Element required!");
            }
            if (this.p_AD_OrgTrx_ID < 0) {
                throw new IllegalArgumentException("AD_OrgTrx required!");
            }
            if (this.p_C_DocType_ID <= 0) {
                throw new IllegalArgumentException("Cost Adjustment Document Type required!");
            }
            this.acctSchema = MAcctSchema.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID, (String)this.get_TrxName());
        }
        if (this.p_JP_PhysicalWarehouse_ID <= 0) {
            throw new IllegalArgumentException(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PhysicalWarehouse_ID"));
        }
        if (this.p_M_Locator_ID <= 0) {
            throw new IllegalArgumentException(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Locator_ID"));
        }
        MLocator loc = new MLocator(this.getCtx(), this.p_M_Locator_ID, this.get_TrxName());
        if (loc.get_ValueAsInt("JP_PhysicalWarehouse_ID") != this.p_JP_PhysicalWarehouse_ID) {
            Object[] objs = new Object[]{Msg.getElement((Properties)this.getCtx(), (String)"JP_PhysicalWarehouse_ID"), Msg.getElement((Properties)this.getCtx(), (String)"M_Locator_ID")};
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Different", (Object[])objs));
        }
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
        if (this.p_DeleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_Inventory ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Imported=" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_Inventory ").append("SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append("),").append(" AD_Org_ID = CASE WHEN COALESCE(AD_Org_ID,0)=0 THEN ").append(this.p_AD_Org_ID).append(" ELSE AD_Org_ID END,");
        if (this.p_MovementDate != null) {
            sql.append(" MovementDate = COALESCE (MovementDate,").append(DB.TO_DATE((Timestamp)this.p_MovementDate)).append("),");
        }
        sql.append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, getDate()),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, getDate()),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" M_Warehouse_ID = NULL,").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Reset=" + no);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        sql = new StringBuilder("UPDATE I_Inventory o ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, '").append("WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0").append(" OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuilder("UPDATE I_Inventory i ").append("SET C_DocType_ID=(SELECT d.C_DocType_ID FROM C_DocType d").append(" WHERE d.Name=i.DocTypeName AND d.DocBaseType='MMI' AND i.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set DocType=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Inventory i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid DocType, ' ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid DocType=" + no);
        }
        sql = new StringBuilder("UPDATE I_Inventory i ").append("SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l").append(" WHERE i.LocatorValue=l.Value AND i.AD_Client_ID=l.AD_Client_ID) ").append("WHERE M_Locator_ID IS NULL AND LocatorValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set Locator from Value =" + no);
        }
        sql = new StringBuilder("UPDATE I_Inventory i ").append("SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l").append(" WHERE i.X=l.X AND i.Y=l.Y AND i.Z=l.Z AND i.AD_Client_ID=l.AD_Client_ID) ").append("WHERE M_Locator_ID IS NULL AND X IS NOT NULL AND Y IS NOT NULL AND Z IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set Locator from X,Y,Z =" + no);
        }
        if (this.p_M_Locator_ID != 0) {
            sql = new StringBuilder("UPDATE I_Inventory ").append("SET M_Locator_ID = ").append(this.p_M_Locator_ID).append(" WHERE M_Locator_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Locator from Parameter=" + no);
            }
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Location, ' ").append("WHERE M_Locator_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Location=" + no);
        }
        sql = new StringBuilder("UPDATE I_Inventory i ").append("SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Locator l WHERE i.M_Locator_ID=l.M_Locator_ID) ").append("WHERE M_Locator_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set Warehouse from Locator =" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Warehouse, ' ").append("WHERE M_Warehouse_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Warehouse=" + no);
        }
        Object[] objs = new Object[]{Msg.getElement((Properties)this.getCtx(), (String)"JP_PhysicalWarehouse_ID"), Msg.getElement((Properties)this.getCtx(), (String)"M_Locator_ID")};
        String errorMsg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Different", (Object[])objs);
        sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='E', I_ErrorMsg='" + errorMsg + "' ").append("WHERE " + this.p_JP_PhysicalWarehouse_ID + " <> (SELECT JP_PhysicalWarehouse_ID FROM M_Locator WHERE M_Locator.M_Locator_ID = I_Inventory.M_Locator_ID) ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning(String.valueOf(errorMsg) + "=" + no);
        }
        sql = new StringBuilder("UPDATE I_Inventory i ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE i.Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set Product from Value=" + no);
        }
        sql = new StringBuilder("UPDATE I_Inventory i ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE i.UPC=p.UPC AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND UPC IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set Product from UPC=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Product, ' ").append("WHERE M_Product_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Product=" + no);
        }
        sql = new StringBuilder("UPDATE I_Inventory o ").append("SET C_Charge_ID=(SELECT C_Charge_ID FROM C_Charge p").append(" WHERE o.ChargeName=p.Name AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_Charge_ID IS NULL AND ChargeName IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set Charge=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Charge, ' ").append("WHERE C_Charge_ID IS NULL AND (ChargeName IS NOT NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid Charge=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Qty Count or Internal Use, ' ").append("WHERE QtyCount IS NULL AND QtyInternalUse IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No QtyCount or QtyInternalUse=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Excluding quantities, ' ").append("WHERE NVL(QtyInternalUse,0)<>0 AND (NVL(QtyCount,0)<>0 OR NVL(QtyBook,0)<>0) ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Excluding quantities=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Required charge, ' ").append("WHERE NVL(QtyInternalUse,0)<>0 AND NVL(C_Charge_ID,0)=0 ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Required charge=" + no);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        MInventory inventory = null;
        int noInsert = 0;
        int noInsertLine = 0;
        sql = new StringBuilder("SELECT * FROM I_Inventory ").append("WHERE I_IsImported='N'").append((CharSequence)clientCheck).append(" ORDER BY AD_Org_ID, M_Product_ID, TRUNC(MovementDate), I_Inventory_ID");
        try {
            Throwable throwable = null;
            Object var11_14 = null;
            try (CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());){
                ResultSet rs = pstmt.executeQuery();
                int x_AD_Org_ID = -1;
                int x_C_DocType_ID = -1;
                Timestamp x_MovementDate = null;
                int x_isInternalUse = -1;
                X_I_Inventory lastImp = null;
                while (rs.next()) {
                    int isInternalUse;
                    X_I_Inventory imp = new X_I_Inventory(this.getCtx(), rs, this.get_TrxName());
                    Timestamp MovementDate = TimeUtil.getDay((Timestamp)imp.getMovementDate());
                    int n = isInternalUse = imp.getQtyInternalUse().signum() != 0 ? 1 : 0;
                    if (inventory == null || imp.getAD_Org_ID() != x_AD_Org_ID || imp.getC_DocType_ID() != x_C_DocType_ID || !MovementDate.equals(x_MovementDate) || isInternalUse != x_isInternalUse) {
                        if (inventory != null) {
                            ModelValidationEngine.get().fireImportValidate((ImportProcess)this, lastImp, inventory, 40);
                            if (this.m_docAction != null && this.m_docAction.length() > 0) {
                                if (!inventory.processIt(this.m_docAction)) {
                                    this.log.warning("Inventory Process Failed: " + inventory + " - " + inventory.getProcessMsg());
                                    throw new IllegalStateException("Inventory Process Failed: " + inventory + " - " + inventory.getProcessMsg());
                                }
                                inventory.saveEx();
                            }
                        }
                        inventory = new MInventory(this.getCtx(), 0, this.get_TrxName());
                        if (imp.getC_DocType_ID() > 0) {
                            inventory.setC_DocType_ID(imp.getC_DocType_ID());
                        }
                        inventory.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                        inventory.setDescription("I " + imp.getM_Warehouse_ID() + " " + MovementDate);
                        inventory.setM_Warehouse_ID(imp.getM_Warehouse_ID());
                        inventory.setMovementDate(MovementDate);
                        if (this.p_JP_PhysicalWarehouse_ID != 0) {
                            inventory.set_ValueNoCheck("JP_PhysicalWarehouse_ID", (Object)this.p_JP_PhysicalWarehouse_ID);
                        }
                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)inventory, 30);
                        if (!inventory.save()) {
                            ValueNamePair vnp = CLogger.retrieveError();
                            if (vnp != null) {
                                imp.setI_ErrorMsg(String.valueOf(vnp.getValue()) + ": " + vnp.getName());
                                imp.saveEx();
                            }
                            this.log.log(Level.SEVERE, "Inventory not saved");
                            break;
                        }
                        x_AD_Org_ID = imp.getAD_Org_ID();
                        x_C_DocType_ID = imp.getC_DocType_ID();
                        x_MovementDate = MovementDate;
                        x_isInternalUse = isInternalUse;
                        ++noInsert;
                    }
                    MProduct product = new MProduct(this.getCtx(), imp.getM_Product_ID(), this.get_TrxName());
                    int M_AttributeSetInstance_ID = this.generateASI(product, imp);
                    MInventoryLine line = new MInventoryLine(inventory, imp.getM_Locator_ID(), imp.getM_Product_ID(), M_AttributeSetInstance_ID, imp.getQtyBook(), imp.getQtyCount(), imp.getQtyInternalUse());
                    line.setDescription(imp.getDescription());
                    if (imp.getC_Charge_ID() > 0) {
                        line.setInventoryType("C");
                    } else {
                        line.setInventoryType("D");
                    }
                    line.setC_Charge_ID(imp.getC_Charge_ID());
                    ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)line, 30);
                    if (!line.save()) {
                        ValueNamePair vnp = CLogger.retrieveError();
                        if (vnp != null) {
                            imp.setI_ErrorMsg(String.valueOf(vnp.getValue()) + ": " + vnp.getName());
                            imp.saveEx();
                        }
                        this.log.log(Level.SEVERE, "Inventory Line not saved");
                        break;
                    }
                    imp.setI_IsImported(true);
                    imp.setM_Inventory_ID(line.getM_Inventory_ID());
                    imp.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                    imp.setProcessed(true);
                    if (imp.save()) {
                        ++noInsertLine;
                        if (this.p_UpdateCosting) {
                            this.updateCosting(imp, product, line);
                        }
                    }
                    ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)line, 40);
                    lastImp = imp;
                }
                if (inventory != null && this.m_docAction != null && this.m_docAction.length() > 0) {
                    if (!inventory.processIt(this.m_docAction)) {
                        this.log.warning("Inventory Process Failed: " + inventory + " - " + inventory.getProcessMsg());
                        throw new IllegalStateException("Inventory Process Failed: " + inventory + " - " + inventory.getProcessMsg());
                    }
                    inventory.saveEx();
                }
                if (this.costingDoc != null) {
                    if (!DocumentEngine.processIt((DocAction)this.costingDoc, (String)"CO")) {
                        StringBuilder msg = new StringBuilder();
                        I_C_DocType docType = this.costingDoc.getC_DocType();
                        msg.append(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessFailed")).append(": ");
                        if (Env.isBaseLanguage((Properties)this.getCtx(), (String)"C_DocType")) {
                            msg.append(docType.getName());
                        } else {
                            msg.append(((PO)docType).get_Translation("Name"));
                        }
                        throw new AdempiereUserError(msg.toString());
                    }
                    this.costingDoc.saveEx();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        sql = new StringBuilder("UPDATE I_Inventory ").append("SET I_IsImported='N', Updated=getDate() ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@M_Inventory_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@M_InventoryLine_ID@: @Inserted@");
        return "";
    }

    protected int generateASI(MProduct product, X_I_Inventory imp) {
        int M_AttributeSetInstance_ID = 0;
        if ((imp.getLot() != null && imp.getLot().length() > 0 || imp.getSerNo() != null && imp.getSerNo().length() > 0) && product.isInstanceAttribute()) {
            MAttributeSet mas = product.getAttributeSet();
            MAttributeSetInstance masi = new MAttributeSetInstance(this.getCtx(), 0, mas.getM_AttributeSet_ID(), this.get_TrxName());
            if (mas.isLot() && imp.getLot() != null) {
                masi.setLot(imp.getLot(), imp.getM_Product_ID());
            }
            if (mas.isSerNo() && imp.getSerNo() != null) {
                masi.setSerNo(imp.getSerNo());
            }
            masi.setDescription();
            masi.saveEx();
            M_AttributeSetInstance_ID = masi.getM_AttributeSetInstance_ID();
        }
        return M_AttributeSetInstance_ID;
    }

    protected void updateCosting(X_I_Inventory imp, MProduct product, MInventoryLine line) {
        MProductCategoryAcct pca;
        String costingLevel = null;
        if (product.getM_Product_Category_ID() > 0 && (costingLevel = (pca = MProductCategoryAcct.get((Properties)this.getCtx(), (int)product.getM_Product_Category_ID(), (int)this.p_C_AcctSchema_ID, (String)this.get_TrxName())).getCostingLevel()) == null) {
            costingLevel = this.acctSchema.getCostingLevel();
        }
        int costOrgID = this.p_AD_OrgTrx_ID;
        int costASI = line.getM_AttributeSetInstance_ID();
        if ("C".equals(costingLevel)) {
            costOrgID = 0;
            costASI = 0;
        } else if ("O".equals(costingLevel)) {
            costASI = 0;
        } else if ("B".equals(costingLevel)) {
            costOrgID = 0;
        }
        MCost cost = MCost.get((MProduct)product, (int)costASI, (MAcctSchema)this.acctSchema, (int)costOrgID, (int)this.p_M_CostElement_ID, (String)this.get_TrxName());
        if (cost.is_new()) {
            cost.saveEx();
        }
        if (this.costingDoc == null) {
            this.costingDoc = new MInventory(this.getCtx(), 0, this.get_TrxName());
            this.costingDoc.setC_DocType_ID(this.p_C_DocType_ID);
            this.costingDoc.setCostingMethod(cost.getM_CostElement().getCostingMethod());
            this.costingDoc.setAD_Org_ID(imp.getAD_Org_ID());
            this.costingDoc.setDocAction("CO");
            this.costingDoc.saveEx();
        }
        MInventoryLine costingLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
        costingLine.setM_Inventory_ID(this.costingDoc.getM_Inventory_ID());
        costingLine.setM_Product_ID(cost.getM_Product_ID());
        costingLine.setCurrentCostPrice(cost.getCurrentCostPrice());
        costingLine.setNewCostPrice(imp.getCurrentCostPrice());
        costingLine.setM_Locator_ID(0);
        costingLine.setAD_Org_ID(imp.getAD_Org_ID());
        costingLine.setM_AttributeSetInstance_ID(costASI);
        costingLine.saveEx();
        imp.setM_CostingLine_ID(costingLine.getM_InventoryLine_ID());
        imp.saveEx();
    }

    public String getImportTableName() {
        return "I_Inventory";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
        return msgreturn.toString();
    }
}

