/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import jpiere.base.plugin.org.adempiere.model.X_I_EstimationJP;
import jpiere.base.plugin.org.adempiere.model.X_JP_Estimation;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MTable;
import org.compiere.model.MTableIndex;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_C_BPartner;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class JPiereImportEstimation
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private boolean m_deleteOldImported = false;
    private String m_docAction = "PR";
    private Timestamp m_DateValue = null;
    private boolean isRecordCommitJP = false;
    private boolean isDeleteIndexJP = false;
    private boolean isInvalidConstraintJP = false;
    private boolean isMonitoringProcessJP = true;
    private boolean isUniqueCheckJP = false;
    private String[] EstimationTables = new String[]{"JP_Estimation", "JP_EstimationLine"};
    private String[] allDocumentTables = new String[]{"C_Order", "C_OrderLine", "M_InOut", "M_InOutLine", "C_Invoice", "C_InvoiceLine", "Fact_Acct"};

    protected void prepare() {
        this.m_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("AD_Org_ID")) {
                this.m_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("DocAction")) {
                this.m_docAction = (String)para[i].getParameter();
            } else if (name.equals("IsRecordCommitJP")) {
                this.isRecordCommitJP = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsDeleteIndexJP")) {
                this.isDeleteIndexJP = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsInvalidConstraintJP")) {
                this.isInvalidConstraintJP = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsMonitoringProcessJP")) {
                this.isMonitoringProcessJP = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsUniqueCheckJP")) {
                this.isUniqueCheckJP = "Y".equals(para[i].getParameter());
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        int noInsertLine;
        int noInsert;
        long startImport;
        StringBuilder clientCheck;
        int no;
        StringBuilder sql;
        IProcessUI processMonitor;
        long start;
        block153: {
            ResultSet rs;
            CPreparedStatement pstmt;
            long startCreateBP;
            block151: {
                start = System.currentTimeMillis();
                processMonitor = null;
                if (this.isMonitoringProcessJP) {
                    processMonitor = Env.getProcessUI((Properties)this.getCtx());
                }
                sql = null;
                no = 0;
                clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u30a4\u30f3\u30dd\u30fc\u30c8\u6e08\u307f\u306e\u30c7\u30fc\u30bf\u306e\u524a\u9664");
                }
                if (this.m_deleteOldImported) {
                    sql = new StringBuilder("DELETE FROM I_EstimationJP ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                    no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Delete Old Impored =" + no);
                    }
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u7d44\u7e54\u3001\u66f4\u65b0\u60c5\u5831\u306e\u8a2d\u5b9a");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID,").append(this.m_AD_Org_ID).append("),").append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, SysDate),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, SysDate),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Reset=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u7d44\u7e54\u30de\u30b9\u30bf\u306e\u59a5\u5f53\u6027\u30c1\u30a7\u30c3\u30af");
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, '").append("WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0").append(" OR EXISTS (SELECT * FROM AD_Org o WHERE e.AD_Org_ID=o.AD_Org_ID AND (o.IsSummary='Y' OR o.IsActive='N')))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Org=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u4f1d\u7968\u30bf\u30a4\u30d7\u3092\u4f1d\u7968\u30bf\u30a4\u30d7\u306e\u540d\u79f0\u3088\u308a\u9006\u5f15\u304d\u8a2d\u5b9a");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=e.DocTypeName").append(" AND d.DocBaseType='JPE' AND e.AD_Client_ID=d.AD_Client_ID) ").append("WHERE e.C_DocType_ID IS NULL AND e.DocTypeName IS NOT NULL AND e.I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set JPE DocType=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid DocTypeName, ' ").append("WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid DocTypeName=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u4f1d\u7968\u30bf\u30a4\u30d7\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u30c7\u30fc\u30bf\u306b\u3001\u4f1d\u7968\u30bf\u30a4\u30d7\u3092\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType='JPE' AND e.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set JPE Default DocType=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No DocType, ' ").append("WHERE C_DocType_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No DocType=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u4f1d\u7968\u30bf\u30a4\u30d7\u304b\u3089IsSOTrx\u3092\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e SET IsSOTrx='Y' ").append("WHERE EXISTS (SELECT * FROM C_DocType d WHERE e.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='SOO' AND e.AD_Client_ID=d.AD_Client_ID)").append(" AND C_DocType_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set IsSOTrx=Y=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e SET IsSOTrx='N' ").append("WHERE EXISTS (SELECT * FROM C_DocType d WHERE e.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='POO' AND e.AD_Client_ID=d.AD_Client_ID)").append(" AND C_DocType_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set IsSOTrx=N=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u30d7\u30e9\u30a4\u30b9\u30ea\u30b9\u30c8\u3092\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y'").append(" AND p.C_Currency_ID=e.C_Currency_ID AND p.IsSOPriceList=e.IsSOTrx AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default Currency PriceList=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y'").append(" AND p.IsSOPriceList=e.IsSOTrx AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default PriceList=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.C_Currency_ID=e.C_Currency_ID AND p.IsSOPriceList=e.IsSOTrx AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Currency PriceList=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.IsSOPriceList=e.IsSOTrx AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set PriceList=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No PriceList, ' ").append("WHERE M_PriceList_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No PriceList=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("Order Source\u3092\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_OrderSource_ID=(SELECT C_OrderSource_ID FROM C_OrderSource o").append(" WHERE e.C_OrderSourceValue=o.Value AND e.AD_Client_ID=o.AD_Client_ID) ").append("WHERE C_OrderSource_ID IS NULL AND C_OrderSourceValue IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Order Source=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Not Found Order Source, ' ").append("WHERE C_OrderSource_ID IS NULL AND C_OrderSourceValue IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No OrderSource=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u652f\u6255\u6761\u4ef6\u3092\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p").append(" WHERE e.PaymentTermValue=p.Value AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_PaymentTerm_ID IS NULL AND PaymentTermValue IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set PaymentTerm=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_PaymentTerm_ID=(SELECT MAX(C_PaymentTerm_ID) FROM C_PaymentTerm p").append(" WHERE p.IsDefault='Y' AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_PaymentTerm_ID IS NULL AND e.PaymentTermValue IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default PaymentTerm=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No PaymentTerm, ' ").append("WHERE C_PaymentTerm_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No PaymentTerm=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u5009\u5eab\u3092\u8a2d\u5b9a\u3059\u308b");
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_Warehouse_ID=(SELECT MAX(M_Warehouse_ID) FROM M_Warehouse w").append(" WHERE e.AD_Client_ID=w.AD_Client_ID AND e.AD_Org_ID=w.AD_Org_ID) ").append("WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Warehouse=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Warehouse w").append(" WHERE e.AD_Client_ID=w.AD_Client_ID) ").append("WHERE M_Warehouse_ID IS NULL").append(" AND EXISTS (SELECT AD_Client_ID FROM M_Warehouse w WHERE w.AD_Client_ID=e.AD_Client_ID GROUP BY AD_Client_ID HAVING COUNT(*)=1)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Only Client Warehouse=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Warehouse, ' ").append("WHERE M_Warehouse_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No Warehouse=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u53d6\u5f15\u5148\u3092\u30e6\u30fc\u30b6\u30fc\u306eEmail\u3088\u308a\u9006\u5f15\u304d\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u").append(" WHERE e.EMail=u.EMail AND e.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) ").append("WHERE C_BPartner_ID IS NULL AND EMail IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP from EMail=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u53d6\u5f15\u5148\u3092\u30e6\u30fc\u30b6\u30fc\u306eContact Name\u3088\u308a\u9006\u5f15\u304d\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u").append(" WHERE e.ContactName=u.Name AND e.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) ").append("WHERE C_BPartner_ID IS NULL AND ContactName IS NOT NULL").append(" AND EXISTS (SELECT Name FROM AD_User u WHERE e.ContactName=u.Name AND e.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL GROUP BY Name HAVING COUNT(*)=1)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP from ContactName=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u53d6\u5f15\u5148\u3092\u53d6\u5f15\u5148\u306e\u691c\u7d22\u30ad\u30fc\u3088\u308a\u9006\u5f15\u304d\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp").append(" WHERE e.BPartnerValue=bp.Value AND e.AD_Client_ID=bp.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP from Value=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u53d6\u5f15\u5148\u304c\u7121\u3044\u30c7\u30fc\u30bf\u306b\u5bfe\u3057\u3066\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u53d6\u5f15\u5148\u3092\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_BPartner_ID=(SELECT C_BPartnerCashTrx_ID FROM AD_ClientInfo c").append(" WHERE e.AD_Client_ID=c.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NULL AND Name IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Default BP=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u53d6\u5f15\u5148\u3068\u8acb\u6c42\u5148\u306e\u4f4f\u6240\u3092\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET (BillTo_ID,C_BPartner_Location_ID)=(SELECT C_BPartner_Location_ID,C_BPartner_Location_ID").append(" FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID)").append(" WHERE e.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=e.AD_Client_ID").append(" AND DUMP(e.Address1)=DUMP(l.Address1) AND DUMP(e.Address2)=DUMP(l.Address2)").append(" AND DUMP(e.City)=DUMP(l.City) AND DUMP(e.Postal)=DUMP(l.Postal)").append(" AND e.C_Region_ID=l.C_Region_ID AND e.C_Country_ID=l.C_Country_ID) ").append("WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Found Location=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET BillTo_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l").append(" WHERE l.C_BPartner_ID=e.C_BPartner_ID AND e.AD_Client_ID=l.AD_Client_ID").append(" AND ((l.IsBillTo='Y' AND e.IsSOTrx='Y') OR (l.IsPayFrom='Y' AND e.IsSOTrx='N'))").append(") ").append("WHERE C_BPartner_ID IS NOT NULL AND BillTo_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP BillTo from BP=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_BPartner_Location_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l").append(" WHERE l.C_BPartner_ID=e.C_BPartner_ID AND e.AD_Client_ID=l.AD_Client_ID").append(" AND ((l.IsShipTo='Y' AND e.IsSOTrx='Y') OR e.IsSOTrx='N')").append(") ").append("WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set BP Location from BP=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BP Location, ' ").append("WHERE C_BPartner_ID IS NOT NULL AND (BillTo_ID IS NULL OR C_BPartner_Location_ID IS NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("No BP Location=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u901a\u8ca8\u306e\u8a2d\u5b9a\u3059\u308b");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c").append(" WHERE e.CountryCode=c.CountryCode AND c.AD_Client_ID IN (0, e.AD_Client_ID)) ").append("WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL AND CountryCode IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Country=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Country, ' ").append("WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Country=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u5730\u57df(\u90fd\u9053\u5e9c\u770c)\u306e\u8a2d\u5b9a");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("Set RegionName=(SELECT MAX(Name) FROM C_Region r").append(" WHERE r.IsDefault='Y' AND r.C_Country_ID=e.C_Country_ID").append(" AND r.AD_Client_ID IN (0, e.AD_Client_ID)) ").append("WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Region Default=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r").append(" WHERE r.Name=e.RegionName AND r.C_Country_ID=e.C_Country_ID").append(" AND r.AD_Client_ID IN (0, e.AD_Client_ID)) ").append("WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Region=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Region, ' ").append("WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL ").append(" AND EXISTS (SELECT * FROM C_Country c").append(" WHERE c.C_Country_ID=e.C_Country_ID AND c.HasRegion='Y')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Region=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u54c1\u76ee\u306e\u8a2d\u5b9a");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE e.ProductValue=p.Value AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Product from Value=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE e.UPC=p.UPC AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND UPC IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Product from UPC=" + no);
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE e.SKU=p.SKU AND e.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND SKU IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Product fom SKU=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, ' ").append("WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Product=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u6599\u91d1\u30bf\u30a4\u30d7\u306e\u8a2d\u5b9a");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_Charge_ID=(SELECT C_Charge_ID FROM C_Charge c").append(" WHERE e.ChargeName=c.Name AND e.AD_Client_ID=c.AD_Client_ID) ").append("WHERE C_Charge_ID IS NULL AND ChargeName IS NOT NULL AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Charge=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Charge, ' ").append("WHERE C_Charge_ID IS NULL AND (ChargeName IS NOT NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Charge=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Product and Charge, ' ").append("WHERE M_Product_ID IS NOT NULL AND C_Charge_ID IS NOT NULL ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Product and Charge exclusive=" + no);
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u7a0e\u91d1\u60c5\u5831\u306e\u8a2d\u5b9a");
                }
                sql = new StringBuilder("UPDATE I_EstimationJP e ").append("SET C_Tax_ID=(SELECT MAX(C_Tax_ID) FROM C_Tax t").append(" WHERE e.TaxIndicator=t.TaxIndicator AND e.AD_Client_ID=t.AD_Client_ID) ").append("WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Tax=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Tax, ' ").append("WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Tax=" + no);
                }
                this.commitEx();
                long endPreProcessing = System.currentTimeMillis();
                this.addLog("\u524d\u51e6\u7406\u6642\u9593: " + (endPreProcessing - start) + " \u30df\u30ea\u79d2");
                if (this.isInvalidConstraintJP) {
                    if (processMonitor != null) {
                        processMonitor.statusUpdate("\u5236\u7d04\u306e\u7121\u52b9\u5316");
                    }
                    long startInvalidConstraint = System.currentTimeMillis();
                    int i = 0;
                    while (i < this.allDocumentTables.length) {
                        StringBuilder invalidConstraint = new StringBuilder(" update pg_trigger set tgenabled = 'D' where oid in (select tr.oid from pg_trigger tr INNER JOIN pg_class cl on (tr.tgrelid = cl.oid) WHERE cl.relname=lower('" + this.allDocumentTables[i] + "') )");
                        DB.executeUpdate((String)invalidConstraint.toString(), (String)this.get_TrxName());
                        ++i;
                    }
                    this.commitEx();
                    long endInvalidConstraint = System.currentTimeMillis();
                    this.addLog("\u5236\u7d04\u7121\u52b9\u306e\u51e6\u7406\u6642\u9593: " + (endInvalidConstraint - startInvalidConstraint) + " \u30df\u30ea\u79d2");
                }
                if (this.isDeleteIndexJP) {
                    if (processMonitor != null) {
                        processMonitor.statusUpdate("Index\u306e\u524a\u9664");
                    }
                    long startDeleteIndex = System.currentTimeMillis();
                    int i = 0;
                    while (i < this.allDocumentTables.length) {
                        MTable mTable = MTable.get((Properties)this.getCtx(), (String)this.allDocumentTables[i]);
                        MTableIndex[] indexes = MTableIndex.get((MTable)mTable);
                        int j = 0;
                        while (j < indexes.length) {
                            String indexDropSql = indexes[j].getDropDDL();
                            DB.executeUpdateEx((String)indexDropSql, (String)this.get_TrxName());
                            ++j;
                        }
                        ++i;
                    }
                    this.commitEx();
                    long endDeleteIndex = System.currentTimeMillis();
                    this.addLog("Index\u306e\u524a\u9664\u6642\u9593: " + (endDeleteIndex - startDeleteIndex) + " \u30df\u30ea\u79d2");
                }
                if (processMonitor != null) {
                    processMonitor.statusUpdate("\u65b0\u898f\u53d6\u5f15\u5148\u306e\u767b\u9332");
                }
                startCreateBP = System.currentTimeMillis();
                sql = new StringBuilder("SELECT * FROM I_EstimationJP ").append("WHERE I_IsImported='N' AND C_BPartner_ID IS NULL").append((CharSequence)clientCheck);
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MBPartner bp;
                            X_I_EstimationJP imp = new X_I_EstimationJP(this.getCtx(), rs, this.get_TrxName());
                            if (imp.getBPartnerValue() == null) {
                                if (imp.getEMail() != null) {
                                    imp.setBPartnerValue(imp.getEMail());
                                } else {
                                    if (imp.getName() == null) continue;
                                    imp.setBPartnerValue(imp.getName());
                                }
                            }
                            if (imp.getName() == null) {
                                if (imp.getContactName() != null) {
                                    imp.setName(imp.getContactName());
                                } else {
                                    imp.setName(imp.getBPartnerValue());
                                }
                            }
                            if ((bp = MBPartner.get((Properties)this.getCtx(), (String)imp.getBPartnerValue())) == null) {
                                bp = new MBPartner(this.getCtx(), -1, this.get_TrxName());
                                bp.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                                bp.setValue(imp.getBPartnerValue());
                                bp.setName(imp.getName());
                                if (!bp.save()) continue;
                            }
                            imp.setC_BPartner_ID(bp.getC_BPartner_ID());
                            MBPartnerLocation bpl = null;
                            MBPartnerLocation[] bpls = bp.getLocations(true);
                            int i = 0;
                            while (bpl == null && i < bpls.length) {
                                MLocation loc;
                                if (imp.getC_BPartner_Location_ID() == bpls[i].getC_BPartner_Location_ID()) {
                                    bpl = bpls[i];
                                } else if (imp.getC_Location_ID() == bpls[i].getC_Location_ID()) {
                                    bpl = bpls[i];
                                } else if (imp.getC_Location_ID() == 0 && (loc = bpls[i].getLocation(false)).equals(imp.getC_Country_ID(), imp.getC_Region_ID(), imp.getPostal(), "", imp.getCity(), imp.getAddress1(), imp.getAddress2())) {
                                    bpl = bpls[i];
                                }
                                ++i;
                            }
                            if (bpl == null) {
                                MLocation loc = new MLocation(this.getCtx(), 0, this.get_TrxName());
                                loc.setAddress1(imp.getAddress1());
                                loc.setAddress2(imp.getAddress2());
                                loc.setCity(imp.getCity());
                                loc.setPostal(imp.getPostal());
                                if (imp.getC_Region_ID() != 0) {
                                    loc.setC_Region_ID(imp.getC_Region_ID());
                                }
                                loc.setC_Country_ID(imp.getC_Country_ID());
                                if (!loc.save()) continue;
                                bpl = new MBPartnerLocation(bp);
                                bpl.setC_Location_ID(loc.getC_Location_ID());
                                if (!bpl.save()) continue;
                            }
                            imp.setC_Location_ID(bpl.getC_Location_ID());
                            imp.setBillTo_ID(bpl.getC_BPartner_Location_ID());
                            imp.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                            if (imp.getContactName() != null || imp.getEMail() != null || imp.getPhone() != null) {
                                MUser[] users = bp.getContacts(true);
                                MUser user = null;
                                int i2 = 0;
                                while (user == null && i2 < users.length) {
                                    String name = users[i2].getName();
                                    if (name.equals(imp.getContactName()) || name.equals(imp.getName())) {
                                        user = users[i2];
                                        imp.setAD_User_ID(user.getAD_User_ID());
                                    }
                                    ++i2;
                                }
                                if (user == null) {
                                    user = new MUser((X_C_BPartner)bp);
                                    if (imp.getContactName() == null) {
                                        user.setName(imp.getName());
                                    } else {
                                        user.setName(imp.getContactName());
                                    }
                                    user.setEMail(imp.getEMail());
                                    user.setPhone(imp.getPhone());
                                    if (user.save()) {
                                        imp.setAD_User_ID(user.getAD_User_ID());
                                    }
                                }
                            }
                            imp.save();
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, "BP - " + sql.toString(), (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block151;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BPartner, ' ").append("WHERE C_BPartner_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (no != 0) {
                this.log.warning("No BPartner=" + no);
            }
            this.commitEx();
            long endCreateBP = System.currentTimeMillis();
            this.addLog("\u65b0\u898f\u53d6\u5f15\u5148\u306e\u767b\u9332\u6642\u9593: " + (endCreateBP - startCreateBP) + " \u30df\u30ea\u79d2");
            startImport = System.currentTimeMillis();
            if (processMonitor != null) {
                processMonitor.statusUpdate("\u898b\u7a4d\u4f1d\u7968\u306e\u767b\u9332");
            }
            noInsert = 0;
            noInsertLine = 0;
            sql = new StringBuilder("SELECT * FROM I_EstimationJP ").append("WHERE I_IsImported='N'").append((CharSequence)clientCheck).append(" ORDER BY DateOrdered, C_BPartner_ID, BillTo_ID, C_BPartner_Location_ID, I_EstimationJP_ID");
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    int oldC_BPartner_ID = 0;
                    int oldBillTo_ID = 0;
                    int oldC_BPartner_Location_ID = 0;
                    String oldDocumentNo = "";
                    X_JP_Estimation estimation = null;
                    int lineNo = 0;
                    while (rs.next()) {
                        X_I_EstimationJP imp = new X_I_EstimationJP(this.getCtx(), rs, this.get_TrxName());
                        String cmpDocumentNo = imp.getDocumentNo();
                        if (cmpDocumentNo == null) {
                            cmpDocumentNo = "";
                        }
                        if (oldC_BPartner_ID != imp.getC_BPartner_ID() || oldC_BPartner_Location_ID != imp.getC_BPartner_Location_ID() || oldBillTo_ID != imp.getBillTo_ID() || !oldDocumentNo.equals(cmpDocumentNo)) {
                            if (estimation != null) {
                                if (this.m_docAction != null && this.m_docAction.length() > 0 && !((MEstimation)estimation).processIt(this.m_docAction)) {
                                    this.log.warning("Estimation Process Failed: " + estimation + " - " + ((MEstimation)estimation).getProcessMsg());
                                    throw new IllegalStateException("Estimation Process Failed: " + estimation + " - " + ((MEstimation)estimation).getProcessMsg());
                                }
                                estimation.saveEx();
                                if (this.isRecordCommitJP) {
                                    this.commitEx();
                                }
                                if (processMonitor != null) {
                                    processMonitor.statusUpdate(String.valueOf(estimation.getDocumentNo()) + "\u306e\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                                }
                            }
                            oldC_BPartner_ID = imp.getC_BPartner_ID();
                            oldC_BPartner_Location_ID = imp.getC_BPartner_Location_ID();
                            oldBillTo_ID = imp.getBillTo_ID();
                            oldDocumentNo = imp.getDocumentNo();
                            if (oldDocumentNo == null) {
                                oldDocumentNo = "";
                            }
                            estimation = new MEstimation(this.getCtx(), 0, this.get_TrxName());
                            PO.copyValues((PO)imp, (PO)estimation);
                            estimation.setAD_Org_ID(imp.getAD_Org_ID());
                            estimation.setC_DocTypeTarget_ID(imp.getC_DocType_ID());
                            estimation.setIsSOTrx(imp.isSOTrx());
                            estimation.setDocAction(this.m_docAction);
                            estimation.setDocStatus("DR");
                            if (imp.getDeliveryRule() != null) {
                                estimation.setDeliveryRule(imp.getDeliveryRule());
                            }
                            if (imp.getInvoiceRule() != null) {
                                estimation.setInvoiceRule(imp.getInvoiceRule());
                            }
                            if (imp.getFreightCostRule() != null) {
                                estimation.setFreightCostRule(imp.getFreightCostRule());
                            }
                            if (imp.getDeliveryViaRule() != null) {
                                estimation.setDeliveryViaRule(imp.getDeliveryViaRule());
                            }
                            if (imp.getPriorityRule() != null) {
                                estimation.setPriorityRule(imp.getPriorityRule());
                            }
                            if (imp.getDocumentNo() != null) {
                                estimation.setDocumentNo(imp.getDocumentNo());
                            }
                            estimation.setC_BPartner_ID(imp.getC_BPartner_ID());
                            estimation.setC_BPartner_Location_ID(imp.getC_BPartner_Location_ID());
                            if (imp.getAD_User_ID() != 0) {
                                estimation.setAD_User_ID(imp.getAD_User_ID());
                            }
                            estimation.setBill_BPartner_ID(imp.getC_BPartner_ID());
                            estimation.setBill_Location_ID(imp.getBillTo_ID());
                            if (imp.getDescription() != null) {
                                estimation.setDescription(imp.getDescription());
                            }
                            estimation.setPaymentRule(imp.getPaymentRule());
                            estimation.setC_PaymentTerm_ID(imp.getC_PaymentTerm_ID());
                            ((MEstimation)estimation).setM_PriceList_ID(imp.getM_PriceList_ID());
                            estimation.setM_Warehouse_ID(imp.getM_Warehouse_ID());
                            if (imp.getM_Shipper_ID() != 0) {
                                estimation.setM_Shipper_ID(imp.getM_Shipper_ID());
                            }
                            if (imp.getSalesRep_ID() != 0) {
                                estimation.setSalesRep_ID(imp.getSalesRep_ID());
                            }
                            if (estimation.getSalesRep_ID() == 0) {
                                estimation.setSalesRep_ID(this.getAD_User_ID());
                            }
                            if (imp.getAD_OrgTrx_ID() != 0) {
                                estimation.setAD_OrgTrx_ID(imp.getAD_OrgTrx_ID());
                            }
                            if (imp.getC_Activity_ID() != 0) {
                                estimation.setC_Activity_ID(imp.getC_Activity_ID());
                            }
                            if (imp.getC_Campaign_ID() != 0) {
                                estimation.setC_Campaign_ID(imp.getC_Campaign_ID());
                            }
                            if (imp.getC_Project_ID() != 0) {
                                estimation.setC_Project_ID(imp.getC_Project_ID());
                            }
                            if (imp.getDateOrdered() != null) {
                                estimation.setDateOrdered(imp.getDateOrdered());
                            }
                            if (imp.getDateAcct() != null) {
                                estimation.setDateAcct(imp.getDateAcct());
                            }
                            if (imp.getDatePromised() != null) {
                                estimation.setDatePromised(imp.getDatePromised());
                            }
                            if (imp.getC_OrderSource() != null) {
                                estimation.setC_OrderSource_ID(imp.getC_OrderSource_ID());
                            }
                            estimation.saveEx();
                            ++noInsert;
                            lineNo = 10;
                        }
                        imp.setJP_Estimation_ID(estimation.getJP_Estimation_ID());
                        MEstimationLine line = new MEstimationLine((MEstimation)estimation);
                        line.setLine(lineNo);
                        lineNo += 10;
                        if (imp.getM_Product_ID() != 0) {
                            line.setM_Product_ID(imp.getM_Product_ID());
                        }
                        if (imp.getC_Charge_ID() != 0) {
                            line.setC_Charge_ID(imp.getC_Charge_ID());
                        }
                        line.setQtyOrdered(imp.getQtyOrdered());
                        line.setPrice();
                        if (imp.getPriceActual().compareTo(Env.ZERO) != 0) {
                            line.setPriceActual(imp.getPriceActual());
                        }
                        if (imp.getC_Tax_ID() != 0) {
                            line.setC_Tax_ID(imp.getC_Tax_ID());
                        } else {
                            imp.setC_Tax_ID(line.getC_Tax_ID());
                        }
                        if (imp.getFreightAmt() != null) {
                            line.setFreightAmt(imp.getFreightAmt());
                        }
                        if (imp.getLineDescription() != null) {
                            line.setDescription(imp.getLineDescription());
                        }
                        line.saveEx();
                        imp.setJP_EstimationLine_ID(line.getJP_EstimationLine_ID());
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                        if (!imp.save()) continue;
                        ++noInsertLine;
                    }
                    if (estimation != null) {
                        if (this.m_docAction != null && this.m_docAction.length() > 0) {
                            estimation.setDocAction(this.m_docAction);
                            if (!((MEstimation)estimation).processIt(this.m_docAction)) {
                                this.log.warning("Estimation Process Failed: " + estimation + " - " + ((MEstimation)estimation).getProcessMsg());
                                throw new IllegalStateException("Estimation Process Failed: " + estimation + " - " + ((MEstimation)estimation).getProcessMsg());
                            }
                        }
                        estimation.saveEx();
                        if (this.isRecordCommitJP) {
                            this.commitEx();
                        }
                        if (processMonitor != null) {
                            processMonitor.statusUpdate(String.valueOf(estimation.getDocumentNo()) + "\u306e\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Estimation - " + sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block153;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        sql = new StringBuilder("UPDATE I_EstimationJP ").append("SET I_IsImported='N', Updated=SysDate ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        long endImport = System.currentTimeMillis();
        this.addLog("\u30a4\u30f3\u30dd\u30fc\u30c8\u51e6\u7406\u6642\u9593: " + (endImport - startImport) + " \u30df\u30ea\u79d2");
        if (this.isDeleteIndexJP) {
            if (processMonitor != null) {
                processMonitor.statusUpdate("Index\u306e\u518d\u4f5c\u6210");
            }
            long startCreateIndex = System.currentTimeMillis();
            this.createIndex();
            this.commitEx();
            long endCreateIndex = System.currentTimeMillis();
            this.addLog("Index\u306e\u518d\u4f5c\u6210\u6642\u9593: " + (endCreateIndex - startCreateIndex) + " \u30df\u30ea\u79d2");
        }
        if (this.isInvalidConstraintJP) {
            if (processMonitor != null) {
                processMonitor.statusUpdate("\u5236\u7d04\u306e\u6709\u52b9\u5316");
            }
            long startValidConstraint = System.currentTimeMillis();
            this.validConstraint();
            this.commitEx();
            long endValidConstraint = System.currentTimeMillis();
            this.addLog("\u5236\u7d04\u306e\u6709\u52b9\u5316\u306e\u51e6\u7406\u6642\u9593: " + (endValidConstraint - startValidConstraint) + " \u30df\u30ea\u79d2");
        }
        long finish = System.currentTimeMillis();
        this.addLog("*****\u51e6\u7406\u304c\u7121\u4e8b\u7d42\u4e86\u3057\u307e\u3057\u305f*****");
        this.addLog("\u5408\u8a08\u6642\u9593\u51e6\u7406\u6642\u9593: " + (finish - start) + " \u30df\u30ea\u79d2");
        this.addLog(0, null, new BigDecimal(noInsert), "@JP_Estimation_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@JP_EstimationLine_ID@: @Inserted@");
        StringBuilder msgreturn = new StringBuilder("#").append(noInsert).append("/").append(noInsertLine);
        return msgreturn.toString();
    }

    private boolean createIndex() {
        int i = 0;
        while (i < this.allDocumentTables.length) {
            MTable mTable = MTable.get((Properties)this.getCtx(), (String)this.allDocumentTables[i]);
            MTableIndex[] indexes = MTableIndex.get((MTable)mTable);
            int j = 0;
            while (j < indexes.length) {
                String indexDropSql = indexes[j].getDDL();
                DB.executeUpdateEx((String)indexDropSql, (String)this.get_TrxName());
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean validConstraint() {
        int i = 0;
        while (i < this.allDocumentTables.length) {
            StringBuilder invalidConstraint = new StringBuilder(" update pg_trigger set tgenabled = 'O' where oid in (select tr.oid from pg_trigger tr INNER JOIN pg_class cl on (tr.tgrelid = cl.oid) WHERE cl.relname=lower('" + this.allDocumentTables[i] + "') )");
            DB.executeUpdate((String)invalidConstraint.toString(), (String)this.get_TrxName());
            ++i;
        }
        return true;
    }
}

