/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MCorporation;
import jpiere.base.plugin.org.adempiere.model.X_I_CorporationJP;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class JPiereImportCorporation
extends SvrProcess {
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.getAD_Client_ID());
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_CorporationJP ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_CorporationJP i ").append("SET JP_Corporation_ID=(SELECT JP_Corporation_ID FROM JP_Corporation p").append(" WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE JP_Corporation_ID is Null AND Value IS NOT NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Found Corporation=" + no);
        }
        this.commitEx();
        sql = new StringBuilder("UPDATE I_CorporationJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.BPValue=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE C_BPartner_ID is Null AND BPValue IS NOT NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Found Business Partner=" + no);
        }
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_CorporationJP WHERE I_IsImported='N'").append((CharSequence)clientCheck);
        CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            X_I_CorporationJP imp = new X_I_CorporationJP(this.getCtx(), rs, this.get_TrxName());
            boolean isNew = true;
            if (imp.getJP_Corporation_ID() != 0) {
                isNew = false;
            }
            if (isNew) {
                if (imp.getName() != null && !imp.getName().isEmpty()) {
                    MCorporation newCorp = new MCorporation(this.getCtx(), 0, this.get_TrxName());
                    newCorp.setValue(imp.getValue());
                    newCorp.setName(imp.getName());
                    newCorp.setName2(imp.getName2());
                    newCorp.setDescription(imp.getDescription());
                    newCorp.setDUNS(imp.getDUNS());
                    newCorp.setC_BPartner_ID(imp.getC_BPartner_ID());
                    newCorp.saveEx();
                    imp.setJP_Corporation_ID(newCorp.getJP_Corporation_ID());
                    imp.setI_ErrorMsg("New Record");
                    imp.setI_IsImported(true);
                    imp.setProcessed(true);
                } else {
                    imp.setI_ErrorMsg("No Name");
                    imp.setI_IsImported(false);
                    imp.setProcessed(false);
                }
            } else {
                MCorporation updateCorp = new MCorporation(this.getCtx(), imp.getJP_Corporation_ID(), this.get_TrxName());
                updateCorp.setName(imp.getName());
                updateCorp.setName2(imp.getName2());
                updateCorp.setDescription(imp.getDescription());
                updateCorp.setDUNS(imp.getDUNS());
                updateCorp.setC_BPartner_ID(imp.getC_BPartner_ID());
                updateCorp.saveEx();
                imp.setI_ErrorMsg("Update Record");
                imp.setI_IsImported(true);
                imp.setProcessed(true);
            }
            imp.saveEx();
        }
        return "";
    }
}

