/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_CityJP;
import org.compiere.model.MCity;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class JPiereImportCity
extends SvrProcess {
    private boolean p_deleteOldImported = false;
    private boolean isMatchNameJP = true;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            }
            if (name.equals("IsMatchNameJP")) {
                this.isMatchNameJP = "Y".equals(para[i].getParameter());
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.getAD_Client_ID());
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_CityJP ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_CityJP ").append("SET C_Region_ID=(SELECT C_Region_ID FROM C_Region").append(" WHERE i_CityJP.RegionName =C_Region.Name AND i_CityJP.AD_Client_ID=C_Region.AD_Client_ID) ").append("WHERE RegionName IS NOT NULL AND C_Region_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.commitEx();
        sql = new StringBuilder("UPDATE I_CityJP ").append("SET C_Country_ID=(SELECT C_Country_ID FROM C_Region").append(" WHERE i_CityJP.C_Region_ID =C_Region.C_Region_ID) ").append(" WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.commitEx();
        sql = new StringBuilder("UPDATE I_CityJP ").append("SET C_Country_ID=(SELECT C_Country_ID FROM C_Country").append(" WHERE i_CityJP.CountryName =C_Country.Name AND i_CityJP.AD_Client_ID=C_Country.AD_Client_ID) ").append("WHERE CountryName IS NOT NULL AND C_Country_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.commitEx();
        sql = new StringBuilder("SELECT DISTINCT C_Country_ID FROM I_CityJP WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        CPreparedStatement checkOneCountry = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
        ResultSet checkOneCountryRS = checkOneCountry.executeQuery();
        int C_Country_ID = 0;
        int countryCounter = 0;
        while (checkOneCountryRS.next()) {
            if (countryCounter > 0) {
                this.addLog("This import data contain several country data.");
                return "This import data contain several country data.";
            }
            C_Country_ID = checkOneCountryRS.getInt(1);
            ++countryCounter;
        }
        if (this.isMatchNameJP) {
            sql = new StringBuilder("UPDATE I_CityJP ").append("SET C_City_ID = (SELECT C_City_ID FROM C_City").append(" WHERE C_City.C_Country_ID = I_CityJP.C_Country_ID AND C_City.C_Region_ID = I_CityJP.C_Region_ID  ").append(" AND C_City.Name = I_CityJP.Name) ").append(" WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        } else {
            sql = new StringBuilder("UPDATE I_CityJP ").append("SET C_City_ID = (SELECT C_City_ID FROM C_City").append(" WHERE C_City.C_Country_ID = I_CityJP.C_Country_ID AND C_City.C_Region_ID = I_CityJP.C_Region_ID  ").append(" AND C_City.AreaCode = I_CityJP.AreaCode) ").append(" WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        }
        this.commitEx();
        sql = this.isMatchNameJP ? new StringBuilder("SELECT * FROM C_City WHERE C_Country_ID = " + C_Country_ID).append((CharSequence)clientCheck).append("ORDER BY C_Region_ID,Name,AreaCode ") : new StringBuilder("SELECT * FROM C_City WHERE C_Country_ID = " + C_Country_ID).append((CharSequence)clientCheck).append("ORDER BY C_Region_ID,AreaCode,Name ");
        CPreparedStatement pstmt1 = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
        ResultSet rs1 = pstmt1.executeQuery();
        ArrayList<MCity> list = new ArrayList<MCity>();
        while (rs1.next()) {
            list.add(new MCity(this.getCtx(), rs1, this.get_TrxName()));
        }
        sql = new StringBuilder("SELECT * FROM I_CityJP WHERE I_IsImported='N'").append((CharSequence)clientCheck);
        CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            X_I_CityJP imp = new X_I_CityJP(this.getCtx(), rs, this.get_TrxName());
            boolean isNew = true;
            if (imp.getC_City_ID() != 0) {
                isNew = false;
            }
            if (isNew) {
                if (imp.getName() != null && !imp.getName().isEmpty()) {
                    MCity newCity = new MCity(this.getCtx(), 0, this.get_TrxName());
                    newCity.setC_Country_ID(imp.getC_Country_ID());
                    newCity.setC_Region_ID(imp.getC_Region_ID());
                    newCity.setName(imp.getName());
                    newCity.setAreaCode(imp.getAreaCode());
                    newCity.saveEx(this.get_TrxName());
                    imp.setC_City_ID(newCity.getC_City_ID());
                    imp.setI_ErrorMsg("New Record");
                    imp.setI_IsImported(true);
                    imp.setProcessed(true);
                } else {
                    imp.setI_IsImported(false);
                    imp.setProcessed(false);
                    imp.setI_ErrorMsg("No Name");
                }
            } else {
                for (MCity city : list) {
                    if (imp.getName() != null && !imp.getName().isEmpty()) {
                        if (this.isMatchNameJP && imp.getC_Region_ID() == city.getC_Region_ID() && imp.getName().equals(city.getName())) {
                            city.setPostal(imp.getPostal());
                            city.setAreaCode(imp.getAreaCode());
                            city.setLocode(imp.getLocode());
                            city.setCoordinates(imp.getCoordinates());
                            city.saveEx();
                            imp.setI_ErrorMsg("Update data matching name");
                            imp.setI_IsImported(true);
                            imp.setProcessed(true);
                            break;
                        }
                        if (this.isMatchNameJP || imp.getC_Region_ID() != city.getC_Region_ID() || !imp.getAreaCode().equals(city.getAreaCode())) continue;
                        city.setName(imp.getName());
                        city.setPostal(imp.getPostal());
                        city.setLocode(imp.getLocode());
                        city.setCoordinates(imp.getCoordinates());
                        city.saveEx();
                        imp.setI_ErrorMsg("Update data matching AreaCode");
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                        break;
                    }
                    imp.setI_IsImported(false);
                    imp.setProcessed(false);
                    imp.setI_ErrorMsg("No Name");
                    break;
                }
            }
            imp.saveEx();
        }
        return "";
    }
}

