/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_ChargeJP;
import jpiere.base.plugin.util.JPiereValidCombinationUtil;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MCharge;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_C_Charge_Acct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportCharge
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private IProcessUI processMonitor = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_ChargeJP ").append("WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_ChargeJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.reverseLookupC_Charge_ID();
        this.reverseLookupAD_Org_ID();
        this.reverseLookupC_ChargeType_ID();
        this.reverseLookupC_TaxCategory_ID();
        this.reverseLookupC_BPartner_ID();
        this.reverseLookupC_AcctSchema_ID();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_ChargeJP WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY Name ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                String preName = "";
                MCharge charge = null;
                while (rs.next()) {
                    X_I_ChargeJP imp = new X_I_ChargeJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (imp.getC_Charge_ID() != 0) {
                        isNew = false;
                        charge = new MCharge(this.getCtx(), imp.getC_Charge_ID(), this.get_TrxName());
                    } else if (preName.equals(imp.getName())) {
                        isNew = false;
                    } else {
                        preName = imp.getName();
                    }
                    if (isNew) {
                        charge = new MCharge(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewCharge(imp, charge)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else if (this.updateCharge(imp, charge)) {
                        ++successUpdateNum;
                    } else {
                        ++failureUpdateNum;
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(records) + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    public String getImportTableName() {
        return "I_WarehouseJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private void reverseLookupC_Charge_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Charge_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Charge_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Name");
        sql = new StringBuilder("UPDATE I_ChargeJP i ").append("SET C_Charge_ID=(SELECT C_Charge_ID FROM C_Charge p").append(" WHERE i.Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_Charge_ID IS NULL AND i.Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + e.toString() + sql);
        }
    }

    private void reverseLookupAD_Org_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_ChargeJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_ChargeJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_ChargeType_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_ChargeType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_ChargeType_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ChargeType_Value");
        sql = new StringBuilder("UPDATE I_ChargeJP i ").append("SET C_ChargeType_ID=(SELECT C_ChargeType_ID FROM C_ChargeType p").append(" WHERE i.JP_ChargeType_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_ChargeType_ID IS NULL AND i.JP_ChargeType_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ChargeType_Value");
        sql = new StringBuilder("UPDATE I_ChargeJP ").append("SET I_ErrorMsg='" + msg + "'").append("WHERE C_ChargeType_ID IS NULL AND JP_ChargeType_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + no);
        }
    }

    private void reverseLookupC_TaxCategory_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_TaxCategory_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_TaxCategory_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxCategory_Name");
        sql = new StringBuilder("UPDATE I_ChargeJP i ").append("SET C_TaxCategory_ID=(SELECT C_TaxCategory_ID FROM C_TaxCategory p").append(" WHERE i.JP_TaxCategory_Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_TaxCategory_ID IS NULL AND i.JP_TaxCategory_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_TaxCategory_Name");
        sql = new StringBuilder("UPDATE I_ChargeJP ").append("SET I_ErrorMsg='" + msg + "'").append("WHERE C_TaxCategory_ID IS NULL AND JP_TaxCategory_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + no);
        }
    }

    private void reverseLookupC_BPartner_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Value");
        sql = new StringBuilder("UPDATE I_ChargeJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.JP_BPartner_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_BPartner_ID IS NULL AND i.JP_BPartner_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Value");
        sql = new StringBuilder("UPDATE I_ChargeJP ").append("SET I_ErrorMsg='" + msg + "'").append("WHERE C_BPartner_ID IS NULL AND JP_BPartner_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + no);
        }
    }

    private void reverseLookupC_AcctSchema_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_ChargeJP i ").append("SET C_AcctSchema_ID=(SELECT C_AcctSchema_ID FROM C_AcctSchema p").append(" WHERE i.JP_AcctSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_ChargeJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void setChargeAcct(MCharge charge, X_I_ChargeJP impCharge) {
        block10: {
            int C_ValidCombination_ID = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), impCharge.getC_AcctSchema_ID(), impCharge.getJP_Ch_Expense_Acct_Value(), this.get_TrxName());
            if (C_ValidCombination_ID == -1) {
                return;
            }
            impCharge.setCh_Expense_Acct(C_ValidCombination_ID);
            String WhereClause = " C_AcctSchema_ID=" + impCharge.getC_AcctSchema_ID() + " AND C_Charge_ID=" + charge.getC_Charge_ID() + " AND AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx());
            StringBuilder sql = new StringBuilder("SELECT * FROM C_Charge_Acct WHERE " + WhereClause);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        X_C_Charge_Acct acct = new X_C_Charge_Acct(this.getCtx(), rs, this.get_TrxName());
                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impCharge, (PO)acct, 30);
                        if (acct.getCh_Expense_Acct() != C_ValidCombination_ID) {
                            acct.setCh_Expense_Acct(C_ValidCombination_ID);
                            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"Ch_Expense_Acct");
                            if (Util.isEmpty((String)impCharge.getI_ErrorMsg())) {
                                impCharge.setI_ErrorMsg(msg);
                            } else {
                                impCharge.setI_ErrorMsg(String.valueOf(impCharge.getI_ErrorMsg()) + " / " + msg);
                            }
                        }
                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impCharge, (PO)acct, 40);
                        acct.saveEx(this.get_TrxName());
                        this.commitEx();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private boolean createNewCharge(X_I_ChargeJP impCharge, MCharge newCharge) {
        if (impCharge.getAD_Org_ID() < 0) {
            impCharge.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value"));
            impCharge.setI_IsImported(false);
            impCharge.setProcessed(false);
            impCharge.saveEx(this.get_TrxName());
            return false;
        }
        if (Util.isEmpty((String)impCharge.getName())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            impCharge.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impCharge.setI_IsImported(false);
            impCharge.setProcessed(false);
            impCharge.saveEx(this.get_TrxName());
            return false;
        }
        if (impCharge.getC_TaxCategory_ID() == 0) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_TaxCategory_ID")};
            impCharge.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impCharge.setI_IsImported(false);
            impCharge.setProcessed(false);
            impCharge.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impCharge, (PO)newCharge, 30);
        newCharge.setAD_Org_ID(impCharge.getAD_Org_ID());
        newCharge.setName(impCharge.getName());
        if (!Util.isEmpty((String)impCharge.getDescription())) {
            newCharge.setDescription(impCharge.getDescription());
        }
        newCharge.setIsSameTax(impCharge.isSameTax());
        newCharge.setIsTaxIncluded(impCharge.isTaxIncluded());
        if (impCharge.getC_ChargeType_ID() > 0) {
            newCharge.setC_ChargeType_ID(impCharge.getC_ChargeType_ID());
        }
        if (impCharge.getC_TaxCategory_ID() > 0) {
            newCharge.setC_TaxCategory_ID(impCharge.getC_TaxCategory_ID());
        }
        if (impCharge.getC_BPartner_ID() > 0) {
            newCharge.setC_BPartner_ID(impCharge.getC_BPartner_ID());
        }
        if (impCharge.getChargeAmt() != null) {
            newCharge.setChargeAmt(impCharge.getChargeAmt());
        }
        newCharge.setIsActive(impCharge.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impCharge, (PO)newCharge, 40);
        try {
            newCharge.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            impCharge.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_Charge_ID") + " : " + e.toString());
            impCharge.setI_IsImported(false);
            impCharge.setProcessed(false);
            impCharge.saveEx(this.get_TrxName());
            return false;
        }
        impCharge.setC_Charge_ID(newCharge.getC_Charge_ID());
        if (!Util.isEmpty((String)impCharge.getJP_Ch_Expense_Acct_Value()) && impCharge.getC_AcctSchema_ID() > 0) {
            this.setChargeAcct(newCharge, impCharge);
        }
        if (Util.isEmpty((String)impCharge.getI_ErrorMsg())) {
            impCharge.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
        } else {
            impCharge.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord")) + " / " + impCharge.getI_ErrorMsg());
        }
        impCharge.setI_IsImported(true);
        impCharge.setProcessed(true);
        impCharge.saveEx(this.get_TrxName());
        return true;
    }

    private boolean updateCharge(X_I_ChargeJP impCharge, MCharge updateCharge) {
        if (Util.isEmpty((String)impCharge.getName())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            impCharge.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impCharge.setI_IsImported(false);
            impCharge.setProcessed(false);
            impCharge.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impCharge, (PO)updateCharge, 30);
        if (!Util.isEmpty((String)impCharge.getDescription())) {
            updateCharge.setDescription(impCharge.getDescription());
        }
        updateCharge.setIsSameTax(impCharge.isSameTax());
        updateCharge.setIsTaxIncluded(impCharge.isTaxIncluded());
        if (impCharge.getC_ChargeType_ID() > 0) {
            updateCharge.setC_ChargeType_ID(impCharge.getC_ChargeType_ID());
        }
        if (impCharge.getC_TaxCategory_ID() > 0) {
            updateCharge.setC_TaxCategory_ID(impCharge.getC_TaxCategory_ID());
        }
        if (impCharge.getC_BPartner_ID() > 0) {
            updateCharge.setC_BPartner_ID(impCharge.getC_BPartner_ID());
        }
        if (impCharge.getChargeAmt() != null) {
            updateCharge.setChargeAmt(impCharge.getChargeAmt());
        }
        updateCharge.setIsActive(impCharge.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impCharge, (PO)updateCharge, 40);
        try {
            updateCharge.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            impCharge.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"C_Charge_ID") + " :  " + e.toString());
            impCharge.setI_IsImported(false);
            impCharge.setProcessed(false);
            impCharge.saveEx(this.get_TrxName());
            return false;
        }
        if (!Util.isEmpty((String)impCharge.getJP_Ch_Expense_Acct_Value()) && impCharge.getC_AcctSchema_ID() > 0) {
            this.setChargeAcct(updateCharge, impCharge);
        }
        if (Util.isEmpty((String)impCharge.getI_ErrorMsg())) {
            impCharge.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        } else {
            impCharge.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + " / " + impCharge.getI_ErrorMsg());
        }
        impCharge.setI_IsImported(true);
        impCharge.setProcessed(true);
        impCharge.saveEx(this.get_TrxName());
        return true;
    }
}

