/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankData;
import jpiere.base.plugin.org.adempiere.model.MBankDataLine;
import jpiere.base.plugin.org.adempiere.model.X_I_BankDataJP;
import jpiere.base.plugin.org.adempiere.model.X_JP_BankData;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MColumn;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportBankData
extends SvrProcess
implements ImportProcess {
    private int p_AD_Client_ID = 0;
    private int p_JP_BankDataSchema_ID = 0;
    private int p_JP_Year = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private IProcessUI processMonitor = null;
    private String message = null;
    private String p_JP_ImportSalesRepIdentifier = null;
    private ArrayList<MBankData> list_BankData = new ArrayList();

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("JP_BankDataSchema_ID")) {
                this.p_JP_BankDataSchema_ID = para[i].getParameterAsInt();
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("JP_Year")) {
                this.p_JP_Year = para[i].getParameterAsInt();
            } else if (name.equals("JP_ImportSalesRepIdentifier")) {
                this.p_JP_ImportSalesRepIdentifier = para[i].getParameterAsString();
            } else if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.p_JP_Year <= 1970) {
            LocalDateTime now = LocalDateTime.now();
            this.p_JP_Year = now.getYear();
        }
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_BankDataJP ").append("WHERE I_IsImported='Y' ").append(this.getWhereClause());
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_BankDataJP ").append(" SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y' ").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_OrgTrx_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_OrgTrx_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Bank_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Bank_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BankAccount_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BankAccount_ID()) {
            return this.message;
        }
        this.commitEx();
        if (this.p_JP_ImportSalesRepIdentifier != null) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"SalesRep_ID");
            if (this.processMonitor != null) {
                this.processMonitor.statusUpdate(this.message);
            }
            if (this.reverseLookupSalesRep_ID()) {
                this.commitEx();
            } else {
                return this.message;
            }
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Checking")) + " : " + Msg.getMsg((Properties)this.getCtx(), (String)"Date");
        if (!this.checkMonthDateString()) {
            return this.message;
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"StatementDate");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.setStatementDate()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DateAcct");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.setDateAcct()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Checking")) + " : " + Msg.getMsg((Properties)this.getCtx(), (String)"Date");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.checkDate()) {
            return this.message;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"CreateNew")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BankData_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        sql = new StringBuilder("SELECT * FROM I_BankDataJP ").append("WHERE I_IsImported='N'").append(this.getWhereClause()).append(" ORDER BY C_BankAccount_ID, AD_Org_ID, StatementDate, DateAcct, JP_BankData_ReferenceNo");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int skipNum = 0;
        int errorNum = 0;
        int successNum = 0;
        int successCreateDocHeader = 0;
        int successCreateDocLine = 0;
        int failureCreateDocHeader = 0;
        int failureCreateDocLine = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String skipRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfSkipRecords");
        String errorRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfUnexpectedErrorRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String createHeader = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateHeader");
        String createLine = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateLine");
        String detail = Msg.getMsg((Properties)this.getCtx(), (String)"JP_DetailLog");
        boolean isError = false;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                int lastC_BankAccount_ID = 0;
                int lastAD_Org_ID = 0;
                Timestamp lastStatementDate = null;
                Timestamp lastDateAcct = null;
                X_JP_BankData m_BankData = null;
                MBankDataLine m_line = null;
                X_I_BankDataJP imp = null;
                int lineNo = 0;
                boolean isCreateHeader = true;
                while (rs.next()) {
                    ++recordsNum;
                    imp = new X_I_BankDataJP(this.getCtx(), rs, this.get_TrxName());
                    if (imp.getJP_BankData_ID() > 0) {
                        ++skipNum;
                        String msg = Msg.getMsg((Properties)this.getCtx(), (String)"AlreadyExists");
                        imp.setI_ErrorMsg(msg);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        continue;
                    }
                    isCreateHeader = true;
                    if (lastC_BankAccount_ID != imp.getC_BankAccount_ID() || lastAD_Org_ID != imp.getAD_Org_ID() || lastStatementDate.compareTo(imp.getStatementDate()) != 0 || lastDateAcct.compareTo(imp.getDateAcct()) != 0) {
                        lastC_BankAccount_ID = imp.getC_BankAccount_ID();
                        lastAD_Org_ID = imp.getAD_Org_ID();
                        lastStatementDate = imp.getStatementDate();
                        lastDateAcct = imp.getDateAcct();
                    } else {
                        isCreateHeader = false;
                    }
                    if (isCreateHeader) {
                        m_BankData = new MBankData(this.getCtx(), 0, this.get_TrxName());
                        lineNo = 0;
                        if (!this.createBankData(imp, (MBankData)m_BankData)) {
                            this.rollback();
                            m_BankData = null;
                            ++failureCreateDocHeader;
                            ++errorNum;
                            imp.setI_ErrorMsg(this.message);
                            imp.setI_IsImported(false);
                            imp.setProcessed(false);
                            imp.saveEx(this.get_TrxName());
                            this.commitEx();
                            isError = true;
                            break;
                        }
                        ++successCreateDocHeader;
                    }
                    if (m_BankData == null) {
                        this.rollback();
                        ++errorNum;
                        this.message = Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                        imp.setI_ErrorMsg(this.message);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        isError = true;
                        break;
                    }
                    imp.setJP_BankData_ID(m_BankData.getJP_BankData_ID());
                    m_line = new MBankDataLine(this.getCtx(), 0, this.get_TrxName());
                    if (!this.addBankDataLine(imp, (MBankData)m_BankData, m_line, lineNo += 10)) {
                        this.rollback();
                        m_BankData = null;
                        ++failureCreateDocLine;
                        ++errorNum;
                        imp.setJP_BankData_ID(0);
                        imp.setI_ErrorMsg(this.message);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        isError = true;
                        break;
                    }
                    ++successCreateDocLine;
                    ++successNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (isError) {
            throw new Exception(this.message);
        }
        for (MBankData m_BankData : this.list_BankData) {
            this.addBufferLog(0, null, null, m_BankData.getName(), MBankData.Table_ID, m_BankData.getJP_BankData_ID());
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"OK");
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
        return msgreturn.toString();
    }

    public String getImportTableName() {
        return "I_BankDataJP";
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET AD_Org_ID=(SELECT CASE WHEN MAX(p.AD_Org_ID) > 0 THEN MAX(p.AD_Org_ID) ELSE 0 END  FROM AD_Org p").append(" WHERE (i.JP_Org_Value=p.Value OR p.Value = '0') AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        sql = new StringBuilder("UPDATE I_BankDataJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAD_OrgTrx_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET AD_OrgTrx_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_OrgTrx_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_OrgTrx_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_OrgTrx_Value");
        sql = new StringBuilder("UPDATE I_BankDataJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_OrgTrx_ID IS NULL AND JP_OrgTrx_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Bank_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET C_Bank_ID=(SELECT C_Bank_ID FROM C_Bank p").append(" WHERE i.RoutingNo=p.RoutingNo AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.RoutingNo IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET C_Bank_ID=(SELECT C_Bank_ID FROM C_Bank p").append(" WHERE i.JP_Bank_Name=p.Name AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.JP_Bank_Name IS NOT NULL").append(" AND i.I_IsImported='N' AND C_Bank_ID is null ").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET C_Bank_ID=(SELECT C_Bank_ID FROM C_Bank p").append(" WHERE i.JP_BankName_Kana=p.JP_BankName_Kana AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.JP_BankName_Kana IS NOT NULL").append(" AND i.I_IsImported='N' AND C_Bank_ID is null ").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"C_Bank_ID");
        sql = new StringBuilder("UPDATE I_BankDataJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_Bank_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_BankAccount_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount p").append(" WHERE i.C_Bank_ID=p.C_Bank_ID AND (i.JP_BranchCode=p.JP_BranchCode OR i.JP_BranchName=p.JP_BranchName OR i.JP_BranchName_Kana=p.JP_BranchName_Kana) ").append(" AND i.AccountNo = p.AccountNo  AND i.BankAccountType = p.BankAccountType ").append(" AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.C_BankAccount_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount p").append(" WHERE i.C_Bank_ID=p.C_Bank_ID AND (i.JP_BranchCode=p.JP_BranchCode OR i.JP_BranchName=p.JP_BranchName OR i.JP_BranchName_Kana=p.JP_BranchName_Kana) ").append(" AND i.AccountNo = p.AccountNo ").append(" AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.C_BankAccount_ID IS NULL and i.BankAccountType IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount p").append(" WHERE  i.C_Bank_ID=p.C_Bank_ID AND i.JP_BankAccount_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.C_BankAccount_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM C_BankAccount p").append(" WHERE i.C_BankAccount_ID=p.C_BankAccount_ID ) ").append(" WHERE i.C_BankAccount_ID IS NOT NULL AND i.JP_Org_Value IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"C_BankAccount_ID");
        sql = new StringBuilder("UPDATE I_BankDataJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_BankAccount_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupSalesRep_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportSalesRepIdentifier) || this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        if (this.p_JP_ImportSalesRepIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_EMail IS NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name  AND i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL AND i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_BankDataJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND i.JP_SalesRep_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL AND i.JP_SalesRep_EMail IS NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkMonthDateString() {
        StringBuilder sql = new StringBuilder("SELECT * FROM I_BankDataJP ").append("WHERE I_IsImported='N'").append(this.getWhereClause());
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        X_I_BankDataJP m_BankDataJP = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            rs = pstmt.executeQuery();
            while (true) {
                if (!rs.next()) {
                    return true;
                }
                m_BankDataJP = new X_I_BankDataJP(this.getCtx(), rs, this.get_TrxName());
                if (m_BankDataJP.getStatementDate() == null) {
                    if (!this.checkMonthString(m_BankDataJP.getJP_Month())) {
                        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Month");
                        m_BankDataJP.setI_ErrorMsg(this.message);
                        m_BankDataJP.saveEx(this.get_TrxName());
                        return false;
                    }
                    if (!this.checkDateString(m_BankDataJP.getJP_Date())) {
                        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Date");
                        m_BankDataJP.setI_ErrorMsg(this.message);
                        m_BankDataJP.saveEx(this.get_TrxName());
                        return false;
                    }
                }
                if (m_BankDataJP.getDateAcct() != null) continue;
                if (!this.checkMonthString(m_BankDataJP.getJP_AcctMonth())) {
                    this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctMonth");
                    m_BankDataJP.setI_ErrorMsg(this.message);
                    m_BankDataJP.saveEx(this.get_TrxName());
                    return false;
                }
                if (!this.checkDateString(m_BankDataJP.getJP_AcctDate())) break;
            }
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctDate");
            m_BankDataJP.setI_ErrorMsg(this.message);
            m_BankDataJP.saveEx(this.get_TrxName());
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean checkMonthString(String month) {
        if (Util.isEmpty((String)month)) {
            return true;
        }
        if (month.length() > 2) {
            return false;
        }
        int i_month = 0;
        try {
            i_month = Integer.parseInt(month);
        }
        catch (Exception e) {
            return false;
        }
        if (i_month > 12) {
            return false;
        }
        return i_month >= 1;
    }

    private boolean checkDateString(String date) {
        if (Util.isEmpty((String)date)) {
            return true;
        }
        if (date.length() > 2) {
            return false;
        }
        int i_date = 0;
        try {
            i_date = Integer.parseInt(date);
        }
        catch (Exception e) {
            return false;
        }
        if (i_date > 31) {
            return false;
        }
        return i_date >= 1;
    }

    private boolean checkDate() throws Exception {
        int no = 0;
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory") + Msg.getElement((Properties)this.getCtx(), (String)"StatementDate") + " OR " + Msg.getElement((Properties)this.getCtx(), (String)"DateAcct");
        StringBuilder sql = new StringBuilder("UPDATE I_BankDataJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE StatementDate IS NULL AND  DateAcct IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean setStatementDate() throws Exception {
        int no = 0;
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"CreateNew")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BankData_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        StringBuilder sql = new StringBuilder("UPDATE I_BankDataJP ").append("SET StatementDate= TO_DATE('" + this.p_JP_Year + "'|| '/' || JP_Month || '/'  || JP_Date,'YYYY/MM/DD') ").append(" WHERE JP_Month IS NOT NULL AND JP_Date IS NOT NULL ").append(" AND I_IsImported='N' AND StatementDate IS NULL ").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean setDateAcct() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BankDataJP ").append("SET DateAcct= TO_DATE('" + this.p_JP_Year + "'|| '/' || JP_AcctMonth || '/'  || JP_AcctDate,'YYYY/MM/DD') ").append(" WHERE JP_AcctMonth IS NOT NULL AND JP_AcctDate IS NOT NULL ").append(" AND I_IsImported='N' AND DateAcct IS NULL ").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean createBankData(X_I_BankDataJP imp, MBankData m_BankData) {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)m_BankData, 30);
        PO.copyValues((PO)imp, (PO)m_BankData);
        m_BankData.setJP_BankData_ID(0);
        m_BankData.setJP_BankDataSchema_ID(this.p_JP_BankDataSchema_ID);
        m_BankData.setAD_Org_ID(imp.getAD_Org_ID());
        if (imp.getStatementDate() == null && imp.getDateAcct() == null) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory") + Msg.getElement((Properties)this.getCtx(), (String)"StatementDate") + " OR " + Msg.getElement((Properties)this.getCtx(), (String)"DateAcct");
        } else if (imp.getStatementDate() == null) {
            m_BankData.setStatementDate(imp.getDateAcct());
            m_BankData.setDateAcct(imp.getDateAcct());
        } else if (imp.getDateAcct() == null) {
            m_BankData.setStatementDate(imp.getStatementDate());
            m_BankData.setDateAcct(imp.getStatementDate());
        } else {
            m_BankData.setStatementDate(imp.getStatementDate());
            m_BankData.setDateAcct(imp.getDateAcct());
        }
        String name = LocalDateTime.now().toString();
        m_BankData.setName(name);
        m_BankData.setJP_Processing1("Y");
        m_BankData.setJP_ProcessedTime1(Timestamp.valueOf(LocalDateTime.now()));
        if (!Util.isEmpty((String)imp.getJP_BankAccountType()) && imp.getJP_BankAccountType().length() != 1) {
            m_BankData.setJP_BankAccountType(null);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)m_BankData, 40);
        try {
            m_BankData.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_BankData_ID") + " : " + e.toString();
            return false;
        }
        this.list_BankData.add(m_BankData);
        return true;
    }

    private boolean addBankDataLine(X_I_BankDataJP imp, MBankData m_BankData, MBankDataLine m_line, int lineNo) {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)m_line, 30);
        PO.copyValues((PO)imp, (PO)m_line);
        m_line.setJP_BankData_ID(m_BankData.getJP_BankData_ID());
        m_line.setAD_Org_ID(m_BankData.getAD_Org_ID());
        m_line.setLine(lineNo);
        m_line.setStatementLineDate(m_BankData.getStatementDate());
        m_line.setDateAcct(m_BankData.getDateAcct());
        m_line.setValutaDate(m_BankData.getDateAcct());
        m_line.setJP_BankName_Kana(imp.getJP_BankName_Kana_Line());
        m_line.setJP_BranchName_Kana(imp.getJP_BranchName_Kana_Line());
        if (!Util.isEmpty((String)imp.getJP_BankAccountType()) && imp.getJP_BankAccountType().length() != 1) {
            m_line.setJP_BankAccountType(null);
        }
        MColumn m_colmun = MColumn.get((Properties)this.getCtx(), (String)"JP_BankDataLine", (String)"JP_A_Name_Kana");
        int columnLength = m_colmun.getFieldLength();
        String a_Name_Lana = imp.getJP_A_Name_Kana();
        if (!Util.isEmpty((String)a_Name_Lana) && a_Name_Lana.length() > columnLength) {
            m_line.setJP_A_Name_Kana(a_Name_Lana.substring(0, columnLength));
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)m_line, 40);
        try {
            m_line.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_OrderLine_ID") + " : " + e.toString();
            return false;
        }
        imp.setJP_BankDataLine_ID(m_line.getJP_BankDataLine_ID());
        imp.setI_IsImported(true);
        imp.setProcessed(true);
        imp.saveEx(this.get_TrxName());
        return true;
    }
}

