/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_BankAccountJP;
import jpiere.base.plugin.util.JPiereValidCombinationUtil;
import jpiere.base.plugin.util.ZenginCheck;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBankAccount;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_C_BankAccount_Acct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportBankAccount
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private IProcessUI processMonitor = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    public String getImportTableName() {
        return "I_BankAccountJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.getAD_Client_ID());
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_BankAccountJP ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            try {
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        this.commitEx();
        sql = new StringBuilder("UPDATE I_BankAccountJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.reverseLookupAD_Org_ID();
        this.reverseLookupC_Bank_ID();
        this.reverseLookupC_BankAccount_ID();
        this.reverseLookupC_Currency_ID();
        this.reverseLookupC_AcctSchema_ID();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_BankAccountJP WHERE I_IsImported='N'").append((CharSequence)clientCheck);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_I_BankAccountJP imp = new X_I_BankAccountJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (imp.getC_BankAccount_ID() != 0) {
                        isNew = false;
                    }
                    if (isNew) {
                        MBankAccount newBankAccount = new MBankAccount(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewBankAccount(imp, newBankAccount)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else {
                        MBankAccount updateBankAccount = new MBankAccount(this.getCtx(), imp.getC_BankAccount_ID(), this.get_TrxName());
                        if (this.updateBankAccount(imp, updateBankAccount)) {
                            ++successUpdateNum;
                        } else {
                            ++failureUpdateNum;
                        }
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(records) + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    private void setBankAccountAcct(MBankAccount pc, X_I_BankAccountJP imp) {
        int B_InterestRev_Acct;
        int B_InterestExp_Acct;
        int B_UnallocatedCash_Acct;
        int B_PaymentSelect_Acct;
        int B_InTransit_Acct;
        String msg;
        int B_Asset_Acct;
        X_C_BankAccount_Acct acct;
        block31: {
            acct = null;
            String WhereClause = " C_AcctSchema_ID=" + imp.getC_AcctSchema_ID() + " AND C_BankAccount_ID=" + pc.getC_BankAccount_ID() + " AND AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx());
            StringBuilder sql = new StringBuilder("SELECT * FROM C_BankAccount_Acct WHERE " + WhereClause);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        acct = new X_C_BankAccount_Acct(this.getCtx(), rs, this.get_TrxName());
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block31;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (acct == null) {
            return;
        }
        if (!Util.isEmpty((String)imp.getJP_B_Asset_Acct_Value()) && (B_Asset_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_B_Asset_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setB_Asset_Acct(B_Asset_Acct);
            if (acct.getB_Asset_Acct() != B_Asset_Acct) {
                acct.setB_Asset_Acct(B_Asset_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"B_Asset_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_InTransit_Acct_Value()) && (B_InTransit_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_InTransit_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setB_InTransit_Acct(B_InTransit_Acct);
            if (acct.getB_InTransit_Acct() != B_InTransit_Acct) {
                acct.setB_InTransit_Acct(B_InTransit_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"B_InTransit_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_PaymentSelect_Value()) && (B_PaymentSelect_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_PaymentSelect_Value(), this.get_TrxName())) > 0) {
            imp.setB_PaymentSelect_Acct(B_PaymentSelect_Acct);
            if (acct.getB_PaymentSelect_Acct() != B_PaymentSelect_Acct) {
                acct.setB_PaymentSelect_Acct(B_PaymentSelect_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"B_PaymentSelect_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_UnallocatedCash_Value()) && (B_UnallocatedCash_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_UnallocatedCash_Value(), this.get_TrxName())) > 0) {
            imp.setB_UnallocatedCash_Acct(B_UnallocatedCash_Acct);
            if (acct.getB_UnallocatedCash_Acct() != B_UnallocatedCash_Acct) {
                acct.setB_UnallocatedCash_Acct(B_UnallocatedCash_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"B_UnallocatedCash_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_InterestExp_Acct_Value()) && (B_InterestExp_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_InterestExp_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setB_InterestExp_Acct(B_InterestExp_Acct);
            if (acct.getB_InterestExp_Acct() != B_InterestExp_Acct) {
                acct.setB_InterestExp_Acct(B_InterestExp_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"B_InterestExp_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_InterestRev_Acct_Value()) && (B_InterestRev_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_InterestRev_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setB_InterestRev_Acct(B_InterestRev_Acct);
            if (acct.getB_InterestRev_Acct() != B_InterestRev_Acct) {
                acct.setB_InterestRev_Acct(B_InterestRev_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"B_InterestRev_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        acct.saveEx(this.get_TrxName());
    }

    private void reverseLookupAD_Org_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_BankAccountJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) )").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_BankAccountJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_Bank_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Bank_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Bank_Name");
        sql = new StringBuilder("UPDATE I_BankAccountJP i ").append("SET C_Bank_ID=(SELECT C_Bank_ID FROM C_Bank p").append(" WHERE i.JP_Bank_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_Bank_ID IS NULL AND i.JP_Bank_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Bank_Name");
        sql = new StringBuilder("UPDATE I_BankAccountJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE C_Bank_ID IS NULL AND JP_Bank_Name IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_BankAccount_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BankAccount_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BranchCode") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AccountNo") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"BankAccountType");
        sql = new StringBuilder("UPDATE I_BankAccountJP i ").append("SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount p").append(" WHERE i.JP_BranchCode=p.JP_BranchCode AND i.AccountNo=p.AccountNo AND i.C_Bank_ID = p.C_Bank_ID AND i.BankAccountType = p.BankAccountType) ").append(" WHERE i.AccountNo IS NOT NULL AND i.JP_BranchCode IS NOT NULL  AND i.BankAccountType IS NOT NULL AND i.C_BankAccount_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + e.toString() + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BankAccount_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BranchCode") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AccountNo");
        sql = new StringBuilder("UPDATE I_BankAccountJP i ").append("SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount p").append(" WHERE i.JP_BranchCode=p.JP_BranchCode AND i.AccountNo=p.AccountNo AND i.C_Bank_ID = p.C_Bank_ID) ").append(" WHERE i.AccountNo IS NOT NULL AND i.JP_BranchCode IS NOT NULL  AND i.BankAccountType IS NULL AND i.C_BankAccount_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + e.toString() + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BankAccount_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Value");
        sql = new StringBuilder("UPDATE I_BankAccountJP i ").append("SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount p").append(" WHERE i.Value=p.Value AND i.Name=p.Name AND i.AD_Client_ID=p.AD_Client_ID AND i.C_Bank_ID = p.C_Bank_ID) ").append(" WHERE i.Value IS NOT NULL AND i.C_BankAccount_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + e.toString() + " : " + sql);
        }
    }

    private void reverseLookupC_Currency_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Currency_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"ISO_Code");
        sql = new StringBuilder("UPDATE I_BankAccountJP i ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency p").append(" WHERE i.ISO_Code=p.ISO_Code AND (p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0) ) ").append(" WHERE i.C_Currency_ID IS NULL AND ISO_Code IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + e.toString() + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"ISO_Code");
        sql = new StringBuilder("UPDATE I_BankAccountJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE C_Currency_ID IS NULL AND ISO_Code IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + e.toString() + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_AcctSchema_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_BankAccountJP i ").append("SET C_AcctSchema_ID=(SELECT C_AcctSchema_ID FROM C_AcctSchema p").append(" WHERE i.JP_AcctSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_BankAccountJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private boolean createNewBankAccount(X_I_BankAccountJP importBankAccount, MBankAccount newBankAccount) {
        Object[] objs;
        Object[] objs2;
        int i;
        boolean isOK;
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBankAccount, (PO)newBankAccount, 30);
        if (importBankAccount.getAD_Org_ID() <= 0) {
            importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " AD_Org_ID = 0");
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        newBankAccount.setAD_Org_ID(importBankAccount.getAD_Org_ID());
        if (importBankAccount.getC_Bank_ID() <= 0) {
            importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " C_Bank_ID = 0");
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        newBankAccount.setC_Bank_ID(importBankAccount.getC_Bank_ID());
        if (Util.isEmpty((String)importBankAccount.getValue())) {
            Object[] objs3 = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
            importBankAccount.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs3));
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        newBankAccount.setValue(importBankAccount.getValue());
        if (Util.isEmpty((String)importBankAccount.getName())) {
            Object[] objs4 = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            importBankAccount.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs4));
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        newBankAccount.setName(importBankAccount.getName());
        if (!Util.isEmpty((String)importBankAccount.getDescription())) {
            newBankAccount.setDescription(importBankAccount.getDescription());
        }
        newBankAccount.setIsDefault(importBankAccount.isDefault());
        if (!Util.isEmpty((String)importBankAccount.getJP_BranchCode())) {
            String jp_BranchCode = importBankAccount.getJP_BranchCode();
            if (jp_BranchCode.length() != 3) {
                Object[] objs5 = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BranchCode"), 3};
                importBankAccount.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Characters", (Object[])objs5));
                importBankAccount.setI_IsImported(false);
                importBankAccount.setProcessed(false);
                return false;
            }
            if (!ZenginCheck.numStringCheck(jp_BranchCode)) {
                Object[] objs6 = new Object[]{jp_BranchCode};
                importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_BranchCode")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseString", (Object[])objs6));
                importBankAccount.setI_IsImported(false);
                importBankAccount.setProcessed(false);
                importBankAccount.saveEx(this.get_TrxName());
                return false;
            }
            newBankAccount.set_ValueNoCheck("JP_BranchCode", (Object)importBankAccount.getJP_BranchCode());
        }
        if (!Util.isEmpty((String)importBankAccount.getJP_BranchName_Kana())) {
            String jp_BranchName_Kana = importBankAccount.getJP_BranchName_Kana();
            isOK = true;
            i = 0;
            while (i < jp_BranchName_Kana.length()) {
                if (!ZenginCheck.charCheck(jp_BranchName_Kana.charAt(i))) {
                    objs2 = new Object[]{Character.valueOf(jp_BranchName_Kana.charAt(i))};
                    importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_BranchName_Kana")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseChar", (Object[])objs2));
                    importBankAccount.setI_IsImported(false);
                    importBankAccount.setProcessed(false);
                    importBankAccount.saveEx(this.get_TrxName());
                    isOK = false;
                    break;
                }
                ++i;
            }
            if (!isOK) {
                return false;
            }
            if (jp_BranchName_Kana.length() > 15) {
                Object[] objs7 = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BankName_Kana"), 15};
                importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_BranchName_Kana")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_LessThanChars", (Object[])objs7));
                importBankAccount.setI_IsImported(false);
                importBankAccount.setProcessed(false);
                return false;
            }
            newBankAccount.set_ValueNoCheck("JP_BranchName_Kana", (Object)importBankAccount.getJP_BranchName_Kana());
        }
        if (Util.isEmpty((String)importBankAccount.getAccountNo())) {
            importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " Account No is Empty");
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        newBankAccount.setAccountNo(importBankAccount.getAccountNo());
        if (!Util.isEmpty((String)importBankAccount.getJP_RequesterCode())) {
            String jp_RequesterCode = importBankAccount.getJP_RequesterCode();
            if (jp_RequesterCode.length() != 10) {
                Object[] objs8 = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_RequesterCode"), 10};
                importBankAccount.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Characters", (Object[])objs8));
                importBankAccount.setI_IsImported(false);
                importBankAccount.setProcessed(false);
                return false;
            }
            if (!ZenginCheck.numStringCheck(jp_RequesterCode)) {
                Object[] objs9 = new Object[]{jp_RequesterCode};
                importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_RequesterCode")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseString", (Object[])objs9));
                importBankAccount.setI_IsImported(false);
                importBankAccount.setProcessed(false);
                importBankAccount.saveEx(this.get_TrxName());
                return false;
            }
            newBankAccount.set_ValueNoCheck("JP_RequesterCode", (Object)importBankAccount.getJP_RequesterCode());
        }
        if (!Util.isEmpty((String)importBankAccount.getJP_RequesterName())) {
            String jp_RequesterName = importBankAccount.getJP_RequesterName();
            isOK = true;
            i = 0;
            while (i < jp_RequesterName.length()) {
                if (!ZenginCheck.charCheck(jp_RequesterName.charAt(i))) {
                    objs2 = new Object[]{Character.valueOf(jp_RequesterName.charAt(i))};
                    importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_RequesterName")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseChar", (Object[])objs2));
                    importBankAccount.setI_IsImported(false);
                    importBankAccount.setProcessed(false);
                    importBankAccount.saveEx(this.get_TrxName());
                    isOK = false;
                    break;
                }
                ++i;
            }
            if (!isOK) {
                return false;
            }
            if (jp_RequesterName.length() > 40) {
                Object[] objs10 = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BankName_Kana"), 40};
                importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_RequesterName")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_LessThanChars", (Object[])objs10));
                importBankAccount.setI_IsImported(false);
                importBankAccount.setProcessed(false);
                return false;
            }
            newBankAccount.set_ValueNoCheck("JP_RequesterName", (Object)importBankAccount.getJP_RequesterName());
        }
        if (!Util.isEmpty((String)importBankAccount.getBBAN())) {
            newBankAccount.setBBAN(importBankAccount.getBBAN());
        }
        if (!Util.isEmpty((String)importBankAccount.getIBAN())) {
            newBankAccount.setIBAN(importBankAccount.getIBAN());
        }
        if (importBankAccount.getC_Currency_ID() <= 0) {
            objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID")};
            importBankAccount.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        newBankAccount.setC_Currency_ID(importBankAccount.getC_Currency_ID());
        if (Util.isEmpty((String)importBankAccount.getBankAccountType())) {
            objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"BankAccountType")};
            importBankAccount.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        newBankAccount.setBankAccountType(importBankAccount.getBankAccountType());
        if (importBankAccount.getCreditLimit().compareTo(Env.ZERO) > 0) {
            newBankAccount.setCreditLimit(importBankAccount.getCreditLimit());
        }
        if (importBankAccount.getCurrentBalance().compareTo(Env.ZERO) > 0) {
            newBankAccount.setCurrentBalance(importBankAccount.getCurrentBalance());
        }
        newBankAccount.setIsActive(importBankAccount.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBankAccount, (PO)newBankAccount, 40);
        try {
            newBankAccount.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BankAccount_ID") + " : " + e.toString());
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        importBankAccount.setC_BankAccount_ID(newBankAccount.getC_BankAccount_ID());
        if (!Util.isEmpty((String)importBankAccount.getJP_AcctSchema_Name()) && importBankAccount.getC_AcctSchema_ID() > 0) {
            this.setBankAccountAcct(newBankAccount, importBankAccount);
        }
        if (Util.isEmpty((String)importBankAccount.getI_ErrorMsg())) {
            importBankAccount.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
        } else {
            importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord")) + "  &  " + importBankAccount.getI_ErrorMsg());
        }
        importBankAccount.setI_IsImported(true);
        importBankAccount.setProcessed(true);
        importBankAccount.saveEx(this.get_TrxName());
        return true;
    }

    private boolean updateBankAccount(X_I_BankAccountJP importBankAccount, MBankAccount updateBankAccount) {
        if (importBankAccount.getAD_Org_ID() > 0 && !Util.isEmpty((String)importBankAccount.getName())) {
            updateBankAccount.setName(importBankAccount.getName());
        }
        if (!Util.isEmpty((String)importBankAccount.getDescription())) {
            updateBankAccount.setValue(importBankAccount.getDescription());
        }
        updateBankAccount.setIsDefault(importBankAccount.isDefault());
        if (!Util.isEmpty((String)importBankAccount.getJP_BranchCode())) {
            updateBankAccount.set_ValueNoCheck("JP_BranchCode", (Object)importBankAccount.getJP_BranchCode());
        }
        if (!Util.isEmpty((String)importBankAccount.getJP_BranchName_Kana())) {
            updateBankAccount.set_ValueNoCheck("JP_BranchName_Kana", (Object)importBankAccount.getJP_BranchName_Kana());
        }
        if (!Util.isEmpty((String)importBankAccount.getAccountNo())) {
            updateBankAccount.setAccountNo(importBankAccount.getAccountNo());
        }
        if (!Util.isEmpty((String)importBankAccount.getJP_RequesterCode())) {
            updateBankAccount.set_ValueNoCheck("JP_RequesterCode", (Object)importBankAccount.getJP_RequesterCode());
        }
        if (!Util.isEmpty((String)importBankAccount.getJP_RequesterName())) {
            updateBankAccount.set_ValueNoCheck("JP_RequesterName", (Object)importBankAccount.getJP_RequesterName());
        }
        if (!Util.isEmpty((String)importBankAccount.getBBAN())) {
            updateBankAccount.setBBAN(importBankAccount.getBBAN());
        }
        if (!Util.isEmpty((String)importBankAccount.getIBAN())) {
            updateBankAccount.setIBAN(importBankAccount.getIBAN());
        }
        if (importBankAccount.getC_Currency_ID() > 0) {
            updateBankAccount.setC_Currency_ID(importBankAccount.getC_Currency_ID());
        }
        if (!Util.isEmpty((String)importBankAccount.getBankAccountType())) {
            updateBankAccount.setBankAccountType(importBankAccount.getBankAccountType());
        }
        if (importBankAccount.getCreditLimit().compareTo(Env.ZERO) > 0) {
            updateBankAccount.setCreditLimit(importBankAccount.getCreditLimit());
        }
        if (importBankAccount.getCurrentBalance().compareTo(Env.ZERO) > 0) {
            updateBankAccount.setCurrentBalance(importBankAccount.getCurrentBalance());
        }
        updateBankAccount.setIsActive(importBankAccount.isI_IsActiveJP());
        try {
            updateBankAccount.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BankAccount_ID") + " :  " + e.toString());
            importBankAccount.setI_IsImported(false);
            importBankAccount.setProcessed(false);
            importBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        if (!Util.isEmpty((String)importBankAccount.getJP_AcctSchema_Name()) && importBankAccount.getC_AcctSchema_ID() > 0) {
            this.setBankAccountAcct(updateBankAccount, importBankAccount);
        }
        if (Util.isEmpty((String)importBankAccount.getI_ErrorMsg())) {
            importBankAccount.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        } else {
            importBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + "  &  " + importBankAccount.getI_ErrorMsg());
        }
        importBankAccount.setI_IsImported(true);
        importBankAccount.setProcessed(true);
        importBankAccount.saveEx(this.get_TrxName());
        return true;
    }
}

