/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_BP_GroupJP;
import jpiere.base.plugin.util.JPiereValidCombinationUtil;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBPGroup;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_C_BP_Group_Acct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportBPGroup
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private IProcessUI processMonitor = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        StringBuilder clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.getAD_Client_ID());
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_BP_GroupJP ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
            try {
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.reverseLookupAD_Org_ID();
        this.reverseLookupC_BP_Group_ID();
        this.reverseLookupAD_PrintColor_ID();
        this.reverseLookupM_PriceList_ID();
        this.reverseLookupPO_PriceList_ID();
        this.reverseLookupM_DiscountSchema_ID();
        this.reverseLookupPO_DiscountSchema_ID();
        this.reverseLookupC_Dunning_ID();
        this.reverseLookupC_AcctSchema_ID();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_BP_GroupJP WHERE I_IsImported='N'").append((CharSequence)clientCheck);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_I_BP_GroupJP imp = new X_I_BP_GroupJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (imp.getC_BP_Group_ID() != 0) {
                        isNew = false;
                    }
                    if (isNew) {
                        MBPGroup newBPGroup = new MBPGroup(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewBPGroup(imp, newBPGroup)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else {
                        MBPGroup updateBPGroup = new MBPGroup(this.getCtx(), imp.getC_BP_Group_ID(), this.get_TrxName());
                        if (this.updateBPGroup(imp, updateBPGroup)) {
                            ++successUpdateNum;
                        } else {
                            ++failureUpdateNum;
                        }
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(records) + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    public String getImportTableName() {
        return "I_BP_GroupJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private void setBPGroupAcct(MBPGroup pc, X_I_BP_GroupJP imp) {
        int V_Prepayment_Acct;
        int V_Liability_Acct;
        int C_Prepayment_Acct;
        int C_Receivable_Acct;
        int WriteOff_Acct;
        int PayDiscount_Rev_Acct;
        int PayDiscount_Exp_Acct;
        String msg;
        int NotInvoicedReceipts_Acct;
        X_C_BP_Group_Acct acct;
        block39: {
            acct = null;
            String WhereClause = " C_AcctSchema_ID=" + imp.getC_AcctSchema_ID() + " AND C_BP_Group_ID=" + pc.getC_BP_Group_ID() + " AND AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx());
            StringBuilder sql = new StringBuilder("SELECT * FROM C_BP_Group_Acct WHERE " + WhereClause);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        acct = new X_C_BP_Group_Acct(this.getCtx(), rs, this.get_TrxName());
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block39;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (acct == null) {
            return;
        }
        if (!Util.isEmpty((String)imp.getJP_NotInvoicedReceipts_Value()) && (NotInvoicedReceipts_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_NotInvoicedReceipts_Value(), this.get_TrxName())) > 0) {
            imp.setNotInvoicedReceipts_Acct(NotInvoicedReceipts_Acct);
            if (acct.getNotInvoicedReceipts_Acct() != NotInvoicedReceipts_Acct) {
                acct.setNotInvoicedReceipts_Acct(NotInvoicedReceipts_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"NotInvoicedReceipts_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_PayDiscount_Exp_Value()) && (PayDiscount_Exp_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_PayDiscount_Exp_Value(), this.get_TrxName())) > 0) {
            imp.setPayDiscount_Exp_Acct(PayDiscount_Exp_Acct);
            if (acct.getPayDiscount_Exp_Acct() != PayDiscount_Exp_Acct) {
                acct.setPayDiscount_Exp_Acct(PayDiscount_Exp_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"PayDiscount_Exp_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_PayDiscount_Rev_Value()) && (PayDiscount_Rev_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_PayDiscount_Rev_Value(), this.get_TrxName())) > 0) {
            imp.setPayDiscount_Rev_Acct(PayDiscount_Rev_Acct);
            if (acct.getPayDiscount_Rev_Acct() != PayDiscount_Rev_Acct) {
                acct.setPayDiscount_Rev_Acct(PayDiscount_Rev_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"PayDiscount_Rev_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_WriteOff_Acct_Value()) && (WriteOff_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_WriteOff_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setWriteOff_Acct(WriteOff_Acct);
            if (acct.getWriteOff_Acct() != WriteOff_Acct) {
                acct.setWriteOff_Acct(WriteOff_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"WriteOff_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_Receivable_Acct_Value()) && (C_Receivable_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_Receivable_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setC_Receivable_Acct(C_Receivable_Acct);
            if (acct.getC_Receivable_Acct() != C_Receivable_Acct) {
                acct.setC_Receivable_Acct(C_Receivable_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"C_Receivable_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_C_PrePayment_Acct_Value()) && (C_Prepayment_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_C_PrePayment_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setC_Prepayment_Acct(C_Prepayment_Acct);
            if (acct.getC_Prepayment_Acct() != C_Prepayment_Acct) {
                acct.setC_Prepayment_Acct(C_Prepayment_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"C_Prepayment_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_Liability_Acct_Value()) && (V_Liability_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_Liability_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setV_Liability_Acct(V_Liability_Acct);
            if (acct.getV_Liability_Acct() != V_Liability_Acct) {
                acct.setV_Liability_Acct(V_Liability_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"V_Liability_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_V_Prepayment_Acct_Value()) && (V_Prepayment_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_V_Prepayment_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setV_Prepayment_Acct(V_Prepayment_Acct);
            if (acct.getV_Prepayment_Acct() != V_Prepayment_Acct) {
                acct.setV_Prepayment_Acct(V_Prepayment_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"V_Prepayment_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        acct.saveEx(this.get_TrxName());
    }

    private void reverseLookupAD_Org_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_BP_Group_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BP_Group_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET C_BP_Group_ID=(SELECT C_BP_Group_ID FROM C_BP_Group p").append(" WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_BP_Group_ID IS NULL AND i.Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
    }

    private void reverseLookupAD_PrintColor_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_PrintColor_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_PrintColor_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PrintColor_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET AD_PrintColor_ID=(SELECT AD_PrintColor_ID FROM AD_PrintColor p").append(" WHERE i.JP_PrintColor_Name=p.Name AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.AD_PrintColor_ID IS NULL AND i.JP_PrintColor_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PrintColor_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE AD_PrintColor_ID IS NULL AND JP_PrintColor_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupM_PriceList_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PriceList_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET M_PriceList_ID=(SELECT M_PriceList_ID FROM M_PriceList p").append(" WHERE i.JP_PriceList_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.M_PriceList_ID IS NULL AND i.JP_PriceList_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PriceList_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE JP_PriceList_Name IS NOT NULL AND M_PriceList_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupPO_PriceList_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PO_PriceList_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PO_PriceList_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PO_PriceList_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET PO_PriceList_ID=(SELECT M_PriceList_ID FROM M_PriceList p").append(" WHERE i.JP_PO_PriceList_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.PO_PriceList_ID IS NULL AND i.JP_PO_PriceList_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PO_PriceList_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE JP_PO_PriceList_Name IS NOT NULL AND PO_PriceList_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupM_DiscountSchema_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_DiscountSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_DiscountSchema_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_DiscountSchema_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET M_DiscountSchema_ID=(SELECT M_DiscountSchema_ID FROM M_DiscountSchema p").append(" WHERE i.JP_DiscountSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.M_DiscountSchema_ID IS NULL AND i.JP_DiscountSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_DiscountSchema_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE JP_DiscountSchema_Name IS NOT NULL AND M_DiscountSchema_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupPO_DiscountSchema_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PO_DiscountSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PO_DiscountSchema_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PO_DiscountSchema_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET PO_DiscountSchema_ID=(SELECT M_DiscountSchema_ID FROM M_DiscountSchema p").append(" WHERE i.JP_PO_DiscountSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.PO_DiscountSchema_ID IS NULL AND i.JP_PO_DiscountSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PO_DiscountSchema_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE JP_PO_DiscountSchema_Name IS NOT NULL AND PO_DiscountSchema_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_Dunning_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Dunning_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Dunning_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Dunning_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET C_Dunning_ID=(SELECT C_Dunning_ID FROM C_Dunning p").append(" WHERE i.JP_Dunning_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.C_Dunning_ID IS NULL AND i.JP_Dunning_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Dunning_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE JP_Dunning_Name IS NOT NULL AND C_Dunning_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_AcctSchema_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP i ").append("SET C_AcctSchema_ID=(SELECT C_AcctSchema_ID FROM C_AcctSchema p").append(" WHERE i.JP_AcctSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_BP_GroupJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private boolean createNewBPGroup(X_I_BP_GroupJP impBPGroup, MBPGroup newBPGroup) {
        if (Util.isEmpty((String)impBPGroup.getValue())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
            impBPGroup.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impBPGroup.setI_IsImported(false);
            impBPGroup.setProcessed(false);
            impBPGroup.saveEx(this.get_TrxName());
            return false;
        }
        if (Util.isEmpty((String)impBPGroup.getName())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            impBPGroup.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impBPGroup.setI_IsImported(false);
            impBPGroup.setProcessed(false);
            impBPGroup.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBPGroup, (PO)newBPGroup, 30);
        newBPGroup.setAD_Org_ID(impBPGroup.getAD_Org_ID());
        newBPGroup.setValue(impBPGroup.getValue());
        newBPGroup.setName(impBPGroup.getName());
        if (!Util.isEmpty((String)impBPGroup.getDescription())) {
            newBPGroup.setDescription(impBPGroup.getDescription());
        }
        newBPGroup.setIsDefault(impBPGroup.isDefault());
        newBPGroup.setIsConfidentialInfo(impBPGroup.isConfidentialInfo());
        if (impBPGroup.getAD_PrintColor_ID() > 0) {
            newBPGroup.setAD_PrintColor_ID(impBPGroup.getAD_PrintColor_ID());
        }
        if (impBPGroup.getM_PriceList_ID() > 0) {
            newBPGroup.setM_PriceList_ID(impBPGroup.getM_PriceList_ID());
        }
        if (impBPGroup.getPO_PriceList_ID() > 0) {
            newBPGroup.setPO_PriceList_ID(impBPGroup.getPO_PriceList_ID());
        }
        if (impBPGroup.getM_DiscountSchema_ID() > 0) {
            newBPGroup.setM_DiscountSchema_ID(impBPGroup.getM_DiscountSchema_ID());
        }
        if (impBPGroup.getPO_DiscountSchema_ID() > 0) {
            newBPGroup.setPO_DiscountSchema_ID(impBPGroup.getPO_DiscountSchema_ID());
        }
        if (impBPGroup.getCreditWatchPercent() != null) {
            newBPGroup.setCreditWatchPercent(impBPGroup.getCreditWatchPercent());
        }
        if (impBPGroup.getPriceMatchTolerance() != null) {
            newBPGroup.setPriceMatchTolerance(impBPGroup.getPriceMatchTolerance());
        }
        if (impBPGroup.getC_Dunning_ID() > 0) {
            newBPGroup.setC_Dunning_ID(impBPGroup.getC_Dunning_ID());
        }
        newBPGroup.setIsActive(impBPGroup.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBPGroup, (PO)newBPGroup, 40);
        try {
            newBPGroup.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            impBPGroup.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BP_Group_ID"));
            impBPGroup.setI_IsImported(false);
            impBPGroup.setProcessed(false);
            impBPGroup.saveEx(this.get_TrxName());
            return false;
        }
        impBPGroup.setC_BP_Group_ID(newBPGroup.getC_BP_Group_ID());
        if (!Util.isEmpty((String)impBPGroup.getJP_AcctSchema_Name()) && impBPGroup.getC_AcctSchema_ID() > 0) {
            this.setBPGroupAcct(newBPGroup, impBPGroup);
        }
        if (Util.isEmpty((String)impBPGroup.getI_ErrorMsg())) {
            impBPGroup.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
        } else {
            impBPGroup.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord")) + "  &  " + impBPGroup.getI_ErrorMsg());
        }
        impBPGroup.setI_IsImported(true);
        impBPGroup.setProcessed(true);
        impBPGroup.saveEx(this.get_TrxName());
        return true;
    }

    private boolean updateBPGroup(X_I_BP_GroupJP impBPGroup, MBPGroup updateBPGroup) {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBPGroup, (PO)updateBPGroup, 30);
        updateBPGroup.setAD_Org_ID(impBPGroup.getAD_Org_ID());
        if (!Util.isEmpty((String)impBPGroup.getName())) {
            updateBPGroup.setName(impBPGroup.getName());
        }
        if (!Util.isEmpty((String)impBPGroup.getDescription())) {
            updateBPGroup.setDescription(impBPGroup.getDescription());
        }
        updateBPGroup.setIsDefault(impBPGroup.isDefault());
        updateBPGroup.setIsConfidentialInfo(impBPGroup.isConfidentialInfo());
        if (impBPGroup.getAD_PrintColor_ID() > 0) {
            updateBPGroup.setAD_PrintColor_ID(impBPGroup.getAD_PrintColor_ID());
        }
        if (impBPGroup.getM_PriceList_ID() > 0) {
            updateBPGroup.setM_PriceList_ID(impBPGroup.getM_PriceList_ID());
        }
        if (impBPGroup.getPO_PriceList_ID() > 0) {
            updateBPGroup.setPO_PriceList_ID(impBPGroup.getPO_PriceList_ID());
        }
        if (impBPGroup.getM_DiscountSchema_ID() > 0) {
            updateBPGroup.setM_DiscountSchema_ID(impBPGroup.getM_DiscountSchema_ID());
        }
        if (impBPGroup.getPO_DiscountSchema_ID() > 0) {
            updateBPGroup.setPO_DiscountSchema_ID(impBPGroup.getPO_DiscountSchema_ID());
        }
        if (impBPGroup.getCreditWatchPercent() != null) {
            updateBPGroup.setCreditWatchPercent(impBPGroup.getCreditWatchPercent());
        }
        if (impBPGroup.getPriceMatchTolerance() != null) {
            updateBPGroup.setPriceMatchTolerance(impBPGroup.getPriceMatchTolerance());
        }
        if (impBPGroup.getC_Dunning_ID() > 0) {
            updateBPGroup.setC_Dunning_ID(impBPGroup.getC_Dunning_ID());
        }
        updateBPGroup.setIsActive(impBPGroup.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBPGroup, (PO)updateBPGroup, 40);
        try {
            updateBPGroup.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            impBPGroup.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BP_Group_ID") + " :  " + e.toString());
            impBPGroup.setI_IsImported(false);
            impBPGroup.setProcessed(false);
            impBPGroup.saveEx(this.get_TrxName());
            return false;
        }
        if (!Util.isEmpty((String)impBPGroup.getJP_AcctSchema_Name()) && impBPGroup.getC_AcctSchema_ID() > 0) {
            this.setBPGroupAcct(updateBPGroup, impBPGroup);
        }
        if (Util.isEmpty((String)impBPGroup.getI_ErrorMsg())) {
            impBPGroup.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        } else {
            impBPGroup.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + "  &  " + impBPGroup.getI_ErrorMsg());
        }
        impBPGroup.setI_IsImported(true);
        impBPGroup.setProcessed(true);
        impBPGroup.saveEx(this.get_TrxName());
        return true;
    }
}

