/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_BP_BankAccountJP;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportBPBankAccount
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private String message = null;
    private IProcessUI processMonitor = null;
    private long startTime = System.currentTimeMillis();
    private String p_JP_ImportUserIdentifier = "NA";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("JP_ImportUserIdentifier")) {
                this.p_JP_ImportUserIdentifier = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE FROM I_BP_BankAccountJP ").append("WHERE I_IsImported='Y'").append(clientCheck);
            try {
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        sql = new StringBuilder("UPDATE I_BP_BankAccountJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_User_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Bank_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Bank_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BP_BankAccount_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BP_BankAccount_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_BP_BankAccountJP WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY C_BPartner_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                X_I_BP_BankAccountJP impBPBankAccount = null;
                MBPBankAccount m_BankAccount = null;
                while (rs.next()) {
                    impBPBankAccount = new X_I_BP_BankAccountJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (impBPBankAccount.getC_BP_BankAccount_ID() != 0) {
                        isNew = false;
                    }
                    if (isNew) {
                        m_BankAccount = new MBPBankAccount(this.getCtx(), 0, this.get_TrxName());
                        if (this.createBPBankAccount(impBPBankAccount, m_BankAccount)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else {
                        m_BankAccount = new MBPBankAccount(this.getCtx(), impBPBankAccount.getC_BP_BankAccount_ID(), this.get_TrxName());
                        if (this.updateBPBankAccount(impBPBankAccount, m_BankAccount)) {
                            ++successUpdateNum;
                        } else {
                            ++failureUpdateNum;
                        }
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        long endTime = System.currentTimeMillis();
        long time = endTime - this.startTime;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timeFormatted = formatter.format(time);
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + "  " + timeFormatted + " ( " + records + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    public String getImportTableName() {
        return "I_CostJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        sql = new StringBuilder("UPDATE I_BP_BankAccountJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID IS Null ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_BPartner_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.JP_BPartner_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_BPartner_ID IS NULL AND i.JP_BPartner_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Value");
        sql = new StringBuilder("UPDATE I_BP_BankAccountJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_BPartner_Value IS NOT NULL AND C_BPartner_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        if (no > 0) {
            return false;
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Value");
        sql = new StringBuilder("UPDATE I_BP_BankAccountJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE I_BP_BankAccountJP IS NULL AND C_BPartner_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAD_User_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier) || this.p_JP_ImportUserIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        if (this.p_JP_ImportUserIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_EMail IS NULL AND i.AD_User_ID IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name  AND i.JP_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL AND i.JP_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name  AND i.JP_User_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL AND i.JP_User_EMail IS NULL AND i.AD_User_ID IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportUserIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupC_Bank_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET C_Bank_ID=(SELECT C_Bank_ID FROM C_Bank p").append(" WHERE i.JP_Bank_Name=p.Name AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.JP_Bank_Name IS NOT NULL AND C_Bank_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Bank_Name");
        sql = new StringBuilder("UPDATE I_BP_BankAccountJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Bank_Name IS Not Null AND C_Bank_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_BP_BankAccount_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET C_BP_BankAccount_ID=(SELECT C_BP_BankAccount_ID FROM C_BP_BankAccount p").append(" WHERE i.C_Bank_ID=p.C_Bank_ID AND i.JP_BranchCode=p.JP_BranchCode AND i.AccountNo=p.AccountNo AND p.C_BPartner_ID=i.C_BPartner_ID ) ").append(" WHERE i.C_Bank_ID IS NOT NULL AND i.JP_BranchCode IS NOT NULL AND i.AccountNo IS NOT NULL AND C_BP_BankAccount_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Look up C_BP_BankAccount_ID From Bank Info -> #" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_BP_BankAccountJP i ").append("SET C_BP_BankAccount_ID=(SELECT C_BP_BankAccount_ID FROM C_BP_BankAccount p").append(" WHERE i.CreditCardType=p.CreditCardType AND i.CreditCardNumber=p.CreditCardNumber AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.CreditCardType IS NOT NULL AND i.CreditCardNumber IS NOT NULL AND C_BP_BankAccount_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean createBPBankAccount(X_I_BP_BankAccountJP importBPBankAccount, MBPBankAccount newBPBankAccount) {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPBankAccount, (PO)newBPBankAccount, 30);
        PO.copyValues((PO)importBPBankAccount, (PO)newBPBankAccount);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPBankAccount, (PO)newBPBankAccount, 40);
        try {
            newBPBankAccount.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importBPBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BP_BankAccount_ID") + " : " + e.toString());
            importBPBankAccount.setI_IsImported(false);
            importBPBankAccount.setProcessed(false);
            importBPBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        importBPBankAccount.setC_BP_BankAccount_ID(newBPBankAccount.getC_BP_BankAccount_ID());
        StringBuilder msg = new StringBuilder(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
        importBPBankAccount.setI_ErrorMsg(msg.toString());
        importBPBankAccount.setI_IsImported(true);
        importBPBankAccount.setProcessed(true);
        importBPBankAccount.saveEx(this.get_TrxName());
        return true;
    }

    private boolean updateBPBankAccount(X_I_BP_BankAccountJP importBPBankAccount, MBPBankAccount updateBPBankAccount) {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPBankAccount, (PO)updateBPBankAccount, 30);
        MTable C_BP_BankAccount_Table = MTable.get((Properties)this.getCtx(), (int)298, (String)this.get_TrxName());
        MColumn[] C_BP_BankAccount_Columns = C_BP_BankAccount_Table.getColumns(true);
        MTable I_BP_BankAccountJP_Table = MTable.get((Properties)this.getCtx(), (int)X_I_BP_BankAccountJP.Table_ID, (String)this.get_TrxName());
        MColumn[] I_BP_BankAccountJP_Columns = I_BP_BankAccountJP_Table.getColumns(true);
        MColumn i_Column = null;
        int i = 0;
        while (i < C_BP_BankAccount_Columns.length) {
            i_Column = C_BP_BankAccount_Columns[i];
            if (!(i_Column.isVirtualColumn() || i_Column.isKey() || i_Column.isUUIDColumn() || i_Column.getColumnName().equals("IsActive") || i_Column.getColumnName().equals("AD_Client_ID") || i_Column.getColumnName().equals("Value") || i_Column.getColumnName().equals("Processing") || i_Column.getColumnName().equals("Created") || i_Column.getColumnName().equals("CreatedBy") || i_Column.getColumnName().equals("Updated") || i_Column.getColumnName().equals("UpdatedBy"))) {
                MColumn j_Column = null;
                Object importValue = null;
                int j = 0;
                while (j < I_BP_BankAccountJP_Columns.length) {
                    j_Column = I_BP_BankAccountJP_Columns[j];
                    if (i_Column.getColumnName().equals(j_Column.getColumnName())) {
                        importValue = importBPBankAccount.get_Value(j_Column.getColumnName());
                        if (importValue == null) break;
                        if (importValue instanceof BigDecimal) {
                            BigDecimal bigDecimal_Value = (BigDecimal)importValue;
                            if (bigDecimal_Value.compareTo(Env.ZERO) == 0) {
                                break;
                            }
                        } else {
                            Integer p_key;
                            if (j_Column.getAD_Reference_ID() == 10) {
                                String string_Value = (String)importValue;
                                if (Util.isEmpty((String)string_Value)) break;
                                updateBPBankAccount.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                                break;
                            }
                            if (j_Column.getColumnName().endsWith("_ID") && (p_key = (Integer)importValue) <= 0) break;
                        }
                        if (importValue == null) break;
                        try {
                            updateBPBankAccount.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                            break;
                        }
                        catch (Exception e) {
                            importBPBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " Column = " + i_Column.getColumnName() + " & " + "Value = " + importValue.toString() + " -> " + e.toString());
                            importBPBankAccount.setI_IsImported(false);
                            importBPBankAccount.setProcessed(false);
                            importBPBankAccount.saveEx(this.get_TrxName());
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPBankAccount, (PO)updateBPBankAccount, 40);
        try {
            updateBPBankAccount.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importBPBankAccount.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BP_BankAccount_ID") + " -> " + e.toString());
            importBPBankAccount.setI_IsImported(false);
            importBPBankAccount.setProcessed(false);
            importBPBankAccount.saveEx(this.get_TrxName());
            return false;
        }
        StringBuilder msg = new StringBuilder(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        importBPBankAccount.setI_ErrorMsg(msg.toString());
        importBPBankAccount.setI_IsImported(true);
        importBPBankAccount.setProcessed(true);
        importBPBankAccount.saveEx(this.get_TrxName());
        return true;
    }
}

