/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MPeriod;
import org.compiere.model.MPeriodControl;
import org.compiere.model.MRefList;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class JPiereCalendarBulkOpenClose
extends SvrProcess {
    private int p_C_Calendar_ID = 0;
    private Timestamp p_EndDate = null;
    private String p_DocBaseType = null;
    private String p_PeriodAction = null;
    private IProcessUI processUI = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Calendar_ID")) {
                    this.p_C_Calendar_ID = para[i].getParameterAsInt();
                } else if (name.equals("EndDate")) {
                    this.p_EndDate = (Timestamp)para[i].getParameter();
                } else if (name.equals("DocBaseType")) {
                    this.p_DocBaseType = para[i].getParameterAsString();
                } else if (name.equals("PeriodAction")) {
                    this.p_PeriodAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        MPeriod[] periods = JPiereCalendarBulkOpenClose.getPeriodByCalendar(this.getCtx(), this.p_EndDate, this.p_C_Calendar_ID, this.get_TrxName());
        if (Util.isEmpty((String)this.p_DocBaseType)) {
            ProcessInfo pi = new ProcessInfo("Period Open - Close", 0);
            pi.setClassName("org.compiere.process.PeriodStatus");
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
            ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
            list.add(new ProcessInfoParameter("PeriodAction", (Object)this.p_PeriodAction, null, null, null));
            ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
            list.toArray(pars);
            pi.setParameter(pars);
            String msg = null;
            int i = 0;
            while (i < periods.length) {
                pi.setRecord_ID(periods[i].getC_Period_ID());
                boolean success = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI);
                msg = success ? String.valueOf(periods[i].getName()) + " - " + MRefList.getListName((Properties)this.getCtx(), (int)176, (String)this.p_PeriodAction) : String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure")) + " : " + periods[i].getName() + " - " + MRefList.getListName((Properties)this.getCtx(), (int)176, (String)this.p_PeriodAction);
                if (this.processUI != null) {
                    this.processUI.statusUpdate(msg);
                }
                this.addLog(msg);
                ++i;
            }
        } else {
            String msg = null;
            int i = 0;
            while (i < periods.length) {
                MPeriodControl periodControl = JPiereCalendarBulkOpenClose.getPeriodControl(this.getCtx(), periods[i].getC_Period_ID(), this.p_DocBaseType, this.get_TrxName());
                if (periodControl != null) {
                    if ("O".equals(this.p_PeriodAction)) {
                        periodControl.setPeriodStatus("O");
                    }
                    if ("C".equals(this.p_PeriodAction)) {
                        periodControl.setPeriodStatus("C");
                    }
                    if ("P".equals(this.p_PeriodAction)) {
                        periodControl.setPeriodStatus("P");
                    }
                    periodControl.setPeriodAction("N");
                    boolean success = periodControl.save(this.get_TrxName());
                    msg = success && this.processUI != null ? String.valueOf(periods[i].getName()) + " - " + MRefList.getListName((Properties)this.getCtx(), (int)183, (String)this.p_DocBaseType) + " - " + MRefList.getListName((Properties)this.getCtx(), (int)176, (String)this.p_PeriodAction) : String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure")) + " : " + periods[i].getName() + " - " + MRefList.getListName((Properties)this.getCtx(), (int)183, (String)this.p_DocBaseType) + " - " + MRefList.getListName((Properties)this.getCtx(), (int)176, (String)this.p_PeriodAction);
                    if (this.processUI != null) {
                        this.processUI.statusUpdate(msg);
                    }
                    this.addLog(msg);
                    CacheMgt.get().reset("C_PeriodControl", 0);
                    CacheMgt.get().reset("C_Period", periodControl.getC_Period_ID());
                }
                ++i;
            }
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private static MPeriod[] getPeriodByCalendar(Properties ctx, Timestamp EndDate, int C_Calendar_ID, String trxName) {
        ArrayList<MPeriod> list;
        block6: {
            list = new ArrayList<MPeriod>();
            String sql = "SELECT * FROM C_Period WHERE C_Year_ID IN (SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID= ?) AND EndDate <= ? ORDER BY EndDate ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, C_Calendar_ID);
                    pstmt.setTimestamp(2, EndDate);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MPeriod(ctx, rs, trxName));
                    }
                }
                catch (SQLException sQLException) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MPeriod[] periods = new MPeriod[list.size()];
        list.toArray(periods);
        return periods;
    }

    private static MPeriodControl getPeriodControl(Properties ctx, int C_Period_ID, String DocBaseType, String trxName) {
        MPeriodControl retValue;
        block6: {
            retValue = null;
            String sql = "SELECT * FROM C_PeriodControl WHERE C_Period_ID=? AND DocBaseType=? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, C_Period_ID);
                    pstmt.setString(2, DocBaseType);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MPeriodControl(ctx, rs, trxName);
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }
}

