/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class InvoiceCorpSummary
extends SvrProcess {
    private int p_AD_Client_ID;
    private Timestamp p_DateInvoiced_From = null;
    private Timestamp p_DateInvoiced_To = null;
    private int p_AD_Org_ID = 0;
    private int p_JP_CorporationGroup_ID = 0;
    private int p_JP_Corporation_ID = 0;
    private int p_C_Currency_ID = 0;
    private boolean p_IsSOTrx = true;

    protected void prepare() {
        this.p_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced_From = (Timestamp)para[i].getParameter();
                    this.p_DateInvoiced_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_CorporationGroup_ID")) {
                    this.p_JP_CorporationGroup_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_Corporation_ID")) {
                    this.p_JP_Corporation_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Currency_ID")) {
                    this.p_C_Currency_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsSOTrx")) {
                    this.p_IsSOTrx = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String DateFrom = this.p_DateInvoiced_From.toString();
        String DateTo = this.p_DateInvoiced_To.toString();
        StringBuilder sql = new StringBuilder("INSERT INTO T_InvoiceCorpSummaryJP ").append("(AD_PInstance_ID, AD_Client_ID, AD_Org_ID, JP_CorporationGroup_ID, JP_Corporation_ID, DocBaseTYpe, C_Currency_ID, IsSOTrx, TotalLines, GrandTotal,DateInvoiced)").append(" SELECT ").append(this.getAD_PInstance_ID()).append(" , inv.AD_Client_ID, inv.AD_Org_ID,gc.JP_CorporationGroup_ID, bp.JP_Corporation_ID, dt.DocBaseType, inv.C_Currency_ID, inv.IsSOTrx,").append(" CASE WHEN  dt.DocBaseType = 'ARC'THEN sum(inv.TotalLines)*-1 WHEN  dt.DocBaseType = 'APC'THEN sum(inv.TotalLines)*-1 ELSE sum(inv.TotalLines) END,").append(" CASE WHEN  dt.DocBaseType = 'ARC'THEN sum(inv.GrandTotal)*-1 WHEN  dt.DocBaseType = 'APC'THEN sum(inv.GrandTotal)*-1 ELSE sum(inv.GrandTotal) END,").append(" TO_DATE('").append(DateFrom.substring(0, 10)).append(" 12:00:00','YYYY-MM-DD HH24:MI:SS')").append(" FROM C_Invoice inv").append(" INNER JOIN C_BPartner bp ON (inv.C_BPartner_ID = bp.C_BPartner_ID)").append(" INNER JOIN C_DocType dt ON (inv.C_DocType_ID = dt.C_DocType_ID)").append(" LEFT OUTER JOIN JP_GroupCorporations gc ON (bp.JP_Corporation_ID = gc.JP_Corporation_ID )").append(" WHERE inv.docstatus in ('CO','CL') AND bp.JP_Corporation_ID is not null ").append(" AND inv.AD_Client_ID = ").append(this.p_AD_Client_ID).append(" AND inv.DateInvoiced >= TO_DATE('").append(DateFrom.substring(0, 10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS')").append(" AND inv.DateInvoiced <= TO_DATE('").append(DateTo.substring(0, 10)).append(" 23:59:59','YYYY-MM-DD HH24:MI:SS')");
        if (this.p_AD_Org_ID != 0) {
            sql = sql.append(" AND inv.AD_Org_ID=").append(this.p_AD_Org_ID);
        }
        if (this.p_JP_CorporationGroup_ID != 0) {
            sql = sql.append(" AND gc.JP_CorporationGroup_ID=").append(this.p_JP_CorporationGroup_ID);
        }
        if (this.p_JP_Corporation_ID != 0) {
            sql = sql.append(" AND bp.JP_Corporation_ID=").append(this.p_JP_Corporation_ID);
        }
        if (this.p_C_Currency_ID != 0) {
            sql = sql.append(" AND inv.C_Currency_ID=").append(this.p_C_Currency_ID);
        }
        sql = this.p_IsSOTrx ? sql.append(" AND inv.IsSOTrx='Y'") : sql.append(" AND inv.IsSOTrx='N'");
        sql = sql.append(" GROUP BY inv.AD_Client_ID,inv.AD_Org_ID,gc.JP_CorporationGroup_ID, bp.JP_Corporation_ID, dt.DocBaseType, inv.C_Currency_ID, inv.IsSOTrx ;");
        int InsertRecords = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Inserted Records=" + InsertRecords);
        }
        return "Inserted Records=" + InsertRecords;
    }
}

