/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class InventoryCountCreateFromTransaction
extends SvrProcess {
    private int p_M_Locator_ID = 0;
    private String p_LocatorValue = null;
    private String p_ProductValue = null;
    private int p_M_Product_Category_ID = 0;
    private String p_QtyRange = null;
    private boolean p_InventoryCountSetZero = false;
    private boolean p_DeleteOld = false;
    private MInventoryLine m_line = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Locator_ID")) {
                    this.p_M_Locator_ID = para[i].getParameterAsInt();
                } else if (name.equals("LocatorValue")) {
                    this.p_LocatorValue = para[i].getParameterAsString();
                } else if (name.equals("ProductValue")) {
                    this.p_ProductValue = para[i].getParameterAsString();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else if (name.equals("QtyRange")) {
                    this.p_QtyRange = para[i].getParameterAsString();
                } else if (name.equals("InventoryCountSet")) {
                    this.p_InventoryCountSetZero = "Z".equals(para[i].getParameter());
                } else if (name.equals("DeleteOld")) {
                    this.p_DeleteOld = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int count;
        block9: {
            int inventoryID = this.getRecord_ID();
            MInventory inventory = new MInventory(this.getCtx(), inventoryID, this.get_TrxName());
            if (inventory.get_ID() == 0) {
                throw new AdempiereSystemError("Not found: M_Inventory_ID=" + inventoryID);
            }
            if (inventory.isProcessed()) {
                throw new AdempiereSystemError("@M_Inventory_ID@ @Processed@");
            }
            if (this.p_DeleteOld) {
                this.deleteOldRecord(inventoryID);
            }
            String sql = this.createSelectStatement();
            count = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    this.setSelectStatementParameter((PreparedStatement)pstmt, inventory);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int M_Product_ID = rs.getInt(1);
                        int M_Locator_ID = rs.getInt(2);
                        BigDecimal qty = rs.getBigDecimal(3);
                        int M_AttributeSetInstance_ID = 0;
                        count += this.createInventoryLine(M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, qty, inventory);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@M_InventoryLine_ID@ - #").append(count);
        return msgreturn.toString();
    }

    private void deleteOldRecord(int inventoryID) {
        StringBuilder sql = new StringBuilder("DELETE FROM M_InventoryLineMA ma WHERE EXISTS ").append("(SELECT * FROM M_InventoryLine l WHERE l.M_InventoryLine_ID=ma.M_InventoryLine_ID").append(" AND Processed='N' AND M_Inventory_ID=").append(inventoryID).append(")");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("doIt - Deleted MA #" + no);
        }
        sql = new StringBuilder("DELETE M_InventoryLine WHERE Processed='N' ").append("AND M_Inventory_ID=").append(inventoryID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("doIt - Deleted #" + no);
        }
    }

    private String createSelectStatement() throws Exception {
        StringBuilder sql = new StringBuilder("SELECT t.M_Product_ID, t.M_Locator_ID, ");
        if (this.p_InventoryCountSetZero) {
            sql.append("0 Qty, ");
        } else {
            sql.append("SUM(t.MovementQty) Qty, ");
        }
        sql.append("l.Value, p.Value ");
        sql.append("FROM M_Product p ");
        sql.append("INNER JOIN M_Transaction t ON (p.m_product_id = t.m_product_id) ");
        sql.append("INNER JOIN M_Locator l ON (t.M_Locator_ID=l.M_Locator_ID) ");
        sql.append("WHERE l.M_Warehouse_ID=? ");
        sql.append(" AND p.IsActive='Y' AND p.IsStocked='Y' AND p.ProductType='I' ");
        sql.append(" AND t.MovementDate <= TO_DATE(? ,'YYYY-MM-DD HH24:MI:SS') ");
        if (this.p_M_Locator_ID != 0) {
            sql.append(" AND t.M_Locator_ID=? ");
        }
        if (this.p_LocatorValue != null && (this.p_LocatorValue.trim().length() == 0 || this.p_LocatorValue.equals("%"))) {
            this.p_LocatorValue = null;
        } else if (this.p_LocatorValue != null) {
            sql.append(" AND UPPER(l.Value) LIKE ? ");
        }
        if (this.p_ProductValue != null && (this.p_ProductValue.trim().length() == 0 || this.p_ProductValue.equals("%"))) {
            this.p_ProductValue = null;
        } else if (this.p_ProductValue != null) {
            sql.append(" AND UPPER(p.Value) LIKE ? ");
        }
        if (this.p_M_Product_Category_ID != 0) {
            sql.append(" AND p.M_Product_Category_ID IN (").append(this.getSubCategoryWhereClause(this.p_M_Product_Category_ID)).append(") ");
        }
        if (!this.p_DeleteOld) {
            sql.append(" AND NOT EXISTS (SELECT * FROM M_InventoryLine il ").append("WHERE il.M_Inventory_ID=? ").append(" AND il.M_Product_ID=t.M_Product_ID ").append(" AND il.M_Locator_ID=t.M_Locator_ID ").append(" AND COALESCE(il.M_AttributeSetInstance_ID,0)=COALESCE(t.M_AttributeSetInstance_ID,0)) ");
        }
        sql.append("GROUP BY l.Value, p.Value, t.M_Product_ID, t.M_Locator_ID ");
        if (this.p_QtyRange != null && (this.p_QtyRange.equals(">") || this.p_QtyRange.equals("<") || this.p_QtyRange.equals("=") || this.p_QtyRange.equals("N"))) {
            String operator = "";
            operator = !this.p_QtyRange.equals("N") ? this.p_QtyRange : "<>";
            sql.append("HAVING SUM(t.MovementQty) ").append(operator).append(" 0 ");
        }
        sql.append("ORDER BY l.Value, p.Value");
        return sql.toString();
    }

    private void setSelectStatementParameter(PreparedStatement pstmt, MInventory inventory) throws Exception {
        int index = 1;
        pstmt.setInt(index++, inventory.getM_Warehouse_ID());
        StringBuilder movementDateStr = new StringBuilder(inventory.getMovementDate().toString().substring(0, 10));
        pstmt.setString(index++, movementDateStr.append(" 23:59:59'").toString());
        if (this.p_M_Locator_ID != 0) {
            pstmt.setInt(index++, this.p_M_Locator_ID);
        }
        if (this.p_LocatorValue != null) {
            pstmt.setString(index++, this.p_LocatorValue.toUpperCase());
        }
        if (this.p_ProductValue != null) {
            pstmt.setString(index++, this.p_ProductValue.toUpperCase());
        }
        if (!this.p_DeleteOld) {
            pstmt.setInt(index++, inventory.get_ID());
        }
    }

    private int createInventoryLine(int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal qty, MInventory inventory) {
        if (qty.signum() == 0) {
            M_AttributeSetInstance_ID = 0;
        }
        if (this.m_line != null && this.m_line.getM_Locator_ID() == M_Locator_ID && this.m_line.getM_Product_ID() == M_Product_ID) {
            if (qty.signum() == 0) {
                return 0;
            }
            if (this.m_line.getM_AttributeSetInstance_ID() == M_AttributeSetInstance_ID) {
                this.m_line.setQtyBook(this.m_line.getQtyBook().add(qty));
                this.m_line.setQtyCount(this.m_line.getQtyCount().add(qty));
                this.m_line.saveEx();
                return 0;
            }
            this.m_line.setM_AttributeSetInstance_ID(0);
            this.m_line.setQtyBook(this.m_line.getQtyBook().add(qty));
            this.m_line.setQtyCount(this.m_line.getQtyCount().add(qty));
            this.m_line.saveEx();
            return 0;
        }
        this.m_line = new MInventoryLine(inventory, M_Locator_ID, M_Product_ID, 0, qty, qty);
        if (this.m_line.save()) {
            return 1;
        }
        return 0;
    }

    private String getSubCategoryWhereClause(int productCategoryId) throws SQLException, AdempiereSystemError {
        int subTreeRootParentId = 0;
        StringBuilder retString = new StringBuilder();
        String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
        Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DB.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt(1) == productCategoryId) {
                    subTreeRootParentId = rs.getInt(2);
                }
                categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
            }
            retString.append(this.getSubCategoriesString(productCategoryId, categories, subTreeRootParentId));
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)stmt);
            rs = null;
            stmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)stmt);
        rs = null;
        stmt = null;
        return retString.toString();
    }

    private String getSubCategoriesString(int productCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) throws AdempiereSystemError {
        StringBuilder ret = new StringBuilder();
        for (SimpleTreeNode node : categories) {
            if (node.getParentId() != productCategoryId) continue;
            if (node.getNodeId() == loopIndicatorId) {
                throw new AdempiereSystemError("The product category tree contains a loop on categoryId: " + loopIndicatorId);
            }
            ret.append(this.getSubCategoriesString(node.getNodeId(), categories, loopIndicatorId));
            ret.append(",");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(ret.toString());
        }
        StringBuilder msgreturn = new StringBuilder(ret).append(productCategoryId);
        return msgreturn.toString();
    }

    private static class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

