/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MJournal;
import org.compiere.model.MPeriod;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFProcess;

public class GLJournalBulkComplete
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private String p_DocStatus = null;
    private int p_AD_User_ID = 0;
    private Timestamp p_Created_From = null;
    private Timestamp p_Created_To = null;
    private int p_C_DocType_ID = 0;
    private int p_JP_Contract_ID = 0;
    private int p_JP_ContractContent_ID = 0;
    private Timestamp p_JP_OverwriteDateDoc = null;
    private Timestamp p_JP_OverwriteDateAcct = null;
    private String p_DocAction = "CO";
    private String p_JP_Process_Value = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                Calendar cal;
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                    this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                    if (this.p_DateAcct_To != null) {
                        cal = Calendar.getInstance();
                        cal.setTimeInMillis(this.p_DateAcct_To.getTime());
                        cal.add(5, 1);
                        this.p_DateAcct_To = new Timestamp(cal.getTimeInMillis());
                    }
                } else if (name.equals("DocStatus")) {
                    this.p_DocStatus = para[i].getParameterAsString();
                } else if (name.equals("AD_User_ID")) {
                    this.p_AD_User_ID = para[i].getParameterAsInt();
                } else if (name.equals("Created")) {
                    this.p_Created_From = (Timestamp)para[i].getParameter();
                    this.p_Created_To = (Timestamp)para[i].getParameter_To();
                    if (this.p_Created_To != null) {
                        cal = Calendar.getInstance();
                        cal.setTimeInMillis(this.p_Created_To.getTime());
                        cal.add(5, 1);
                        this.p_Created_To = new Timestamp(cal.getTimeInMillis());
                    }
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_Contract_ID")) {
                    this.p_JP_Contract_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractContent_ID")) {
                    this.p_JP_ContractContent_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_OverwriteDateDoc")) {
                    this.p_JP_OverwriteDateDoc = (Timestamp)para[i].getParameter();
                } else if (name.equals("JP_OverwriteDateAcct")) {
                    this.p_JP_OverwriteDateAcct = (Timestamp)para[i].getParameter();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else if (name.equals("JP_Process_Value")) {
                    this.p_JP_Process_Value = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MJournal[] glJournals = this.getGLjournals();
        if (glJournals == null) {
            return "ok";
        }
        IProcessUI processMonitor = Env.getProcessUI((Properties)this.getCtx());
        int successNo = 0;
        int failureNo = 0;
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        ProcessInfo pInfo = this.getProcessInfo();
        MColumn docActionColumn = MColumn.get((Properties)this.getCtx(), (String)"GL_Journal", (String)"DocAction");
        MProcess process = MProcess.get((int)docActionColumn.getAD_Process_ID());
        int i = 0;
        while (i < glJournals.length) {
            MJournal mj = glJournals[i];
            if (!mj.isProcessed()) {
                String msg;
                block16: {
                    String wfStatus;
                    if (this.p_JP_OverwriteDateDoc != null) {
                        mj.setDateDoc(this.p_JP_OverwriteDateDoc);
                    }
                    if (this.p_JP_OverwriteDateAcct != null) {
                        int C_Period_ID = MPeriod.getC_Period_ID((Properties)this.getCtx(), (Timestamp)this.p_JP_OverwriteDateAcct, (int)mj.getAD_Org_ID());
                        if (C_Period_ID == 0) {
                            msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"PeriodNotFound")) + " : " + DisplayType.getDateFormat().format(this.p_JP_OverwriteDateAcct) + " - " + mj.getDocumentNo();
                            throw new Exception(msg);
                        }
                        mj.setDateAcct(this.p_JP_OverwriteDateAcct);
                        mj.setC_Period_ID(C_Period_ID);
                        mj.saveEx(this.get_TrxName());
                    }
                    if (Util.isEmpty((String)(wfStatus = MWFActivity.getActiveInfo((Properties)Env.getCtx(), (int)224, (int)mj.getGL_Journal_ID())))) {
                        try {
                            if ("CO".equals(this.p_DocAction)) {
                                pInfo.setPO((PO)mj);
                                pInfo.setRecord_ID(mj.getGL_Journal_ID());
                                pInfo.setTable_ID(224);
                                MWFProcess wfProcess = ProcessUtil.startWorkFlow((Properties)Env.getCtx(), (ProcessInfo)pInfo, (int)process.getAD_Workflow_ID());
                                if (wfProcess.getWFState().equals("CT")) {
                                    ++failureNo;
                                    mj.saveEx(this.get_TrxName());
                                    this.addBufferLog(0, null, null, mj.getDocumentNo(), 224, mj.getGL_Journal_ID());
                                } else {
                                    ++successNo;
                                    mj.saveEx(this.get_TrxName());
                                    this.addBufferLog(0, null, null, mj.getDocumentNo(), 224, mj.getGL_Journal_ID());
                                }
                                break block16;
                            }
                            if (!"PR".equals(this.p_DocAction)) break block16;
                            if (mj.processIt(this.p_DocAction)) {
                                ++successNo;
                                mj.saveEx(this.get_TrxName());
                                this.addBufferLog(0, null, null, mj.getDocumentNo(), 224, mj.getGL_Journal_ID());
                                break block16;
                            }
                            ++failureNo;
                            mj.saveEx(this.get_TrxName());
                            this.addBufferLog(0, null, null, mj.getDocumentNo(), 224, mj.getGL_Journal_ID());
                        }
                        catch (Exception e) {
                            ++failureNo;
                            this.addBufferLog(0, null, null, mj.getDocumentNo(), 224, mj.getGL_Journal_ID());
                        }
                    } else {
                        ++failureNo;
                        this.addBufferLog(0, null, null, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"WFActiveForRecord")) + ":" + mj.getDocumentNo(), 224, mj.getGL_Journal_ID());
                    }
                }
                if (processMonitor != null) {
                    msg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo")) + " : " + mj.getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus") + " : " + mj.getDocStatus();
                    processMonitor.statusUpdate(msg);
                } else {
                    processMonitor = Env.getProcessUI((Properties)this.getCtx());
                }
            }
            ++i;
        }
        return String.valueOf(success) + " : " + successNo + "  /  " + failure + " " + failureNo;
    }

    private MJournal[] getGLjournals() throws Exception {
        if ("Y".equals(this.p_JP_Process_Value)) {
            StringBuilder whereClause = new StringBuilder("AD_Client_ID = ? AND Processed = 'N' ");
            ArrayList<Object> docListParams = new ArrayList<Object>();
            docListParams.add(this.p_AD_Client_ID);
            if (!Util.isEmpty((String)this.p_DocStatus)) {
                whereClause.append(" AND DocStatus = ? ");
                docListParams.add(this.p_DocStatus);
            }
            if (this.p_AD_Org_ID != 0) {
                whereClause.append(" AND AD_Org_ID = ? ");
                docListParams.add(this.p_AD_Org_ID);
            }
            if (this.p_DateAcct_From != null) {
                whereClause.append(" AND DateAcct >= ? ");
                docListParams.add(this.p_DateAcct_From);
            }
            if (this.p_DateAcct_To != null) {
                whereClause.append(" AND DateAcct <= ? ");
                docListParams.add(this.p_DateAcct_To);
            }
            if (this.p_AD_User_ID != 0) {
                whereClause.append(" AND CreatedBy = ? ");
                docListParams.add(this.p_AD_User_ID);
            }
            if (this.p_Created_From != null) {
                whereClause.append(" AND Created >= ? ");
                docListParams.add(this.p_Created_From);
            }
            if (this.p_Created_To != null) {
                whereClause.append(" AND Created <= ? ");
                docListParams.add(this.p_Created_To);
            }
            if (this.p_C_DocType_ID != 0) {
                whereClause.append(" AND C_DocType_ID = ? ");
                docListParams.add(this.p_AD_Org_ID);
            }
            if (this.p_JP_Contract_ID != 0) {
                whereClause.append(" AND JP_Contract_ID = ? ");
                docListParams.add(this.p_JP_Contract_ID);
            }
            if (this.p_JP_ContractContent_ID != 0) {
                whereClause.append(" AND JP_ContractContent_ID = ? ");
                docListParams.add(this.p_JP_ContractContent_ID);
            }
            List list = new Query(this.getCtx(), "GL_Journal", whereClause.toString(), this.get_TrxName()).setParameters(docListParams).list();
            MJournal[] glJournals = list.toArray(new MJournal[list.size()]);
            return glJournals;
        }
        ArrayList<MJournal> list = new ArrayList<MJournal>();
        String sql = "SELECT gl.* FROM GL_Journal gl  INNER JOIN T_Selection ts ON (gl.GL_Journal_ID = ts.T_Selection_ID AND ts.AD_PInstance_ID=?)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MJournal(this.getCtx(), rs, this.get_TrxName()));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        MJournal[] glJournals = list.toArray(new MJournal[list.size()]);
        return glJournals;
    }
}

