/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MReportCubeJP;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MPeriod;
import org.compiere.model.MYear;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class FactAcctBS
extends SvrProcess {
    private int p_Cube_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private int p_C_Calendar_ID = 0;
    private int p_C_Year_ID = 0;
    private int p_C_Period_ID = 0;
    private boolean p_IsDeleteDataOnlyJP = false;
    private IProcessUI processUI = null;

    protected void prepare() {
        ProcessInfoParameter[] params;
        ProcessInfoParameter[] processInfoParameterArray = params = this.getParameter();
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter p = processInfoParameterArray[n2];
            if (p.getParameterName().equals("PA_ReportCubeJP_ID")) {
                this.p_Cube_ID = p.getParameterAsInt();
            } else if (p.getParameterName().equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = p.getParameterAsInt();
            } else if (p.getParameterName().equals("C_Calendar_ID")) {
                this.p_C_Calendar_ID = p.getParameterAsInt();
            } else if (p.getParameterName().equals("C_Year_ID")) {
                this.p_C_Year_ID = p.getParameterAsInt();
            } else if (p.getParameterName().equals("C_Period_ID")) {
                this.p_C_Period_ID = p.getParameterAsInt();
            } else if (p.getParameterName().equals("IsDeleteDataOnlyJP")) {
                this.p_IsDeleteDataOnlyJP = p.getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + p.getParameterName());
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        MReportCubeJP cube = new MReportCubeJP(this.getCtx(), this.p_Cube_ID, this.get_TrxName());
        if (this.processUI != null) {
            this.processUI.statusUpdate(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + " : " + cube.getName());
        }
        cube.update(false, false);
        this.commitEx();
        if (this.p_C_Year_ID == 0) {
            this.calculateYear(cube, this.p_C_Calendar_ID);
        }
        if (this.p_C_Period_ID == 0) {
            this.calculatePeriod(cube, this.p_C_Year_ID);
        } else {
            MPeriod m_Period = MPeriod.get((Properties)this.getCtx(), (int)this.p_C_Period_ID);
            if (this.processUI != null) {
                this.processUI.statusUpdate(m_Period.getName());
            }
            String message = cube.updateBS(this.p_C_AcctSchema_ID, this.p_C_Calendar_ID, this.p_C_Year_ID, m_Period, this.p_IsDeleteDataOnlyJP);
            this.addLog(String.valueOf(m_Period.getName()) + " : " + message);
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private void calculateYear(MReportCubeJP cube, int C_Calendar_ID) throws SQLException {
        StringBuilder whereClause = new StringBuilder("C_Calendar_ID =? ");
        StringBuilder orderClause = new StringBuilder("C_Calendar_ID");
        List list = new Query(this.getCtx(), "C_Year", whereClause.toString(), this.get_TrxName()).setParameters(new Object[]{C_Calendar_ID}).setOrderBy(orderClause.toString()).list();
        for (MYear m_Year : list) {
            this.calculatePeriod(cube, m_Year.getC_Year_ID());
        }
    }

    private void calculatePeriod(MReportCubeJP cube, int C_Year_ID) throws SQLException {
        StringBuilder whereClause = new StringBuilder("C_Year_ID=? ");
        StringBuilder orderClause = new StringBuilder("StartDate");
        List list = new Query(this.getCtx(), "C_Period", whereClause.toString(), this.get_TrxName()).setParameters(new Object[]{C_Year_ID}).setOrderBy(orderClause.toString()).list();
        String message = null;
        for (MPeriod m_Period : list) {
            message = cube.updateBS(this.p_C_AcctSchema_ID, this.p_C_Calendar_ID, this.p_C_Year_ID, m_Period, this.p_IsDeleteDataOnlyJP);
            if (this.processUI != null) {
                this.processUI.statusUpdate(String.valueOf(m_Period.getName()) + " : " + message);
            }
            this.addLog(String.valueOf(m_Period.getName()) + " : " + message);
            this.commitEx();
        }
    }
}

