/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.util.JPierePaymentTerms;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class DeliveryDaysInvoiceGenerate
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_DocTypeOrder_ID = 0;
    private Timestamp p_MovementDate_From;
    private Timestamp p_MovementDate_To;
    private String p_DocAction = "CO";
    private int p_M_Warehouse_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private MInvoice m_invoice = null;
    private Savepoint m_savepoint = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;
    Timestamp SystemDate = new Timestamp(System.currentTimeMillis());

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocTypeOrder_ID = para[i].getParameterAsInt();
                } else if (name.equals("MovementDate")) {
                    this.p_MovementDate_From = (Timestamp)para[i].getParameter();
                    this.p_MovementDate_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        List<MOrder> oList = new ArrayList();
        if (this.getParameter().length > 0) {
            StringBuilder getInOutSQL = new StringBuilder("SELECT distinct o.* FROM M_InOut io ").append("INNER JOIN C_DocType dt on(io.C_DocType_ID = dt.C_DocType_ID) ").append("INNER JOIN C_BPartner bp on(io.C_BPartner_ID = bp.C_BPartner_ID) ").append("INNER JOIN M_InOutLine iol on(io.M_InOut_ID = iol.M_InOut_ID) ").append("INNER JOIN C_OrderLine ol on(iol.C_OrderLine_ID = ol.C_OrderLine_ID) ").append("INNER JOIN C_Order o on(ol.C_Order_ID=o.C_Order_ID) ").append("INNER JOIN C_DocType odt on(o.C_DocType_ID=odt.C_DocType_ID) ").append("WHERE io.DocStatus in ('CO','CL') ").append("AND io.IsSOTrx ='Y' ").append("AND io.IsInDispute = 'N' ").append("AND dt.DocBaseType = 'MMS' ").append("AND iol.isinvoiced = 'N' ").append("AND ol.QtyDelivered<>ol.QtyInvoiced ").append("AND io.AD_Client_ID=" + this.getAD_Client_ID());
            if (this.p_AD_Org_ID != 0) {
                getInOutSQL.append(" AND io.AD_Org_ID=" + this.p_AD_Org_ID);
            }
            if (this.p_M_Warehouse_ID != 0) {
                getInOutSQL.append(" AND io.M_Warehouse_ID=" + this.p_M_Warehouse_ID);
            }
            if (this.p_C_BP_Group_ID != 0) {
                getInOutSQL.append(" AND bp.C_BP_Group_ID=" + this.p_C_BP_Group_ID);
            }
            if (this.p_C_BPartner_ID != 0) {
                getInOutSQL.append(" AND io.C_BPartner_ID=" + this.p_C_BPartner_ID);
            }
            if (this.p_MovementDate_From != null) {
                getInOutSQL.append(" AND io.MovementDate > '").append(new SimpleDateFormat("yyyy-MM-dd").format(this.p_MovementDate_From)).append("'");
            }
            if (this.p_MovementDate_To != null) {
                getInOutSQL.append(" AND io.MovementDate < '").append(new SimpleDateFormat("yyyy-MM-dd").format(this.p_MovementDate_To)).append("'");
            }
            if (this.p_C_DocTypeOrder_ID != 0) {
                getInOutSQL.append(" AND odt.C_DocType_ID = " + this.p_C_DocTypeOrder_ID);
            }
            getInOutSQL.append(" ORDER BY o.M_Warehouse_ID, o.PriorityRule, o.C_BPartner_ID, o.Bill_Location_ID, o.C_Order_ID");
            CPreparedStatement getInOutPSTMT = null;
            ResultSet getInOutRS = null;
            try {
                try {
                    getInOutPSTMT = DB.prepareStatement((String)getInOutSQL.toString(), (String)this.get_TrxName());
                    getInOutRS = getInOutPSTMT.executeQuery();
                    while (getInOutRS.next()) {
                        oList.add(new MOrder(this.getCtx(), getInOutRS, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    throw new AdempiereException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DB.close(getInOutRS, getInOutPSTMT);
                getInOutRS = null;
                getInOutPSTMT = null;
                throw throwable;
            }
            DB.close((ResultSet)getInOutRS, (Statement)getInOutPSTMT);
            getInOutRS = null;
            Iterator iterator = null;
        } else {
            String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID = C_Order.C_Order_ID)";
            oList = new Query(this.getCtx(), "C_Order", whereClause, this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getAD_PInstance_ID()}).list();
        }
        if (oList.size() < 1) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"NotFound");
        }
        for (MOrder order : oList) {
            MInOut[] shipments = order.getShipments();
            int i = 0;
            while (i < shipments.length) {
                MInOut ship = shipments[i];
                if (ship.getDocStatus().equals("CO") || ship.getDocStatus().equals("CL")) {
                    Timestamp dateInvoiced = ship.getDateAcct();
                    MInOutLine[] shipLines = ship.getLines(false);
                    int j = 0;
                    while (j < shipLines.length) {
                        MInOutLine shipLine = shipLines[j];
                        if (order.isOrderLine(shipLine.getC_OrderLine_ID()) && !shipLine.isInvoiced()) {
                            this.createLine(order, ship, shipLine, dateInvoiced);
                        }
                        ++j;
                    }
                    this.completeInvoice();
                }
                ++i;
            }
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ = ").append(this.m_created);
        return msgreturn.toString();
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine, Timestamp dateInvoiced) {
        if (this.m_invoice == null) {
            try {
                if (this.m_savepoint != null) {
                    Trx.get((String)this.get_TrxName(), (boolean)false).releaseSavepoint(this.m_savepoint);
                }
                this.m_savepoint = Trx.get((String)this.get_TrxName(), (boolean)false).setSavepoint(null);
            }
            catch (SQLException e) {
                throw new AdempiereException((Throwable)e);
            }
            this.m_invoice = new MInvoice(order, 0, dateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError"));
            }
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID()) {
            MDocType dt = MDocType.get((Properties)this.getCtx(), (int)ship.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get((Properties)this.getCtx(), (int)order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat((int)15, (Language)Language.getLanguage((String)AD_Language));
            StringBuilder reference = new StringBuilder().append(dt.getPrintName(this.m_bp.getAD_Language())).append(": ").append(ship.getDocumentNo()).append(" - ").append(format.format(ship.getMovementDate()));
            this.m_ship = ship;
            MInvoiceLine line = new MInvoiceLine(this.m_invoice);
            line.setIsDescription(true);
            line.setDescription(reference.toString());
            line.setLine(this.m_line + sLine.getLine() - 2);
            if (!line.save()) {
                throw new IllegalStateException(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError"));
            }
            if (order.getBill_Location_ID() != ship.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation((Properties)this.getCtx(), (int)ship.getC_BPartner_Location_ID(), null);
                line = new MInvoiceLine(this.m_invoice);
                line.setIsDescription(true);
                line.setDescription(addr.toString());
                line.setLine(this.m_line + sLine.getLine() - 1);
                if (!line.save()) {
                    throw new IllegalStateException(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError"));
                }
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setShipLine(sLine);
        if (sLine.sameOrderLineUOM()) {
            line.setQtyEntered(sLine.getQtyEntered());
        } else {
            line.setQtyEntered(sLine.getMovementQty());
        }
        line.setQtyInvoiced(sLine.getMovementQty());
        line.setLine(this.m_line + sLine.getLine());
        if (!line.save()) {
            throw new IllegalStateException(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError"));
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError"));
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(line.toString());
        }
    }

    private void completeInvoice() {
        MOrder order = new MOrder(this.getCtx(), this.m_invoice.getC_Order_ID(), this.get_TrxName());
        if (order != null) {
            this.m_invoice.setPaymentRule(order.getPaymentRule());
            MPaymentTerm paymentTerm = new MPaymentTerm(this.getCtx(), order.getC_PaymentTerm_ID(), this.get_TrxName());
            if (paymentTerm.get_ValueAsBoolean("IsPaymentTermsJP")) {
                MPaymentTerm[] paymentTerms = JPierePaymentTerms.getPaymentTerms(this.getCtx(), this.m_invoice.getC_BPartner_ID());
                Timestamp dateAcct = this.m_invoice.getDateAcct();
                String dateString = new SimpleDateFormat("dd").format(dateAcct);
                Integer dateInt = Integer.valueOf(dateString);
                int i = 0;
                while (i < paymentTerms.length) {
                    int FixMonthCutoff = paymentTerms[i].getFixMonthCutoff();
                    if (dateInt < FixMonthCutoff) {
                        this.m_invoice.setC_PaymentTerm_ID(paymentTerms[i].get_ID());
                        break;
                    }
                    ++i;
                }
            } else {
                this.m_invoice.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
            }
            this.m_invoice.saveEx();
            this.m_invoice.load(this.m_invoice.get_TrxName(), new String[0]);
            MOrderPaySchedule[] opss = MOrderPaySchedule.getOrderPaySchedule((Properties)this.getCtx(), (int)order.getC_Order_ID(), (int)0, (String)this.get_TrxName());
            MInvoicePaySchedule[] ipss = MInvoicePaySchedule.getInvoicePaySchedule((Properties)this.getCtx(), (int)this.m_invoice.getC_Invoice_ID(), (int)0, (String)this.get_TrxName());
            if (ipss.length == 0 && opss.length > 0) {
                BigDecimal ogt = order.getGrandTotal();
                BigDecimal igt = this.m_invoice.getGrandTotal();
                BigDecimal percent = Env.ONE;
                if (ogt.compareTo(igt) != 0) {
                    percent = igt.divide(ogt, 10, RoundingMode.HALF_UP);
                }
                MCurrency cur = MCurrency.get((Properties)order.getCtx(), (int)order.getC_Currency_ID());
                int scale = cur.getStdPrecision();
                MOrderPaySchedule[] mOrderPayScheduleArray = opss;
                int n = opss.length;
                int n2 = 0;
                while (n2 < n) {
                    MOrderPaySchedule ops = mOrderPayScheduleArray[n2];
                    MInvoicePaySchedule ips = new MInvoicePaySchedule(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)ops, (PO)ips);
                    if (percent != Env.ONE) {
                        BigDecimal propDueAmt = ops.getDueAmt().multiply(percent);
                        if (propDueAmt.scale() > scale) {
                            propDueAmt = propDueAmt.setScale(scale, RoundingMode.HALF_UP);
                        }
                        ips.setDueAmt(propDueAmt);
                    }
                    ips.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
                    ips.setAD_Org_ID(ops.getAD_Org_ID());
                    ips.setProcessing(ops.isProcessing());
                    ips.setIsActive(ops.isActive());
                    ips.saveEx();
                    ++n2;
                }
                this.m_invoice.validatePaySchedule();
                this.m_invoice.saveEx();
            }
            if (!this.p_DocAction.equals("CO")) {
                this.p_DocAction = "PR";
            }
            if (!this.m_invoice.processIt(this.p_DocAction)) {
                this.log.warning("completeInvoice - failed: " + this.m_invoice);
                this.addBufferLog(0, null, null, "completeInvoice - failed: " + this.m_invoice, this.m_invoice.get_Table_ID(), this.m_invoice.getC_Invoice_ID());
                throw new IllegalStateException(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessFailed")) + " " + this.m_invoice + " - " + this.m_invoice.getProcessMsg());
            }
            this.m_invoice.saveEx();
            String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@InvoiceProcessed@ " + this.m_invoice.getDocumentNo()));
            this.addBufferLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, message, this.m_invoice.get_Table_ID(), this.m_invoice.getC_Invoice_ID());
            ++this.m_created;
        }
        this.m_invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }
}

