/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MInvValCal;
import jpiere.base.plugin.org.adempiere.model.MInvValCalLine;
import jpiere.base.plugin.org.adempiere.model.MInvValCalLog;
import jpiere.base.plugin.org.adempiere.model.MInvValProfile;
import jpiere.base.plugin.util.JPiereInvValUtil;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class DefaultInventoryValuationCalculate
extends SvrProcess {
    private MInvValProfile m_InvValProfile = null;
    private MInvValCal m_InvValCal = null;
    private MInvValCalLine[] lines = null;
    private MCurrency m_Currency = null;
    private LinkedHashMap<Integer, BigDecimal> map_Product_Qty_LastDateValue = null;
    private MPriceList m_PriceList = null;
    private MPriceListVersion m_PriceListVersionOfLastDateValue = null;
    private MPriceListVersion m_PriceListVersionOfDateValue = null;
    int Record_ID = 0;

    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
        if (this.Record_ID > 0) {
            this.m_InvValCal = new MInvValCal(this.getCtx(), this.Record_ID, null);
            this.m_InvValProfile = MInvValProfile.get(this.getCtx(), this.m_InvValCal.getJP_InvValProfile_ID());
            this.lines = this.m_InvValCal.getLines();
            this.m_Currency = MCurrency.get((Properties)this.getCtx(), (int)this.m_InvValCal.getC_Currency_ID());
            if (this.m_InvValProfile.getM_PriceList_ID() > 0) {
                this.m_PriceList = new MPriceList(this.getCtx(), this.m_InvValProfile.getM_PriceList_ID(), this.get_TrxName());
            }
            if (this.m_PriceList != null && this.m_InvValCal.getJP_LastDateValue() != null) {
                this.m_PriceListVersionOfLastDateValue = JPiereInvValUtil.getPriceListVersion(this.getCtx(), this.m_PriceList.getM_PriceList_ID(), this.m_InvValCal.getJP_LastDateValue(), this.get_TrxName());
            }
            StringBuilder DeleteSQL = new StringBuilder("DELETE FROM JP_InvValCalLog WHERE JP_InvValCalLine_ID = ?");
            CPreparedStatement pstmt = null;
            Object rs = null;
            int i = 0;
            while (i < this.lines.length) {
                try {
                    try {
                        pstmt = DB.prepareStatement((String)DeleteSQL.toString(), (String)this.get_TrxName());
                        pstmt.setInt(1, this.lines[i].get_ID());
                        pstmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, DeleteSQL.toString(), (Throwable)e);
                        throw new DBException(e, DeleteSQL.toString());
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                ++i;
            }
        } else {
            this.log.log(Level.SEVERE, "Record_ID <= 0 ");
        }
    }

    protected String doIt() throws Exception {
        if (this.m_InvValProfile.getCostingMethod().equals("R")) {
            if (this.m_PriceList != null && this.m_InvValCal.getDateValue() != null) {
                this.m_PriceListVersionOfDateValue = JPiereInvValUtil.getPriceListVersion(this.getCtx(), this.m_PriceList.getM_PriceList_ID(), this.m_InvValCal.getDateValue(), this.get_TrxName());
            }
            if (this.m_PriceListVersionOfDateValue == null) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DateValue_PriceListVersion"));
            }
        }
        if (this.m_InvValCal.getJP_LastDateValue() != null && (this.m_InvValProfile.getCostingMethod().equals("A") || this.m_InvValProfile.getCostingMethod().equals("I"))) {
            this.map_Product_Qty_LastDateValue = JPiereInvValUtil.getAllQtyBookFromStockOrg(this.getCtx(), this.m_InvValCal.getJP_LastDateValue(), this.m_InvValProfile.getOrgs(), " p.M_Product_Category_ID, p.Value");
        }
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i].getCostingMethod().equals("F")) {
                this.calculate_Fifo(this.lines[i]);
            } else if (this.lines[i].getCostingMethod().equals("L")) {
                this.calculate_Lifo(this.lines[i]);
            } else if (this.lines[i].getCostingMethod().equals("p")) {
                this.calculate_LastPO(this.lines[i]);
            } else if (this.lines[i].getCostingMethod().equals("i")) {
                this.calculate_LastInvoice(this.lines[i]);
            } else if (this.lines[i].getCostingMethod().equals("A")) {
                this.calculate_AveragePO(this.lines[i]);
            } else if (this.lines[i].getCostingMethod().equals("I")) {
                this.calculate_AverageInvoice(this.lines[i]);
            } else if (this.lines[i].getCostingMethod().equals("R")) {
                this.calculate_RetailInventoryMethod(this.lines[i]);
            } else {
                if (this.lines[i].getCostingMethod().equals("S")) {
                    return Msg.getMsg((Properties)this.getCtx(), (String)"JP_Can_Not_Calculate_Costing_Method");
                }
                return Msg.getMsg((Properties)this.getCtx(), (String)"JP_Can_Not_Calculate_Costing_Method");
            }
            ++i;
        }
        BigDecimal totalLines = JPiereInvValUtil.calculateTotalLines(this.getCtx(), "JP_InvValCalLine", "JP_InvValCal_ID", this.Record_ID, this.get_TrxName());
        if (totalLines == null) {
            totalLines = Env.ZERO;
        }
        totalLines = totalLines.setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP);
        this.m_InvValCal.setTotalLines(totalLines);
        this.m_InvValCal.saveEx(this.get_TrxName());
        return String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"TotalLines")) + " = " + totalLines;
    }

    private void calculate_Fifo(MInvValCalLine line) {
        BigDecimal qtyBook = line.getQtyBook().abs();
        MInOutLine[] ioLines = JPiereInvValUtil.getInOutLines(this.getCtx(), line.getM_Product_ID(), this.m_InvValCal.getJP_LastDateValue(), this.m_InvValCal.getDateValue(), this.m_InvValProfile.getOrgs(), "io.MovementDate DESC, io.DocumentNo DESC, io.M_InOut_ID DESC, iol.Line DESC, iol.M_InOutLine_ID DESC");
        int lineNo = 1;
        MMatchPO[] matchPos = null;
        MMatchInv[] matchInvs = null;
        int i = 0;
        while (i < ioLines.length) {
            block42: {
                BigDecimal rate;
                MInvValCalLog log;
                int j;
                block44: {
                    block43: {
                        if (ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMR") && ioLines[i].getMovementQty().compareTo(Env.ZERO) <= 0 || ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMS")) break block42;
                        matchPos = null;
                        matchInvs = null;
                        if (!this.m_InvValProfile.getJP_ApplyAmtList().equals("PO")) break block43;
                        matchPos = JPiereInvValUtil.getMatchPOs(this.getCtx(), ioLines[i].getM_InOutLine_ID(), " DateAcct DESC, M_MatchPO_ID DESC", this.get_TrxName());
                        if (matchPos != null && matchPos.length >= 1) break block44;
                        break block42;
                    }
                    if (!this.m_InvValProfile.getJP_ApplyAmtList().equals("PI")) break;
                    matchInvs = JPiereInvValUtil.getMatchInvs(this.getCtx(), ioLines[i].getM_InOutLine_ID(), " DateAcct DESC, M_MatchInv_ID DESC", this.get_TrxName());
                    if (matchInvs == null || matchInvs.length < 1) break block42;
                }
                if (this.m_InvValProfile.getJP_ApplyAmtList().equals("PO")) {
                    I_C_OrderLine orderLine = null;
                    MOrder order = null;
                    j = 0;
                    while (j < matchPos.length) {
                        if (matchPos[j].getDateAcct().compareTo(this.m_InvValCal.getDateValue()) <= 0 && (orderLine = matchPos[j].getC_OrderLine()).getQtyOrdered().compareTo(Env.ZERO) != 0 && ((order = JPiereInvValUtil.getMOrder(this.getCtx(), orderLine.getC_Order_ID())).getDocStatus().equals("CO") || order.getDocStatus().equals("CL"))) {
                            log = new MInvValCalLog(line);
                            log.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                            log.setLine(lineNo * 10);
                            log.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                            log.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                            log.setMovementType(ioLines[i].getM_InOut().getMovementType());
                            log.setM_MatchPO_ID(matchPos[j].get_ID());
                            log.setQty(matchPos[j].getQty());
                            JPiereInvValUtil.copyInfoFromOrderLineToLog(log, orderLine);
                            log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                            if (orderLine.getC_Currency_ID() != this.m_InvValCal.getC_Currency_ID()) {
                                rate = MConversionRate.getRate((int)orderLine.getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (Timestamp)orderLine.getDateOrdered(), (int)orderLine.getC_Order().getC_ConversionType_ID(), (int)orderLine.getAD_Client_ID(), (int)orderLine.getAD_Org_ID());
                                if (rate == null) {
                                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)MConversionRateUtil.getErrorMessage((Properties)this.getCtx(), (String)"ErrorConvertingCurrencyToBaseCurrency", (int)orderLine.getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (int)this.m_InvValProfile.getC_ConversionType_ID(), (Timestamp)this.m_InvValCal.getDateValue(), (String)this.get_TrxName())));
                                }
                                log.setMultiplyRate(rate);
                            } else {
                                log.setMultiplyRate(Env.ONE);
                            }
                            log.setJP_ExchangedAmt(log.getLineNetAmt().multiply(log.getMultiplyRate()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            if (log.isTaxIncluded()) {
                                log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt().subtract(log.calculateTax("PO")).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            } else {
                                log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt());
                            }
                            log.setJP_ExchangedPriceActual(log.getJP_ExchangedNoTaxAmt().divide(log.getQtyOrdered(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            if (qtyBook.compareTo(log.getQty()) >= 0) {
                                log.setJP_ApplyQty(log.getQty());
                                if (log.getQty().compareTo(log.getQtyOrdered()) == 0) {
                                    log.setJP_ApplyAmt(log.getJP_ExchangedNoTaxAmt());
                                } else {
                                    log.setJP_ApplyAmt(log.getJP_ExchangedPriceActual().multiply(log.getQty()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                                }
                                qtyBook = qtyBook.subtract(log.getQty());
                            } else {
                                log.setJP_ApplyQty(qtyBook);
                                log.setJP_ApplyAmt(qtyBook.multiply(log.getJP_ExchangedPriceActual()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                                qtyBook = Env.ZERO;
                            }
                            log.saveEx(this.get_TrxName());
                            ++lineNo;
                            if (qtyBook.signum() <= 0) break;
                        }
                        ++j;
                    }
                    if (qtyBook.signum() <= 0) break;
                } else if (this.m_InvValProfile.getJP_ApplyAmtList().equals("PI")) {
                    I_C_InvoiceLine invoiceLine = null;
                    MInvoice invoice = null;
                    j = 0;
                    while (j < matchInvs.length) {
                        if (matchInvs[j].getDateAcct().compareTo(this.m_InvValCal.getDateValue()) <= 0 && (invoiceLine = matchInvs[j].getC_InvoiceLine()).getQtyInvoiced().compareTo(Env.ZERO) != 0 && ((invoice = MInvoice.get((Properties)this.getCtx(), (int)invoiceLine.getC_Invoice_ID())).getDocStatus().equals("CO") || invoice.getDocStatus().equals("CL"))) {
                            log = new MInvValCalLog(line);
                            log.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                            log.setLine(lineNo * 10);
                            log.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                            log.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                            log.setMovementType(ioLines[i].getM_InOut().getMovementType());
                            log.setM_MatchInv_ID(matchInvs[j].get_ID());
                            log.setQty(matchInvs[j].getQty());
                            invoiceLine = matchInvs[j].getC_InvoiceLine();
                            JPiereInvValUtil.copyInfoFromInvoiceLineToLog(log, invoiceLine);
                            log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                            if (invoiceLine.getC_Invoice().getC_Currency_ID() != this.m_InvValCal.getC_Currency_ID()) {
                                rate = MConversionRate.getRate((int)invoiceLine.getC_Invoice().getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (Timestamp)invoiceLine.getC_Invoice().getDateOrdered(), (int)invoiceLine.getC_Invoice().getC_ConversionType_ID(), (int)invoiceLine.getAD_Client_ID(), (int)invoiceLine.getAD_Org_ID());
                                if (rate == null) {
                                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)MConversionRateUtil.getErrorMessage((Properties)this.getCtx(), (String)"ErrorConvertingCurrencyToBaseCurrency", (int)invoiceLine.getC_Invoice().getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (int)this.m_InvValProfile.getC_ConversionType_ID(), (Timestamp)this.m_InvValCal.getDateValue(), (String)this.get_TrxName())));
                                }
                                log.setMultiplyRate(rate);
                            } else {
                                log.setMultiplyRate(Env.ONE);
                            }
                            log.setJP_ExchangedAmt(log.getLineNetAmt().multiply(log.getMultiplyRate()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            if (log.isTaxIncluded()) {
                                log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt().subtract(log.calculateTax("PI")).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            } else {
                                log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt());
                            }
                            log.setJP_ExchangedPriceActual(log.getJP_ExchangedNoTaxAmt().divide(log.getQtyInvoiced(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            if (qtyBook.compareTo(log.getQty()) >= 0) {
                                log.setJP_ApplyQty(log.getQty());
                                if (log.getQty().compareTo(log.getQtyOrdered()) == 0) {
                                    log.setJP_ApplyAmt(log.getJP_ExchangedNoTaxAmt());
                                } else {
                                    log.setJP_ApplyAmt(log.getJP_ExchangedPriceActual().multiply(log.getQty()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                                }
                                qtyBook = qtyBook.subtract(log.getQty());
                            } else {
                                log.setJP_ApplyQty(qtyBook);
                                log.setJP_ApplyAmt(qtyBook.multiply(log.getJP_ExchangedPriceActual()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                                qtyBook = Env.ZERO;
                            }
                            log.saveEx(this.get_TrxName());
                            ++lineNo;
                            if (qtyBook.signum() <= 0) break;
                        }
                        ++j;
                    }
                    if (qtyBook.signum() <= 0) break;
                } else {
                    MInvValCalLog log2 = new MInvValCalLog(line);
                    log2.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                    log2.setLine(lineNo * 10);
                    log2.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                    log2.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                    log2.setMovementType(ioLines[i].getM_InOut().getMovementType());
                    log2.setDescription("Can not Calculate");
                    log2.saveEx(this.get_TrxName());
                    return;
                }
            }
            ++i;
        }
        if (qtyBook.signum() > 0) {
            MInvValCalLog log = new MInvValCalLog(line);
            log.setLine(lineNo * 10);
            log.setC_Currency_ID(this.m_InvValCal.getC_Currency_ID());
            log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
            log.setJP_ApplyQty(qtyBook);
            MInvValCalLine beginInvValCalLine = MInvValCalLine.getBeginInvValCalLine(line);
            if (beginInvValCalLine != null) {
                line.setJP_BeginInvValCalLine_ID(beginInvValCalLine.getJP_InvValCalLine_ID());
                log.setJP_ExchangedPriceActual(beginInvValCalLine.getJP_InvValAmt().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                log.setJP_ApplyAmt(qtyBook.multiply(beginInvValCalLine.getJP_InvValAmt().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP)));
                log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BeginInvValCalLine_ID"));
                log.setJP_BeginInvValCalLine_ID(beginInvValCalLine.getJP_InvValCalLine_ID());
            } else {
                MProductPrice m_ProductPrice = null;
                if (this.m_PriceListVersionOfLastDateValue != null) {
                    m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)this.m_PriceListVersionOfLastDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
                }
                if (m_ProductPrice != null) {
                    log.setJP_ExchangedPriceActual(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                    log.setJP_ApplyAmt(qtyBook.multiply(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP)));
                    log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID") + " : " + this.m_PriceList.getName() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_Version_ID") + " : " + this.m_PriceListVersionOfLastDateValue.getName());
                } else {
                    log.setJP_ExchangedPriceActual(line.getCurrentCostPrice().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                    log.setJP_ApplyAmt(qtyBook.multiply(line.getCurrentCostPrice()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                    log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"CurrentCostPrice"));
                }
            }
            log.setIsTaxIncluded(false);
            log.saveEx(this.get_TrxName());
        }
        BigDecimal JP_InvValTotalAmt = JPiereInvValUtil.calculateInvValTotalAmt(this.getCtx(), line.get_ID(), this.get_TrxName());
        JP_InvValTotalAmt = JP_InvValTotalAmt.setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP);
        if (line.getQtyBook().compareTo(Env.ZERO) >= 0) {
            line.setJP_InvValTotalAmt(JP_InvValTotalAmt);
            if (JP_InvValTotalAmt.compareTo(Env.ZERO) == 0) {
                line.setJP_InvValAmt(Env.ZERO);
            } else {
                line.setJP_InvValAmt(JP_InvValTotalAmt.divide(line.getQtyBook(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
            }
        } else if (JP_InvValTotalAmt.compareTo(Env.ZERO) == 0) {
            line.setJP_InvValTotalAmt(Env.ZERO);
            line.setJP_InvValAmt(Env.ZERO);
        } else {
            line.setJP_InvValTotalAmt(JP_InvValTotalAmt.negate());
            line.setJP_InvValAmt(JP_InvValTotalAmt.divide(line.getQtyBook().abs(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        line.saveEx(this.get_TrxName());
    }

    private void calculate_Lifo(MInvValCalLine line) {
        BigDecimal qtyBook = line.getQtyBook().abs();
        MInOutLine[] ioLines = JPiereInvValUtil.getInOutLines(this.getCtx(), line.getM_Product_ID(), this.m_InvValCal.getJP_LastDateValue(), this.m_InvValCal.getDateValue(), this.m_InvValProfile.getOrgs(), "io.MovementDate ASC, io.DocumentNo ASC, io.M_InOut_ID ASC, iol.Line ASC, iol.M_InOutLine_ID ASC");
        int lineNo = 1;
        int i = 0;
        while (i < ioLines.length) {
            if (!(ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMR") && ioLines[i].getMovementQty().compareTo(Env.ZERO) <= 0 || ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMS"))) {
                BigDecimal rate;
                MInvValCalLog log;
                int j;
                if (this.m_InvValProfile.getJP_ApplyAmtList().equals("PO")) {
                    MMatchPO[] matchPos = JPiereInvValUtil.getMatchPOs(this.getCtx(), ioLines[i].getM_InOutLine_ID(), " DateAcct DESC, M_MatchPO_ID DESC", this.get_TrxName());
                    I_C_OrderLine orderLine = null;
                    MOrder order = null;
                    j = 0;
                    while (j < matchPos.length) {
                        if (matchPos[j].getDateAcct().compareTo(this.m_InvValCal.getDateValue()) <= 0 && (orderLine = matchPos[j].getC_OrderLine()).getQtyOrdered().compareTo(Env.ZERO) != 0 && ((order = JPiereInvValUtil.getMOrder(this.getCtx(), orderLine.getC_Order_ID())).getDocStatus().equals("CO") || order.getDocStatus().equals("CL"))) {
                            log = new MInvValCalLog(line);
                            log.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                            log.setLine(lineNo * 10);
                            log.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                            log.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                            log.setMovementType(ioLines[i].getM_InOut().getMovementType());
                            log.setM_MatchPO_ID(matchPos[j].get_ID());
                            log.setQty(matchPos[j].getQty());
                            JPiereInvValUtil.copyInfoFromOrderLineToLog(log, orderLine);
                            log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                            if (orderLine.getC_Currency_ID() != this.m_InvValCal.getC_Currency_ID()) {
                                rate = MConversionRate.getRate((int)orderLine.getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (Timestamp)orderLine.getDateOrdered(), (int)orderLine.getC_Order().getC_ConversionType_ID(), (int)orderLine.getAD_Client_ID(), (int)orderLine.getAD_Org_ID());
                                if (rate == null) {
                                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)MConversionRateUtil.getErrorMessage((Properties)this.getCtx(), (String)"ErrorConvertingCurrencyToBaseCurrency", (int)orderLine.getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (int)this.m_InvValProfile.getC_ConversionType_ID(), (Timestamp)this.m_InvValCal.getDateValue(), (String)this.get_TrxName())));
                                }
                                log.setMultiplyRate(rate);
                            } else {
                                log.setMultiplyRate(Env.ONE);
                            }
                            log.setJP_ExchangedAmt(log.getLineNetAmt().multiply(log.getMultiplyRate()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            if (log.isTaxIncluded()) {
                                log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt().subtract(log.calculateTax("PO")).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            } else {
                                log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt());
                            }
                            log.setJP_ExchangedPriceActual(log.getJP_ExchangedNoTaxAmt().divide(log.getQtyOrdered(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            if (qtyBook.compareTo(log.getQty()) >= 0) {
                                log.setJP_ApplyQty(log.getQty());
                                if (log.getQty().compareTo(log.getQtyOrdered()) == 0) {
                                    log.setJP_ApplyAmt(log.getJP_ExchangedNoTaxAmt());
                                } else {
                                    log.setJP_ApplyAmt(log.getJP_ExchangedPriceActual().multiply(log.getQty()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                                }
                                qtyBook = qtyBook.subtract(log.getQty());
                            } else {
                                log.setJP_ApplyQty(qtyBook);
                                log.setJP_ApplyAmt(qtyBook.multiply(log.getJP_ExchangedPriceActual()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                                qtyBook = Env.ZERO;
                            }
                            log.saveEx(this.get_TrxName());
                            ++lineNo;
                            if (qtyBook.signum() <= 0) break;
                        }
                        ++j;
                    }
                    if (qtyBook.signum() <= 0) break;
                } else if (this.m_InvValProfile.getJP_ApplyAmtList().equals("PI")) {
                    MMatchInv[] matchInvs = JPiereInvValUtil.getMatchInvs(this.getCtx(), ioLines[i].getM_InOutLine_ID(), " DateAcct DESC, M_MatchInv_ID DESC", this.get_TrxName());
                    I_C_InvoiceLine invoiceLine = null;
                    MInvoice invoice = null;
                    j = 0;
                    while (j < matchInvs.length) {
                        if (matchInvs[j].getDateAcct().compareTo(this.m_InvValCal.getDateValue()) <= 0 && (invoiceLine = matchInvs[j].getC_InvoiceLine()).getQtyInvoiced().compareTo(Env.ZERO) != 0 && ((invoice = MInvoice.get((Properties)this.getCtx(), (int)invoiceLine.getC_Invoice_ID())).getDocStatus().equals("CO") || invoice.getDocStatus().equals("CL"))) {
                            log = new MInvValCalLog(line);
                            log.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                            log.setLine(lineNo * 10);
                            log.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                            log.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                            log.setMovementType(ioLines[i].getM_InOut().getMovementType());
                            log.setM_MatchInv_ID(matchInvs[j].get_ID());
                            log.setQty(matchInvs[j].getQty());
                            invoiceLine = matchInvs[j].getC_InvoiceLine();
                            JPiereInvValUtil.copyInfoFromInvoiceLineToLog(log, invoiceLine);
                            log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                            if (invoiceLine.getC_Invoice().getC_Currency_ID() != this.m_InvValCal.getC_Currency_ID()) {
                                rate = MConversionRate.getRate((int)invoiceLine.getC_Invoice().getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (Timestamp)invoiceLine.getC_Invoice().getDateOrdered(), (int)invoiceLine.getC_Invoice().getC_ConversionType_ID(), (int)invoiceLine.getAD_Client_ID(), (int)invoiceLine.getAD_Org_ID());
                                if (rate == null) {
                                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)MConversionRateUtil.getErrorMessage((Properties)this.getCtx(), (String)"ErrorConvertingCurrencyToBaseCurrency", (int)invoiceLine.getC_Invoice().getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (int)this.m_InvValProfile.getC_ConversionType_ID(), (Timestamp)this.m_InvValCal.getDateValue(), (String)this.get_TrxName())));
                                }
                                log.setMultiplyRate(rate);
                            } else {
                                log.setMultiplyRate(Env.ONE);
                            }
                            log.setJP_ExchangedAmt(log.getLineNetAmt().multiply(log.getMultiplyRate()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            if (log.isTaxIncluded()) {
                                log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt().subtract(log.calculateTax("PI")).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            } else {
                                log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt());
                            }
                            log.setJP_ExchangedPriceActual(log.getJP_ExchangedNoTaxAmt().divide(log.getQtyInvoiced(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            if (qtyBook.compareTo(log.getQty()) >= 0) {
                                log.setJP_ApplyQty(log.getQty());
                                if (log.getQty().compareTo(log.getQtyOrdered()) == 0) {
                                    log.setJP_ApplyAmt(log.getJP_ExchangedNoTaxAmt());
                                } else {
                                    log.setJP_ApplyAmt(log.getJP_ExchangedPriceActual().multiply(log.getQty()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                                }
                                qtyBook = qtyBook.subtract(log.getQty());
                            } else {
                                log.setJP_ApplyQty(qtyBook);
                                log.setJP_ApplyAmt(qtyBook.multiply(log.getJP_ExchangedPriceActual()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                                qtyBook = Env.ZERO;
                            }
                            log.saveEx(this.get_TrxName());
                            ++lineNo;
                            if (qtyBook.signum() <= 0) break;
                        }
                        ++j;
                    }
                    if (qtyBook.signum() <= 0) break;
                } else {
                    MInvValCalLog log2 = new MInvValCalLog(line);
                    log2.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                    log2.setLine(lineNo * 10);
                    log2.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                    log2.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                    log2.setMovementType(ioLines[i].getM_InOut().getMovementType());
                    log2.setDescription("Can not Calculate");
                    log2.saveEx(this.get_TrxName());
                    return;
                }
            }
            ++i;
        }
        if (qtyBook.signum() > 0) {
            MInvValCalLog log = new MInvValCalLog(line);
            log.setLine(lineNo * 10);
            log.setC_Currency_ID(this.m_InvValCal.getC_Currency_ID());
            log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
            log.setJP_ApplyQty(qtyBook);
            MInvValCalLine beginInvValCalLine = MInvValCalLine.getBeginInvValCalLine(line);
            if (beginInvValCalLine != null) {
                line.setJP_BeginInvValCalLine_ID(beginInvValCalLine.getJP_InvValCalLine_ID());
                log.setJP_ExchangedPriceActual(beginInvValCalLine.getJP_InvValAmt().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                log.setJP_ApplyAmt(qtyBook.multiply(beginInvValCalLine.getJP_InvValAmt().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP)));
                log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Cost")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BeginInvValCalLine_ID"));
                log.setJP_BeginInvValCalLine_ID(beginInvValCalLine.getJP_InvValCalLine_ID());
            } else {
                MProductPrice m_ProductPrice = null;
                if (this.m_PriceListVersionOfLastDateValue != null) {
                    m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)this.m_PriceListVersionOfLastDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
                }
                if (m_ProductPrice != null) {
                    log.setJP_ExchangedPriceActual(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                    log.setJP_ApplyAmt(qtyBook.multiply(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP)));
                    log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Cost")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID") + " : " + this.m_PriceList.getName() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_Version_ID") + " : " + this.m_PriceListVersionOfLastDateValue.getName());
                } else {
                    log.setJP_ExchangedPriceActual(line.getCurrentCostPrice().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                    log.setJP_ApplyAmt(qtyBook.multiply(line.getCurrentCostPrice()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                    log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Cost")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"CurrentCostPrice"));
                }
            }
            log.setIsTaxIncluded(false);
            log.saveEx(this.get_TrxName());
        }
        BigDecimal JP_InvValTotalAmt = JPiereInvValUtil.calculateInvValTotalAmt(this.getCtx(), line.get_ID(), this.get_TrxName());
        JP_InvValTotalAmt = JP_InvValTotalAmt.setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP);
        if (line.getQtyBook().compareTo(Env.ZERO) >= 0) {
            line.setJP_InvValTotalAmt(JP_InvValTotalAmt);
            if (JP_InvValTotalAmt.compareTo(Env.ZERO) == 0) {
                line.setJP_InvValAmt(Env.ZERO);
            } else {
                line.setJP_InvValAmt(JP_InvValTotalAmt.divide(line.getQtyBook(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
            }
        } else if (JP_InvValTotalAmt.compareTo(Env.ZERO) == 0) {
            line.setJP_InvValTotalAmt(Env.ZERO);
            line.setJP_InvValAmt(Env.ZERO);
        } else {
            line.setJP_InvValTotalAmt(JP_InvValTotalAmt.negate());
            line.setJP_InvValAmt(JP_InvValTotalAmt.divide(line.getQtyBook().abs(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        line.saveEx(this.get_TrxName());
    }

    private void calculate_LastPO(MInvValCalLine line) {
        BigDecimal qtyBook = line.getQtyBook().abs();
        MInOutLine[] ioLines = JPiereInvValUtil.getInOutLines(this.getCtx(), line.getM_Product_ID(), this.m_InvValCal.getJP_LastDateValue(), this.m_InvValCal.getDateValue(), this.m_InvValProfile.getOrgs(), "io.MovementDate DESC, io.DocumentNo DESC, io.M_InOut_ID DESC,  iol.Line DESC, iol.M_InOutLine_ID DESC");
        int lineNo = 10;
        BigDecimal JP_InvValAmt = Env.ZERO;
        int i = 0;
        while (i < ioLines.length) {
            MMatchPO[] matchPos;
            if (!(ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMR") && ioLines[i].getMovementQty().compareTo(Env.ZERO) <= 0 || ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMS") || (matchPos = JPiereInvValUtil.getMatchPOs(this.getCtx(), ioLines[i].getM_InOutLine_ID(), " DateAcct DESC, M_MatchPO_ID DESC", this.get_TrxName())).length <= 0)) {
                I_C_OrderLine orderLine = null;
                MOrder order = null;
                boolean isBreak = false;
                int j = 0;
                while (j < matchPos.length) {
                    if (matchPos[j].getDateAcct().compareTo(this.m_InvValCal.getDateValue()) <= 0 && (orderLine = matchPos[j].getC_OrderLine()).getQtyOrdered().compareTo(Env.ZERO) != 0 && ((order = JPiereInvValUtil.getMOrder(this.getCtx(), orderLine.getC_Order_ID())).getDocStatus().equals("CO") || order.getDocStatus().equals("CL")) && matchPos[j].getQty().compareTo(Env.ZERO) >= 0) {
                        MInvValCalLog log = new MInvValCalLog(line);
                        log.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                        log.setLine(lineNo);
                        log.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                        log.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                        log.setMovementType(ioLines[i].getM_InOut().getMovementType());
                        log.setM_MatchPO_ID(matchPos[0].get_ID());
                        log.setQty(matchPos[0].getQty());
                        orderLine = matchPos[0].getC_OrderLine();
                        JPiereInvValUtil.copyInfoFromOrderLineToLog(log, orderLine);
                        log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                        if (orderLine.getC_Currency_ID() != this.m_InvValCal.getC_Currency_ID()) {
                            BigDecimal rate = MConversionRate.getRate((int)orderLine.getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (Timestamp)orderLine.getDateOrdered(), (int)orderLine.getC_Order().getC_ConversionType_ID(), (int)orderLine.getAD_Client_ID(), (int)orderLine.getAD_Org_ID());
                            if (rate == null) {
                                throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)MConversionRateUtil.getErrorMessage((Properties)this.getCtx(), (String)"ErrorConvertingCurrencyToBaseCurrency", (int)orderLine.getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (int)this.m_InvValProfile.getC_ConversionType_ID(), (Timestamp)this.m_InvValCal.getDateValue(), (String)this.get_TrxName())));
                            }
                            log.setMultiplyRate(rate);
                        } else {
                            log.setMultiplyRate(Env.ONE);
                        }
                        log.setJP_ExchangedAmt(log.getLineNetAmt().multiply(log.getMultiplyRate()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        if (log.isTaxIncluded()) {
                            log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt().subtract(log.calculateTax("PO")).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        } else {
                            log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt());
                        }
                        log.setJP_ExchangedPriceActual(log.getJP_ExchangedNoTaxAmt().divide(log.getQtyOrdered(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        if (qtyBook.compareTo(log.getQty()) >= 0) {
                            log.setJP_ApplyQty(log.getQty());
                            if (log.getQty().compareTo(log.getQtyOrdered()) == 0) {
                                log.setJP_ApplyAmt(log.getJP_ExchangedNoTaxAmt());
                            } else {
                                log.setJP_ApplyAmt(log.getJP_ExchangedPriceActual().multiply(log.getQty()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            }
                            qtyBook = qtyBook.subtract(log.getQty());
                        } else {
                            log.setJP_ApplyQty(qtyBook);
                            log.setJP_ApplyAmt(qtyBook.multiply(log.getJP_ExchangedPriceActual()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            qtyBook = Env.ZERO;
                        }
                        log.saveEx(this.get_TrxName());
                        JP_InvValAmt = log.getJP_ExchangedPriceActual();
                        isBreak = true;
                        break;
                    }
                    ++j;
                }
                if (isBreak) break;
            }
            ++i;
        }
        if (JP_InvValAmt.compareTo(Env.ZERO) == 0) {
            line.setJP_InvValAmt(line.getCurrentCostPrice().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
        } else {
            line.setJP_InvValAmt(JP_InvValAmt);
        }
        line.setJP_InvValTotalAmt(line.getQtyBook().multiply(line.getJP_InvValAmt()).setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP));
        line.saveEx(this.get_TrxName());
    }

    private void calculate_LastInvoice(MInvValCalLine line) {
        BigDecimal qtyBook = line.getQtyBook().abs();
        MInOutLine[] ioLines = JPiereInvValUtil.getInOutLines(this.getCtx(), line.getM_Product_ID(), this.m_InvValCal.getJP_LastDateValue(), this.m_InvValCal.getDateValue(), this.m_InvValProfile.getOrgs(), "io.MovementDate DESC, io.DocumentNo DESC, io.M_InOut_ID DESC, iol.Line DESC, iol.M_InOutLine_ID DESC");
        int lineNo = 10;
        BigDecimal JP_InvValAmt = Env.ZERO;
        int i = 0;
        while (i < ioLines.length) {
            MMatchInv[] matchInvs;
            if (!(ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMR") && ioLines[i].getMovementQty().compareTo(Env.ZERO) <= 0 || ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMS") || (matchInvs = JPiereInvValUtil.getMatchInvs(this.getCtx(), ioLines[i].getM_InOutLine_ID(), " DateAcct DESC, M_MatchInv_ID DESC", this.get_TrxName())) == null || matchInvs.length < 1)) {
                I_C_InvoiceLine invoiceLine = null;
                MInvoice invoice = null;
                boolean isBreak = false;
                int j = 0;
                while (j < matchInvs.length) {
                    if (matchInvs[j].getDateAcct().compareTo(this.m_InvValCal.getDateValue()) <= 0 && (invoiceLine = matchInvs[j].getC_InvoiceLine()).getQtyInvoiced().compareTo(Env.ZERO) != 0 && ((invoice = MInvoice.get((Properties)this.getCtx(), (int)invoiceLine.getC_Invoice_ID())).getDocStatus().equals("CO") || invoice.getDocStatus().equals("CL")) && matchInvs[j].getQty().compareTo(Env.ZERO) >= 0) {
                        MInvValCalLog log = new MInvValCalLog(line);
                        log.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                        log.setLine(lineNo);
                        log.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                        log.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                        log.setMovementType(ioLines[i].getM_InOut().getMovementType());
                        log.setM_MatchInv_ID(matchInvs[j].get_ID());
                        log.setQty(matchInvs[j].getQty());
                        JPiereInvValUtil.copyInfoFromInvoiceLineToLog(log, invoiceLine);
                        log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                        if (invoiceLine.getC_Invoice().getC_Currency_ID() != this.m_InvValCal.getC_Currency_ID()) {
                            BigDecimal rate = MConversionRate.getRate((int)invoiceLine.getC_Invoice().getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (Timestamp)invoiceLine.getC_Invoice().getDateInvoiced(), (int)invoiceLine.getC_Invoice().getC_ConversionType_ID(), (int)invoiceLine.getAD_Client_ID(), (int)invoiceLine.getAD_Org_ID());
                            if (rate == null) {
                                throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)MConversionRateUtil.getErrorMessage((Properties)this.getCtx(), (String)"ErrorConvertingCurrencyToBaseCurrency", (int)invoiceLine.getC_Invoice().getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (int)this.m_InvValProfile.getC_ConversionType_ID(), (Timestamp)this.m_InvValCal.getDateValue(), (String)this.get_TrxName())));
                            }
                            log.setMultiplyRate(rate);
                        } else {
                            log.setMultiplyRate(Env.ONE);
                        }
                        log.setJP_ExchangedAmt(log.getLineNetAmt().multiply(log.getMultiplyRate()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        if (log.isTaxIncluded()) {
                            log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt().subtract(log.calculateTax("PI")).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        } else {
                            log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt());
                        }
                        log.setJP_ExchangedPriceActual(log.getJP_ExchangedNoTaxAmt().divide(log.getQtyInvoiced(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        if (qtyBook.compareTo(log.getQty()) >= 0) {
                            log.setJP_ApplyQty(log.getQty());
                            if (log.getQty().compareTo(log.getQtyOrdered()) == 0) {
                                log.setJP_ApplyAmt(log.getJP_ExchangedNoTaxAmt());
                            } else {
                                log.setJP_ApplyAmt(log.getJP_ExchangedPriceActual().multiply(log.getQty()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            }
                            qtyBook = qtyBook.subtract(log.getQty());
                        } else {
                            log.setJP_ApplyQty(qtyBook);
                            log.setJP_ApplyAmt(qtyBook.multiply(log.getJP_ExchangedPriceActual()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                            qtyBook = Env.ZERO;
                        }
                        log.saveEx(this.get_TrxName());
                        JP_InvValAmt = log.getJP_ExchangedPriceActual();
                        isBreak = true;
                        break;
                    }
                    ++j;
                }
                if (isBreak) break;
            }
            ++i;
        }
        if (JP_InvValAmt.compareTo(Env.ZERO) == 0) {
            line.setJP_InvValAmt(line.getCurrentCostPrice().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
        } else {
            line.setJP_InvValAmt(JP_InvValAmt);
        }
        line.setJP_InvValTotalAmt(line.getQtyBook().multiply(line.getJP_InvValAmt()).setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP));
        line.saveEx(this.get_TrxName());
    }

    private void calculate_AveragePO(MInvValCalLine line) {
        MInOutLine[] ioLines = JPiereInvValUtil.getInOutLines(this.getCtx(), line.getM_Product_ID(), this.m_InvValCal.getJP_LastDateValue(), this.m_InvValCal.getDateValue(), this.m_InvValProfile.getOrgs(), "io.MovementDate DESC, io.DocumentNo DESC, io.M_InOut_ID DESC, iol.Line DESC, iol.M_InOutLine_ID DESC");
        int lineNo = 1;
        MMatchPO[] matchPos = null;
        int i = 0;
        while (i < ioLines.length) {
            if (!(ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMR") && ioLines[i].getMovementQty().compareTo(Env.ZERO) <= 0 || ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMS") || (matchPos = JPiereInvValUtil.getMatchPOs(this.getCtx(), ioLines[i].getM_InOutLine_ID(), " DateAcct DESC, M_MatchPO_ID DESC", this.get_TrxName())) == null || matchPos.length < 1)) {
                I_C_OrderLine orderLine = null;
                MOrder order = null;
                int j = 0;
                while (j < matchPos.length) {
                    if (matchPos[j].getDateAcct().compareTo(this.m_InvValCal.getDateValue()) <= 0 && (orderLine = matchPos[j].getC_OrderLine()).getQtyOrdered().compareTo(Env.ZERO) != 0 && ((order = JPiereInvValUtil.getMOrder(this.getCtx(), orderLine.getC_Order_ID())).getDocStatus().equals("CO") || order.getDocStatus().equals("CL"))) {
                        MInvValCalLog log = new MInvValCalLog(line);
                        log.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                        log.setLine(lineNo * 10);
                        log.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                        log.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                        log.setMovementType(ioLines[i].getM_InOut().getMovementType());
                        log.setM_MatchPO_ID(matchPos[j].get_ID());
                        log.setQty(matchPos[j].getQty());
                        orderLine = matchPos[j].getC_OrderLine();
                        JPiereInvValUtil.copyInfoFromOrderLineToLog(log, orderLine);
                        log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                        if (orderLine.getC_Currency_ID() != this.m_InvValCal.getC_Currency_ID()) {
                            BigDecimal rate = MConversionRate.getRate((int)orderLine.getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (Timestamp)orderLine.getDateOrdered(), (int)orderLine.getC_Order().getC_ConversionType_ID(), (int)orderLine.getAD_Client_ID(), (int)orderLine.getAD_Org_ID());
                            if (rate == null) {
                                throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)MConversionRateUtil.getErrorMessage((Properties)this.getCtx(), (String)"ErrorConvertingCurrencyToBaseCurrency", (int)orderLine.getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (int)this.m_InvValProfile.getC_ConversionType_ID(), (Timestamp)this.m_InvValCal.getDateValue(), (String)this.get_TrxName())));
                            }
                            log.setMultiplyRate(rate);
                        } else {
                            log.setMultiplyRate(Env.ONE);
                        }
                        log.setJP_ExchangedAmt(log.getLineNetAmt().multiply(log.getMultiplyRate()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        if (log.isTaxIncluded()) {
                            log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt().subtract(log.calculateTax("PO")).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        } else {
                            log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt());
                        }
                        log.setJP_ExchangedPriceActual(log.getJP_ExchangedNoTaxAmt().divide(log.getQtyOrdered(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.setJP_ApplyQty(log.getQty());
                        log.setJP_ApplyAmt(log.getJP_ExchangedPriceActual().multiply(log.getQty()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.saveEx(this.get_TrxName());
                        ++lineNo;
                    }
                    ++j;
                }
            }
            ++i;
        }
        MInvValCalLine beginInvValCalLine = null;
        if (this.m_InvValProfile.getJP_TypeOfAverageCost().equals("GA")) {
            beginInvValCalLine = MInvValCalLine.getBeginInvValCalLine(line);
            if (beginInvValCalLine != null) {
                line.setJP_BeginInvValCalLine_ID(beginInvValCalLine.getJP_InvValCalLine_ID());
                MInvValCalLog log = new MInvValCalLog(line);
                log.setLine(lineNo * 10);
                log.setC_Currency_ID(this.m_InvValCal.getC_Currency_ID());
                log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                log.setJP_ExchangedPriceActual(beginInvValCalLine.getJP_InvValAmt().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                log.setJP_ApplyQty(beginInvValCalLine.getQtyBook());
                log.setJP_ApplyAmt(beginInvValCalLine.getJP_InvValTotalAmt().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ApplyQty")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BeginInvValCalLine_ID") + " , " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual") + " = " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BeginInvValCalLine_ID"));
                log.setJP_BeginInvValCalLine_ID(beginInvValCalLine.getJP_InvValCalLine_ID());
                log.saveEx(this.get_TrxName());
            } else if (this.map_Product_Qty_LastDateValue != null) {
                BigDecimal QtyBook;
                MProductPrice m_ProductPrice = null;
                if (this.m_PriceListVersionOfLastDateValue != null) {
                    m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)this.m_PriceListVersionOfLastDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
                }
                if ((QtyBook = this.map_Product_Qty_LastDateValue.get(line.getM_Product_ID())) != null) {
                    MInvValCalLog log = new MInvValCalLog(line);
                    log.setLine(lineNo * 10);
                    log.setC_Currency_ID(this.m_InvValCal.getC_Currency_ID());
                    log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                    if (m_ProductPrice != null) {
                        log.setJP_ExchangedPriceActual(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.setJP_ApplyAmt(QtyBook.multiply(m_ProductPrice.getPriceStd()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ApplyQty")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"QtyBook") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_LastDateValue") + " , " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual") + " = " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID") + " : " + this.m_PriceList.getName() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_Version_ID") + " : " + this.m_PriceListVersionOfLastDateValue.getName());
                    } else {
                        log.setJP_ExchangedPriceActual(line.getCurrentCostPrice().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.setJP_ApplyAmt(QtyBook.multiply(line.getCurrentCostPrice().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP)));
                        log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ApplyQty")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"QtyBook") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_LastDateValue") + " , " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual") + " = " + Msg.getElement((Properties)this.getCtx(), (String)"CurrentCostPrice"));
                    }
                    log.setJP_ApplyQty(QtyBook);
                    log.saveEx(this.get_TrxName());
                }
            }
        }
        BigDecimal JP_InvValTotalAmt = JPiereInvValUtil.calculateInvValTotalAmt(this.getCtx(), line.get_ID(), this.get_TrxName());
        JP_InvValTotalAmt = JP_InvValTotalAmt.setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP);
        BigDecimal JP_ApplyQty = JPiereInvValUtil.calculateApplyQty(this.getCtx(), line.get_ID(), this.get_TrxName());
        if (JP_ApplyQty.compareTo(Env.ZERO) == 0) {
            MPriceListVersion m_PriceListVersionOfDateValue = null;
            MProductPrice m_ProductPrice = null;
            if (this.m_PriceList != null && this.m_InvValCal.getDateValue() != null) {
                m_PriceListVersionOfDateValue = this.m_PriceList.getPriceListVersion(this.m_InvValCal.getDateValue());
            }
            if (m_PriceListVersionOfDateValue != null) {
                m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)m_PriceListVersionOfDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
            }
            if (m_ProductPrice != null) {
                line.setJP_InvValAmt(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
            } else if (beginInvValCalLine != null) {
                line.setJP_InvValAmt(beginInvValCalLine.getJP_InvValAmt());
            } else {
                if (this.m_PriceListVersionOfLastDateValue != null) {
                    m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)this.m_PriceListVersionOfLastDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
                }
                if (m_ProductPrice != null) {
                    line.setJP_InvValAmt(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                } else {
                    line.setJP_InvValAmt(line.getCurrentCostPrice());
                }
            }
        } else {
            line.setJP_InvValAmt(JP_InvValTotalAmt.divide(JP_ApplyQty, this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        if (line.getQtyBook().compareTo(Env.ZERO) == 0) {
            line.setJP_InvValTotalAmt(Env.ZERO);
        } else {
            line.setJP_InvValTotalAmt(line.getQtyBook().multiply(line.getJP_InvValAmt()).setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP));
        }
        line.saveEx(this.get_TrxName());
    }

    private void calculate_AverageInvoice(MInvValCalLine line) {
        MInOutLine[] ioLines = JPiereInvValUtil.getInOutLines(this.getCtx(), line.getM_Product_ID(), this.m_InvValCal.getJP_LastDateValue(), this.m_InvValCal.getDateValue(), this.m_InvValProfile.getOrgs(), "io.MovementDate DESC, io.DocumentNo DESC, io.M_InOut_ID DESC, iol.Line DESC, iol.M_InOutLine_ID DESC");
        int lineNo = 1;
        MMatchInv[] matchInvs = null;
        int i = 0;
        while (i < ioLines.length) {
            matchInvs = JPiereInvValUtil.getMatchInvs(this.getCtx(), ioLines[i].getM_InOutLine_ID(), " DateAcct DESC, M_MatchInv_ID DESC", this.get_TrxName());
            if (matchInvs != null && matchInvs.length >= 1) {
                I_C_InvoiceLine invoiceLine = null;
                MInvoice invoice = null;
                int j = 0;
                while (j < matchInvs.length) {
                    if (matchInvs[j].getDateAcct().compareTo(this.m_InvValCal.getDateValue()) <= 0 && (invoiceLine = matchInvs[j].getC_InvoiceLine()).getQtyInvoiced().compareTo(Env.ZERO) != 0 && ((invoice = MInvoice.get((Properties)this.getCtx(), (int)invoiceLine.getC_Invoice_ID())).getDocStatus().equals("CO") || invoice.getDocStatus().equals("CL"))) {
                        MInvValCalLog log = new MInvValCalLog(line);
                        log.setAD_Org_ID(ioLines[i].getAD_Org_ID());
                        log.setLine(lineNo * 10);
                        log.setM_InOutLine_ID(ioLines[i].getM_InOutLine_ID());
                        log.setMovementDate(ioLines[i].getM_InOut().getMovementDate());
                        log.setMovementType(ioLines[i].getM_InOut().getMovementType());
                        log.setM_MatchInv_ID(matchInvs[j].get_ID());
                        if (ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMR")) {
                            log.setQty(matchInvs[j].getQty());
                        } else if (ioLines[i].getParent().getC_DocType().getDocBaseType().equals("MMS")) {
                            log.setQty(matchInvs[j].getQty().negate());
                        }
                        JPiereInvValUtil.copyInfoFromInvoiceLineToLog(log, invoiceLine);
                        log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                        if (invoiceLine.getC_Invoice().getC_Currency_ID() != this.m_InvValCal.getC_Currency_ID()) {
                            BigDecimal rate = MConversionRate.getRate((int)invoiceLine.getC_Invoice().getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (Timestamp)invoiceLine.getC_Invoice().getDateOrdered(), (int)invoiceLine.getC_Invoice().getC_ConversionType_ID(), (int)invoiceLine.getAD_Client_ID(), (int)invoiceLine.getAD_Org_ID());
                            if (rate == null) {
                                throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)MConversionRateUtil.getErrorMessage((Properties)this.getCtx(), (String)"ErrorConvertingCurrencyToBaseCurrency", (int)invoiceLine.getC_Invoice().getC_Currency_ID(), (int)this.m_InvValCal.getC_Currency_ID(), (int)this.m_InvValProfile.getC_ConversionType_ID(), (Timestamp)this.m_InvValCal.getDateValue(), (String)this.get_TrxName())));
                            }
                            log.setMultiplyRate(rate);
                        } else {
                            log.setMultiplyRate(Env.ONE);
                        }
                        log.setJP_ExchangedAmt(log.getLineNetAmt().multiply(log.getMultiplyRate()).setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP));
                        if (log.isTaxIncluded()) {
                            log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt().subtract(log.calculateTax("PI")).setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP));
                        } else {
                            log.setJP_ExchangedNoTaxAmt(log.getJP_ExchangedAmt());
                        }
                        log.setJP_ExchangedPriceActual(log.getJP_ExchangedNoTaxAmt().divide(log.getQtyInvoiced(), this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.setJP_ApplyQty(log.getQty());
                        log.setJP_ApplyAmt(log.getJP_ExchangedPriceActual().multiply(log.getQty()).setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP));
                        log.saveEx(this.get_TrxName());
                        ++lineNo;
                    }
                    ++j;
                }
            }
            ++i;
        }
        MInvValCalLine beginInvValCalLine = null;
        if (this.m_InvValProfile.getJP_TypeOfAverageCost().equals("GA")) {
            beginInvValCalLine = MInvValCalLine.getBeginInvValCalLine(line);
            if (beginInvValCalLine != null) {
                line.setJP_BeginInvValCalLine_ID(beginInvValCalLine.getJP_InvValCalLine_ID());
                MInvValCalLog log = new MInvValCalLog(line);
                log.setLine(lineNo * 10);
                log.setC_Currency_ID(this.m_InvValCal.getC_Currency_ID());
                log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                log.setJP_ExchangedPriceActual(beginInvValCalLine.getJP_InvValAmt().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                log.setJP_ApplyQty(beginInvValCalLine.getQtyBook());
                log.setJP_ApplyAmt(beginInvValCalLine.getJP_InvValTotalAmt().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ApplyQty")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BeginInvValCalLine_ID") + " , " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual") + " = " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BeginInvValCalLine_ID"));
                log.setJP_BeginInvValCalLine_ID(beginInvValCalLine.getJP_InvValCalLine_ID());
                log.saveEx(this.get_TrxName());
            } else if (this.map_Product_Qty_LastDateValue != null) {
                BigDecimal QtyBook;
                MProductPrice m_ProductPrice = null;
                if (this.m_PriceListVersionOfLastDateValue != null) {
                    m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)this.m_PriceListVersionOfLastDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
                }
                if ((QtyBook = this.map_Product_Qty_LastDateValue.get(line.getM_Product_ID())) != null) {
                    MInvValCalLog log = new MInvValCalLog(line);
                    log.setLine(lineNo * 10);
                    log.setC_Currency_ID(this.m_InvValCal.getC_Currency_ID());
                    log.setJP_CurrencyTo_ID(this.m_InvValCal.getC_Currency_ID());
                    if (m_ProductPrice != null) {
                        log.setJP_ExchangedPriceActual(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.setJP_ApplyAmt(QtyBook.multiply(m_ProductPrice.getPriceStd()).setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ApplyQty")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"QtyBook") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_LastDateValue") + " , " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual") + " = " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID") + " : " + this.m_PriceList.getName() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_Version_ID") + " : " + this.m_PriceListVersionOfLastDateValue.getName());
                    } else {
                        log.setJP_ExchangedPriceActual(line.getCurrentCostPrice().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                        log.setJP_ApplyAmt(QtyBook.multiply(line.getCurrentCostPrice().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP)));
                        log.setDescription(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ApplyQty")) + " = " + Msg.getElement((Properties)this.getCtx(), (String)"QtyBook") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_LastDateValue") + " , " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ExchangedPriceActual") + " = " + Msg.getElement((Properties)this.getCtx(), (String)"CurrentCostPrice"));
                    }
                    log.setJP_ApplyQty(QtyBook);
                    log.saveEx(this.get_TrxName());
                }
            }
        }
        BigDecimal JP_InvValTotalAmt = JPiereInvValUtil.calculateInvValTotalAmt(this.getCtx(), line.get_ID(), this.get_TrxName());
        JP_InvValTotalAmt = JP_InvValTotalAmt.setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP);
        BigDecimal JP_ApplyQty = JPiereInvValUtil.calculateApplyQty(this.getCtx(), line.get_ID(), this.get_TrxName());
        if (JP_ApplyQty.compareTo(Env.ZERO) == 0) {
            MPriceListVersion m_PriceListVersionOfDateValue = null;
            MProductPrice m_ProductPrice = null;
            if (this.m_PriceList != null && this.m_InvValCal.getDateValue() != null) {
                m_PriceListVersionOfDateValue = this.m_PriceList.getPriceListVersion(this.m_InvValCal.getDateValue());
            }
            if (m_PriceListVersionOfDateValue != null) {
                m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)m_PriceListVersionOfDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
            }
            if (m_ProductPrice != null) {
                line.setJP_InvValAmt(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
            } else if (beginInvValCalLine != null) {
                line.setJP_InvValAmt(beginInvValCalLine.getJP_InvValAmt());
            } else {
                if (this.m_PriceListVersionOfLastDateValue != null) {
                    m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)this.m_PriceListVersionOfLastDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
                }
                if (m_ProductPrice != null) {
                    line.setJP_InvValAmt(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
                } else {
                    line.setJP_InvValAmt(line.getCurrentCostPrice());
                }
            }
        } else {
            line.setJP_InvValAmt(JP_InvValTotalAmt.divide(JP_ApplyQty, this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
        }
        if (line.getQtyBook().compareTo(Env.ZERO) == 0) {
            line.setJP_InvValTotalAmt(Env.ZERO);
        } else {
            line.setJP_InvValTotalAmt(line.getQtyBook().multiply(line.getJP_InvValAmt()).setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP));
        }
        line.saveEx(this.get_TrxName());
    }

    private void calculate_RetailInventoryMethod(MInvValCalLine line) {
        MProductPrice m_ProductPrice = null;
        if (this.m_PriceListVersionOfDateValue != null) {
            m_ProductPrice = MProductPrice.get((Properties)this.getCtx(), (int)this.m_PriceListVersionOfDateValue.getM_PriceList_Version_ID(), (int)line.getM_Product_ID(), (String)this.get_TrxName());
        }
        if (m_ProductPrice != null) {
            line.setJP_InvValAmt(m_ProductPrice.getPriceStd().setScale(this.m_Currency.getCostingPrecision(), RoundingMode.HALF_UP));
        } else {
            line.setJP_InvValAmt(line.getCurrentCostPrice());
        }
        if (line.getQtyBook().compareTo(Env.ZERO) == 0) {
            line.setJP_InvValTotalAmt(Env.ZERO);
        } else {
            line.setJP_InvValTotalAmt(line.getQtyBook().multiply(line.getJP_InvValAmt()).setScale(this.m_Currency.getStdPrecision(), RoundingMode.HALF_UP));
        }
        line.saveEx(this.get_TrxName());
    }
}

