/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MInvValAdjust;
import jpiere.base.plugin.org.adempiere.model.MInvValAdjustLine;
import jpiere.base.plugin.org.adempiere.model.MInvValProfile;
import jpiere.base.plugin.org.adempiere.model.MInventoryDiffQtyLog;
import jpiere.base.plugin.util.JPiereInvValUtil;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class DefaultInvValAdjustCalculate
extends SvrProcess {
    MInvValProfile m_InvValProfile = null;
    MInvValAdjust m_InvValAdjust = null;
    MInvValAdjustLine[] lines = null;
    int Record_ID = 0;

    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
        if (this.Record_ID > 0) {
            this.m_InvValAdjust = new MInvValAdjust(this.getCtx(), this.Record_ID, null);
            this.m_InvValProfile = MInvValProfile.get(this.getCtx(), this.m_InvValAdjust.getJP_InvValProfile_ID());
            this.lines = this.m_InvValAdjust.getLines();
        } else {
            this.log.log(Level.SEVERE, "Record_ID <= 0 ");
        }
    }

    protected String doIt() throws Exception {
        int AD_Org_ID = 0;
        int M_CostType_ID = this.m_InvValProfile.getC_AcctSchema().getM_CostType_ID();
        int C_AcctSchema_ID = this.m_InvValProfile.getC_AcctSchema_ID();
        MCostElement[] costElements = JPiereInvValUtil.getMaterialStandardCostElements(this.getCtx());
        int M_CostElement_ID = costElements[0].get_ID();
        MPriceListVersion plversion = this.getPriceListVersion(this.m_InvValProfile.getM_PriceList_ID(), this.m_InvValAdjust.getDateValue());
        MProductPrice[] pp = null;
        if (plversion != null) {
            pp = plversion.getProductPrice(true);
        }
        MCost m_Cost = null;
        BigDecimal currentCostPrice = Env.ZERO;
        BigDecimal QtyOnHand = Env.ZERO;
        BigDecimal DifferenceQty = Env.ZERO;
        int i = 0;
        while (i < this.lines.length) {
            AD_Org_ID = this.lines[i].getCostingLevel().equals("C") ? 0 : (this.lines[i].getCostingLevel().equals("B") ? 0 : (this.lines[i].getCostingLevel().equals("O") ? this.lines[i].getAD_OrgTrx_ID() : 0));
            if (pp != null) {
                int j = 0;
                while (j < pp.length) {
                    if (pp[j].getM_Product_ID() == this.lines[i].getM_Product_ID()) {
                        currentCostPrice = pp[j].getPriceStd();
                        break;
                    }
                    ++j;
                }
            }
            if (currentCostPrice.compareTo(Env.ZERO) == 0 && (m_Cost = MCost.get((Properties)this.getCtx(), (int)this.lines[i].getAD_Client_ID(), (int)AD_Org_ID, (int)this.lines[i].getM_Product_ID(), (int)M_CostType_ID, (int)C_AcctSchema_ID, (int)M_CostElement_ID, (int)this.lines[i].getM_AttributeSetInstance_ID(), (String)this.get_TrxName())) != null) {
                currentCostPrice = m_Cost.getCurrentCostPrice();
            }
            this.lines[i].setJP_InvValAmt(currentCostPrice);
            this.lines[i].setJP_InvValTotalAmt(this.lines[i].getQtyBook().multiply(currentCostPrice));
            this.lines[i].setDifferenceAmt(this.lines[i].getJP_InvValTotalAmt().subtract(this.lines[i].getAmtAcctBalance()));
            QtyOnHand = JPiereInvValUtil.getQtyBookFromStockOrg(this.getCtx(), this.m_InvValAdjust.getDateValue(), this.lines[i].getM_Product_ID(), this.lines[i].getAD_OrgTrx_ID());
            this.lines[i].setQtyOnHand(QtyOnHand);
            DifferenceQty = QtyOnHand.subtract(this.lines[i].getQtyBook());
            this.lines[i].setDifferenceQty(DifferenceQty);
            if (DifferenceQty.compareTo(Env.ZERO) == 0) {
                this.lines[i].setIsConfirmed(true);
                this.lines[i].saveEx(this.get_TrxName());
            } else {
                this.lines[i].saveEx(this.get_TrxName());
                StringBuilder DateValue = new StringBuilder(this.lines[i].getParent().getDateValue().toString());
                StringBuilder DateValue_24 = new StringBuilder("TO_DATE('").append(DateValue.substring(0, 10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS') + CAST('1Day' AS INTERVAL)");
                StringBuilder sqlBase = new StringBuilder("SELECT AD_Org_ID, M_Product_ID, M_InOutLine_ID, M_Transaction_ID").append(" ,MovementDate, DateAcct, MovementType, MovementQty").append(" FROM JP_InOutTransaction").append(" WHERE AD_Org_ID= " + this.lines[i].getAD_OrgTrx_ID() + " AND M_Product_ID =" + this.lines[i].getM_Product_ID()).append(" AND DocStatus IN ('CO', 'CL')");
                String sqlFutureDateAcct = String.valueOf(sqlBase.toString()) + " AND MovementDate < " + DateValue_24 + " AND DateAcct >= " + DateValue_24;
                int lineNo = this.createMInventoryDiffQtyLog(sqlFutureDateAcct, true, this.lines[i], 0);
                String sqlFutureMovementDate = String.valueOf(sqlBase.toString()) + " AND DateAcct < " + DateValue_24 + " AND MovementDate >= " + DateValue_24;
                this.createMInventoryDiffQtyLog(sqlFutureMovementDate, false, this.lines[i], lineNo);
                MInventoryDiffQtyLog[] diffLogs = this.lines[i].getDiffQtyLogs(true, "");
                BigDecimal JP_AdjustToAcctQty = Env.ZERO;
                int j = 0;
                while (j < diffLogs.length) {
                    JP_AdjustToAcctQty = JP_AdjustToAcctQty.add(diffLogs[j].getJP_AdjustToAcctQty());
                    ++j;
                }
                if (Env.ZERO.equals(JP_AdjustToAcctQty.add(this.lines[i].getDifferenceQty()))) {
                    this.lines[i].setIsConfirmed(true);
                    this.lines[i].saveEx(this.get_TrxName());
                }
            }
            currentCostPrice = Env.ZERO;
            QtyOnHand = Env.ZERO;
            DifferenceQty = Env.ZERO;
            ++i;
        }
        BigDecimal totalLines = JPiereInvValUtil.calculateTotalLines(this.getCtx(), "JP_InvValAdjustLine", "JP_InvValAdjust_ID", this.Record_ID, this.get_TrxName());
        BigDecimal diffAmt = JPiereInvValUtil.calculateTotals(this.getCtx(), "DifferenceAmt", "JP_InvValAdjustLine", "JP_InvValAdjust_ID", this.Record_ID, this.get_TrxName());
        this.m_InvValAdjust.setTotalLines(totalLines);
        this.m_InvValAdjust.setDifferenceAmt(diffAmt);
        this.m_InvValAdjust.saveEx(this.get_TrxName());
        return String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"TotalLines")) + " = " + totalLines;
    }

    private int createMInventoryDiffQtyLog(String sql, boolean IsFutureDateAcct, MInvValAdjustLine ivaLine, int lineNo) {
        block8: {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MInventoryDiffQtyLog diffLog = new MInventoryDiffQtyLog(this.getCtx(), 0, this.get_TrxName());
                        diffLog.setJP_InvValAdjustLine_ID(ivaLine.getJP_InvValAdjustLine_ID());
                        diffLog.setLine(lineNo += 10);
                        diffLog.setAD_Org_ID(ivaLine.getAD_Org_ID());
                        diffLog.setAD_OrgTrx_ID(rs.getInt(1));
                        diffLog.setM_Product_ID(rs.getInt(2));
                        diffLog.setM_InOutLine_ID(rs.getInt(3));
                        diffLog.setM_Transaction_ID(rs.getInt(4));
                        diffLog.setMovementDate(rs.getTimestamp(5));
                        diffLog.setDateAcct(rs.getTimestamp(6));
                        diffLog.setMovementType(rs.getString(7));
                        diffLog.setMovementQty(rs.getBigDecimal(8));
                        if (IsFutureDateAcct) {
                            diffLog.setJP_AdjustToAcctQty(rs.getBigDecimal(8).negate());
                        } else {
                            diffLog.setJP_AdjustToAcctQty(rs.getBigDecimal(8));
                        }
                        diffLog.saveEx(this.get_TrxName());
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return lineNo;
    }

    private MPriceListVersion getPriceListVersion(int M_PriceList_ID, Timestamp valid) {
        if (valid == null) {
            valid = new Timestamp(System.currentTimeMillis());
        }
        String whereClause = "M_PriceList_ID=? AND TRUNC(ValidFrom)=?";
        MPriceListVersion m_plv = (MPriceListVersion)new Query(this.getCtx(), "M_PriceList_Version", "M_PriceList_ID=? AND TRUNC(ValidFrom)=?", this.get_TrxName()).setParameters(new Object[]{M_PriceList_ID, valid}).setOnlyActiveRecords(true).first();
        return m_plv;
    }
}

