/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractCalender;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractPSInOutLine;
import jpiere.base.plugin.org.adempiere.model.MContractPSInvoiceLine;
import jpiere.base.plugin.org.adempiere.model.MContractPSLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractProcSchedule;
import jpiere.base.plugin.org.adempiere.process.AbstractContractProcess;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class DefaultContractProcessCreateSchedule
extends AbstractContractProcess {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        super.doIt();
        MContractCalender contractCalender = MContractCalender.get(this.getCtx(), this.m_ContractContent.getJP_ContractCalender_ID());
        if (this.m_ContractContent.getJP_ContractProcDate_To() == null) {
            String descriptionMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcDate_To");
            this.createContractLogDetail("ZZ", null, null, descriptionMsg);
            return "";
        }
        int JP_ContractProcPeriod_ID = this.getJP_ContractProctPeriod_ID();
        MContractProcPeriod firstContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_From());
        MContractProcPeriod endContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_To());
        MContractProcPeriod contractProcPeriod = null;
        boolean isOK = true;
        MContractLine[] lines = this.m_ContractContent.getLines();
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].checkPeriodContractInfo(false, true)) {
                String error = lines[i].getProcessMsg();
                this.createContractLogDetail("ZZ", lines[i], null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Line")) + " : " + lines[i].getLine() + "  " + error.toString());
                isOK = false;
            }
            ++i;
        }
        if (!isOK) {
            return "";
        }
        if (JP_ContractProcPeriod_ID == 0) {
            i = 1;
            do {
                contractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_From(), null, i);
                this.p_JP_ContractProcPeriod_ID = contractProcPeriod.getJP_ContractProcPeriod_ID();
                if (contractProcPeriod.getJP_ContractProcPeriod_ID() == firstContractProcPeriod.getJP_ContractProcPeriod_ID() && contractProcPeriod.getJP_ContractProcPeriod_ID() == endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                    isOK = this.createContractProcSchedule(contractProcPeriod, true, true);
                } else if (contractProcPeriod.getJP_ContractProcPeriod_ID() == firstContractProcPeriod.getJP_ContractProcPeriod_ID() && contractProcPeriod.getJP_ContractProcPeriod_ID() != endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                    isOK = this.createContractProcSchedule(contractProcPeriod, true, false);
                } else if (contractProcPeriod.getJP_ContractProcPeriod_ID() != firstContractProcPeriod.getJP_ContractProcPeriod_ID() && contractProcPeriod.getJP_ContractProcPeriod_ID() == endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                    isOK = this.createContractProcSchedule(contractProcPeriod, false, true);
                } else if (contractProcPeriod.getJP_ContractProcPeriod_ID() != firstContractProcPeriod.getJP_ContractProcPeriod_ID() && contractProcPeriod.getJP_ContractProcPeriod_ID() != endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                    isOK = this.createContractProcSchedule(contractProcPeriod, false, false);
                }
                ++i;
            } while (contractProcPeriod.getJP_ContractProcPeriod_ID() != endContractProcPeriod.getJP_ContractProcPeriod_ID());
        } else {
            contractProcPeriod = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
            if (contractProcPeriod.getJP_ContractProcPeriod_ID() == firstContractProcPeriod.getJP_ContractProcPeriod_ID() && contractProcPeriod.getJP_ContractProcPeriod_ID() == endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                isOK = this.createContractProcSchedule(contractProcPeriod, true, true);
            } else if (contractProcPeriod.getJP_ContractProcPeriod_ID() == firstContractProcPeriod.getJP_ContractProcPeriod_ID() && contractProcPeriod.getJP_ContractProcPeriod_ID() != endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                isOK = this.createContractProcSchedule(contractProcPeriod, true, false);
            } else if (contractProcPeriod.getJP_ContractProcPeriod_ID() != firstContractProcPeriod.getJP_ContractProcPeriod_ID() && contractProcPeriod.getJP_ContractProcPeriod_ID() == endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                isOK = this.createContractProcSchedule(contractProcPeriod, false, true);
            } else if (contractProcPeriod.getJP_ContractProcPeriod_ID() != firstContractProcPeriod.getJP_ContractProcPeriod_ID() && contractProcPeriod.getJP_ContractProcPeriod_ID() != endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                isOK = this.createContractProcSchedule(contractProcPeriod, false, false);
            }
        }
        if (isOK && !this.m_ContractContent.isScheduleCreatedJP()) {
            this.m_ContractContent.setIsScheduleCreatedJP(true);
            try {
                this.m_ContractContent.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                this.createContractLogDetail("Z1", null, null, e.getMessage());
                throw e;
            }
        }
        return "";
    }

    private boolean createContractProcSchedule(MContractProcPeriod contractProcPeriod, boolean isFirstPeriod, boolean isLastPeriod) {
        boolean isOK;
        block22: {
            isOK = false;
            MContractProcSchedule[] contractProcSchedules = this.m_ContractContent.getContractProcScheduleByContractPeriod(Env.getCtx(), contractProcPeriod.getJP_ContractProcPeriod_ID(), this.get_TrxName());
            if (contractProcSchedules != null && contractProcSchedules.length > 0) {
                this.p_JP_ContractProcPeriod_ID = contractProcPeriod.getJP_ContractProcPeriod_ID();
                this.createContractLogDetail("B1", null, contractProcSchedules[0], null);
                return false;
            }
            MContractLine[] m_lines = this.m_ContractContent.getLines();
            boolean isCreateDocLine = false;
            int i = 0;
            while (i < m_lines.length) {
                if (this.isCreateContractPSLine(m_lines[i], contractProcPeriod.getJP_ContractProcPeriod_ID(), false)) {
                    isCreateDocLine = true;
                    break;
                }
                ++i;
            }
            if (!isCreateDocLine) {
                this.createContractLogDetail("B2", null, null, null);
                return false;
            }
            MContractProcSchedule contractProcSchedule = new MContractProcSchedule(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)this.m_ContractContent, (PO)contractProcSchedule);
            contractProcSchedule.setJP_ContractProcPeriod_ID(contractProcPeriod.getJP_ContractProcPeriod_ID());
            contractProcSchedule.setAD_Org_ID(this.m_ContractContent.getAD_Org_ID());
            contractProcSchedule.setJP_ContractContent_ID(this.m_ContractContent.getJP_ContractContent_ID());
            contractProcSchedule.setDocAction(this.getDocAction());
            contractProcSchedule.setDocStatus("DR");
            if (isFirstPeriod) {
                contractProcSchedule.setDateDoc(this.m_ContractContent.getDateDoc());
                contractProcSchedule.setDateOrdered(this.m_ContractContent.getDateDoc());
                contractProcSchedule.setDateInvoiced(this.m_ContractContent.getDateDoc());
                if (this.m_ContractContent.getDateAcct().compareTo(contractProcPeriod.getStartDate()) > 0 && this.m_ContractContent.getDateAcct().compareTo(contractProcPeriod.getEndDate()) < 0) {
                    contractProcSchedule.setDateAcct(this.m_ContractContent.getDateAcct());
                } else {
                    contractProcSchedule.setDateAcct(contractProcPeriod.getDateAcct());
                }
            } else {
                contractProcSchedule.setDateDoc(contractProcPeriod.getDateDoc());
                contractProcSchedule.setDateOrdered(contractProcPeriod.getDateDoc());
                contractProcSchedule.setDateInvoiced(contractProcPeriod.getDateDoc());
                contractProcSchedule.setDateAcct(contractProcPeriod.getDateAcct());
            }
            contractProcSchedule.setDatePromised(this.getOrderHeaderDatePromised(contractProcSchedule.getDateAcct()));
            MDocType contractContentDocType = MDocType.get((Properties)this.getCtx(), (int)this.m_ContractContent.getC_DocType_ID());
            Object obj_ContractPSDocType_ID = contractContentDocType.get_Value("JP_ContractPSDocType_ID");
            if (obj_ContractPSDocType_ID == null) {
                int JP_ContractPSDocType_ID = this.getDefaultContractPSDocType_ID();
                if (JP_ContractPSDocType_ID == 0) {
                    this.createContractLogDetail("ZZ", null, null, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID"));
                    return false;
                }
                contractProcSchedule.setC_DocType_ID(JP_ContractPSDocType_ID);
            } else {
                contractProcSchedule.setC_DocType_ID((Integer)obj_ContractPSDocType_ID);
            }
            contractProcSchedule.setDocumentNo(String.valueOf(contractProcSchedule.getDocumentNo()) + "-" + contractProcPeriod.getName());
            try {
                contractProcSchedule.saveEx(this.get_TrxName());
            }
            catch (AdempiereException e) {
                this.createContractLogDetail("Z1", null, null, e.getMessage());
                throw e;
            }
            this.createContractLogDetail("A1", null, contractProcSchedule, null);
            isOK = this.createContractPSLines(contractProcSchedule, contractProcPeriod, isFirstPeriod, isLastPeriod);
            if (isOK && this.getDocAction() != null) {
                if (contractProcSchedule.processIt(this.getDocAction())) {
                    try {
                        contractProcSchedule.saveEx(this.get_TrxName());
                        break block22;
                    }
                    catch (AdempiereException e) {
                        this.createContractLogDetail("Z1", null, null, e.getMessage());
                        throw e;
                    }
                }
                this.createContractLogDetail("Z2", null, contractProcSchedule, null);
            }
        }
        return isOK;
    }

    private boolean createContractPSLines(MContractProcSchedule contractProcSchedule, MContractProcPeriod contractProcessPeriod, boolean isFirstPeriod, boolean isLastPeriod) {
        MContractLine[] contractLines = this.m_ContractContent.getLines();
        int i = 0;
        while (i < contractLines.length) {
            if (this.isCreateContractPSLine(contractLines[i], contractProcessPeriod.getJP_ContractProcPeriod_ID(), true)) {
                BigDecimal qtyOrdered;
                BigDecimal denominator;
                BigDecimal umerator;
                MContractPSLine contractPSLine = new MContractPSLine(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)contractLines[i], (PO)contractPSLine);
                contractPSLine.setAD_Org_ID(this.m_ContractContent.getAD_Org_ID());
                contractPSLine.setJP_ContractProcSchedule_ID(contractProcSchedule.getJP_ContractProcSchedule_ID());
                contractPSLine.setJP_ContractLine_ID(contractLines[i].getJP_ContractLine_ID());
                MUOM uom = null;
                uom = contractLines[i].getM_Product_ID() > 0 ? MUOM.get((Properties)this.getCtx(), (int)contractLines[i].getM_Product().getC_UOM_ID()) : MUOM.get((Properties)this.getCtx(), (int)contractLines[i].getC_UOM_ID());
                if (isFirstPeriod && isLastPeriod) {
                    contractPSLine.setQtyEntered(contractLines[i].getQtyEntered());
                    contractPSLine.setC_UOM_ID(contractLines[i].getC_UOM_ID());
                    contractPSLine.setQtyOrdered(contractLines[i].getQtyOrdered());
                } else if (isFirstPeriod && !isLastPeriod) {
                    if (this.m_ContractContent.getJP_ContractProcDate_From().compareTo(contractProcessPeriod.getStartDate()) == 0) {
                        contractPSLine.setQtyEntered(contractLines[i].getQtyEntered());
                        contractPSLine.setC_UOM_ID(contractLines[i].getC_UOM_ID());
                        contractPSLine.setQtyOrdered(contractLines[i].getQtyOrdered());
                    } else {
                        umerator = new BigDecimal(this.getContractDays(this.m_ContractContent.getJP_ContractProcDate_From(), contractProcessPeriod.getEndDate()));
                        denominator = new BigDecimal(contractProcessPeriod.getContractProcPeriodDays());
                        qtyOrdered = umerator.divide(denominator, uom.getStdPrecision() + 2, RoundingMode.HALF_UP).multiply(contractLines[i].getQtyOrdered());
                        qtyOrdered = qtyOrdered.divide(Env.ONE, uom.getStdPrecision(), RoundingMode.HALF_UP);
                        contractPSLine.setQtyEntered(qtyOrdered);
                        contractPSLine.setC_UOM_ID(uom.getC_UOM_ID());
                        contractPSLine.setQtyOrdered(qtyOrdered);
                    }
                } else if (!isFirstPeriod && isLastPeriod) {
                    if (this.m_ContractContent.getJP_ContractProcDate_To().compareTo(contractProcessPeriod.getEndDate()) == 0) {
                        contractPSLine.setQtyEntered(contractLines[i].getQtyEntered());
                        contractPSLine.setC_UOM_ID(contractLines[i].getC_UOM_ID());
                        contractPSLine.setQtyOrdered(contractLines[i].getQtyOrdered());
                    } else {
                        umerator = new BigDecimal(this.getContractDays(contractProcessPeriod.getStartDate(), this.m_ContractContent.getJP_ContractProcDate_To()));
                        denominator = new BigDecimal(contractProcessPeriod.getContractProcPeriodDays());
                        qtyOrdered = umerator.divide(denominator, uom.getStdPrecision() + 2, RoundingMode.HALF_UP).multiply(contractLines[i].getQtyOrdered());
                        qtyOrdered = qtyOrdered.divide(Env.ONE, uom.getStdPrecision(), RoundingMode.HALF_UP);
                        contractPSLine.setQtyEntered(qtyOrdered);
                        contractPSLine.setC_UOM_ID(uom.getC_UOM_ID());
                        contractPSLine.setQtyOrdered(qtyOrdered);
                    }
                } else if (!isFirstPeriod && !isLastPeriod) {
                    contractPSLine.setQtyEntered(contractLines[i].getQtyEntered());
                    contractPSLine.setC_UOM_ID(contractLines[i].getC_UOM_ID());
                    contractPSLine.setQtyOrdered(contractLines[i].getQtyOrdered());
                }
                if (contractLines[i].getC_UOM_ID() == uom.getC_UOM_ID()) {
                    contractPSLine.setPriceEntered(contractLines[i].getPriceEntered());
                } else {
                    contractPSLine.setPriceEntered(contractLines[i].getPriceActual());
                }
                contractPSLine.setPriceActual(contractLines[i].getPriceActual());
                contractPSLine.setLineNetAmt(contractPSLine.getQtyOrdered().multiply(contractPSLine.getPriceActual()));
                try {
                    contractPSLine.saveEx(this.get_TrxName());
                    this.createContractLogDetail("A2", contractLines[i], contractProcSchedule, null);
                }
                catch (AdempiereException e) {
                    this.createContractLogDetail("Z1", contractLines[i], contractProcSchedule, e.getMessage());
                    throw e;
                }
                if (this.m_ContractContent.getJP_CreateDerivativeDocPolicy() != null && !this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("MA")) {
                    if (this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("IO") || this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("BT")) {
                        this.createContractPSInOutLines(contractLines[i], contractPSLine, contractProcessPeriod);
                    }
                    if (this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("IV") || this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("BT")) {
                        this.createContractPSInvoiceLines(contractLines[i], contractPSLine, contractProcessPeriod);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean createContractPSInOutLines(MContractLine contractLine, MContractPSLine contractPSLine, MContractProcPeriod baseDocContractProcPeriod) {
        MContractCalender contractCalender = MContractCalender.get(this.getCtx(), contractLine.getJP_ContractCalender_InOut_ID());
        if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("DD") || contractLine.getJP_DerivativeDocPolicy_InOut().equals("PB") || contractLine.getJP_DerivativeDocPolicy_InOut().equals("PS") || contractLine.getJP_DerivativeDocPolicy_InOut().equals("PE")) {
            MContractProcPeriod contractProcPeriod = null;
            MContractProcPeriod startContractProcPeriod = null;
            MContractProcPeriod endContractProcPeriod = null;
            if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("DD")) {
                startContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_From());
                endContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_To());
            } else if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                startContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_InOut_ID());
                endContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_InOut_ID());
            } else if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("PS")) {
                startContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_InOut_ID());
                endContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_To());
            } else if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("PE")) {
                startContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_From());
                endContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_InOut_ID());
            }
            int i = 1;
            do {
                if ((contractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), startContractProcPeriod.getDateDoc(), null, i)).isContainedBaseDocContractProcPeriod(baseDocContractProcPeriod)) {
                    if (i == 1) {
                        if (contractProcPeriod.getJP_ContractProcPeriod_ID() == endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                            this.createContractPSInOutLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, true, true, i);
                        } else {
                            this.createContractPSInOutLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, true, false, i);
                        }
                    } else if (contractProcPeriod.getJP_ContractProcPeriod_ID() == endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                        this.createContractPSInOutLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, false, true, i);
                    } else {
                        this.createContractPSInOutLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, false, false, i);
                    }
                }
                ++i;
            } while (contractProcPeriod.getJP_ContractProcPeriod_ID() != endContractProcPeriod.getJP_ContractProcPeriod_ID());
        } else if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("LP")) {
            MContractProcPeriod contractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Lump_InOut_ID());
            this.createContractPSInOutLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, true, true, 1);
        }
        return true;
    }

    private boolean createContractPSInOutLine(MContractLine contractLine, MContractPSLine contractPSLine, MContractProcPeriod baseDocContractProcPeriod, MContractProcPeriod contractProcPeriod, boolean isFirstPeriod, boolean isLastPeriod, int loopCounter) {
        if (!this.isCreateContractPSInOutLine(contractPSLine, contractProcPeriod.getJP_ContractProcPeriod_ID(), false)) {
            this.createContractLogDetail("B2", null, contractPSLine, Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractPSInOutLine_ID"));
            return true;
        }
        MContractPSInOutLine contractPSInOutLine = new MContractPSInOutLine(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)contractLine, (PO)contractPSInOutLine);
        contractPSInOutLine.setAD_Org_ID(this.m_ContractContent.getAD_Org_ID());
        contractPSInOutLine.setJP_ContractLine_ID(contractLine.getJP_ContractLine_ID());
        contractPSInOutLine.setJP_ContractPSLine_ID(contractPSLine.getJP_ContractPSLine_ID());
        contractPSInOutLine.setJP_ContractProcPeriod_ID(contractProcPeriod.getJP_ContractProcPeriod_ID());
        contractPSInOutLine.setJP_ContractProcSchedule_ID(contractPSLine.getJP_ContractProcSchedule_ID());
        MUOM uom = null;
        uom = contractLine.getM_Product_ID() > 0 ? MUOM.get((Properties)this.getCtx(), (int)contractLine.getM_Product().getC_UOM_ID()) : MUOM.get((Properties)this.getCtx(), (int)contractLine.getC_UOM_ID());
        if (isFirstPeriod && isLastPeriod) {
            contractPSInOutLine.setQtyEntered(contractLine.getMovementQty());
            contractPSInOutLine.setC_UOM_ID(uom.getC_UOM_ID());
            contractPSInOutLine.setMovementQty(contractLine.getMovementQty());
        } else if (isFirstPeriod && !isLastPeriod) {
            if (this.m_ContractContent.getJP_ContractProcDate_From().compareTo(contractProcPeriod.getStartDate()) == 0) {
                contractPSInOutLine.setQtyEntered(contractLine.getMovementQty());
                contractPSInOutLine.setC_UOM_ID(uom.getC_UOM_ID());
                contractPSInOutLine.setMovementQty(contractLine.getMovementQty());
            } else {
                BigDecimal umerator = new BigDecimal(this.getContractDays(this.m_ContractContent.getJP_ContractProcDate_From(), contractProcPeriod.getEndDate()));
                BigDecimal denominator = new BigDecimal(contractProcPeriod.getContractProcPeriodDays());
                BigDecimal qtyEntered = umerator.divide(denominator, uom.getStdPrecision() + 2, RoundingMode.HALF_UP).multiply(contractLine.getMovementQty());
                qtyEntered = qtyEntered.divide(Env.ONE, uom.getStdPrecision(), RoundingMode.HALF_UP);
                contractPSInOutLine.setQtyEntered(qtyEntered);
                contractPSInOutLine.setC_UOM_ID(uom.getC_UOM_ID());
                contractPSInOutLine.setMovementQty(qtyEntered);
            }
        } else if (!isFirstPeriod && isLastPeriod) {
            BigDecimal totalMovementQty;
            BigDecimal qtyOrdered;
            block20: {
                qtyOrdered = contractPSLine.getQtyOrdered();
                totalMovementQty = Env.ZERO;
                String sql = "SELECT COALESCE(SUM(MovementQty),0) FROM JP_ContractPSInOutLine WHERE JP_ContractPSLine_ID=? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, contractPSLine.getJP_ContractPSLine_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            totalMovementQty = rs.getBigDecimal(1);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            BigDecimal qtyLastPeriod = qtyOrdered.subtract(totalMovementQty);
            contractPSInOutLine.setQtyEntered(qtyLastPeriod);
            contractPSInOutLine.setC_UOM_ID(uom.getC_UOM_ID());
            contractPSInOutLine.setMovementQty(qtyLastPeriod);
        } else if (!isFirstPeriod && !isLastPeriod) {
            contractPSInOutLine.setQtyEntered(contractLine.getMovementQty());
            contractPSInOutLine.setC_UOM_ID(uom.getC_UOM_ID());
            contractPSInOutLine.setMovementQty(contractLine.getMovementQty());
        }
        contractPSInOutLine.setPriceEntered(contractPSLine.getPriceActual());
        contractPSInOutLine.setPriceActual(contractPSLine.getPriceActual());
        contractPSInOutLine.setLineNetAmt(contractPSInOutLine.getMovementQty().multiply(contractPSInOutLine.getPriceActual()));
        try {
            contractPSInOutLine.saveEx(this.get_TrxName());
            this.createContractLogDetail("A2", contractLine, contractPSInOutLine, null);
        }
        catch (AdempiereException e) {
            this.createContractLogDetail("Z1", contractLine, contractPSLine, e.getMessage());
            throw e;
        }
        return true;
    }

    private boolean createContractPSInvoiceLines(MContractLine contractLine, MContractPSLine contractPSLine, MContractProcPeriod baseDocContractProcPeriod) {
        MContractCalender contractCalender = MContractCalender.get(this.getCtx(), contractLine.getJP_ContractCalender_Inv_ID());
        if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("DD") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PB") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PS") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PE")) {
            MContractProcPeriod contractProcPeriod = null;
            MContractProcPeriod startContractProcPeriod = null;
            MContractProcPeriod endContractProcPeriod = null;
            if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("DD")) {
                startContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_From());
                endContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_To());
            } else if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                startContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_Inv_ID());
                endContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_Inv_ID());
            } else if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PS")) {
                startContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_Inv_ID());
                endContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_To());
            } else if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PE")) {
                startContractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), this.m_ContractContent.getJP_ContractProcDate_From());
                endContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_Inv_ID());
            }
            int i = 1;
            do {
                if ((contractProcPeriod = contractCalender.getContractProcessPeriod(this.getCtx(), startContractProcPeriod.getDateDoc(), null, i)).isContainedBaseDocContractProcPeriod(baseDocContractProcPeriod)) {
                    if (i == 1) {
                        if (contractProcPeriod.getJP_ContractProcPeriod_ID() == endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                            this.createContractPSInvoiceLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, true, true, i);
                        } else {
                            this.createContractPSInvoiceLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, true, false, i);
                        }
                    } else if (contractProcPeriod.getJP_ContractProcPeriod_ID() == endContractProcPeriod.getJP_ContractProcPeriod_ID()) {
                        this.createContractPSInvoiceLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, false, true, i);
                    } else {
                        this.createContractPSInvoiceLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, false, false, i);
                    }
                }
                ++i;
            } while (contractProcPeriod.getJP_ContractProcPeriod_ID() != endContractProcPeriod.getJP_ContractProcPeriod_ID());
        } else if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
            MContractProcPeriod contractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Lump_Inv_ID());
            this.createContractPSInvoiceLine(contractLine, contractPSLine, baseDocContractProcPeriod, contractProcPeriod, true, true, 1);
        }
        return true;
    }

    private boolean createContractPSInvoiceLine(MContractLine contractLine, MContractPSLine contractPSLine, MContractProcPeriod baseDocContractProcPeriod, MContractProcPeriod contractProcPeriod, boolean isFirstPeriod, boolean isLastPeriod, int loopCounter) {
        if (!this.isCreateContractPSInvoiceLine(contractPSLine, contractProcPeriod.getJP_ContractProcPeriod_ID(), false)) {
            this.createContractLogDetail("B2", null, contractPSLine, Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractPSInvoiceLine_ID"));
            return true;
        }
        MContractPSInvoiceLine contractPSInvoiceLine = new MContractPSInvoiceLine(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)contractLine, (PO)contractPSInvoiceLine);
        contractPSInvoiceLine.setAD_Org_ID(this.m_ContractContent.getAD_Org_ID());
        contractPSInvoiceLine.setJP_ContractLine_ID(contractLine.getJP_ContractLine_ID());
        contractPSInvoiceLine.setJP_ContractPSLine_ID(contractPSLine.getJP_ContractPSLine_ID());
        contractPSInvoiceLine.setJP_ContractProcPeriod_ID(contractProcPeriod.getJP_ContractProcPeriod_ID());
        contractPSInvoiceLine.setJP_ContractProcSchedule_ID(contractPSLine.getJP_ContractProcSchedule_ID());
        MUOM uom = null;
        uom = contractLine.getM_Product_ID() > 0 ? MUOM.get((Properties)this.getCtx(), (int)contractLine.getM_Product().getC_UOM_ID()) : MUOM.get((Properties)this.getCtx(), (int)contractLine.getC_UOM_ID());
        if (isFirstPeriod && isLastPeriod) {
            contractPSInvoiceLine.setQtyEntered(contractLine.getQtyInvoiced());
            contractPSInvoiceLine.setC_UOM_ID(uom.getC_UOM_ID());
            contractPSInvoiceLine.setQtyInvoiced(contractLine.getQtyInvoiced());
        } else if (isFirstPeriod && !isLastPeriod) {
            if (this.m_ContractContent.getJP_ContractProcDate_From().compareTo(contractProcPeriod.getStartDate()) == 0) {
                contractPSInvoiceLine.setQtyEntered(contractLine.getQtyInvoiced());
                contractPSInvoiceLine.setC_UOM_ID(uom.getC_UOM_ID());
                contractPSInvoiceLine.setQtyInvoiced(contractLine.getQtyInvoiced());
            } else {
                BigDecimal umerator = new BigDecimal(this.getContractDays(this.m_ContractContent.getJP_ContractProcDate_From(), contractProcPeriod.getEndDate()));
                BigDecimal denominator = new BigDecimal(contractProcPeriod.getContractProcPeriodDays());
                BigDecimal qtyEntered = umerator.divide(denominator, uom.getStdPrecision() + 2, RoundingMode.HALF_UP).multiply(contractLine.getQtyInvoiced());
                qtyEntered = qtyEntered.divide(Env.ONE, uom.getStdPrecision(), RoundingMode.HALF_UP);
                contractPSInvoiceLine.setQtyEntered(qtyEntered);
                contractPSInvoiceLine.setC_UOM_ID(uom.getC_UOM_ID());
                contractPSInvoiceLine.setQtyInvoiced(qtyEntered);
            }
        } else if (!isFirstPeriod && isLastPeriod) {
            BigDecimal totalQtyInvoiced;
            BigDecimal qtyOrdered;
            block20: {
                qtyOrdered = contractPSLine.getQtyOrdered();
                totalQtyInvoiced = Env.ZERO;
                String sql = "SELECT COALESCE(SUM(QtyInvoiced),0) FROM JP_ContractPSInvoiceLine WHERE JP_ContractPSLine_ID=? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, contractPSLine.getJP_ContractPSLine_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            totalQtyInvoiced = rs.getBigDecimal(1);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            BigDecimal qtyLastPeriod = qtyOrdered.subtract(totalQtyInvoiced);
            contractPSInvoiceLine.setQtyEntered(qtyLastPeriod);
            contractPSInvoiceLine.setC_UOM_ID(uom.getC_UOM_ID());
            contractPSInvoiceLine.setQtyInvoiced(qtyLastPeriod);
        } else if (!isFirstPeriod && !isLastPeriod) {
            contractPSInvoiceLine.setQtyEntered(contractLine.getQtyInvoiced());
            contractPSInvoiceLine.setC_UOM_ID(uom.getC_UOM_ID());
            contractPSInvoiceLine.setQtyInvoiced(contractLine.getQtyInvoiced());
        }
        contractPSInvoiceLine.setPriceEntered(contractPSLine.getPriceActual());
        contractPSInvoiceLine.setPriceActual(contractPSLine.getPriceActual());
        contractPSInvoiceLine.setLineNetAmt(contractPSInvoiceLine.getQtyInvoiced().multiply(contractPSInvoiceLine.getPriceActual()));
        try {
            contractPSInvoiceLine.saveEx(this.get_TrxName());
            this.createContractLogDetail("A2", contractLine, contractPSInvoiceLine, null);
        }
        catch (AdempiereException e) {
            this.createContractLogDetail("Z1", contractLine, contractPSLine, e.getMessage());
            throw e;
        }
        return true;
    }

    private long getContractDays(Timestamp startDate, Timestamp endDate) {
        return Duration.between(startDate.toLocalDateTime(), endDate.toLocalDateTime()).toDays() + 1L;
    }

    private boolean isCreateContractPSLine(MContractLine contractLine, int JP_ContractProcPeriod_ID, boolean isCreateLog) {
        if (this.m_ContractContent.getDocBaseType().equals("SOO") || this.m_ContractContent.getDocBaseType().equals("POO")) {
            String logMsg = AbstractContractProcess.getSkipReason_CreateBaseOrderLine(this.getCtx(), this.m_ContractContent, contractLine, JP_ContractProcPeriod_ID, true, this.get_TrxName());
            if (logMsg == null) {
                return true;
            }
            if (isCreateLog) {
                if (logMsg.equals("B1")) {
                    MOrderLine[] oLines = contractLine.getOrderLineByContractPeriod(this.getCtx(), JP_ContractProcPeriod_ID, this.get_TrxName());
                    if (oLines != null && oLines.length > 0) {
                        this.createContractLogDetail(logMsg, contractLine, (PO)oLines[0], null);
                    }
                } else {
                    this.createContractLogDetail(logMsg, contractLine, null, null);
                }
            }
            return false;
        }
        if (this.m_ContractContent.getDocBaseType().equals("ARI") || this.m_ContractContent.getDocBaseType().equals("API")) {
            String logMsg = AbstractContractProcess.getSkipReason_CreateBaseInvoiceLine(this.getCtx(), this.m_ContractContent, contractLine, JP_ContractProcPeriod_ID, true, this.get_TrxName());
            if (logMsg == null) {
                return true;
            }
            if (isCreateLog) {
                if (logMsg.equals("B1")) {
                    MInvoiceLine[] iLines = contractLine.getInvoiceLineByContractPeriod(this.getCtx(), JP_ContractProcPeriod_ID, this.get_TrxName());
                    if (iLines != null && iLines.length > 0) {
                        this.createContractLogDetail("B1", contractLine, (PO)iLines[0], null);
                    }
                } else {
                    this.createContractLogDetail(logMsg, contractLine, null, null);
                }
            }
            return false;
        }
        return true;
    }

    private boolean isCreateContractPSInOutLine(MContractPSLine contractPSLine, int JP_ContractProcPeriod_ID, boolean isCreateLog) {
        int JP_ContractLine_ID = contractPSLine.getJP_ContractLine_ID();
        if (JP_ContractLine_ID == 0) {
            return false;
        }
        MContractLine contractLine = MContractLine.get(this.getCtx(), JP_ContractLine_ID);
        String logMsg = DefaultContractProcessCreateSchedule.getSkipReason_CreateDerivativeInOutLine(this.getCtx(), this.m_ContractContent, contractLine, null, JP_ContractProcPeriod_ID, this.getJP_ContractProcess_ID(), false, false, this.get_TrxName());
        if (logMsg == null) {
            return true;
        }
        if (isCreateLog) {
            if (logMsg.equals("B1")) {
                MInOutLine[] ioLines = contractLine.getInOutLineByContractPeriod(this.getCtx(), JP_ContractProcPeriod_ID, this.get_TrxName());
                if (ioLines != null && ioLines.length > 0) {
                    this.createContractLogDetail(logMsg, contractLine, (PO)ioLines[0], null);
                }
            } else {
                this.createContractLogDetail(logMsg, contractLine, null, null);
            }
        }
        return false;
    }

    private boolean isCreateContractPSInvoiceLine(MContractPSLine contractPSLine, int JP_ContractProcPeriod_ID, boolean isCreateLog) {
        int JP_ContractLine_ID = contractPSLine.getJP_ContractLine_ID();
        if (JP_ContractLine_ID == 0) {
            return false;
        }
        MContractLine contractLine = MContractLine.get(this.getCtx(), JP_ContractLine_ID);
        String logMsg = DefaultContractProcessCreateSchedule.getSkipReason_CreateDerivativeInvoiceLine(this.getCtx(), this.m_ContractContent, contractLine, null, JP_ContractProcPeriod_ID, this.getJP_ContractProcess_ID(), false, false, this.get_TrxName());
        if (logMsg == null) {
            return true;
        }
        if (isCreateLog) {
            if (logMsg.equals("B1")) {
                MInvoiceLine[] iLines = contractLine.getInvoiceLineByContractPeriod(this.getCtx(), JP_ContractProcPeriod_ID, this.get_TrxName());
                if (iLines != null && iLines.length > 0) {
                    this.createContractLogDetail("B1", contractLine, (PO)iLines[0], null);
                }
            } else {
                this.createContractLogDetail(logMsg, contractLine, null, null);
            }
        }
        return false;
    }

    public int getDefaultContractPSDocType_ID() {
        int JP_ContractPSDocType_ID;
        block6: {
            JP_ContractPSDocType_ID = 0;
            String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType='JCS' AND IsDefault='Y' ORDER BY C_DocType_ID DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        JP_ContractPSDocType_ID = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "getDefaultContractPSDocType", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return JP_ContractPSDocType_ID;
    }
}

