/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankData;
import jpiere.base.plugin.org.adempiere.model.MBankDataLine;
import jpiere.base.plugin.org.adempiere.model.MBankDataSchema;
import org.compiere.model.MInvoice;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DefaultBankDataMatchInv
extends SvrProcess {
    private int p_JP_BankData_ID = 0;
    private MBankData m_BankData = null;
    private MBankDataSchema BDSchema = null;
    private int p_AD_Client_ID = 0;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        this.p_JP_BankData_ID = this.getRecord_ID();
        this.m_BankData = new MBankData(this.getCtx(), this.p_JP_BankData_ID, this.get_TrxName());
        this.BDSchema = new MBankDataSchema(this.getCtx(), this.m_BankData.getJP_BankDataSchema_ID(), this.get_TrxName());
    }

    protected String doIt() throws Exception {
        BigDecimal acceptableDiffAmt = this.BDSchema.getJP_AcceptableDiffAmt();
        MBankDataLine[] lines = this.m_BankData.getLines();
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE IsPaid='N' AND AD_Client_ID = ? AND IsSOTrx = 'Y' AND  C_BPartner_ID = ? AND ( DocStatus ='CO' or DocStatus ='CL') ORDER BY DateInvoiced ASC;";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int i = 0;
        while (i < lines.length) {
            block9: {
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.p_AD_Client_ID);
                        pstmt.setInt(2, lines[i].getC_BPartner_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            if (!lines[i].isMatchedJP()) {
                                int C_Invoice_ID = rs.getInt(1);
                                MInvoice inv = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
                                BigDecimal openAmt = inv.getOpenAmt();
                                BigDecimal diffAmt = lines[i].getTrxAmt().subtract(openAmt);
                                if (diffAmt.abs().compareTo(acceptableDiffAmt.abs()) > 0) continue;
                                lines[i].setC_Invoice_ID(C_Invoice_ID);
                                if (diffAmt.compareTo(Env.ZERO) != 0) {
                                    lines[i].setTrxAmt(openAmt);
                                    lines[i].setChargeAmt(diffAmt);
                                    lines[i].setC_Charge_ID(this.BDSchema.getC_Charge_ID());
                                    lines[i].setC_Tax_ID(this.BDSchema.getC_Tax_ID());
                                }
                                lines[i].setIsMatchedJP(true);
                                lines[i].saveEx(this.get_TrxName());
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            ++i;
        }
        return null;
    }
}

