/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankData;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class DefaultBankDataImport3
extends SvrProcess {
    private static final int INDEX_HEADER_JP_BankDataType_Header = 0;
    private static final int INDEX_HEADER_JP_BankDataClassification = 1;
    private static final int INDEX_HEADER_JP_BankDataCodeType = 2;
    private static final int INDEX_HEADER_JP_BankDataCreated = 3;
    private static final int INDEX_HEADER_JP_BankDataFrom = 4;
    private static final int INDEX_HEADER_JP_BankDataTo = 5;
    private static final int INDEX_HEADER_RoutingNo = 6;
    private static final int INDEX_HEADER_JP_BankName_kana = 7;
    private static final int INDEX_HEADER_JP_BranchCode = 8;
    private static final int INDEX_HEADER_JP_BranchName_Kana = 9;
    private static final int INDEX_HEADER_JP_BankAccountType = 10;
    private static final int INDEX_HEADER_AccountNo = 11;
    private static final int INDEX_HEADER_JP_RequesterName = 12;
    private static final int INDEX_HEADER_DUMMY = 13;
    private static final int INDEX_LINE_JP_BankDataType_Line = 0;
    private static final int INDEX_LINE_JP_BankData_ReferenceNo = 1;
    private static final int INDEX_LINE_JP_BankData_Kanjyoubi = 2;
    private static final int INDEX_LINE_JP_BankData_Kisanbi = 3;
    private static final int INDEX_LINE_StmtAmt = 4;
    private static final int INDEX_LINE_JP_BankData_Taten_StmtAmt = 5;
    private static final int INDEX_LINE_JP_RequesterCode = 6;
    private static final int INDEX_LINE_JP_A_Name_Kana = 7;
    private static final int INDEX_LINE_JP_BankName_Kana = 8;
    private static final int INDEX_LINE_JP_BranchName_Kana = 9;
    private static final int INDEX_LINE_JP_BankData_Torikeshikubun = 10;
    private static final int INDEX_LINE_JP_BankDate_EDI_Info = 11;
    private static final int INDEX_LINE_DUMMY = 12;
    private static final int INDEX_FOOTER_JP_BankDataType_Footer = 0;
    private static final int INDEX_FOOTER_NumLines = 1;
    private static final int INDEX_FOOTER_TotalAmt = 2;
    private static final int INDEX_FOOTER_JP_BankData_TorikeshiNum = 3;
    private static final int INDEX_FOOTER_JP_BankData_TorikeshiAmt = 4;
    private static final int INDEX_FOOTER_DUMMY = 5;
    private static final String DATADIFF_Header = "1";
    private static final String DATADIFF_Line = "2";
    private static final String DATADIFF_Trailer = "8";
    private static final String DATADIFF_End = "9";
    private int p_AD_Client_ID = 0;
    private int p_JP_BankData_ID = 0;
    private MBankData m_BankData = null;
    private String p_BankDataFile = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (!name.equals("")) {
                if (name.equals("JP_BankDataFile")) {
                    this.p_BankDataFile = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter :" + name);
                }
            }
            this.p_JP_BankData_ID = this.getRecord_ID();
            this.m_BankData = new MBankData(this.getCtx(), this.p_JP_BankData_ID, this.get_TrxName());
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        StringBuffer err = new StringBuffer();
        if (this.p_BankDataFile == null) return Msg.getMsg((Properties)this.getCtx(), (String)"File invalid");
        if (this.p_BankDataFile.length() == 0) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"File invalid");
        }
        try {
            File file = new File(this.p_BankDataFile);
            if (file.isDirectory()) {
                err.append("Path is not a file. - " + file.getAbsolutePath());
                this.log.log(Level.SEVERE, err.toString());
                return Msg.getMsg((Properties)this.getCtx(), (String)"Path is not a file");
            }
            if (!file.exists()) {
                err.append("No file in the folder. - " + file.getAbsolutePath());
                this.log.log(Level.SEVERE, err.toString());
                return Msg.getMsg((Properties)this.getCtx(), (String)"No file in the folder");
            }
            FileInputStream fs = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                try {
                    fs = new FileInputStream(file);
                    isr = new InputStreamReader((InputStream)fs, "SJIS");
                    br = new BufferedReader(isr);
                    StringBuilder sql = null;
                    int lineNo = 10;
                    int no = 0;
                    String tmplinedata = br.readLine();
                    while (true) {
                        if (tmplinedata == null) {
                            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + " : WPayImportProcess()";
                        }
                        String str = tmplinedata;
                        String dataDiff = str.substring(0, 1);
                        if (dataDiff.equals(DATADIFF_Header)) {
                            String[] header = this.parseCSV(str);
                            sql = new StringBuilder("UPDATE JP_BankData ").append("SET ").append(" Updated = COALESCE (Updated, SysDate),").append(" UpdatedBy = ").append(Env.getAD_User_ID((Properties)this.getCtx())).append(",").append(" JP_BankDataType_Header = '").append(header[0]).append("',").append(" JP_BankDataClassification = '").append(header[1]).append("',").append(" JP_BankDataCodeType = '").append(header[2]).append("',").append(" JP_BankDataCreated = '").append(header[3]).append("',").append(" JP_BankDataFrom = '").append(header[4]).append("',").append(" JP_BankDataTo = '").append(header[5]).append("',").append(" RoutingNo = '").append(header[6]).append("',").append(" JP_BankName_Kana = '").append(header[7]).append("',").append(" JP_BranchCode = '").append(header[8]).append("',").append(" JP_BranchName_Kana = '").append(header[9]).append("',").append(" JP_BankAccountType = '").append(header[10]).append("',").append(" AccountNo = '").append(header[11]).append("',").append(" JP_RequesterName = '").append(header[12]).append("' ").append(" WHERE JP_BankData_ID =").append(this.p_JP_BankData_ID);
                            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Reset=" + no);
                            }
                        } else if (dataDiff.equals(DATADIFF_Line)) {
                            String[] line = this.parseCSV(str);
                            sql = new StringBuilder("INSERT INTO JP_BankDataLine ").append(" (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, ").append(" JP_BankDataType_Line, JP_BankData_ReferenceNo, JP_BankData_Kanjyoubi, JP_BankData_Kisanbi, StmtAmt,").append(" JP_BankData_Taten_StmtAmt, JP_RequesterCode, JP_A_Name_Kana, JP_BankName_kana, JP_BranchName_Kana,").append(" JP_BankData_Torikeshikubun, JP_BankData_EDI_Info, ").append(" Line, JP_BankData_ID, JP_BankDataLine_ID, JP_BankDataLine_UU, StatementLineDate, DateAcct, ValutaDate, TrxAmt ) ").append(" VALUES (").append(this.p_AD_Client_ID).append(",").append(this.m_BankData.getAD_Org_ID()).append(",").append(" 'Y',").append(" SysDate,").append(Env.getAD_User_ID((Properties)this.getCtx())).append(",").append(" SysDate,").append(Env.getAD_User_ID((Properties)this.getCtx())).append(",").append(" '").append(line[0]).append("',").append(" '").append(line[1]).append("',").append(" '").append(line[2]).append("',").append(" '").append(line[3]).append("',").append(" ").append(line[4]).append(",").append(" '").append(line[5]).append("',").append(" '").append(line[6]).append("',").append(" '").append(line[7]).append("',").append(" '").append(line[8]).append("',").append(" '").append(line[9]).append("',").append(" '").append(line[10]).append("',");
                            if (line.length == 11) {
                                sql.append(" '',");
                            } else {
                                sql.append(" '").append(line[11]).append("',");
                            }
                            sql.append(" ").append(lineNo).append(",").append(" ").append(this.p_JP_BankData_ID).append(",").append(" ").append(DB.getNextID((int)this.p_AD_Client_ID, (String)"JP_BankDataLine", (String)this.get_TrxName())).append(",").append(" generate_uuid(), ").append(" ").append("TO_DATE('").append(this.m_BankData.getStatementDate().toString().substring(0, 4)).append(line[2].substring(2, 6)).append(" 00:00:00','YYYYMMDD HH24:MI:SS'),").append(" ").append("TO_DATE('").append(this.m_BankData.getDateAcct().toString().substring(0, 4)).append(line[2].substring(2, 6)).append(" 00:00:00','YYYYMMDD HH24:MI:SS'),").append(" ").append("TO_DATE('").append(this.m_BankData.getDateAcct().toString().substring(0, 4)).append(line[2].substring(2, 6)).append(" 00:00:00','YYYYMMDD HH24:MI:SS'),").append(" ").append(line[4]).append(");");
                            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Reset=" + no);
                            }
                            lineNo += 10;
                        } else if (dataDiff.equals(DATADIFF_Trailer)) {
                            String[] footer = this.parseCSV(str);
                            sql = new StringBuilder("UPDATE JP_BankData ").append("SET").append(" JP_BankDataType_Footer = '").append(footer[0]).append("',").append(" NumLines = '").append(footer[1]).append("',").append(" TotalAmt = '").append(footer[2]).append("',").append(" JP_BankData_TorikeshiNum = '").append(footer[3]).append("',").append(" JP_BankData_TorikeshiAmt = '").append(footer[4]).append("'").append(" WHERE JP_BankData_ID =").append(this.p_JP_BankData_ID);
                            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Reset=" + no);
                            }
                        }
                        tmplinedata = br.readLine();
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                    this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                    String string = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " : " + e.toString();
                    fs.close();
                    isr.close();
                    br.close();
                    return string;
                }
            }
            finally {
                fs.close();
                isr.close();
                br.close();
            }
        }
        catch (Exception e) {
            System.out.println(e);
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " : " + e.toString();
        }
    }

    private String[] parseCSV(String str) {
        if (Util.isEmpty((String)str)) {
            return null;
        }
        String[] returnStrings = null;
        char delimiter = ',';
        if (str.contains("\"")) {
            int QUOTE = 34;
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder data = new StringBuilder();
            boolean ignorDelimiter = false;
            int i = 0;
            while (i < str.length()) {
                if (str.charAt(i) == delimiter && !ignorDelimiter) {
                    if (data.length() == 0) {
                        list.add("");
                    } else {
                        list.add(data.toString());
                        data = new StringBuilder();
                    }
                } else if (str.charAt(i) == '\"' && data.length() == 0 && !ignorDelimiter) {
                    ignorDelimiter = true;
                } else if (str.charAt(i) == '\"') {
                    ignorDelimiter = false;
                } else {
                    data.append(str.charAt(i));
                }
                ++i;
            }
            if (data.length() == 0) {
                list.add("");
            } else {
                list.add(data.toString());
            }
            returnStrings = new String[list.size()];
            list.toArray(returnStrings);
            return returnStrings;
        }
        returnStrings = str.split(",");
        return returnStrings;
    }
}

