/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankData;
import jpiere.base.plugin.org.adempiere.model.MBankDataLine;
import jpiere.base.plugin.org.adempiere.model.MBankDataSchema;
import jpiere.base.plugin.org.adempiere.model.MBill;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class DefaultBankDataCreateDoc
extends SvrProcess {
    private int p_JP_BankData_ID = 0;
    private MBankData m_BankData = null;
    private MBankDataSchema BDSchema = null;

    protected void prepare() {
        this.p_JP_BankData_ID = this.getRecord_ID();
        this.m_BankData = new MBankData(this.getCtx(), this.p_JP_BankData_ID, this.get_TrxName());
        this.BDSchema = new MBankDataSchema(this.getCtx(), this.m_BankData.getJP_BankDataSchema_ID(), this.get_TrxName());
    }

    protected String doIt() throws Exception {
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.m_BankData.getStatementDate(), (String)"CMB", (int)this.m_BankData.getAD_Org_ID());
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.m_BankData.getDateAcct(), (String)"CMB", (int)this.m_BankData.getAD_Org_ID());
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.m_BankData.getDateAcct(), (String)"ARR", (int)this.m_BankData.getAD_Org_ID());
        MBankStatement bs = new MBankStatement(this.getCtx(), 0, this.get_TrxName());
        MBankDataLine[] lines = this.m_BankData.getLines();
        int i = 0;
        while (i < lines.length) {
            MPayment payment;
            String erroMsg = this.checkMatchedBankData(lines[i]);
            if (!Util.isEmpty((String)erroMsg)) {
                lines[i].setI_ErrorMsg(erroMsg);
                lines[i].saveEx(this.get_TrxName());
                throw new Exception(String.valueOf(erroMsg) + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + lines[i].getLine());
            }
            if (i == 0) {
                PO.copyValues((PO)this.m_BankData, (PO)bs);
                bs.setAD_Org_ID(this.m_BankData.getAD_Org_ID());
                bs.saveEx(this.get_TrxName());
                this.m_BankData.setC_BankStatement_ID(bs.getC_BankStatement_ID());
                this.m_BankData.saveEx(this.get_TrxName());
            }
            MBankStatementLine bsl = new MBankStatementLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)lines[i], (PO)bsl);
            bsl.setC_BankStatement_ID(bs.getC_BankStatement_ID());
            bsl.setAD_Org_ID(bs.getAD_Org_ID());
            bsl.setC_Currency_ID(this.m_BankData.getC_BankAccount().getC_Currency_ID());
            bsl.setStmtAmt(lines[i].getStmtAmt());
            bsl.setTrxAmt(lines[i].getTrxAmt());
            bsl.setChargeAmt(lines[i].getChargeAmt());
            bsl.setC_Charge_ID(lines[i].getC_Charge_ID());
            bsl.set_ValueNoCheck("C_Tax_ID", lines[i].get_Value("C_Tax_ID"));
            bsl.setInterestAmt(lines[i].getInterestAmt());
            bsl.setC_BPartner_ID(lines[i].getC_BPartner_ID());
            if (lines[i].getJP_Product_ID() > 0) {
                bsl.set_ValueNoCheck("JP_Product_ID", (Object)lines[i].getJP_Product_ID());
            } else {
                bsl.set_ValueNoCheck("JP_Product_ID", null);
            }
            if (lines[i].getJP_UOM_ID() > 0) {
                bsl.set_ValueNoCheck("JP_UOM_ID", (Object)lines[i].getJP_UOM_ID());
            } else {
                bsl.set_ValueNoCheck("JP_UOM_ID", null);
            }
            bsl.set_ValueNoCheck("JP_Qty", (Object)lines[i].getJP_Qty());
            bsl.set_ValueNoCheck("JP_PriceActual", (Object)lines[i].getJP_PriceActual());
            bsl.saveEx(this.get_TrxName());
            if (lines[i].getC_Invoice_ID() > 0) {
                bsl.setC_Invoice_ID(lines[i].getC_Invoice_ID());
                payment = this.createPayment(bsl, lines[i]);
                if (!Util.isEmpty((String)this.BDSchema.getJP_Payment_DocAction())) {
                    payment.processIt(this.BDSchema.getJP_Payment_DocAction());
                    payment.saveEx(this.get_TrxName());
                }
            } else if (lines[i].getJP_Bill_ID() > 0) {
                payment = this.createPayment(bsl, lines[i]);
                payment.set_ValueNoCheck("JP_Bill_ID", (Object)lines[i].getJP_Bill_ID());
                payment.saveEx(this.get_TrxName());
                ProcessInfo pi = new ProcessInfo("Title", 0, this.getTable_ID(), payment.getC_Payment_ID());
                pi.setClassName("jpiere.base.plugin.org.adempiere.process.CreatePaymentAllocateFromBill");
                pi.setAD_Client_ID(this.getAD_Client_ID());
                pi.setAD_User_ID(this.getAD_User_ID());
                pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
                pi.setParameter(this.getParameter());
                boolean isOK = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)Env.getProcessUI((Properties)this.getCtx()));
                if (isOK && !Util.isEmpty((String)this.BDSchema.getJP_Payment_DocAction())) {
                    payment.processIt(this.BDSchema.getJP_Payment_DocAction());
                    payment.saveEx(this.get_TrxName());
                }
            } else if (lines[i].getC_Payment_ID() > 0) {
                bsl.setC_Payment_ID(lines[i].getC_Payment_ID());
            } else if (lines[i].getC_Order_ID() > 0) {
                payment = this.createPayment(bsl, lines[i]);
                if (!Util.isEmpty((String)this.BDSchema.getJP_Payment_DocAction())) {
                    payment.processIt(this.BDSchema.getJP_Payment_DocAction());
                    payment.saveEx(this.get_TrxName());
                }
            }
            lines[i].setC_BankStatementLine_ID(bsl.getC_BankStatementLine_ID());
            lines[i].saveEx(this.get_TrxName());
            bsl.saveEx(this.get_TrxName());
            ++i;
        }
        if (!Util.isEmpty((String)this.BDSchema.getJP_BankStmt_DocAction())) {
            bs.processIt(this.BDSchema.getJP_BankStmt_DocAction());
            bs.saveEx(this.get_TrxName());
        }
        return null;
    }

    private String checkMatchedBankData(MBankDataLine bankDataLine) {
        MOrder order;
        MPayment payment;
        MBill bill;
        BigDecimal currentOpenAmt;
        MInvoice invoice;
        if (bankDataLine.getC_Invoice_ID() > 0 && (invoice = new MInvoice(this.getCtx(), bankDataLine.getC_Invoice_ID(), this.get_TrxName())).isPaid()) {
            this.log.saveError("JP_InvoicePaid", "");
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_InvoicePaid");
        }
        if (bankDataLine.getJP_Bill_ID() > 0 && (currentOpenAmt = (bill = new MBill(this.getCtx(), bankDataLine.getJP_Bill_ID(), this.get_TrxName())).getCurrentOpenAmt()).compareTo(Env.ZERO) <= 0) {
            this.log.saveError("JP_BillPaid", "");
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_BillPaid");
        }
        if (bankDataLine.getC_Payment_ID() > 0 && (payment = new MPayment(this.getCtx(), bankDataLine.getC_Payment_ID(), this.get_TrxName())).isReconciled()) {
            this.log.saveError("JP_PaymentReconciled", "");
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_PaymentReconciled");
        }
        if (bankDataLine.getC_Order_ID() > 0 && (order = new MOrder(this.getCtx(), bankDataLine.getC_Order_ID(), this.get_TrxName())).getC_Payment_ID() > 0) {
            this.log.saveError("JP_OrderPaid", "");
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_OrderPaid");
        }
        return "";
    }

    private MPayment createPayment(MBankStatementLine bsl, MBankDataLine bdLine) throws Exception {
        if (bsl == null || bsl.getC_Payment_ID() != 0) {
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(bsl.toString());
        }
        if (bsl.getC_Invoice_ID() == 0 && bsl.getC_BPartner_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @C_Invoice_ID@ / @C_BPartner_ID@");
        }
        MBankStatement bs = new MBankStatement(this.getCtx(), bsl.getC_BankStatement_ID(), this.get_TrxName());
        MPayment payment = this.createPayment(bsl.getC_Invoice_ID(), bdLine.getC_Order_ID(), bsl.getC_BPartner_ID(), bsl.getC_Currency_ID(), bsl.getStmtAmt(), bsl.getTrxAmt(), bs.getC_BankAccount_ID(), bsl.getStatementLineDate(), bsl.getDateAcct(), bsl.getDescription(), bsl.getAD_Org_ID());
        if (payment == null) {
            throw new AdempiereSystemError("Could not create Payment");
        }
        bsl.setPayment(payment);
        bsl.saveEx();
        return payment;
    }

    private MPayment createPayment(int C_Invoice_ID, int C_Order_ID, int C_BPartner_ID, int C_Currency_ID, BigDecimal StmtAmt, BigDecimal TrxAmt, int C_BankAccount_ID, Timestamp DateTrx, Timestamp DateAcct, String Description, int AD_Org_ID) {
        BigDecimal PayAmt = TrxAmt;
        if (PayAmt == null || Env.ZERO.compareTo(PayAmt) == 0) {
            PayAmt = StmtAmt;
        }
        if (C_Invoice_ID == 0 && (PayAmt == null || Env.ZERO.compareTo(PayAmt) == 0)) {
            throw new IllegalStateException("@PayAmt@ = 0");
        }
        if (PayAmt == null) {
            PayAmt = Env.ZERO;
        }
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        payment.setAD_Org_ID(AD_Org_ID);
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setTenderType("K");
        if (DateTrx != null) {
            payment.setDateTrx(DateTrx);
        } else if (DateAcct != null) {
            payment.setDateTrx(DateAcct);
        }
        if (DateAcct != null) {
            payment.setDateAcct(DateAcct);
        } else {
            payment.setDateAcct(payment.getDateTrx());
        }
        payment.setDescription(Description);
        if (C_Invoice_ID != 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
            payment.setC_DocType_ID(invoice.isSOTrx());
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
            payment.setC_BPartner_ID(invoice.getC_BPartner_ID());
            if (PayAmt.signum() != 0) {
                payment.setC_Currency_ID(C_Currency_ID);
                if (invoice.isSOTrx()) {
                    payment.setPayAmt(PayAmt);
                } else {
                    payment.setPayAmt(PayAmt.negate());
                }
                payment.setOverUnderAmt(invoice.getOpenAmt().subtract(payment.getPayAmt()));
            } else {
                payment.setC_Currency_ID(invoice.getC_Currency_ID());
                payment.setPayAmt(invoice.getOpenAmt());
            }
        } else if (C_BPartner_ID != 0) {
            payment.setC_BPartner_ID(C_BPartner_ID);
            payment.setC_Currency_ID(C_Currency_ID);
            if (PayAmt.signum() < 0) {
                payment.setPayAmt(PayAmt.abs());
                payment.setC_DocType_ID(false);
            } else {
                payment.setPayAmt(PayAmt);
                payment.setC_DocType_ID(true);
            }
            if (C_Order_ID != 0) {
                payment.setC_Order_ID(C_Order_ID);
            }
        } else {
            return null;
        }
        payment.saveEx();
        return payment;
    }
}

