/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractCancelTerm;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractExtendPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.process.AbstractContractProcess;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class DefaultAutoRenewContractProcess
extends AbstractContractProcess {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        LocalDateTime now_LocalDateTime = new Timestamp(System.currentTimeMillis()).toLocalDateTime();
        now_LocalDateTime = now_LocalDateTime.minusDays(1L);
        Timestamp now_Timestamp = Timestamp.valueOf(now_LocalDateTime);
        if (this.m_Contract == null) {
            return "";
        }
        if (this.m_Contract.isAutomaticUpdateJP() && this.m_Contract.getJP_ContractCancelDate() == null && this.m_Contract.getJP_ContractCancelDeadline().compareTo(now_Timestamp) <= 0) {
            this.autoRenewContract(this.m_Contract);
            if (this.m_Contract.getJP_ContractType().equals("PDC")) {
                MContractContent[] contractContents = this.m_Contract.getContractContents(true, null);
                int i = 0;
                while (i < contractContents.length) {
                    if (!(!contractContents[i].isAutomaticUpdateJP() || contractContents[i].getJP_ContractProcStatus().equals("IN") || contractContents[i].getJP_ContractProcStatus().equals("--") || contractContents[i].getDocStatus().equals("CL") || contractContents[i].getDocStatus().equals("RE") || contractContents[i].getDocStatus().equals("VO") || contractContents[i].isRenewedContractContentJP() || this.m_Contract.getJP_ContractPeriodDate_To().compareTo(contractContents[i].getJP_ContractProcDate_To()) == 0)) {
                        if (this.m_Contract.getJP_ContractPeriodDate_To().compareTo(contractContents[i].getJP_ContractProcDate_To()) < 0) {
                            this.createContractLogDetail("ZZ", null, null, Msg.getMsg((Properties)this.getCtx(), (String)"JP_OutsidePperiod"));
                        } else {
                            boolean success;
                            String className = contractContents[i].getJP_ContractProcess().getJP_ContractAutoRenewClass();
                            if (Util.isEmpty((String)className)) {
                                className = "jpiere.base.plugin.org.adempiere.process.DefaultAutoRenewContractContent";
                            }
                            ProcessInfo pi = new ProcessInfo("Auto Renew the Contract Content", 0);
                            pi.setClassName(className);
                            pi.setAD_Client_ID(this.getAD_Client_ID());
                            pi.setAD_User_ID(this.getAD_User_ID());
                            pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
                            pi.setRecord_ID(0);
                            ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
                            list.add(new ProcessInfoParameter("JP_ContractContent_ID", (Object)contractContents[i].getJP_ContractContent_ID(), null, null, null));
                            list.add(new ProcessInfoParameter("JP_ContractContent", (Object)contractContents[i], null, null, null));
                            list.add(new ProcessInfoParameter("JP_Contract", (Object)this.m_Contract, null, null, null));
                            list.add(new ProcessInfoParameter("JP_ContractLog", (Object)this.m_ContractLog, null, null, null));
                            list.add(new ProcessInfoParameter("JP_ContractTabLevel", (Object)"CC", null, null, null));
                            this.setProcessInfoParameter(pi, list, null);
                            if (this.processUI == null) {
                                this.processUI = Env.getProcessUI((Properties)this.getCtx());
                            }
                            if (success = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI)) {
                                // empty if block
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private void autoRenewContract(MContract contract) throws Exception {
        LocalDateTime local_ContractPeriodDate_To = contract.getJP_ContractPeriodDate_To().toLocalDateTime();
        MContractExtendPeriod extendPeriod = MContractExtendPeriod.get(this.getCtx(), contract.getJP_ContractExtendPeriod_ID());
        local_ContractPeriodDate_To = local_ContractPeriodDate_To.plusYears(extendPeriod.getJP_Year()).plusMonths(extendPeriod.getJP_Month()).plusDays(extendPeriod.getJP_Day());
        contract.setJP_ContractPeriodDate_To(Timestamp.valueOf(local_ContractPeriodDate_To));
        MContractCancelTerm cancelTerm = MContractCancelTerm.get(this.getCtx(), contract.getJP_ContractCancelTerm_ID());
        LocalDateTime local_ContractCancelDeadline = local_ContractPeriodDate_To.minusYears(cancelTerm.getJP_Year()).minusMonths(cancelTerm.getJP_Month()).minusDays(cancelTerm.getJP_Day());
        contract.setJP_ContractCancelDeadline(Timestamp.valueOf(local_ContractCancelDeadline));
        try {
            contract.saveEx(this.get_TrxName());
        }
        catch (AdempiereException e) {
            this.createContractLogDetail("Z1", null, contract, e.getMessage());
            throw e;
        }
        this.createContractLogDetail("S3", null, contract, Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success"), "TBC");
    }

    private void setProcessInfoParameter(ProcessInfo pi, ArrayList<ProcessInfoParameter> list, MContractProcPeriod procPeriod) throws Exception {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (para[i].getParameterName().equals("JP_ContractCalender_ID")) {
                if (procPeriod == null) {
                    list.add(new ProcessInfoParameter("JP_ContractCalender_ID", para[i].getParameter(), para[i].getParameter_To(), para[i].getInfo(), para[i].getInfo_To()));
                } else {
                    list.add(new ProcessInfoParameter("JP_ContractCalender_ID", (Object)procPeriod.getJP_ContractCalender_ID(), null, para[i].getInfo(), para[i].getInfo_To()));
                }
            } else if (para[i].getParameterName().equals("JP_ContractProcPeriod_ID")) {
                if (procPeriod == null) {
                    list.add(new ProcessInfoParameter("JP_ContractProcPeriod_ID", para[i].getParameter(), para[i].getParameter_To(), para[i].getInfo(), para[i].getInfo_To()));
                } else {
                    list.add(new ProcessInfoParameter("JP_ContractProcPeriod_ID", (Object)procPeriod.getJP_ContractProcPeriod_ID(), null, para[i].getInfo(), para[i].getInfo_To()));
                }
            } else {
                list.add(new ProcessInfoParameter(para[i].getParameterName(), para[i].getParameter(), para[i].getParameter_To(), para[i].getInfo(), para[i].getInfo_To()));
            }
            ++i;
        }
        ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
        list.toArray(pars);
        pi.setParameter(pars);
    }
}

