/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankTransferFeeDeduct;
import jpiere.base.plugin.org.adempiere.model.MPaySelectionCheckJP;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class DeductBankTransferFee
extends SvrProcess {
    private int p_C_PaySelection_ID = 0;
    private MPaySelection m_PaySelection = null;
    private boolean p_onepaymentPerInvoice = false;
    private ArrayList<MPaySelectionCheckJP> m_list = new ArrayList();
    private static final String JP_BP_BANKkACCOUNT_ID = "JP_BP_BankAccount_ID";
    private static final String IS_AUTO_CAL_BANK_TRANSFER_FEE = "IsAutoCalBankTransferfeeJP";
    private static final String JP_BANK_TRANSFER_FEE_DEDUCT_ID = "JP_BankTransferFeeDeduct_ID";

    protected void prepare() {
        this.p_C_PaySelection_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.m_PaySelection = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        if (this.m_PaySelection.get_ID() == 0) {
            throw new IllegalArgumentException("Not found C_PaySelection_ID=" + this.p_C_PaySelection_ID);
        }
        if (this.m_PaySelection.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        MPaySelectionLine[] lines = this.m_PaySelection.getLines(true);
        if (lines.length == 0) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NoInvoiceToPaymentBatch"));
        }
        this.p_onepaymentPerInvoice = this.m_PaySelection.isOnePaymentPerInvoice();
        if (this.p_onepaymentPerInvoice) {
            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessFailed")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"IsOnePaymentPerInvoice", (boolean)false) + " 'Y'";
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.getCtx(), (String)msg));
        }
        int i = 0;
        while (i < lines.length) {
            MPaySelectionLine line = lines[i];
            if (line.isActive() && !line.get_ValueAsBoolean(IS_AUTO_CAL_BANK_TRANSFER_FEE)) {
                this.creatTentativeCheck(line);
            }
            ++i;
        }
        MBPBankAccount bpba = null;
        MBankTransferFeeDeduct btfd = null;
        int line = this.getMaxLineNo();
        int count = 0;
        for (MPaySelectionCheckJP tentativeCheck : this.m_list) {
            int JP_BankTransferFeeDeduct_ID;
            int C_BP_BankAccount_ID = tentativeCheck.getC_BP_BankAccount_ID();
            if (C_BP_BankAccount_ID == 0 || (JP_BankTransferFeeDeduct_ID = (bpba = new MBPBankAccount(this.getCtx(), C_BP_BankAccount_ID, this.get_TrxName())).get_ValueAsInt(JP_BANK_TRANSFER_FEE_DEDUCT_ID)) == 0 || (btfd = MBankTransferFeeDeduct.get(JP_BankTransferFeeDeduct_ID)).getJP_LowerLimitBankTransferFee().compareTo(tentativeCheck.getPayAmt()) > 0 || this.isCreatedBankTansferFeeLine(tentativeCheck.getC_BPartner_ID(), tentativeCheck.getC_BP_BankAccount_ID())) continue;
            if (this.createBankTransferFeeInvoice(tentativeCheck, btfd, line += 10)) {
                ++count;
                continue;
            }
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError"));
        }
        String returnMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Bank_Transfer_Fee_Invoice")) + " : " + count;
        this.addBufferLog(0, null, null, returnMsg, 0, 0);
        return Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
    }

    private int getMaxLineNo() {
        int lineNo;
        block6: {
            String sql = "SELECT NVL(MAX(Line),0) FROM C_PaySelectionLine WHERE C_PaySelection_ID=?";
            lineNo = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.p_C_PaySelection_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        lineNo = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return lineNo;
    }

    private void creatTentativeCheck(MPaySelectionLine line) throws Exception {
        if (!this.p_onepaymentPerInvoice) {
            int i = 0;
            while (i < this.m_list.size()) {
                MPaySelectionCheckJP check = this.m_list.get(i);
                if (check.getC_BPartner_ID() == line.getInvoice().getC_BPartner_ID() && check.getC_BP_BankAccount_ID() == line.get_ValueAsInt(JP_BP_BANKkACCOUNT_ID)) {
                    check.addLine(line);
                    if (!check.save()) {
                        throw new IllegalStateException("Cannot save MPaySelectionCheck");
                    }
                    return;
                }
                ++i;
            }
        }
        MPaySelectionCheckJP check = new MPaySelectionCheckJP(line);
        check.setAD_PInstance_ID(this.getAD_PInstance_ID());
        check.setC_BP_BankAccount_ID(line.get_ValueAsInt(JP_BP_BANKkACCOUNT_ID));
        if (!check.save()) {
            throw new IllegalStateException("Cannot save MPaySelectionCheckJP");
        }
        this.m_list.add(check);
    }

    private boolean isCreatedBankTansferFeeLine(int C_BPartner_ID, int JP_BP_BankAccount_ID) {
        int count;
        block6: {
            String sql = "SELECT COUNT(*) FROM C_PaySelectionLine psl INNER JOIN C_Invoice inv ON (psl.C_Invoice_ID = inv.C_Invoice_ID)  WHERE psl.C_PaySelection_ID=? AND inv.C_BPartner_ID = ?  AND psl.JP_BP_BankAccount_ID = ? AND psl.IsAutoCalBankTransferfeeJP ='Y' ";
            count = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.p_C_PaySelection_ID);
                    pstmt.setInt(2, C_BPartner_ID);
                    pstmt.setInt(3, JP_BP_BankAccount_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return count > 0;
    }

    private boolean createBankTransferFeeInvoice(MPaySelectionCheckJP tentativeCheck, MBankTransferFeeDeduct m_BankTransferFeeDeduct, int line) {
        MInvoice inv = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        inv.setAD_Org_ID(this.m_PaySelection.getAD_Org_ID());
        MBPartner bp = MBPartner.get((Properties)this.getCtx(), (int)tentativeCheck.getC_BPartner_ID());
        inv.setC_BPartner_ID(bp.getC_BPartner_ID());
        inv.setC_BPartner_Location_ID(bp.getPrimaryC_BPartner_Location_ID());
        if (tentativeCheck.getC_BP_BankAccount_ID() == 0) {
            inv.set_ValueNoCheck(JP_BP_BANKkACCOUNT_ID, null);
        } else {
            inv.set_ValueNoCheck(JP_BP_BANKkACCOUNT_ID, (Object)tentativeCheck.getC_BP_BankAccount_ID());
        }
        if (Util.isEmpty((String)m_BankTransferFeeDeduct.getDescription())) {
            inv.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Bank_Transfer_Fee_Invoice"));
        } else {
            inv.setDescription(m_BankTransferFeeDeduct.getDescription());
        }
        inv.setC_DocTypeTarget_ID(m_BankTransferFeeDeduct.getC_DocType_ID());
        inv.setM_PriceList_ID(m_BankTransferFeeDeduct.getM_PriceList_ID());
        inv.setPaymentRule(m_BankTransferFeeDeduct.getPaymentRule());
        inv.setC_Payment_ID(m_BankTransferFeeDeduct.getC_PaymentTerm_ID());
        inv.saveEx(this.get_TrxName());
        MInvoiceLine invLine = new MInvoiceLine(inv);
        invLine.setLine(m_BankTransferFeeDeduct.getLine());
        if (m_BankTransferFeeDeduct.getM_Product_ID() > 0) {
            invLine.setM_Product_ID(m_BankTransferFeeDeduct.getM_Product_ID());
            invLine.setC_UOM_ID(m_BankTransferFeeDeduct.getM_Product().getC_UOM_ID());
        } else {
            invLine.setC_Charge_ID(m_BankTransferFeeDeduct.getC_Charge_ID());
            invLine.setC_UOM_ID(100);
        }
        invLine.setQtyEntered(Env.ONE);
        invLine.setQtyInvoiced(Env.ONE);
        invLine.setPrice(m_BankTransferFeeDeduct.getPriceEntered());
        invLine.setLine(m_BankTransferFeeDeduct.getC_Tax_ID());
        invLine.saveEx(this.get_TrxName());
        if (inv.processIt("CO")) {
            inv.saveEx(this.get_TrxName());
            MPaySelectionLine psl = new MPaySelectionLine(this.m_PaySelection, line, m_BankTransferFeeDeduct.getPaymentRule());
            if (Util.isEmpty((String)m_BankTransferFeeDeduct.getDescription())) {
                psl.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Bank_Transfer_Fee_Invoice"));
            } else {
                psl.setDescription(m_BankTransferFeeDeduct.getDescription());
            }
            if (m_BankTransferFeeDeduct.getC_DocType().getDocBaseType().equals("APC")) {
                psl.setInvoice(inv.getC_Invoice_ID(), inv.isSOTrx(), m_BankTransferFeeDeduct.getPriceEntered().negate(), m_BankTransferFeeDeduct.getPriceEntered().negate(), Env.ZERO, Env.ZERO);
            } else {
                psl.setInvoice(inv.getC_Invoice_ID(), inv.isSOTrx(), m_BankTransferFeeDeduct.getPriceEntered(), m_BankTransferFeeDeduct.getPriceEntered(), Env.ZERO, Env.ZERO);
            }
            psl.set_ValueNoCheck(IS_AUTO_CAL_BANK_TRANSFER_FEE, (Object)true);
            psl.saveEx(this.get_TrxName());
            tentativeCheck.setC_Invoice_ID(inv.getC_Invoice_ID());
            tentativeCheck.setJP_BankTransferFee(m_BankTransferFeeDeduct.getPriceEntered());
            tentativeCheck.saveEx(this.get_TrxName());
            return true;
        }
        return false;
    }
}

