/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MYayoiJournalJP;
import jpiere.base.plugin.org.adempiere.model.X_T_Yayoi_JournalJP;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MElementValue;
import org.compiere.model.MFactAcct;
import org.compiere.model.MOrg;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CreateYayoiJournal
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private String p_PostingType = "A";
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_AD_Table_ID = 0;
    private int p_Record_ID = 0;
    private IProcessUI processUI = null;
    private String TAX_EXCLUDE = "\u5bfe\u8c61\u5916";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("PostingType")) {
                    this.p_PostingType = para[i].getParameterAsString();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = para[i].getParameterAsTimestamp();
                    this.p_DateAcct_To = para[i].getParameter_ToAsTimestamp();
                } else if (name.equals("AD_Table_ID")) {
                    this.p_AD_Table_ID = para[i].getParameterAsInt();
                } else if (name.equals("Record_ID")) {
                    this.p_Record_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
    }

    protected String doIt() throws Exception {
        ArrayList<MFactAcct> factAcctList;
        HashMap<Integer, MElementValue> accountMap;
        block55: {
            ResultSet rs;
            CPreparedStatement pstmt;
            StringBuilder sql;
            block53: {
                if (this.processUI != null) {
                    this.processUI.statusUpdate("Load Account");
                }
                accountMap = new HashMap<Integer, MElementValue>();
                sql = new StringBuilder("SELECT * FROM C_ElementValue ").append(" WHERE AD_Client_ID = ? AND IsSummary = 'N'  ");
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), null);
                        pstmt.setInt(1, this.getAD_Client_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MElementValue ev = new MElementValue(this.getCtx(), rs, this.get_TrxName());
                            accountMap.put(ev.getC_ElementValue_ID(), ev);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, e.toString());
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block53;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            if (this.processUI != null) {
                this.processUI.statusUpdate("Load iDempiere Journal");
            }
            factAcctList = new ArrayList<MFactAcct>();
            sql = new StringBuilder("SELECT * FROM FACT_ACCT f").append(" WHERE C_AcctSchema_ID = ? AND PostingType = ?  AND DateAcct >= ? AND DateAcct <= ? ");
            if (this.p_AD_Org_ID > 0) {
                sql.append(" AND AD_Org_ID = ? ");
            }
            if (this.p_AD_Table_ID > 0) {
                sql.append(" AND AD_Table_ID = ? ");
            }
            if (this.p_Record_ID > 0) {
                sql.append(" AND Record_ID = ? ");
            }
            sql.append(" ORDER BY DateAcct ASC, AD_Table_ID, Record_ID, FACT_ACCT_ID ");
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    int i = 1;
                    pstmt.setInt(i++, this.p_C_AcctSchema_ID);
                    pstmt.setString(i++, this.p_PostingType);
                    pstmt.setTimestamp(i++, this.p_DateAcct_From);
                    pstmt.setTimestamp(i++, this.p_DateAcct_To);
                    if (this.p_AD_Org_ID > 0) {
                        pstmt.setInt(i++, this.p_AD_Org_ID);
                    }
                    if (this.p_AD_Table_ID > 0) {
                        pstmt.setInt(i++, this.p_AD_Table_ID);
                    }
                    if (this.p_Record_ID > 0) {
                        pstmt.setInt(i++, this.p_Record_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        factAcctList.add(new MFactAcct(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.toString());
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block55;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MYayoiJournalJP m_YayoiJournal = null;
        X_T_Yayoi_JournalJP last_YayoiJournal = null;
        MElementValue m_ElementValue = null;
        MTable m_Table = null;
        String tableNameTrl = null;
        PO document = null;
        int record_ID = 0;
        int counter = 0;
        int listSize = factAcctList.size();
        for (MFactAcct fa : factAcctList) {
            MTax tax;
            m_YayoiJournal = new MYayoiJournalJP(this.getCtx(), 0, this.get_TrxName());
            m_YayoiJournal.setAD_PInstance_ID(this.getAD_PInstance_ID());
            m_YayoiJournal.setAD_Org_ID(fa.getAD_Org_ID());
            m_YayoiJournal.setDateAcct(fa.getDateAcct());
            m_YayoiJournal.setPostingType(fa.getPostingType());
            m_YayoiJournal.setC_AcctSchema_ID(fa.getC_AcctSchema_ID());
            m_YayoiJournal.setFact_Acct_ID(fa.getFact_Acct_ID());
            m_YayoiJournal.setAD_Table_ID(fa.getAD_Table_ID());
            m_YayoiJournal.setRecord_ID(fa.getRecord_ID());
            if (record_ID != fa.getRecord_ID()) {
                record_ID = fa.getRecord_ID();
                m_YayoiJournal.setJP_Yayoi_IdentifierFlag("2110");
                m_Table = MTable.get((Properties)this.getCtx(), (int)fa.getAD_Table_ID());
                tableNameTrl = m_Table.get_Translation("Name");
                document = m_Table.getPO(fa.getRecord_ID(), this.get_TrxName());
                if (last_YayoiJournal != null && last_YayoiJournal.getJP_Yayoi_IdentifierFlag().equals("2100")) {
                    last_YayoiJournal.setJP_Yayoi_IdentifierFlag("2101");
                    last_YayoiJournal.saveEx(this.get_TrxName());
                }
            } else {
                m_YayoiJournal.setJP_Yayoi_IdentifierFlag("2100");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            String JP_Yayoi_DateAcct = sdf.format(fa.getDateAcct());
            m_YayoiJournal.setJP_Yayoi_DateAcct(JP_Yayoi_DateAcct);
            if (fa.getAmtAcctDr().signum() != 0) {
                m_ElementValue = (MElementValue)accountMap.get(fa.getAccount_ID());
                if (m_ElementValue.get_Value("JP_IF_Value") == null) {
                    m_YayoiJournal.setJP_Yayoi_DrAcct(m_ElementValue.getValue());
                } else {
                    m_YayoiJournal.setJP_Yayoi_DrAcct(m_ElementValue.get_ValueAsString("JP_IF_Value"));
                }
            }
            m_YayoiJournal.setJP_Yayoi_DrOrg(MOrg.get((Properties)this.getCtx(), (int)fa.getAD_Org_ID()).getName());
            if (fa.getC_Tax_ID() == 0) {
                m_YayoiJournal.setJP_Yayoi_DrTax(this.TAX_EXCLUDE);
            } else if (fa.getAmtAcctDr().signum() == 0) {
                m_YayoiJournal.setJP_Yayoi_DrTax(this.TAX_EXCLUDE);
            } else {
                tax = MTax.get((Properties)this.getCtx(), (int)fa.getC_Tax_ID());
                if (tax.get_Value("JP_IF_Value") == null) {
                    m_YayoiJournal.setJP_Yayoi_DrTax(this.TAX_EXCLUDE);
                } else {
                    m_YayoiJournal.setJP_Yayoi_DrTax(tax.get_ValueAsString("JP_IF_Value"));
                }
            }
            m_YayoiJournal.setJP_Yayoi_DrAmt(fa.getAmtAcctDr().intValue());
            m_YayoiJournal.setJP_Yayoi_DrTaxAmt(0);
            if (fa.getAmtAcctCr().signum() != 0) {
                m_ElementValue = (MElementValue)accountMap.get(fa.getAccount_ID());
                if (m_ElementValue.get_Value("JP_IF_Value") == null) {
                    m_YayoiJournal.setJP_Yayoi_CrAcct(m_ElementValue.getValue());
                } else {
                    m_YayoiJournal.setJP_Yayoi_CrAcct(m_ElementValue.get_ValueAsString("JP_IF_Value"));
                }
            }
            m_YayoiJournal.setJP_Yayoi_CrOrg(MOrg.get((Properties)this.getCtx(), (int)fa.getAD_Org_ID()).getName());
            if (fa.getC_Tax_ID() == 0) {
                m_YayoiJournal.setJP_Yayoi_CrTax(this.TAX_EXCLUDE);
            } else if (fa.getAmtAcctCr().signum() == 0) {
                m_YayoiJournal.setJP_Yayoi_CrTax(this.TAX_EXCLUDE);
            } else {
                tax = MTax.get((Properties)this.getCtx(), (int)fa.getC_Tax_ID());
                if (tax.get_Value("JP_IF_Value") == null) {
                    m_YayoiJournal.setJP_Yayoi_CrTax(this.TAX_EXCLUDE);
                } else {
                    m_YayoiJournal.setJP_Yayoi_CrTax(tax.get_ValueAsString("JP_IF_Value"));
                }
            }
            m_YayoiJournal.setJP_Yayoi_CrAmt(fa.getAmtAcctCr().intValue());
            m_YayoiJournal.setJP_Yayoi_CrTaxAmt(0);
            if (document.get_ColumnIndex("DocumentNo") >= 0) {
                if (document.get_ColumnIndex("Description") >= 0 && !Util.isEmpty((String)document.get_ValueAsString("Description"))) {
                    m_YayoiJournal.setJP_Yayoi_Tekiyou(String.valueOf(document.get_ValueAsString("DocumentNo")) + "(" + tableNameTrl + ")" + " " + document.get_ValueAsString("Description"));
                } else {
                    m_YayoiJournal.setJP_Yayoi_Tekiyou(String.valueOf(document.get_ValueAsString("DocumentNo")) + "(" + tableNameTrl + ")");
                }
            } else if (document.get_ColumnIndex("Name") >= 0) {
                if (document.get_ColumnIndex("Description") >= 0 && !Util.isEmpty((String)document.get_ValueAsString("Description"))) {
                    m_YayoiJournal.setJP_Yayoi_Tekiyou(String.valueOf(document.get_ValueAsString("Name")) + "(" + tableNameTrl + ")" + " " + document.get_ValueAsString("Description"));
                } else {
                    m_YayoiJournal.setJP_Yayoi_Tekiyou(String.valueOf(document.get_ValueAsString("Name")) + "(" + tableNameTrl + ")");
                }
            } else if (document.get_ColumnIndex("Description") >= 0) {
                m_YayoiJournal.setJP_Yayoi_Tekiyou("(" + tableNameTrl + ")" + " " + document.get_ValueAsString("Description"));
            }
            m_YayoiJournal.setJP_Yayoi_Bango(String.valueOf(fa.getRecord_ID()));
            m_YayoiJournal.setJP_Yayoi_Type(3);
            m_YayoiJournal.setJP_Yayoi_Shiwakememo(fa.getDescription());
            m_YayoiJournal.setJP_Yayoi_Chousei("no");
            last_YayoiJournal = m_YayoiJournal;
            if (++counter == listSize) {
                m_YayoiJournal.setJP_Yayoi_IdentifierFlag("2101");
            } else if (this.processUI != null) {
                this.processUI.statusUpdate("Convert From iDempiere to Yayoi : " + counter + " / " + listSize);
            }
            m_YayoiJournal.saveEx(this.get_TrxName());
        }
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Success")) + " - " + Msg.getElement((Properties)this.getCtx(), (String)"T_Yayoi_JournalJP_ID") + " : " + listSize;
    }
}

