/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_GLJournalJP;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Service;
import org.adempiere.model.GenericPO;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MFactAcct;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class CreateReversingEntry
extends SvrProcess {
    private int p_C_AcctSchema_ID = 0;
    private int p_AD_Org_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_AD_Table_ID = 0;
    private int p_Record_ID = 0;
    private int p_C_DocType_ID = 0;
    private String p_DocAction = null;
    private IProcessUI processMonitor = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                    this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("AD_Table_ID")) {
                    this.p_AD_Table_ID = para[i].getParameterAsInt();
                } else if (name.equals("Record_ID")) {
                    this.p_Record_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
    }

    protected String doIt() throws Exception {
        String deleteSQL = "DELETE FROM I_GLJournalJP WHERE AD_Client_ID=?";
        int deleteNum = DB.executeUpdate((String)deleteSQL, (int)this.getAD_Client_ID(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Delete I_GLJournalJP -> #" + deleteNum);
        }
        this.commitEx();
        MFactAcct[] targetFact = this.getTargetReversingEntry();
        String JP_DataMigration_Identifier = null;
        String preJP_DataMigration_Identifier = null;
        String preDocumentNo = null;
        StringBuffer sql = new StringBuffer("SELECT JP_DataMigration_Identifier FROM GL_Journal WHERE AD_Client_ID=? AND C_AcctSchema_ID=? AND JP_DataMigration_Identifier=?");
        boolean isSkip = false;
        int recordsNum = targetFact.length;
        int skipNum = 0;
        int errorNum = 0;
        int successNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String skipRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfSkipRecords");
        String errorRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfUnexpectedErrorRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        X_I_GLJournalJP impJournal = null;
        int i = 0;
        while (i < targetFact.length) {
            block19: {
                block20: {
                    block16: {
                        block17: {
                            block18: {
                                impJournal = null;
                                JP_DataMigration_Identifier = "RE-" + targetFact[i].getAD_Table_ID() + "-" + targetFact[i].getRecord_ID();
                                if (!JP_DataMigration_Identifier.equals(preJP_DataMigration_Identifier)) break block17;
                                if (!isSkip) break block18;
                                ++skipNum;
                                break block19;
                            }
                            impJournal = new X_I_GLJournalJP(this.getCtx(), 0, this.get_TrxName());
                            impJournal.setDocumentNo(preDocumentNo);
                            break block20;
                        }
                        CPreparedStatement pstmt = null;
                        ResultSet rs = null;
                        try {
                            try {
                                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                                pstmt.setInt(1, this.getAD_Client_ID());
                                pstmt.setInt(2, this.p_C_AcctSchema_ID);
                                pstmt.setString(3, JP_DataMigration_Identifier);
                                rs = pstmt.executeQuery();
                                isSkip = rs.next();
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                                DB.close(rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                    }
                    if (this.processMonitor != null) {
                        this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum);
                    }
                }
                if (!isSkip) {
                    if (impJournal == null) {
                        impJournal = new X_I_GLJournalJP(this.getCtx(), 0, this.get_TrxName());
                    }
                    if (this.createReversingEntory(targetFact[i], impJournal, JP_DataMigration_Identifier)) {
                        ++successNum;
                    } else {
                        this.addLog(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " -> " + JP_DataMigration_Identifier);
                        ++errorNum;
                    }
                } else {
                    ++skipNum;
                }
                preJP_DataMigration_Identifier = JP_DataMigration_Identifier;
                if (impJournal != null) {
                    preDocumentNo = impJournal.getDocumentNo();
                }
            }
            ++i;
        }
        this.commitEx();
        this.addLog(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum);
        if (!Util.isEmpty((String)this.p_DocAction)) {
            ProcessInfo pi = new ProcessInfo("CreateBaseDoc", 0);
            String className = "jpiere.base.plugin.org.adempiere.process.JPiereImportGLJournal";
            pi.setClassName(className);
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
            pi.setRecord_ID(0);
            ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
            list.add(new ProcessInfoParameter("DeleteOldImported", (Object)false, null, null, null));
            list.add(new ProcessInfoParameter("IsValidateOnly", (Object)false, null, null, null));
            list.add(new ProcessInfoParameter("DocAction", (Object)this.p_DocAction, null, null, null));
            list.add(new ProcessInfoParameter("JP_CollateGLJournalPolicy", (Object)"MI", null, null, null));
            list.add(new ProcessInfoParameter("JP_ReimportPolicy", (Object)"NI", null, null, null));
            list.add(new ProcessInfoParameter("IsReleaseDocControlledJP", (Object)true, null, null, null));
            ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
            list.toArray(pars);
            pi.setParameter(pars);
            if (!ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI)) {
                return Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError");
            }
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK");
    }

    private MFactAcct[] getTargetReversingEntry() {
        ArrayList<MFactAcct> list;
        block14: {
            list = new ArrayList<MFactAcct>();
            StringBuffer select = new StringBuffer("SELECT * FROM FACT_ACCT f ");
            StringBuffer where = new StringBuffer(" WHERE f.DateAcct >= ? AND f.DateAcct <=? AND f.AD_Client_ID=? AND f.C_AcctSchema_ID=? AND f.PostingType='A'");
            if (this.p_AD_Org_ID > 0) {
                where.append(" AND f.AD_Org_ID=?");
            }
            if (this.p_AD_Table_ID > 0) {
                where.append(" AND f.AD_Table_ID=?");
                if (this.p_AD_Table_ID == 224) {
                    select.append(" INNER JOIN GL_Journal j ON ( f.Record_ID = j.GL_Journal_ID AND f.AD_Table_ID=224 ) ");
                    where.append(" AND JP_DataMigration_Identifier IS NULL ");
                }
            } else {
                where.append(" AND f.AD_Table_ID<>224");
            }
            if (this.p_AD_Table_ID > 0 && this.p_Record_ID > 0) {
                where.append(" AND f.Record_ID=?");
            }
            where.append(" ORDER BY f.DateAcct, f.AD_Table_ID, f.Record_ID, f.Fact_Acct_ID");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)(String.valueOf(select.toString()) + where.toString()), (String)this.get_TrxName());
                    pstmt.setTimestamp(1, this.p_DateAcct_From);
                    pstmt.setTimestamp(2, this.p_DateAcct_To);
                    pstmt.setInt(3, this.getAD_Client_ID());
                    pstmt.setInt(4, this.p_C_AcctSchema_ID);
                    int i = 4;
                    if (this.p_AD_Org_ID > 0) {
                        pstmt.setInt(++i, this.p_AD_Org_ID);
                    }
                    if (this.p_AD_Table_ID > 0) {
                        pstmt.setInt(++i, this.p_AD_Table_ID);
                    }
                    if (this.p_AD_Table_ID > 0 && this.p_Record_ID > 0) {
                        pstmt.setInt(++i, this.p_Record_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MFactAcct(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, where.toString(), (Throwable)e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MFactAcct[] m_accounts = new MFactAcct[list.size()];
        list.toArray(m_accounts);
        return m_accounts;
    }

    private boolean createReversingEntory(MFactAcct targetFact, X_I_GLJournalJP impJournal, String JP_DataMigration_Identifier) {
        PO.copyValues((PO)targetFact, (PO)impJournal);
        impJournal.setAD_Org_ID(targetFact.getAD_Org_ID());
        impJournal.setJP_DataMigration_Identifier(JP_DataMigration_Identifier);
        impJournal.setLine(targetFact.getFact_Acct_ID());
        impJournal.setJP_ConversionType_Value("S");
        impJournal.setC_DocType_ID(this.p_C_DocType_ID);
        impJournal.setJP_Description_Header(targetFact.getDescription());
        impJournal.setJP_Description_Line(targetFact.getDescription());
        impJournal.setAmtSourceDr(impJournal.getAmtSourceDr().negate());
        impJournal.setAmtSourceCr(impJournal.getAmtSourceCr().negate());
        impJournal.setAmtAcctDr(impJournal.getAmtAcctDr().negate());
        impJournal.setAmtAcctCr(impJournal.getAmtAcctCr().negate());
        impJournal.setQty(impJournal.getQty().negate());
        if (Util.isEmpty((String)impJournal.getDocumentNo())) {
            impJournal.setDocumentNo(this.getDocumentNo(targetFact, JP_DataMigration_Identifier));
        }
        impJournal.saveEx(this.get_TrxName());
        return true;
    }

    private String getDocumentNo(MFactAcct targetFact, String JP_DataMigration_Identifier) {
        MTable table = MTable.get((Properties)this.getCtx(), (int)targetFact.getAD_Table_ID());
        String tableName = table.getTableName();
        GenericPO po = null;
        List factoryList = Service.locator().list(IModelFactory.class).getServices();
        if (factoryList != null) {
            for (IModelFactory factory : factoryList) {
                po = factory.getPO(tableName, targetFact.getRecord_ID(), this.get_TrxName());
                if (po == null) continue;
                if (po.get_ID() == targetFact.getRecord_ID() || targetFact.getRecord_ID() <= 0) break;
                po = null;
            }
        }
        if (po == null && (po = new GenericPO(tableName, this.getCtx(), targetFact.getRecord_ID(), this.get_TrxName())).get_ID() != targetFact.getRecord_ID() && targetFact.getRecord_ID() > 0) {
            po = null;
        }
        if (po == null) {
            return null;
        }
        if (po.get_ColumnIndex("DocumentNo") >= 0) {
            return po.get_ValueAsString("DocumentNo");
        }
        if (po.get_ColumnIndex("Name") >= 0) {
            return String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Record_ID")) + ":" + targetFact.getRecord_ID() + "-" + po.get_ValueAsString("Name");
        }
        return JP_DataMigration_Identifier;
    }
}

