/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreatePaymentBatchFromPaySelection
extends SvrProcess {
    private String p_PaymentRule = null;
    private int p_C_PaySelection_ID = 0;
    private int p_C_DocTYpe_ID = 0;
    private static final CLogger s_log = CLogger.getCLogger(CreatePaymentBatchFromPaySelection.class);

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_DocType_ID")) {
                    this.p_C_DocTYpe_ID = para[i].getParameterAsInt();
                } else if (name.equals("PaymentRule")) {
                    this.p_PaymentRule = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_C_PaySelection_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int JP_PaymentBatch_ID;
        MPaySelection paySelection = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        if (paySelection.get_ColumnIndex("JP_PaymentBatch_ID") > 0 && (JP_PaymentBatch_ID = paySelection.get_ValueAsInt("JP_PaymentBatch_ID")) > 0) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_PaymentBatchAlreadyCreated");
        }
        MPaySelectionCheck[] checks = MPaySelectionCheck.get((int)this.p_C_PaySelection_ID, (String)this.p_PaymentRule, (String)this.get_TrxName());
        if (checks == null || checks.length == 0) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"FindZeroRecords");
        }
        MPaySelectionLine[] pLines = paySelection.getLines(true);
        ArrayList<MInvoice> paidInvoiceList = new ArrayList<MInvoice>();
        MInvoice invoice = null;
        int i = 0;
        while (pLines.length > i) {
            invoice = new MInvoice(this.getCtx(), pLines[i].getC_Invoice_ID(), this.get_TrxName());
            if (invoice.isPaid()) {
                paidInvoiceList.add(invoice);
                this.addBufferLog(this.getProcessInfo().getAD_Process_ID(), null, null, invoice.getDocumentNo(), 318, invoice.getC_Invoice_ID());
            }
            ++i;
        }
        if (paidInvoiceList.size() > 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getElement((Properties)this.getCtx(), (String)"IsPaid", (boolean)paySelection.get_ValueAsBoolean("IsReceiptJP")) + Msg.getElement((Properties)this.getCtx(), (String)"C_Invoice_ID", (boolean)paySelection.get_ValueAsBoolean("IsReceiptJP"));
        }
        MPaymentBatch batch = MPaymentBatch.getForPaySelection((Properties)this.getCtx(), (int)this.getRecord_ID(), (String)this.get_TrxName());
        batch.setProcessingDate(paySelection.getPayDate());
        batch.set_ValueOfColumnReturningBoolean("IsReceiptJP", (Object)paySelection.get_ValueAsBoolean("IsReceiptJP"));
        batch.saveEx(this.get_TrxName());
        MPaySelectionCheck[] mPaySelectionCheckArray = checks;
        int n = checks.length;
        int n2 = 0;
        while (n2 < n) {
            MPaySelectionCheck check = mPaySelectionCheckArray[n2];
            this.createAndAllocatePayment(check, batch);
            ++n2;
        }
        if (paySelection.get_ColumnIndex("JP_PaymentBatch_ID") > 0) {
            paySelection.set_ValueNoCheck("JP_PaymentBatch_ID", (Object)batch.getC_PaymentBatch_ID());
            paySelection.saveEx(this.get_TrxName());
        }
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + " : " + batch.getDocumentNo();
    }

    private void createAndAllocatePayment(MPaySelectionCheck check, MPaymentBatch batch) {
        MPayment payment = new MPayment(this.getCtx(), check.getC_Payment_ID(), this.get_TrxName());
        if (check.getC_Payment_ID() != 0) {
            return;
        }
        payment = new MPayment(check.getCtx(), 0, this.get_TrxName());
        payment.setAD_Org_ID(check.getAD_Org_ID());
        if (check.getPaymentRule().equals("S")) {
            payment.setBankCheck(check.getParent().getC_BankAccount_ID(), false, check.getDocumentNo());
        } else if (check.getPaymentRule().equals("K")) {
            payment.setTenderType("C");
        } else if (check.getPaymentRule().equals("T") || check.getPaymentRule().equals("D")) {
            payment.setBankACH(check);
        } else {
            s_log.log(Level.SEVERE, "Unsupported Payment Rule=" + check.getPaymentRule());
            return;
        }
        payment.setTrxType("C");
        payment.setAmount(check.getParent().getC_Currency_ID(), check.getPayAmt());
        payment.setDiscountAmt(check.getDiscountAmt());
        payment.setWriteOffAmt(check.getWriteOffAmt());
        payment.setDateTrx(check.getParent().getPayDate());
        payment.setDateAcct(payment.getDateTrx());
        payment.setC_BPartner_ID(check.getC_BPartner_ID());
        payment.setC_PaymentBatch_ID(batch.getC_PaymentBatch_ID());
        payment.setC_BP_BankAccount_ID(check.getC_BP_BankAccount_ID());
        MPaySelectionLine[] psls = check.getPaySelectionLines(true);
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("createAndAllocatePayment - " + check + " (#SelectionLines=" + psls.length + ")");
        }
        if (check.getQty() == 1 && psls != null && psls.length == 1) {
            MPaySelectionLine psl = psls[0];
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("Map to Invoice " + psl);
            }
            payment.setC_Invoice_ID(psl.getC_Invoice_ID());
            payment.setDiscountAmt(psl.getDiscountAmt());
            payment.setWriteOffAmt(psl.getWriteOffAmt());
            BigDecimal overUnder = psl.getOpenAmt().subtract(psl.getPayAmt()).subtract(psl.getDiscountAmt()).subtract(psl.getWriteOffAmt()).subtract(psl.getDifferenceAmt());
            payment.setOverUnderAmt(overUnder);
        } else {
            payment.setWriteOffAmt(Env.ZERO);
            payment.setDiscountAmt(Env.ZERO);
        }
        payment.setC_DocType_ID(this.p_C_DocTYpe_ID);
        payment.saveEx(this.get_TrxName());
        int C_Payment_ID = payment.get_ID();
        if (C_Payment_ID < 1) {
            s_log.log(Level.SEVERE, "Payment not created=" + check);
        } else {
            check.setC_Payment_ID(C_Payment_ID);
            check.saveEx(this.get_TrxName());
            if (!payment.processIt("CO")) {
                throw new AdempiereException("Failed when processing document - " + payment.getProcessMsg());
            }
            payment.saveEx(this.get_TrxName());
        }
        check.setIsPrinted(true);
        check.setProcessed(true);
        check.saveEx(this.get_TrxName());
    }
}

