/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.MBillLine;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBankAccount;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreatePaySelectionFromBill
extends SvrProcess {
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private Timestamp p_JP_PromisedPayDate_From = null;
    private Timestamp p_JP_PromisedPayDate_To = null;
    private boolean p_IsSOTrx = false;
    private String p_TargetPaymentRule = null;
    private int p_C_BankAccount_ID = 0;
    private Timestamp p_PayDate = null;
    private int p_JP_Bill_ID = 0;
    private int p_C_PaySelection_ID = 0;
    private MPaySelection m_PaySelection = null;
    private boolean isCalledFromDocumentWindow = false;
    private boolean isCalledFromProcessWindow = false;
    private boolean isCalledFromInfoWindow = false;
    ArrayList<MBill> p_selectedBillList = new ArrayList();
    ArrayList<MBill> p_searchedBillList = new ArrayList();
    private MBankAccount m_BankAccount = null;
    private IProcessUI processUI = null;
    private boolean isOpenDialog = false;
    private boolean isAskAnswer = true;
    private boolean isCreatePaySelection = false;
    private int createLines = 0;
    private int maxLineNo = 0;

    protected void prepare() {
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID = JP_Bill.JP_Bill_ID)";
        List selectedBills = new Query(this.getCtx(), "JP_Bill", whereClause, this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getAD_PInstance_ID()}).list();
        this.p_JP_Bill_ID = this.getRecord_ID();
        if (this.p_JP_Bill_ID != 0) {
            this.isCalledFromDocumentWindow = true;
        }
        if (selectedBills.size() != 0) {
            this.isCalledFromInfoWindow = true;
            this.p_selectedBillList = (ArrayList)selectedBills;
        }
        if (!this.isCalledFromInfoWindow && !this.isCalledFromDocumentWindow) {
            this.isCalledFromProcessWindow = true;
        }
    }

    protected String doIt() throws Exception {
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        if (this.isCalledFromDocumentWindow) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("TargetPaymentRule")) {
                        this.p_TargetPaymentRule = para[i].getParameterAsString();
                    } else if (name.equals("C_BankAccount_ID")) {
                        this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                    } else if (name.equals("PayDate")) {
                        this.p_PayDate = (Timestamp)para[i].getParameter();
                    } else if (name.equals("C_PaySelection_ID")) {
                        this.p_C_PaySelection_ID = para[i].getParameterAsInt();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            this.isPaySelectionProcessed();
            if (this.p_JP_Bill_ID == 0) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Bill_ID"));
            }
            final MBill m_Bill = new MBill(this.getCtx(), this.p_JP_Bill_ID, this.get_TrxName());
            if (!m_Bill.getDocStatus().equals("CO") && !m_Bill.getDocStatus().equals("CL")) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Not_Completed_Document"));
            }
            this.p_IsSOTrx = m_Bill.isSOTrx();
            final MPaySelection psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
            if (this.p_C_PaySelection_ID == 0) {
                this.m_BankAccount = new MBankAccount(this.getCtx(), this.p_C_BankAccount_ID, this.get_TrxName());
                if (this.m_BankAccount.getC_Currency_ID() != m_Bill.getC_Currency_ID()) {
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency"));
                }
                psel.setAD_Org_ID(this.m_BankAccount.getAD_Org_ID());
                psel.setC_BankAccount_ID(this.p_C_BankAccount_ID);
                psel.setPayDate(this.p_PayDate);
                LocalDateTime dateTime = LocalDateTime.now();
                psel.setName(dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("T", " "));
                psel.set_ValueNoCheck("IsReceiptJP", (Object)m_Bill.isSOTrx());
                psel.saveEx(this.get_TrxName());
            } else {
                if (m_Bill.isSOTrx() != psel.get_ValueAsBoolean("IsReceiptJP")) {
                    throw new Exception("JP_UnexpectedError");
                }
                this.m_BankAccount = new MBankAccount(this.getCtx(), psel.getC_BankAccount_ID(), this.get_TrxName());
            }
            this.getMaxLineNo();
            if (this.processUI != null && m_Bill.getC_PaySelection_ID() != 0) {
                this.isOpenDialog = true;
                this.processUI.ask("JP_CreatePSfromBillAgain", (Callback)new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            CreatePaySelectionFromBill.this.createPaySelectionLine(psel, m_Bill);
                            CreatePaySelectionFromBill.this.isCreatePaySelection = true;
                        } else {
                            CreatePaySelectionFromBill.this.isAskAnswer = false;
                        }
                    }
                });
            } else {
                this.createPaySelectionLine(psel, m_Bill);
                this.isCreatePaySelection = true;
            }
            while (this.isOpenDialog && this.isAskAnswer && !this.isCreatePaySelection) {
                Thread.sleep(2000L);
            }
            MPaySelectionLine[] lines = psel.getLines(true);
            if (lines.length == 0) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FindZeroRecords")) + Msg.getElement((Properties)this.getCtx(), (String)"IsPaid", (boolean)m_Bill.isSOTrx()));
            }
            if (m_Bill.getC_PaySelection_ID() == 0) {
                m_Bill.setC_PaySelection_ID(psel.getC_PaySelection_ID());
                m_Bill.saveEx(this.get_TrxName());
            }
            this.addLog(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)m_Bill.isSOTrx())) + " : " + psel.getName());
            if (this.createLines > 0) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Created")) + " : " + this.createLines + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)this.p_IsSOTrx) + " : " + psel.getName();
            }
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate");
        }
        if (this.isCalledFromInfoWindow) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("TargetPaymentRule")) {
                        this.p_TargetPaymentRule = (String)para[i].getParameter();
                    } else if (name.equals("IsSOTrx")) {
                        this.p_IsSOTrx = "Y".equals(para[i].getParameter());
                    } else if (name.equals("C_BankAccount_ID")) {
                        this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                    } else if (name.equals("PayDate")) {
                        this.p_PayDate = (Timestamp)para[i].getParameter();
                    } else if (name.equals("C_PaySelection_ID")) {
                        this.p_C_PaySelection_ID = para[i].getParameterAsInt();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            this.isPaySelectionProcessed();
            if (this.p_selectedBillList != null && this.p_selectedBillList.size() > 0) {
                MPaySelection psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
                if (this.p_C_PaySelection_ID == 0) {
                    this.m_BankAccount = new MBankAccount(this.getCtx(), this.p_C_BankAccount_ID, this.get_TrxName());
                    if (this.m_BankAccount.getC_Currency_ID() != this.p_selectedBillList.get(0).getC_Currency_ID()) {
                        throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency"));
                    }
                    psel.setAD_Org_ID(this.m_BankAccount.getAD_Org_ID());
                    psel.setC_BankAccount_ID(this.p_C_BankAccount_ID);
                    psel.setPayDate(this.p_PayDate);
                    LocalDateTime dateTime = LocalDateTime.now();
                    psel.setName(dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("T", " "));
                    psel.set_ValueNoCheck("IsReceiptJP", (Object)this.p_IsSOTrx);
                    psel.saveEx(this.get_TrxName());
                } else {
                    this.m_BankAccount = new MBankAccount(this.getCtx(), psel.getC_BankAccount_ID(), this.get_TrxName());
                }
                this.getMaxLineNo();
                int i2 = 0;
                while (i2 < this.p_selectedBillList.size()) {
                    MBill m_Bill = new MBill(this.getCtx(), this.p_selectedBillList.get(i2).getJP_Bill_ID(), this.get_TrxName());
                    if (!m_Bill.getDocStatus().equals("CO") && !m_Bill.getDocStatus().equals("CL")) {
                        throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Not_Completed_Document")) + " - " + m_Bill.getDocumentNo());
                    }
                    if (this.m_BankAccount.getC_Currency_ID() == m_Bill.getC_Currency_ID()) {
                        if (m_Bill.isSOTrx() != psel.get_ValueAsBoolean("IsReceiptJP")) {
                            throw new Exception("JP_UnexpectedError");
                        }
                        this.createPaySelectionLine(psel, m_Bill);
                        if (m_Bill.getC_PaySelection_ID() == 0) {
                            m_Bill.setC_PaySelection_ID(psel.getC_PaySelection_ID());
                            m_Bill.saveEx(this.get_TrxName());
                        }
                    }
                    ++i2;
                }
                this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)this.p_IsSOTrx)) + " : " + psel.getName(), psel.get_Table_ID(), psel.getC_PaySelection_ID());
                if (this.createLines > 0) {
                    return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Created")) + " : " + this.createLines + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)this.p_IsSOTrx) + " : " + psel.getName();
                }
                return Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate");
            }
        } else if (this.isCalledFromProcessWindow) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("C_BPartner_ID")) {
                        this.p_C_BPartner_ID = para[i].getParameterAsInt();
                    } else if (name.equals("C_BP_Group_ID")) {
                        this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                    } else if (name.equals("JP_PromisedPayDate")) {
                        this.p_JP_PromisedPayDate_From = (Timestamp)para[i].getParameter();
                        this.p_JP_PromisedPayDate_To = (Timestamp)para[i].getParameter_To();
                    } else if (name.equals("TargetPaymentRule")) {
                        this.p_TargetPaymentRule = (String)para[i].getParameter();
                    } else if (name.equals("IsSOTrx")) {
                        this.p_IsSOTrx = "Y".equals(para[i].getParameter());
                    } else if (name.equals("C_BankAccount_ID")) {
                        this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                    } else if (name.equals("PayDate")) {
                        this.p_PayDate = (Timestamp)para[i].getParameter();
                    } else if (name.equals("C_PaySelection_ID")) {
                        this.p_C_PaySelection_ID = para[i].getParameterAsInt();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            this.isPaySelectionProcessed();
            if (this.p_C_BankAccount_ID == 0 && this.m_PaySelection != null) {
                this.p_C_BankAccount_ID = this.m_PaySelection.getC_BankAccount_ID();
            }
            this.m_BankAccount = new MBankAccount(this.getCtx(), this.p_C_BankAccount_ID, this.get_TrxName());
            StringBuilder sql = new StringBuilder("SELECT * FROM JP_Bill b INNER JOIN C_BPartner bp ON (b.C_BPartner_ID = bp.C_BPartner_ID) WHERE b.DocStatus IN ('CO','CL') ");
            if (this.p_C_BPartner_ID != 0) {
                sql.append("AND b.C_BPartner_ID = ? ");
            }
            if (this.p_C_BP_Group_ID != 0) {
                sql.append(" AND bp.C_BP_Group_ID = ? ");
            }
            if (this.p_JP_PromisedPayDate_From != null) {
                sql.append(" AND b.JP_PromisedPayDate >= ?");
            }
            if (this.p_JP_PromisedPayDate_To != null) {
                sql.append(" AND b.JP_PromisedPayDate <= ?");
            }
            if (this.p_IsSOTrx) {
                sql.append(" AND b.IsSOTrx= ?");
            } else {
                sql.append(" AND b.IsSOTrx= ?");
            }
            sql.append(" AND b.C_Currency_ID = ? ");
            sql.append(" AND b.C_PaySelection_ID is null ");
            sql.append(" ORDER BY b.C_BPartner_ID ");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    int i3 = 0;
                    if (this.p_C_BPartner_ID != 0) {
                        pstmt.setInt(++i3, this.p_C_BPartner_ID);
                    }
                    if (this.p_C_BP_Group_ID != 0) {
                        pstmt.setInt(++i3, this.p_C_BP_Group_ID);
                    }
                    if (this.p_JP_PromisedPayDate_From != null) {
                        pstmt.setTimestamp(++i3, this.p_JP_PromisedPayDate_From);
                    }
                    if (this.p_JP_PromisedPayDate_To != null) {
                        pstmt.setTimestamp(++i3, this.p_JP_PromisedPayDate_To);
                    }
                    ++i3;
                    if (this.p_IsSOTrx) {
                        pstmt.setString(i3, "Y");
                    } else {
                        pstmt.setString(i3, "N");
                    }
                    pstmt.setInt(++i3, this.m_BankAccount.getC_Currency_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.p_searchedBillList.add(new MBill(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"DBExecuteError"));
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            if (this.p_searchedBillList != null && this.p_searchedBillList.size() > 0) {
                MPaySelection psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
                if (this.p_C_PaySelection_ID == 0) {
                    psel.setAD_Org_ID(this.m_BankAccount.getAD_Org_ID());
                    psel.setC_BankAccount_ID(this.p_C_BankAccount_ID);
                    psel.setPayDate(this.p_PayDate);
                    LocalDateTime dateTime = LocalDateTime.now();
                    psel.setName(dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("T", " "));
                    psel.set_ValueNoCheck("IsReceiptJP", (Object)this.p_IsSOTrx);
                    psel.saveEx(this.get_TrxName());
                } else {
                    this.m_BankAccount = new MBankAccount(this.getCtx(), psel.getC_BankAccount_ID(), this.get_TrxName());
                }
                this.getMaxLineNo();
                int i4 = 0;
                while (i4 < this.p_searchedBillList.size()) {
                    MBill m_Bill = new MBill(this.getCtx(), this.p_searchedBillList.get(i4).getJP_Bill_ID(), this.get_TrxName());
                    if (!m_Bill.getDocStatus().equals("CO") && !m_Bill.getDocStatus().equals("CL")) {
                        throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Not_Completed_Document")) + " - " + m_Bill.getDocumentNo());
                    }
                    if (this.m_BankAccount.getC_Currency_ID() == m_Bill.getC_Currency_ID()) {
                        if (m_Bill.isSOTrx() != psel.get_ValueAsBoolean("IsReceiptJP")) {
                            throw new Exception("JP_UnexpectedError");
                        }
                        this.createPaySelectionLine(psel, this.p_searchedBillList.get(i4));
                        if (m_Bill.getC_PaySelection_ID() == 0) {
                            m_Bill.setC_PaySelection_ID(psel.getC_PaySelection_ID());
                            m_Bill.saveEx(this.get_TrxName());
                        }
                    }
                    ++i4;
                }
                this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)this.p_IsSOTrx)) + " : " + psel.getName(), psel.get_Table_ID(), psel.getC_PaySelection_ID());
                if (this.createLines > 0) {
                    return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Created")) + " : " + this.createLines + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_PaySelection_ID", (boolean)this.p_IsSOTrx) + " : " + psel.getName();
                }
                return Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate");
            }
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate");
    }

    private int createPaySelectionLine(MPaySelection paySelection, MBill bill) {
        MInvoice invoice = null;
        MDocType docType = null;
        MPaySelectionLine[] psls = paySelection.getLines(true);
        MBillLine[] billLines = bill.getLines();
        boolean isAlreadyCreated = false;
        int i = 0;
        while (i < billLines.length) {
            String msg;
            invoice = new MInvoice(this.getCtx(), billLines[i].getC_Invoice_ID(), this.get_TrxName());
            if (invoice.isPaid()) {
                msg = "Skip: " + invoice.getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"IsPaid", (boolean)invoice.isSOTrx());
                this.addBufferLog(0, null, null, msg, 318, invoice.getC_Invoice_ID());
            } else if (!invoice.getDocStatus().equals("CO") && !invoice.getDocStatus().equals("CL")) {
                msg = "Skip: " + invoice.getDocumentNo() + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Not_Completed_Document");
                this.addBufferLog(0, null, null, msg, 318, invoice.getC_Invoice_ID());
            } else if (this.m_BankAccount.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                msg = "Skip: " + invoice.getDocumentNo() + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency");
                this.addBufferLog(0, null, null, msg, 318, invoice.getC_Invoice_ID());
            } else {
                isAlreadyCreated = false;
                MPaySelectionLine[] mPaySelectionLineArray = psls;
                int n = psls.length;
                int n2 = 0;
                while (n2 < n) {
                    MPaySelectionLine psl = mPaySelectionLineArray[n2];
                    if (invoice.getC_Invoice_ID() == psl.getC_Invoice_ID()) {
                        isAlreadyCreated = true;
                        String msg2 = "Skip: " + invoice.getDocumentNo() + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_AlreadyRegistered");
                        this.addBufferLog(0, null, null, msg2, 318, invoice.getC_Invoice_ID());
                        break;
                    }
                    ++n2;
                }
                if (!isAlreadyCreated) {
                    ++this.createLines;
                    docType = MDocType.get((int)invoice.getC_DocTypeTarget_ID());
                    BigDecimal openAmt = invoice.getOpenAmt();
                    MPaySelectionLine pselLine = new MPaySelectionLine(paySelection, this.createLines * 10 + this.maxLineNo, bill.getPaymentRule());
                    if (docType.getDocBaseType().equals("ARC") || docType.getDocBaseType().equals("APC")) {
                        pselLine.setInvoice(invoice.getC_Invoice_ID(), invoice.isSOTrx(), openAmt.negate(), openAmt.negate(), Env.ZERO, Env.ZERO);
                    } else {
                        pselLine.setInvoice(invoice.getC_Invoice_ID(), invoice.isSOTrx(), openAmt, openAmt, Env.ZERO, Env.ZERO);
                    }
                    pselLine.saveEx(this.get_TrxName());
                }
            }
            ++i;
        }
        return this.createLines;
    }

    private int getMaxLineNo() throws Exception {
        if (this.m_PaySelection == null) {
            return this.maxLineNo;
        }
        String sql = "SELECT NVL(MAX(Line),0) FROM C_PaySelectionLine WHERE C_PaySelection_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                pstmt.setInt(1, this.m_PaySelection.getC_PaySelection_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.maxLineNo = rs.getInt(1);
                }
            }
            catch (Exception e) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"DBExecuteError"));
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return this.maxLineNo;
    }

    private boolean isPaySelectionProcessed() throws Exception {
        if (this.p_C_PaySelection_ID == 0) {
            return false;
        }
        this.m_PaySelection = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        if (this.m_PaySelection.isProcessed()) {
            throw new Exception(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Processed")) + " - " + this.m_PaySelection.getName());
        }
        if (!this.m_PaySelection.isActive()) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotActive")) + " - " + this.m_PaySelection.getName());
        }
        return false;
    }
}

