/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreateOrderLineFromContractLine
extends SvrProcess {
    int record_ID = 0;
    MContractContent m_ContractContent = null;

    protected void prepare() {
        this.record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.record_ID == 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError"));
        }
        MOrder order = new MOrder(this.getCtx(), this.record_ID, this.get_TrxName());
        MOrderLine[] oLines = order.getLines();
        if (oLines.length > 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DocLineCreated"));
        }
        int JP_ContractContent_ID = order.get_ValueAsInt("JP_ContractContent_ID");
        if (JP_ContractContent_ID <= 0) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID"));
        }
        this.m_ContractContent = MContractContent.get(this.getCtx(), JP_ContractContent_ID);
        int JP_ContractProcPeriod_ID = order.get_ValueAsInt("JP_ContractProcPeriod_ID");
        MContractLine[] m_lines = this.m_ContractContent.getLines();
        int i = 0;
        while (i < m_lines.length) {
            if (JP_ContractProcPeriod_ID <= 0 || this.isCreateDocLine(m_lines[i], JP_ContractProcPeriod_ID, true)) {
                MOrderLine oline = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)m_lines[i], (PO)oline);
                oline.setC_Order_ID(order.getC_Order_ID());
                oline.setAD_Org_ID(order.getAD_Org_ID());
                oline.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
                oline.setProcessed(false);
                if (m_lines[i].getC_BPartner_ID() == 0) {
                    oline.setC_BPartner_ID(order.getC_BPartner_ID());
                }
                if (m_lines[i].getC_BPartner_Location_ID() == 0) {
                    oline.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
                }
                oline.setM_Warehouse_ID(order.getM_Warehouse_ID());
                oline.setC_Currency_ID(order.getC_Currency_ID());
                if (m_lines[i].getM_Product_ID() > 0) {
                    oline.setC_UOM_ID(m_lines[i].getM_Product().getC_UOM_ID());
                    oline.setQtyEntered(m_lines[i].getQtyOrdered());
                } else {
                    oline.setQtyEntered(m_lines[i].getQtyEntered());
                }
                oline.setQtyOrdered(m_lines[i].getQtyOrdered());
                oline.setQtyReserved(Env.ZERO);
                oline.setQtyDelivered(Env.ZERO);
                oline.setQtyInvoiced(Env.ZERO);
                oline.set_ValueNoCheck("JP_ContractLine_ID", (Object)m_lines[i].getJP_ContractLine_ID());
                if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC")) {
                    oline.set_ValueOfColumn("JP_ContractProcPeriod_ID", (Object)JP_ContractProcPeriod_ID);
                }
                oline.setDateOrdered(order.getDateOrdered());
                oline.setDatePromised(order.getDatePromised());
                oline.saveEx(this.get_TrxName());
            }
            ++i;
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private boolean isCreateDocLine(MContractLine contractLine, int JP_ContractProcPeriod_ID, boolean isCreateLog) {
        MContractProcPeriod process_Period;
        MContractProcPeriod contractLine_Period;
        MContractProcPeriod lump_ContractProcPeriod;
        if (!contractLine.isCreateDocLineJP()) {
            return false;
        }
        if (!this.m_ContractContent.getParent().getJP_ContractType().equals("PDC")) {
            return true;
        }
        if (contractLine.getJP_BaseDocLinePolicy() != null && (this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("MA") || !this.m_ContractContent.getOrderType().equals("SO"))) {
            MContractProcPeriod process_Period2;
            MContractProcPeriod contractLine_Period2;
            MContractProcPeriod lump_ContractProcPeriod2;
            if (contractLine.getJP_BaseDocLinePolicy().equals("LP") && !(lump_ContractProcPeriod2 = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Lump_ID())).isContainedBaseDocContractProcPeriod(JP_ContractProcPeriod_ID)) {
                return false;
            }
            if (contractLine.getJP_BaseDocLinePolicy().equals("PS") || contractLine.getJP_BaseDocLinePolicy().equals("PB")) {
                contractLine_Period2 = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_ID());
                process_Period2 = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
                if (contractLine_Period2.getStartDate().compareTo(process_Period2.getStartDate()) > 0) {
                    return false;
                }
            }
            if (contractLine.getJP_BaseDocLinePolicy().equals("PE") || contractLine.getJP_BaseDocLinePolicy().equals("PB")) {
                contractLine_Period2 = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_ID());
                process_Period2 = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
                if (contractLine_Period2.getEndDate().compareTo(process_Period2.getEndDate()) < 0) {
                    return false;
                }
            }
            return true;
        }
        if (this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("IO") || this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("BT")) {
            if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("LP") && !(lump_ContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Lump_InOut_ID())).isContainedBaseDocContractProcPeriod(JP_ContractProcPeriod_ID)) {
                return false;
            }
            if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("PS") || contractLine.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                contractLine_Period = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_InOut_ID());
                process_Period = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
                if (contractLine_Period.getStartDate().compareTo(process_Period.getStartDate()) > 0 && contractLine_Period.getStartDate().compareTo(process_Period.getEndDate()) > 0) {
                    return false;
                }
            }
            if (contractLine.getJP_DerivativeDocPolicy_InOut().equals("PE") || contractLine.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                contractLine_Period = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_InOut_ID());
                process_Period = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
                if (contractLine_Period.getEndDate().compareTo(process_Period.getEndDate()) < 0 && contractLine_Period.getEndDate().compareTo(process_Period.getStartDate()) < 0) {
                    return false;
                }
            }
        }
        if (this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("IV") || this.m_ContractContent.getJP_CreateDerivativeDocPolicy().equals("BT")) {
            if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("LP") && !(lump_ContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Lump_Inv_ID())).isContainedBaseDocContractProcPeriod(JP_ContractProcPeriod_ID)) {
                return false;
            }
            if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PS") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                contractLine_Period = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_Inv_ID());
                process_Period = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
                if (contractLine_Period.getStartDate().compareTo(process_Period.getStartDate()) > 0 && contractLine_Period.getStartDate().compareTo(process_Period.getEndDate()) > 0) {
                    return false;
                }
            }
            if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PE") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                contractLine_Period = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_Inv_ID());
                process_Period = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
                if (contractLine_Period.getEndDate().compareTo(process_Period.getEndDate()) < 0 && contractLine_Period.getEndDate().compareTo(process_Period.getStartDate()) < 0) {
                    return false;
                }
            }
        }
        return true;
    }
}

