/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_NonBusinessDay;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class CreateNonBusinessDay
extends SvrProcess {
    private int p_AD_Clinet_ID = 0;
    private int p_C_Calendar_ID = 0;
    private Timestamp p_startDate = null;
    private Timestamp p_endDate = null;
    private int p_AD_Org_ID = 0;
    private int p_C_Coutry_ID = 0;
    private String p_Name = null;
    private boolean onSunday;
    private boolean onMonday;
    private boolean onTuesday;
    private boolean onWednesday;
    private boolean onThursday;
    private boolean onFriday;
    private boolean onSaturday;

    protected void prepare() {
        this.p_AD_Clinet_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Calendar_ID")) {
                    this.p_C_Calendar_ID = para[i].getParameterAsInt();
                } else if (name.equals("StartDate")) {
                    this.p_startDate = para[i].getParameterAsTimestamp();
                    this.p_endDate = para[i].getParameter_ToAsTimestamp();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Country_ID")) {
                    this.p_C_Coutry_ID = para[i].getParameterAsInt();
                } else if (name.equals("Name")) {
                    this.p_Name = para[i].getParameterAsString();
                } else if (name.equals("OnMonday")) {
                    this.onMonday = para[i].getParameterAsBoolean();
                } else if (name.equals("OnTuesday")) {
                    this.onTuesday = para[i].getParameterAsBoolean();
                } else if (name.equals("OnWednesday")) {
                    this.onWednesday = para[i].getParameterAsBoolean();
                } else if (name.equals("OnThursday")) {
                    this.onThursday = para[i].getParameterAsBoolean();
                } else if (name.equals("OnFriday")) {
                    this.onFriday = para[i].getParameterAsBoolean();
                } else if (name.equals("OnSaturday")) {
                    this.onSaturday = para[i].getParameterAsBoolean();
                } else if (name.equals("OnSunday")) {
                    this.onSunday = para[i].getParameterAsBoolean();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int recordCount = 0;
        try {
            Calendar calendarOfTargetDate = Calendar.getInstance();
            calendarOfTargetDate.setTime(this.p_startDate);
            Calendar calendarOfTargetEndDate = Calendar.getInstance();
            calendarOfTargetEndDate.setTime(this.p_endDate);
            boolean isFinished = false;
            while (!isFinished) {
                Date hDate;
                Timestamp holidayDate;
                if (this.isHoliday(calendarOfTargetDate) && !this.isExistHoliday(holidayDate = new Timestamp((hDate = calendarOfTargetDate.getTime()).getTime()), this.p_C_Coutry_ID, this.p_AD_Org_ID)) {
                    X_C_NonBusinessDay nonBizDay = new X_C_NonBusinessDay(this.getCtx(), 0, this.get_TrxName());
                    nonBizDay.setAD_Org_ID(this.p_AD_Org_ID);
                    nonBizDay.setC_Calendar_ID(this.p_C_Calendar_ID);
                    nonBizDay.setName(this.p_Name);
                    nonBizDay.setC_Country_ID(this.p_C_Coutry_ID);
                    nonBizDay.setDate1(holidayDate);
                    nonBizDay.setIsActive(true);
                    nonBizDay.saveEx(this.get_TrxName());
                    ++recordCount;
                }
                calendarOfTargetDate.add(5, 1);
                if (!calendarOfTargetDate.after(calendarOfTargetEndDate)) continue;
                isFinished = true;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.toString());
        }
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Created")) + " : " + String.valueOf(recordCount);
    }

    protected boolean isHoliday(Calendar calendar) {
        boolean isHoliday = false;
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1 && this.onSunday) {
            isHoliday = true;
        } else if (dayOfWeek == 2 && this.onMonday) {
            isHoliday = true;
        } else if (dayOfWeek == 3 && this.onTuesday) {
            isHoliday = true;
        } else if (dayOfWeek == 4 && this.onWednesday) {
            isHoliday = true;
        } else if (dayOfWeek == 5 && this.onThursday) {
            isHoliday = true;
        } else if (dayOfWeek == 6 && this.onFriday) {
            isHoliday = true;
        } else if (dayOfWeek == 7 && this.onSaturday) {
            isHoliday = true;
        }
        return isHoliday;
    }

    private boolean isExistHoliday(Timestamp holidayDate, int C_Country_ID, int AD_Org_ID) {
        block11: {
            StringBuilder sql = new StringBuilder("SELECT Date1 FROM C_NonBusinessDay");
            if (C_Country_ID > 0) {
                sql.append(" WHERE AD_Client_ID=? AND C_Calendar_ID=? AND AD_Org_ID=? AND C_Country_ID=? AND Date1=? ");
            } else {
                sql.append(" WHERE AD_Client_ID=? AND C_Calendar_ID=? AND AD_Org_ID=? AND C_Country_ID IS NULL AND Date1=? ");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), null);
                pstmt.setInt(1, this.p_AD_Clinet_ID);
                pstmt.setInt(2, this.p_C_Calendar_ID);
                pstmt.setInt(3, AD_Org_ID);
                if (C_Country_ID > 0) {
                    pstmt.setInt(4, C_Country_ID);
                    pstmt.setTimestamp(5, holidayDate);
                } else {
                    pstmt.setTimestamp(4, holidayDate);
                }
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    return true;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.toString());
                break block11;
            }
            finally {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return false;
    }
}

