/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MPhysicalWarehouse;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreateNextMovement
extends SvrProcess {
    private static final String IsRecordRouteJP = "IsRecordRouteJP";
    private static final String JP_Processing1 = "JP_Processing1";
    private static final String JP_WarehouseFrom_ID = "JP_WarehouseFrom_ID";
    private static final String JP_PhysicalWarehouseFrom_ID = "JP_PhysicalWarehouseFrom_ID";
    private static final String JP_WarehouseTo_ID = "JP_WarehouseTo_ID";
    private static final String JP_PhysicalWarehouseTo_ID = "JP_PhysicalWarehouseTo_ID";
    private static final String JP_WarehouseNext_ID = "JP_WarehouseNext_ID";
    private static final String JP_PhysicalWarehouseNext_ID = "JP_PhysicalWarehouseNext_ID";
    private static final String JP_MovementDateNext = "JP_MovementDateNext";
    private static final String JP_WarehouseDep_ID = "JP_WarehouseDep_ID";
    private static final String JP_PhysicalWarehouseDep_ID = "JP_PhysicalWarehouseDep_ID";
    private static final String JP_MovementDateDep = "JP_MovementDateDep";
    private static final String JP_WarehouseDst_ID = "JP_WarehouseDst_ID";
    private static final String JP_PhysicalWarehouseDst_ID = "JP_PhysicalWarehouseDst_ID";
    private static final String JP_MovementDateDst = "JP_MovementDateDst";
    private static final String JP_MovementPre_ID = "JP_MovementPre_ID";
    private static final String JP_MovementNext_ID = "JP_MovementNext_ID";
    private int p_AD_Org_ID = 0;
    private int p_C_DocType_ID = 0;
    private int p_JP_WarehouseNext_ID = 0;
    private int p_JP_PhysicalWarehouseNext_ID = 0;
    private int p_M_Locator_ID = 0;
    private Timestamp p_JP_MovementDateNext = null;
    private int p_M_Movement_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals(JP_MovementDateNext)) {
                    this.p_JP_MovementDateNext = para[i].getParameterAsTimestamp();
                } else if (name.equals(JP_WarehouseNext_ID)) {
                    this.p_JP_WarehouseNext_ID = para[i].getParameterAsInt();
                } else if (name.equals(JP_PhysicalWarehouseNext_ID)) {
                    this.p_JP_PhysicalWarehouseNext_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Locator_ID")) {
                    this.p_M_Locator_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_M_Movement_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String msg;
        Object[] objs;
        MMovement from = new MMovement(this.getCtx(), this.p_M_Movement_ID, this.get_TrxName());
        if (from.get_ValueAsInt(JP_MovementNext_ID) != 0) {
            MMovement next_mm = new MMovement(this.getCtx(), from.get_ValueAsInt(JP_MovementNext_ID), this.get_TrxName());
            this.addBufferLog(0, null, null, next_mm.getDocumentNo(), 323, next_mm.getM_Movement_ID());
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_AlreadyRegistered");
        }
        MMovementLine[] lines = from.getLines(true);
        if (lines.length <= 0) {
            this.addLog("");
            return Msg.getMsg((Properties)this.getCtx(), (String)"NoLines");
        }
        if (!(from.getDocStatus().equals("DR") || from.getDocStatus().equals("IP") || from.getDocStatus().equals("CO") || from.getDocStatus().equals("CL"))) {
            this.addLog("");
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_InvalidDocStatus");
        }
        if (this.p_JP_WarehouseNext_ID == 0) {
            this.p_JP_WarehouseNext_ID = from.get_ValueAsInt(JP_WarehouseNext_ID);
        } else {
            from.set_ValueNoCheck(JP_WarehouseNext_ID, (Object)this.p_JP_WarehouseNext_ID);
        }
        if (this.p_JP_PhysicalWarehouseNext_ID == 0) {
            this.p_JP_PhysicalWarehouseNext_ID = from.get_ValueAsInt(JP_PhysicalWarehouseNext_ID);
        } else {
            from.set_ValueNoCheck(JP_PhysicalWarehouseNext_ID, (Object)this.p_JP_PhysicalWarehouseNext_ID);
        }
        if (this.p_C_DocType_ID == 0) {
            this.p_C_DocType_ID = from.getC_DocType_ID();
        }
        if (this.p_JP_MovementDateNext == null) {
            Object obj_JP_MovementDateNext = from.get_Value(JP_MovementDateNext);
            if (obj_JP_MovementDateNext == null) {
                this.p_JP_MovementDateNext = from.getMovementDate();
                from.set_ValueNoCheck(JP_MovementDateNext, (Object)this.p_JP_MovementDateNext);
            } else {
                this.p_JP_MovementDateNext = (Timestamp)obj_JP_MovementDateNext;
            }
        } else {
            from.set_ValueNoCheck(JP_MovementDateNext, (Object)this.p_JP_MovementDateNext);
        }
        if (this.p_M_Locator_ID == 0 && this.p_JP_WarehouseNext_ID != 0) {
            MWarehouse m_wh = MWarehouse.get((int)this.p_JP_WarehouseNext_ID);
            if (this.p_JP_PhysicalWarehouseNext_ID != 0) {
                MPhysicalWarehouse m_pwh = MPhysicalWarehouse.get(this.getCtx(), this.p_JP_PhysicalWarehouseNext_ID, this.get_TrxName());
                MLocator locator = m_pwh.getDefaultLocator(m_wh);
                if (locator != null) {
                    this.p_M_Locator_ID = locator.getM_Locator_ID();
                }
            } else {
                MLocator locator = m_wh.getDefaultLocator();
                if (locator != null) {
                    this.p_M_Locator_ID = locator.getM_Locator_ID();
                }
            }
        }
        if (this.p_M_Locator_ID == 0) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Locator_ID"));
        }
        if (this.p_AD_Org_ID == 0) {
            this.p_AD_Org_ID = from.get_ValueAsInt(JP_WarehouseTo_ID) != 0 ? MWarehouse.get((int)from.get_ValueAsInt(JP_WarehouseTo_ID)).getAD_Org_ID() : from.getAD_Org_ID();
        }
        if (from.get_ValueAsBoolean(IsRecordRouteJP) && from.get_ValueAsInt(JP_WarehouseTo_ID) == 0 && from.get_ValueAsInt(JP_PhysicalWarehouseTo_ID) == 0) {
            objs = new Object[]{Msg.getElement((Properties)this.getCtx(), (String)JP_WarehouseTo_ID), Msg.getElement((Properties)this.getCtx(), (String)JP_PhysicalWarehouseTo_ID)};
            msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Set_Either", (Object[])objs);
            throw new Exception(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)IsRecordRouteJP)) + " = ON : " + msg);
        }
        if (from.get_ValueAsBoolean(IsRecordRouteJP) && from.get_ValueAsInt(JP_WarehouseNext_ID) == 0 && from.get_ValueAsInt(JP_PhysicalWarehouseNext_ID) == 0) {
            objs = new Object[]{Msg.getElement((Properties)this.getCtx(), (String)JP_WarehouseNext_ID), Msg.getElement((Properties)this.getCtx(), (String)JP_PhysicalWarehouseNext_ID)};
            msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Set_Either", (Object[])objs);
            throw new Exception(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)IsRecordRouteJP)) + " = ON : " + msg);
        }
        if (this.p_JP_MovementDateNext.compareTo(from.getMovementDate()) < 0) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getElement((Properties)this.getCtx(), (String)"MovementDate") + " > " + Msg.getElement((Properties)this.getCtx(), (String)JP_MovementDateNext));
        }
        MMovement to = new MMovement(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)from, (PO)to);
        if (from.get_ValueAsInt(JP_WarehouseDep_ID) == 0) {
            to.set_ValueNoCheck(JP_WarehouseDep_ID, null);
        } else {
            to.set_ValueNoCheck(JP_WarehouseDep_ID, (Object)from.get_ValueAsInt(JP_WarehouseDep_ID));
        }
        if (from.get_ValueAsInt(JP_PhysicalWarehouseDep_ID) == 0) {
            to.set_ValueNoCheck(JP_PhysicalWarehouseDep_ID, null);
        } else {
            to.set_ValueNoCheck(JP_PhysicalWarehouseDep_ID, (Object)from.get_ValueAsInt(JP_PhysicalWarehouseDep_ID));
        }
        to.set_ValueNoCheck(JP_MovementDateDep, from.get_Value(JP_MovementDateDep));
        if (from.get_ValueAsInt(JP_WarehouseDst_ID) == 0) {
            to.set_ValueNoCheck(JP_WarehouseDst_ID, null);
        } else {
            to.set_ValueNoCheck(JP_WarehouseDst_ID, (Object)from.get_ValueAsInt(JP_WarehouseDst_ID));
        }
        if (from.get_ValueAsInt(JP_PhysicalWarehouseDst_ID) == 0) {
            to.set_ValueNoCheck(JP_PhysicalWarehouseDst_ID, null);
        } else {
            to.set_ValueNoCheck(JP_PhysicalWarehouseDst_ID, (Object)from.get_ValueAsInt(JP_PhysicalWarehouseDst_ID));
        }
        to.set_ValueNoCheck(JP_MovementDateDst, from.get_Value(JP_MovementDateDst));
        to.setAD_Org_ID(this.p_AD_Org_ID);
        to.setC_DocType_ID(this.p_C_DocType_ID);
        to.setDocumentNo("");
        to.setMovementDate(this.p_JP_MovementDateNext);
        if (from.get_ValueAsInt(JP_WarehouseTo_ID) == 0) {
            to.set_ValueNoCheck(JP_WarehouseFrom_ID, null);
        } else {
            to.set_ValueNoCheck(JP_WarehouseFrom_ID, (Object)from.get_ValueAsInt(JP_WarehouseTo_ID));
        }
        if (from.get_ValueAsInt(JP_PhysicalWarehouseTo_ID) == 0) {
            to.set_ValueNoCheck(JP_PhysicalWarehouseFrom_ID, null);
        } else {
            to.set_ValueNoCheck(JP_PhysicalWarehouseFrom_ID, (Object)from.get_ValueAsInt(JP_PhysicalWarehouseTo_ID));
        }
        if (from.get_ValueAsInt(JP_WarehouseNext_ID) == 0) {
            to.set_ValueNoCheck(JP_WarehouseTo_ID, null);
        } else {
            to.set_ValueNoCheck(JP_WarehouseTo_ID, (Object)from.get_ValueAsInt(JP_WarehouseNext_ID));
        }
        if (from.get_ValueAsInt(JP_PhysicalWarehouseNext_ID) == 0) {
            to.set_ValueNoCheck(JP_PhysicalWarehouseTo_ID, null);
        } else {
            to.set_ValueNoCheck(JP_PhysicalWarehouseTo_ID, (Object)from.get_ValueAsInt(JP_PhysicalWarehouseNext_ID));
        }
        to.set_ValueNoCheck(JP_WarehouseNext_ID, null);
        to.set_ValueNoCheck(JP_PhysicalWarehouseNext_ID, null);
        to.set_ValueNoCheck(JP_MovementDateNext, null);
        to.set_ValueNoCheck(JP_MovementPre_ID, (Object)from.getM_Movement_ID());
        to.set_ValueNoCheck(IsRecordRouteJP, (Object)from.get_ValueAsBoolean(IsRecordRouteJP));
        to.saveEx(this.get_TrxName());
        from.set_ValueNoCheck(JP_Processing1, (Object)"Y");
        from.set_ValueNoCheck(JP_MovementNext_ID, (Object)to.getM_Movement_ID());
        from.saveEx(this.get_TrxName());
        MMovementLine[] mMovementLineArray = from.getLines(false);
        int n = mMovementLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMovementLine fromLine = mMovementLineArray[n2];
            if (fromLine.isActive()) {
                MMovementLine toLine = new MMovementLine(to);
                PO.copyValues((PO)fromLine, (PO)toLine);
                toLine.setM_Movement_ID(to.getM_Movement_ID());
                toLine.setAD_Org_ID(to.getAD_Org_ID());
                toLine.setM_Product_ID(fromLine.getM_Product_ID());
                toLine.setM_Locator_ID(fromLine.getM_LocatorTo_ID());
                toLine.setM_LocatorTo_ID(this.p_M_Locator_ID);
                toLine.setM_AttributeSetInstance_ID(fromLine.getM_AttributeSetInstanceTo_ID());
                toLine.setM_AttributeSetInstanceTo_ID(fromLine.getM_AttributeSetInstanceTo_ID());
                toLine.setMovementQty(fromLine.getMovementQty());
                toLine.setProcessed(false);
                toLine.setTargetQty(Env.ZERO);
                toLine.setScrappedQty(Env.ZERO);
                toLine.setConfirmedQty(Env.ZERO);
                toLine.setReversalLine_ID(0);
                toLine.setDD_OrderLine_ID(0);
                toLine.saveEx();
            }
            ++n2;
        }
        this.addBufferLog(0, null, null, to.getDocumentNo(), 323, to.getM_Movement_ID());
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Created")) + " : " + to.getDocumentNo();
    }
}

