/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLog;
import jpiere.base.plugin.org.adempiere.model.MContractLogDetail;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MRefList;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreateInvoiceFromRecogManual
extends SvrProcess {
    private Timestamp p_DateInvoiced = null;
    private Timestamp p_DateAcct = null;
    private String p_DocAction = null;
    private MContractLog m_ContractLog = null;
    private MOrder m_Order = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced = para[i].getParameterAsTimestamp();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct = para[i].getParameterAsTimestamp();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_ContractLog = new MContractLog(this.getCtx(), 0, this.get_TrxName());
        this.m_ContractLog.setAD_PInstance_ID(this.getAD_PInstance_ID());
        this.m_ContractLog.saveEx(this.get_TrxName());
        int JP_ContractLog_ID = this.m_ContractLog.getJP_ContractLog_ID();
        this.addBufferLog(0, null, null, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DetailLog")) + " -> " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLog_ID"), MContractLog.Table_ID, JP_ContractLog_ID);
    }

    protected String doIt() throws Exception {
        MRecognition[] recogs = this.getRocognitions();
        MInvoice invoice = null;
        int linecounter = 1;
        int i = 0;
        while (i < recogs.length) {
            String msg;
            if (i == 0) {
                MContractContent content = MContractContent.get(this.getCtx(), recogs[i].getJP_ContractContent_ID());
                MContractAcct acct = MContractAcct.get(this.getCtx(), content.getJP_Contract_Acct_ID());
                if (acct.getJP_RecogToInvoicePolicy() == null || acct.getJP_RecogToInvoicePolicy().equals("NO")) {
                    String JP_RecogToInvoicePolic = null;
                    if (acct.getJP_RecogToInvoicePolicy().equals("NO")) {
                        JP_RecogToInvoicePolic = MRefList.getListDescription((Properties)this.getCtx(), (String)"JP_RecogToInvoicePolicy", (String)acct.getJP_RecogToInvoicePolicy());
                    } else if (acct.getJP_RecogToInvoicePolicy() == null) {
                        JP_RecogToInvoicePolic = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null");
                    }
                    msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + "   " + Msg.getElement((Properties)this.getCtx(), (String)"JP_RecogToInvoicePolicy") + " : " + JP_RecogToInvoicePolic;
                    this.createContractLogDetail("W9", recogs[i], msg);
                    break;
                }
                this.m_Order = new MOrder(this.getCtx(), recogs[i].getC_Order_ID(), this.get_TrxName());
                if (this.m_Order == null) {
                    this.createContractLogDetail("ZZ", null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_Order_ID", (boolean)this.m_Order.isSOTrx())) + "  " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null"));
                    break;
                }
                if (!this.m_Order.getDocStatus().equals("CO") && !this.m_Order.getDocStatus().equals("CL")) {
                    this.createContractLogDetail("W9", (PO)this.m_Order, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"C_Order_ID", (boolean)this.m_Order.isSOTrx()) + "  " + this.m_Order.getDocumentNo());
                    break;
                }
            }
            if (!recogs[i].getDocStatus().equals("CO") && !recogs[i].getDocStatus().equals("CL")) {
                this.createContractLogDetail("B9", recogs[i], String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus"));
            } else if (recogs[i].getM_RMA_ID() > 0) {
                this.createContractLogDetail("B9", recogs[i], Msg.getElement((Properties)this.getCtx(), (String)"M_RMA_ID", (boolean)recogs[i].isSOTrx()));
            } else {
                MRecognitionLine[] rLines = recogs[i].getLines();
                int j = 0;
                while (j < rLines.length) {
                    MInvoiceLine iLine;
                    if (rLines[j].getC_InvoiceLine_ID() > 0) {
                        iLine = new MInvoiceLine(this.getCtx(), rLines[j].getC_InvoiceLine_ID(), this.get_TrxName());
                        msg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_Invoice_ID", (boolean)recogs[i].isSOTrx())) + " : " + iLine.getParent().getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + iLine.getLine();
                        this.createContractLogDetail("B9", rLines[j], msg);
                    } else {
                        if (invoice == null) {
                            int C_Order_ID = recogs[i].getC_Order_ID();
                            MOrder order = new MOrder(this.getCtx(), C_Order_ID, this.get_TrxName());
                            invoice = new MInvoice(order, order.getC_DocTypeTarget().getC_DocTypeInvoice_ID(), this.p_DateInvoiced);
                            invoice.setDateAcct(this.p_DateAcct);
                            invoice.setDocumentNo(null);
                            invoice.setTotalLines(Env.ZERO);
                            invoice.setGrandTotal(Env.ZERO);
                            invoice.setDocStatus("DR");
                            invoice.setDocAction("CO");
                            try {
                                invoice.saveEx(this.get_TrxName());
                            }
                            catch (AdempiereException e) {
                                this.createContractLogDetail("Z1", null, e.getMessage());
                                throw e;
                            }
                            this.createContractLogDetail("A1", (PO)invoice, null);
                            this.addBufferLog(0, null, null, invoice.getDocumentNo(), 318, invoice.getC_Invoice_ID());
                        }
                        iLine = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
                        PO.copyValues((PO)rLines[j], (PO)iLine);
                        iLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
                        iLine.setC_InvoiceLine_ID(0);
                        iLine.setAD_Org_ID(invoice.getAD_Org_ID());
                        iLine.setLine(linecounter * 10);
                        ++linecounter;
                        iLine.setM_InOutLine_ID(rLines[j].getM_InOutLine_ID());
                        iLine.set_ValueNoCheck("JP_RecognitionLine_ID", (Object)rLines[j].getJP_RecognitionLine_ID());
                        try {
                            iLine.saveEx(this.get_TrxName());
                        }
                        catch (AdempiereException e) {
                            this.createContractLogDetail("Z1", null, e.getMessage());
                            throw e;
                        }
                        rLines[j].setC_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
                        try {
                            rLines[j].saveEx(this.get_TrxName());
                        }
                        catch (AdempiereException e) {
                            this.createContractLogDetail("Z1", rLines[j], e.getMessage());
                            throw e;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (invoice != null && this.p_DocAction != null) {
            if (!invoice.processIt(this.p_DocAction)) {
                this.createContractLogDetail("Z2", (PO)invoice, invoice.getProcessMsg());
                throw new AdempiereException(invoice.getProcessMsg());
            }
            try {
                invoice.saveEx(this.get_TrxName());
            }
            catch (AdempiereException e) {
                this.createContractLogDetail("Z1", (PO)invoice, e.getMessage());
                throw e;
            }
        }
        return null;
    }

    private MRecognition[] getRocognitions() {
        ArrayList<MRecognition> list;
        MRecognition[] recogs;
        block6: {
            recogs = null;
            list = new ArrayList<MRecognition>();
            String sql = " SELECT r.* FROM T_Selection t INNER JOIN JP_Recognition r ON (t.T_Selection_ID = r.JP_Recognition_ID) WHERE t.AD_PInstance_ID=? ORDER BY r.DateAcct ASC, r.JP_Recognition_ID ASC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRecognition(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        recogs = new MRecognition[list.size()];
        list.toArray(recogs);
        return recogs;
    }

    private void createContractLogDetail(String ContractLogMsg, PO po, String descriptionMsg) {
        MContractLogDetail logDetail = new MContractLogDetail(this.getCtx(), 0, this.m_ContractLog.get_TrxName());
        logDetail.setJP_ContractLog_ID(this.m_ContractLog.getJP_ContractLog_ID());
        logDetail.setJP_ContractLogMsg(ContractLogMsg);
        if (descriptionMsg != null) {
            logDetail.setDescription(descriptionMsg);
        }
        logDetail.set_ValueNoCheck("AD_Table_ID", po.get_Table_ID());
        logDetail.set_ValueNoCheck("Record_ID", po.get_ID());
        if (po.get_TableName().equals("C_Order")) {
            MOrder order = (MOrder)po;
            logDetail.setC_Order_ID(order.getC_Order_ID());
            MContractContent content = MContractContent.get(this.getCtx(), order.get_ValueAsInt("JP_ContractContent_ID"));
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
        } else if (po.get_TableName().equals("JP_Recognition")) {
            MRecognition recog = (MRecognition)po;
            logDetail.setC_Order_ID(recog.getC_Order_ID());
            logDetail.setM_InOut_ID(recog.getM_InOut_ID());
            logDetail.setJP_Recognition_ID(recog.getJP_Recognition_ID());
            logDetail.setC_Invoice_ID(recog.getC_Invoice_ID());
            MContractContent content = MContractContent.get(this.getCtx(), recog.getJP_ContractContent_ID());
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
        } else if (po.get_TableName().equals("JP_RecognitionLine")) {
            MRecognitionLine rLine = (MRecognitionLine)po;
            logDetail.setC_OrderLine_ID(rLine.getC_OrderLine_ID());
            logDetail.setM_InOutLine_ID(rLine.getM_InOutLine_ID());
            logDetail.setJP_Recognition_ID(rLine.getJP_Recognition_ID());
            logDetail.setJP_RecognitionLine_ID(rLine.getJP_RecognitionLine_ID());
            logDetail.setC_InvoiceLine_ID(rLine.getC_InvoiceLine_ID());
            MContractContent content = MContractContent.get(this.getCtx(), rLine.getParent().getJP_ContractContent_ID());
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
            int JP_ContractLine_ID = rLine.getJP_ContractLine_ID();
            if (JP_ContractLine_ID > 0) {
                logDetail.setJP_ContractLine_ID(JP_ContractLine_ID);
            }
        } else if (po.get_TableName().equals("C_Invoice")) {
            MInvoice invoice = (MInvoice)po;
            logDetail.setC_Order_ID(invoice.getC_Order_ID());
            logDetail.setC_Invoice_ID(invoice.getC_Invoice_ID());
            MContractContent content = MContractContent.get(this.getCtx(), invoice.get_ValueAsInt("JP_ContractContent_ID"));
            logDetail.setJP_Contract_ID(content.getJP_Contract_ID());
            logDetail.setJP_ContractContent_ID(content.getJP_ContractContent_ID());
        }
        logDetail.saveEx(this.get_TrxName());
    }
}

