/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreateEstimationByCopyAtContract
extends SvrProcess {
    private int p_JP_Estimation_ID = 0;
    private int p_JP_Contract_ID = 0;
    private int p_C_BPartner_ID = 0;
    private MContract p_Contract = null;

    protected void prepare() {
        this.p_JP_Contract_ID = this.getRecord_ID();
        this.p_Contract = new MContract(this.getCtx(), this.p_JP_Contract_ID, this.get_TrxName());
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_Estimation_ID")) {
                    this.p_JP_Estimation_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MEstimation from_Estimation = new MEstimation(this.getCtx(), this.p_JP_Estimation_ID, this.get_TrxName());
        MEstimation to_Estimation = new MEstimation(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)from_Estimation, (PO)to_Estimation);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        to_Estimation.setJP_EstimationDate(now);
        to_Estimation.setDateOrdered(now);
        to_Estimation.setDateAcct(now);
        to_Estimation.setDatePromised(now);
        to_Estimation.setC_DocTypeTarget_ID(from_Estimation.getC_DocTypeTarget_ID());
        if (from_Estimation.getC_DocTypeTarget().isDocNoControlled()) {
            to_Estimation.setDocumentNo("");
        } else {
            to_Estimation.setDocumentNo(now.toString());
        }
        if (from_Estimation.getC_Opportunity_ID() > 0) {
            if (from_Estimation.getC_Opportunity().getC_BPartner_ID() == this.p_C_BPartner_ID) {
                to_Estimation.setC_Opportunity_ID(from_Estimation.getC_Opportunity_ID());
            } else if (this.p_C_BPartner_ID == 0 && from_Estimation.getC_Opportunity().getC_BPartner_ID() == this.p_Contract.getC_BPartner_ID()) {
                to_Estimation.setC_Opportunity_ID(from_Estimation.getC_Opportunity_ID());
            } else {
                to_Estimation.setC_Opportunity_ID(0);
            }
        }
        to_Estimation.setAD_Org_ID(this.p_Contract.getAD_Org_ID());
        this.setWarehouseOfContractContent(from_Estimation, to_Estimation);
        to_Estimation.setDocStatus("DR");
        to_Estimation.setDocAction("CO");
        to_Estimation.setLink_Order_ID(0);
        to_Estimation.setRef_Order_ID(0);
        to_Estimation.setM_InOut_ID(0);
        to_Estimation.setC_Invoice_ID(0);
        to_Estimation.setJP_Bill_ID(0);
        to_Estimation.setC_Payment_ID(0);
        to_Estimation.setM_RMA_ID(0);
        to_Estimation.setJP_Contract_ID(0);
        to_Estimation.setJP_ContractContent_ID(0);
        if (this.p_C_BPartner_ID != 0) {
            if (this.p_C_BPartner_ID == this.p_Contract.getC_BPartner_ID()) {
                to_Estimation.setC_BPartner_ID(this.p_C_BPartner_ID);
                to_Estimation.setC_BPartner_Location_ID(this.p_Contract.getC_BPartner_Location_ID());
                to_Estimation.setAD_User_ID(this.p_Contract.getAD_User_ID());
            } else {
                MBPartner bp = new MBPartner(this.getCtx(), this.p_C_BPartner_ID, this.get_TrxName());
                to_Estimation.setC_BPartner_ID(this.p_C_BPartner_ID);
                to_Estimation.setC_BPartner_Location_ID(0);
                to_Estimation.setAD_User_ID(0);
                MBPartnerLocation[] locations = bp.getLocations(false);
                if (locations.length > 0) {
                    to_Estimation.setC_BPartner_Location_ID(locations[0].getC_BPartner_Location_ID());
                }
            }
            to_Estimation.setBill_BPartner_ID(0);
            to_Estimation.setBill_Location_ID(0);
            to_Estimation.setBill_User_ID(0);
            to_Estimation.setDropShip_BPartner_ID(0);
            to_Estimation.setDropShip_Location_ID(0);
            to_Estimation.setDropShip_User_ID(0);
        }
        to_Estimation.setJP_Contract_ID(this.p_JP_Contract_ID);
        to_Estimation.saveEx(this.get_TrxName());
        int no = to_Estimation.copyLinesFrom(from_Estimation, false, false);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("copy Lines -> #" + no);
        }
        this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo")) + " : " + to_Estimation.getDocumentNo(), MEstimation.Table_ID, to_Estimation.get_ID());
        return to_Estimation.getDocumentInfo();
    }

    protected void setWarehouseOfContractContent(MEstimation from, MEstimation to) throws Exception {
        if (from.getM_Warehouse() != null && from.getM_Warehouse().getAD_Org_ID() == to.getAD_Org_ID()) {
            to.setM_Warehouse_ID(from.getM_Warehouse_ID());
        } else if (MOrgInfo.get(null, (int)to.getAD_Org_ID(), (String)this.get_TrxName()).getM_Warehouse_ID() != 0) {
            to.setM_Warehouse_ID(MOrgInfo.get(null, (int)to.getAD_Org_ID(), (String)this.get_TrxName()).getM_Warehouse_ID());
        } else {
            MWarehouse[] warehouses = MWarehouse.getForOrg((Properties)this.getCtx(), (int)from.getAD_Org_ID());
            if (warehouses.length > 0) {
                to.setM_Warehouse_ID(warehouses[0].getM_Warehouse_ID());
            } else {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"NotFound")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID") + "_" + from.getDocumentNo());
            }
        }
    }
}

