/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MInvoiceJP;
import jpiere.base.plugin.org.adempiere.model.MOrderJP;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CreateDocFromSpotContractContent
extends SvrProcess {
    private String p_DocAction = null;
    private int JP_ContractContent_ID = 0;
    private MContractContent m_ContractContent = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.JP_ContractContent_ID = this.getRecord_ID();
        this.m_ContractContent = new MContractContent(this.getCtx(), this.JP_ContractContent_ID, this.get_TrxName());
    }

    protected String doIt() throws Exception {
        if (!this.m_ContractContent.getParent().getJP_ContractType().equals("STC")) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_SpotContractOnly"));
        }
        if (this.m_ContractContent.getDocStatus().equals("RE") || this.m_ContractContent.getDocStatus().equals("VO")) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_NotValidDocStatus"));
        }
        if (this.m_ContractContent.getDocBaseType().equals("SOO") || this.m_ContractContent.getDocBaseType().equals("POO")) {
            this.createOrder();
        } else if (this.m_ContractContent.getDocBaseType().equals("ARI") || this.m_ContractContent.getDocBaseType().equals("API")) {
            this.createInvoice();
        } else {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError"));
        }
        return null;
    }

    private void createOrder() throws Exception {
        MOrderJP order = new MOrderJP(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this.m_ContractContent, (PO)order);
        order.setAD_Org_ID(this.m_ContractContent.getAD_Org_ID());
        order.setC_DocTypeTarget_ID(this.m_ContractContent.getJP_BaseDocDocType_ID());
        order.setC_DocType_ID(this.m_ContractContent.getJP_BaseDocDocType_ID());
        if (order.getC_DocType().isDocNoControlled()) {
            order.setDocumentNo(null);
        }
        order.set_ValueNoCheck("JP_Contract_ID", this.m_ContractContent.getJP_Contract_ID());
        order.set_ValueNoCheck("JP_ContractContent_ID", this.m_ContractContent.getJP_ContractContent_ID());
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setProcessed(false);
        order.saveEx(this.get_TrxName());
        MContractLine[] cLines = this.m_ContractContent.getLines();
        if (cLines.length == 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"NoLines"));
        }
        int i = 0;
        while (i < cLines.length) {
            if (cLines[i].isCreateDocLineJP()) {
                this.createOrderLine(order, cLines[i]);
            }
            ++i;
        }
        if (!Util.isEmpty((String)this.p_DocAction)) {
            order.processIt(this.p_DocAction);
            order.saveEx(this.get_TrxName());
        }
        this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo")) + " : " + order.getDocumentNo(), 259, order.getC_Order_ID());
    }

    private void createOrderLine(MOrder order, MContractLine cLine) {
        MOrderLine oLine = new MOrderLine(order);
        PO.copyValues((PO)cLine, (PO)oLine);
        oLine.setQtyEntered(cLine.getQtyEntered());
        oLine.setQtyOrdered(cLine.getQtyOrdered());
        oLine.setQtyInvoiced(Env.ZERO);
        oLine.setQtyDelivered(Env.ZERO);
        oLine.set_ValueNoCheck("JP_QtyRecognized", (Object)Env.ZERO);
        oLine.setQtyReserved(Env.ZERO);
        oLine.set_ValueNoCheck("JP_ContractLine_ID", (Object)cLine.getJP_ContractLine_ID());
        oLine.setProcessed(false);
        oLine.saveEx(this.get_TrxName());
    }

    private void createInvoice() throws Exception {
        MInvoiceJP invoice = new MInvoiceJP(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this.m_ContractContent, (PO)invoice);
        invoice.setAD_Org_ID(this.m_ContractContent.getAD_Org_ID());
        invoice.setDateInvoiced(this.m_ContractContent.getDateDoc());
        invoice.setC_DocTypeTarget_ID(this.m_ContractContent.getJP_BaseDocDocType_ID());
        invoice.setC_DocType_ID(this.m_ContractContent.getJP_BaseDocDocType_ID());
        if (invoice.getC_DocType().isDocNoControlled()) {
            invoice.setDocumentNo(null);
        }
        invoice.set_ValueNoCheck("JP_Contract_ID", this.m_ContractContent.getJP_Contract_ID());
        invoice.set_ValueNoCheck("JP_ContractContent_ID", this.m_ContractContent.getJP_ContractContent_ID());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.setProcessed(false);
        invoice.saveEx(this.get_TrxName());
        MContractLine[] cLines = this.m_ContractContent.getLines();
        if (cLines.length == 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"NoLines"));
        }
        int i = 0;
        while (i < cLines.length) {
            if (cLines[i].isCreateDocLineJP()) {
                this.createInvoiceLine(invoice, cLines[i]);
            }
            ++i;
        }
        if (!Util.isEmpty((String)this.p_DocAction)) {
            invoice.processIt(this.p_DocAction);
            invoice.saveEx(this.get_TrxName());
        }
        this.addBufferLog(0, null, null, String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo")) + " : " + invoice.getDocumentNo(), 318, invoice.getC_Invoice_ID());
    }

    private void createInvoiceLine(MInvoice invoice, MContractLine cLine) {
        MInvoiceLine iLine = new MInvoiceLine(invoice);
        PO.copyValues((PO)cLine, (PO)iLine);
        iLine.setQtyEntered(cLine.getQtyEntered());
        iLine.setQtyInvoiced(cLine.getQtyOrdered());
        iLine.set_ValueNoCheck("JP_ContractLine_ID", (Object)cLine.getJP_ContractLine_ID());
        iLine.setProcessed(false);
        iLine.saveEx(this.get_TrxName());
    }
}

