/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBankAccount;
import org.compiere.model.MDepositBatch;
import org.compiere.model.MDepositBatchLine;
import org.compiere.model.MDocType;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class CreateDepositBatch
extends SvrProcess {
    private String p_BankAccountType = null;
    private int p_C_BankAccount_ID = 0;
    private Timestamp p_DateTrx_From = null;
    private Timestamp p_DateTrx_To = null;
    private int p_C_DocType_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("BankAccountType")) {
                    this.p_BankAccountType = para[i].getParameterAsString();
                } else if (name.equals("C_BankAccount_ID")) {
                    this.p_C_BankAccount_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateTrx")) {
                    this.p_DateTrx_From = para[i].getParameterAsTimestamp();
                    this.p_DateTrx_To = para[i].getParameter_ToAsTimestamp();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_DateTrx_To != null) {
            this.p_DateTrx_To = Timestamp.valueOf(LocalDateTime.of(this.p_DateTrx_To.toLocalDateTime().toLocalDate(), LocalTime.MAX));
        }
        if (this.p_C_DocType_ID == 0) {
            this.p_C_DocType_ID = MDocType.getDocType((String)"JDB");
        }
    }

    protected String doIt() throws Exception {
        if (this.p_C_BankAccount_ID == 0) {
            MBankAccount[] m_BankAccounts;
            MBankAccount[] mBankAccountArray = m_BankAccounts = this.getBankAccounts();
            int n = m_BankAccounts.length;
            int n2 = 0;
            while (n2 < n) {
                MBankAccount account = mBankAccountArray[n2];
                this.createDepositBatch(account);
                ++n2;
            }
        } else {
            MBankAccount account = new MBankAccount(this.getCtx(), this.p_C_BankAccount_ID, this.get_TrxName());
            this.createDepositBatch(account);
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private boolean createDepositBatch(MBankAccount account) {
        ArrayList<MPayment> list;
        block8: {
            list = new ArrayList<MPayment>();
            String sql = "SELECT * FROM C_Payment WHERE C_BankAccount_ID = ? AND DateTrx >= ? AND  DateTrx <= ? AND IsActive='Y' AND IsReceipt='Y' AND DocStatus in ('CO','CL') AND AD_Client_ID= ?  AND C_DepositBatch_ID is null AND PayAmt <> 0 ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, account.getC_BankAccount_ID());
                    pstmt.setTimestamp(2, this.p_DateTrx_From);
                    pstmt.setTimestamp(3, this.p_DateTrx_To);
                    pstmt.setInt(4, this.getAD_Client_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MPayment(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() == 0) {
            return true;
        }
        MDepositBatch m_DepositBatch = new MDepositBatch(this.getCtx(), 0, this.get_TrxName());
        m_DepositBatch.setC_BankAccount_ID(account.getC_BankAccount_ID());
        m_DepositBatch.setAD_Org_ID(account.getAD_Org_ID());
        m_DepositBatch.setC_DocType_ID(this.p_C_DocType_ID);
        m_DepositBatch.setDateDeposit(this.p_DateTrx_To);
        m_DepositBatch.setDateAcct(this.p_DateTrx_To);
        m_DepositBatch.setDateDoc(this.p_DateTrx_To);
        m_DepositBatch.setIsActive(true);
        m_DepositBatch.setProcessed(false);
        m_DepositBatch.saveEx(this.get_TrxName());
        int lineNo = 0;
        for (MPayment payment : list) {
            MDepositBatchLine line = new MDepositBatchLine(this.getCtx(), 0, this.get_TrxName());
            line.setAD_Org_ID(m_DepositBatch.getAD_Org_ID());
            line.setC_DepositBatch_ID(m_DepositBatch.getC_DepositBatch_ID());
            line.setLine(lineNo += 10);
            line.setC_Payment_ID(payment.getC_Payment_ID());
            line.saveEx(this.get_TrxName());
        }
        this.addBufferLog(0, null, null, m_DepositBatch.getDocumentNo(), 200056, m_DepositBatch.getC_DepositBatch_ID());
        return true;
    }

    private MBankAccount[] getBankAccounts() {
        ArrayList<MBankAccount> list;
        block6: {
            list = new ArrayList<MBankAccount>();
            String sql = "SELECT * FROM C_BankAccount WHERE BankAccountType=? AND IsActive='Y' AND AD_Client_ID=? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setString(1, this.p_BankAccountType);
                    pstmt.setInt(2, this.getAD_Client_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MBankAccount(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MBankAccount[] m_accounts = new MBankAccount[list.size()];
        list.toArray(m_accounts);
        return m_accounts;
    }
}

