/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractContentT;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractLineT;
import jpiere.base.plugin.org.adempiere.model.MContractProcessList;
import jpiere.base.plugin.org.adempiere.model.MContractProcessRef;
import jpiere.base.plugin.org.adempiere.model.MContractT;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import jpiere.base.plugin.org.adempiere.process.AbstractCreateContractFromTemplate;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CreateContractfromEstimationAndTemplate
extends AbstractCreateContractFromTemplate {
    private int p_JP_Estimation_ID = 0;
    private int p_JP_ContractT_ID = 0;
    private int p_JP_ContractContentT_ID = 0;
    private String p_JP_ContractLineCreatePolicy = null;
    private int p_JP_Para_BPartner_ID = 0;
    private int p_JP_Para_BPartner_Location_ID = 0;
    private int p_JP_CreateTo_Contract_ID = 0;
    private MEstimation estimation = null;
    private IProcessUI processUI = null;
    private boolean isCreateSO = false;
    private boolean isOpenDialog = false;
    private boolean isAskAnswer = true;
    private String errorMsg = "";
    private String returnMsg = "";

    @Override
    protected void prepare() {
        this.p_JP_Estimation_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_CreateTo_Contract_ID")) {
                    this.p_JP_CreateTo_Contract_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractT_ID")) {
                    this.p_JP_ContractT_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractContentT_ID")) {
                    this.p_JP_ContractContentT_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractLineCreatePolicy")) {
                    this.p_JP_ContractLineCreatePolicy = para[i].getParameterAsString();
                } else if (name.equals("JP_Para_BPartner_ID")) {
                    this.p_JP_Para_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_Para_BPartner_Location_ID")) {
                    this.p_JP_Para_BPartner_Location_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        this.estimation = new MEstimation(this.getCtx(), this.p_JP_Estimation_ID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_JP_Para_BPartner_ID == 0 && this.estimation.getC_BPartner_ID() == 0) {
            this.errorMsg = String.valueOf(this.errorMsg) + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID") + System.lineSeparator();
        }
        if (this.estimation.getC_BPartner_ID() == 0) {
            this.estimation.setC_BPartner_ID(this.p_JP_Para_BPartner_ID);
        }
        if (this.p_JP_Para_BPartner_Location_ID == 0 && this.estimation.getC_BPartner_Location_ID() == 0) {
            this.errorMsg = String.valueOf(this.errorMsg) + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID") + System.lineSeparator();
        }
        if (this.estimation.getC_BPartner_Location_ID() == 0) {
            this.estimation.setC_BPartner_Location_ID(this.p_JP_Para_BPartner_Location_ID);
        }
        if (!Util.isEmpty((String)this.errorMsg)) {
            throw new Exception(this.errorMsg);
        }
        MContract[] contracts = MContract.getContractByEstimation(this.getCtx(), this.p_JP_Estimation_ID, this.get_TrxName());
        MContractContent[] contractContents = MContractContent.getContractContentByEstimation(this.getCtx(), this.p_JP_CreateTo_Contract_ID, this.p_JP_Estimation_ID, this.get_TrxName());
        if (this.p_JP_CreateTo_Contract_ID == 0 && this.processUI != null && contracts.length > 0 || this.p_JP_CreateTo_Contract_ID > 0 && this.processUI != null && contractContents.length > 0) {
            this.isOpenDialog = true;
            String msg = null;
            msg = this.p_JP_CreateTo_Contract_ID == 0 ? "JP_CreateContractFromEstimationAgain" : "JP_CreateContracContentFromEstimationAgain";
            this.processUI.ask(msg, (Callback)new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        try {
                            try {
                                CreateContractfromEstimationAndTemplate.this.returnMsg = CreateContractfromEstimationAndTemplate.this.createContract();
                            }
                            catch (Exception e) {
                                CreateContractfromEstimationAndTemplate.this.returnMsg = e.getMessage();
                                CreateContractfromEstimationAndTemplate.this.isCreateSO = true;
                            }
                        }
                        finally {
                            CreateContractfromEstimationAndTemplate.this.isCreateSO = true;
                        }
                    } else {
                        CreateContractfromEstimationAndTemplate.this.isAskAnswer = false;
                    }
                }
            });
        } else {
            this.returnMsg = this.createContract();
            this.isCreateSO = true;
        }
        while (this.isOpenDialog && this.isAskAnswer && !this.isCreateSO) {
            Thread.sleep(2000L);
        }
        if (!Util.isEmpty((String)this.returnMsg)) {
            throw new Exception(this.returnMsg);
        }
        if (this.isCreateSO) {
            this.addBufferLog(0, null, null, this.m_Contract.getDocumentNo(), MContract.Table_ID, this.m_Contract.getJP_Contract_ID());
        }
        return "";
    }

    private String createContract() throws Exception {
        MContractT contractTemplate = MContractT.get(this.getCtx(), this.p_JP_ContractT_ID);
        if (this.p_JP_CreateTo_Contract_ID == 0) {
            this.m_Contract = new MContract(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)contractTemplate, (PO)this.m_Contract);
            PO.copyValues((PO)this.estimation, (PO)this.m_Contract);
            this.m_Contract.setAD_Org_ID(this.estimation.getAD_Org_ID());
            this.m_Contract.setJP_ContractT_ID(contractTemplate.getJP_ContractT_ID());
            this.m_Contract.setC_DocType_ID(contractTemplate.getC_DocType_ID());
            this.m_Contract.setDateDoc(this.estimation.getDateOrdered());
            this.m_Contract.setDateAcct(this.estimation.getDateAcct());
            this.m_Contract.setJP_ContractPeriodDate_From(this.estimation.getDateAcct());
            if (this.p_JP_Para_BPartner_ID != 0) {
                this.m_Contract.setC_BPartner_ID(this.p_JP_Para_BPartner_ID);
            }
            if (this.p_JP_Para_BPartner_Location_ID != 0) {
                this.m_Contract.setC_BPartner_Location_ID(this.p_JP_Para_BPartner_Location_ID);
            }
            if (contractTemplate.getC_DocType().isDocNoControlled()) {
                this.m_Contract.setDocumentNo(null);
            }
            this.m_Contract.setJP_Estimation_ID(this.estimation.getJP_Estimation_ID());
            this.m_Contract.setDocStatus("DR");
            this.m_Contract.setDocAction("CO");
            this.m_Contract.setJP_ContractStatus("PR");
            try {
                this.m_Contract.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Contract_ID") + " >>> " + e.getMessage();
            }
        } else {
            this.m_Contract = new MContract(this.getCtx(), this.p_JP_CreateTo_Contract_ID, this.get_TrxName());
            if (this.m_Contract.getJP_ContractType().equals("GLC")) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_GeneralContract_NotHave_ContractContent"));
            }
            if (!this.m_Contract.getJP_ContractType().equals(MContractContentT.get(this.getCtx(), this.p_JP_ContractContentT_ID).getJP_ContractType())) {
                String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateTo_Contract_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractType");
                String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContentT_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractType");
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1});
            }
        }
        if (this.p_JP_ContractContentT_ID == 0) {
            MContractContentT[] contractContentTemplates = contractTemplate.getContractContentTemplates();
            int i = 0;
            while (i < contractContentTemplates.length) {
                try {
                    this.createContractContent(contractContentTemplates[i]);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                ++i;
            }
        } else {
            MContractContentT contractContentTemplate = MContractContentT.get(this.getCtx(), this.p_JP_ContractContentT_ID);
            if (contractContentTemplate.getJP_ContractContentT_ID() == 0) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + "  " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContentT_ID");
            }
            if (!contractContentTemplate.isSOTrx()) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + "  " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Purchase_Contract") + " - " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContentT_ID");
            }
            try {
                this.createContractContent(contractContentTemplate);
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        this.estimation.setJP_Contract_ID(this.m_Contract.getJP_Contract_ID());
        try {
            this.estimation.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Estimation_ID") + " >>> " + e.getMessage();
        }
        return "";
    }

    protected void createContractContent(MContractContentT contractContentTemplate) throws Exception {
        MContractProcessRef contractProcessRef;
        MContractProcessList[] contractProcessLists;
        MContractContent contractContent = new MContractContent(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)contractContentTemplate, (PO)contractContent);
        PO.copyValues((PO)this.estimation, (PO)contractContent);
        contractContent.setJP_Estimation_ID(this.estimation.getJP_Estimation_ID());
        contractContent.setAD_Org_ID(this.estimation.getAD_Org_ID());
        contractContent.setAD_OrgTrx_ID(this.estimation.getAD_OrgTrx_ID());
        contractContent.setJP_Contract_ID(this.m_Contract.getJP_Contract_ID());
        contractContent.setJP_ContractContentT_ID(contractContentTemplate.getJP_ContractContentT_ID());
        contractContent.setC_DocType_ID(contractContentTemplate.getC_DocType_ID());
        if (contractContent.getC_DocType().isDocNoControlled()) {
            contractContent.setDocumentNo(null);
        }
        contractContent.setJP_Contract_Acct_ID(contractContentTemplate.getJP_Contract_Acct_ID());
        if (contractContentTemplate.getC_BPartner_ID() == 0) {
            if (this.p_JP_Para_BPartner_ID != 0) {
                contractContent.setC_BPartner_ID(this.p_JP_Para_BPartner_ID);
                contractContent.setC_BPartner_Location_ID(this.p_JP_Para_BPartner_Location_ID);
            } else {
                contractContent.setC_BPartner_ID(this.m_Contract.getC_BPartner_ID());
                contractContent.setC_BPartner_Location_ID(this.m_Contract.getC_BPartner_Location_ID());
                contractContent.setAD_User_ID(this.m_Contract.getAD_User_ID());
            }
        }
        contractContent.setDateDoc(this.m_Contract.getDateDoc());
        contractContent.setDateAcct(this.m_Contract.getDateAcct());
        contractContent.setDatePromised(this.calculateDate(this.m_Contract.getDateAcct(), contractContentTemplate.getDeliveryTime_Promised()));
        contractContent.setDateInvoiced(this.m_Contract.getDateAcct());
        this.setContractContentProcDate(contractContent, contractContentTemplate);
        int JP_ContractProcessRef_ID = contractContentTemplate.getJP_ContractProcessRef_ID();
        if (JP_ContractProcessRef_ID > 0 && (contractProcessLists = (contractProcessRef = MContractProcessRef.get(this.getCtx(), JP_ContractProcessRef_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
            contractContent.setJP_ContractProcess_ID(contractProcessLists[0].getJP_ContractProcess_ID());
        }
        contractContent.setTotalLines(Env.ZERO);
        contractContent.setDocStatus("DR");
        contractContent.setDocAction("CO");
        contractContent.setJP_ContractProcStatus("UN");
        contractContent.setC_Currency_ID(contractContent.getM_PriceList().getC_Currency_ID());
        this.setWarehouseOfContractContent(contractContentTemplate, contractContent);
        try {
            contractContent.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContentT_ID") + "_" + contractContentTemplate.getValue() + " >>> " + e.getMessage());
        }
        try {
            if (this.p_JP_ContractLineCreatePolicy.equals("EL") && this.p_JP_ContractContentT_ID > 0) {
                this.createContractLineFromEstimation(contractContent, contractContentTemplate);
            } else {
                this.createContractLineFromTemplate(contractContent, contractContentTemplate);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContentT_ID") + "_" + contractContentTemplate.getValue() + " >>> " + e.getMessage());
        }
    }

    protected void createContractLineFromEstimation(MContractContent contractContent, MContractContentT contractContentTemplate) throws Exception {
        MEstimationLine[] eLines = this.estimation.getLines(true, null);
        int i = 0;
        while (i < eLines.length) {
            MContractLine contractLine = new MContractLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)eLines[i], (PO)contractLine);
            contractLine.setAD_Org_ID(contractContent.getAD_Org_ID());
            contractLine.setAD_OrgTrx_ID(contractContent.getAD_OrgTrx_ID());
            contractLine.setDateOrdered(contractContent.getDateOrdered());
            contractLine.setJP_ContractContent_ID(contractContent.getJP_ContractContent_ID());
            contractLine.setQtyEntered(eLines[i].getQtyEntered());
            contractLine.setC_UOM_ID(eLines[i].getC_UOM_ID());
            contractLine.setQtyOrdered(eLines[i].getQtyOrdered());
            contractLine.setPriceEntered(eLines[i].getPriceEntered());
            contractLine.setPriceActual(eLines[i].getPriceActual());
            contractLine.setC_Tax_ID(eLines[i].getC_Tax_ID());
            contractLine.setLineNetAmt(eLines[i].getLineNetAmt());
            MContractLineT contractLineT = this.getContractLineTemplate(eLines[i], contractContentTemplate);
            if (contractLineT != null) {
                this.setContractLineFromTemplate(contractLine, contractLineT);
                BigDecimal coefficient = Env.ONE;
                if (contractLine.getQtyOrdered().compareTo(Env.ZERO) != 0 && contractLineT.getQtyOrdered().compareTo(Env.ZERO) != 0) {
                    coefficient = contractLine.getQtyOrdered().divide(contractLineT.getQtyOrdered(), 2, RoundingMode.HALF_UP);
                }
                if (!Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy()) && (contractContent.getJP_CreateDerivativeDocPolicy().equals("BT") || contractContent.getJP_CreateDerivativeDocPolicy().equals("IO"))) {
                    contractLine.setJP_DerivativeDocPolicy_InOut(contractLineT.getJP_DerivativeDocPolicy_InOut());
                    if (contractLine.getM_Product_ID() > 0) {
                        contractLine.setMovementQty(contractLineT.getMovementQty().multiply(coefficient).divide(Env.ONE, contractLine.getM_Product().getC_UOM().getStdPrecision(), RoundingMode.HALF_UP));
                    } else {
                        contractLine.setMovementQty(contractLineT.getMovementQty().multiply(coefficient).divide(Env.ONE, eLines[i].getC_UOM().getStdPrecision(), RoundingMode.HALF_UP));
                    }
                }
                if (!Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy()) && (contractContent.getJP_CreateDerivativeDocPolicy().equals("BT") || contractContent.getJP_CreateDerivativeDocPolicy().equals("IV"))) {
                    contractLine.setJP_DerivativeDocPolicy_Inv(contractLineT.getJP_DerivativeDocPolicy_Inv());
                    if (contractLine.getM_Product_ID() > 0) {
                        contractLine.setQtyInvoiced(contractLineT.getQtyInvoiced().multiply(coefficient).divide(Env.ONE, contractLine.getM_Product().getC_UOM().getStdPrecision(), RoundingMode.HALF_UP));
                    } else {
                        contractLine.setQtyInvoiced(contractLineT.getQtyInvoiced().multiply(coefficient).divide(Env.ONE, eLines[i].getC_UOM().getStdPrecision(), RoundingMode.HALF_UP));
                    }
                }
            } else {
                if (!Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy()) && contractContent.getJP_CreateDerivativeDocPolicy().equals("MA") || Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy())) {
                    contractLine.setJP_BaseDocLinePolicy("DD");
                    contractLine.getParent().setJP_ContractCalender_ID(0);
                }
                if (!Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy()) && (contractContent.getJP_CreateDerivativeDocPolicy().equals("BT") || contractContent.getJP_CreateDerivativeDocPolicy().equals("IO"))) {
                    contractLine.setJP_DerivativeDocPolicy_InOut("DD");
                    contractLine.getParent().setJP_ContractCalender_ID(0);
                    contractLine.setMovementQty(Env.ZERO);
                }
                if (!Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy()) && (contractContent.getJP_CreateDerivativeDocPolicy().equals("BT") || contractContent.getJP_CreateDerivativeDocPolicy().equals("IV"))) {
                    contractLine.setJP_DerivativeDocPolicy_Inv("DD");
                    contractLine.getParent().setJP_ContractCalender_ID(0);
                    contractLine.setQtyInvoiced(Env.ZERO);
                }
            }
            try {
                contractLine.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_EstimationLine_ID") + "_" + eLines[i].getLine() + " >>> " + e.getMessage());
            }
            ++i;
        }
    }

    private MContractLineT getContractLineTemplate(MEstimationLine eLine, MContractContentT contractContentTemplate) {
        block31: {
            ResultSet rs;
            CPreparedStatement pstmt;
            block30: {
                MContractLineT mContractLineT;
                MContractLineT[] lineTemplates = contractContentTemplate.getContractLineTemplates();
                if (eLine.getM_Product_ID() > 0) {
                    block27: {
                        ResultSet rs2;
                        CPreparedStatement pstmt2;
                        block26: {
                            MContractLineT mContractLineT2;
                            int i = 0;
                            while (i < lineTemplates.length) {
                                if (eLine.getM_Product_ID() == lineTemplates[i].getM_Product_ID()) {
                                    return lineTemplates[i];
                                }
                                ++i;
                            }
                            StringBuffer sql = new StringBuffer("SELECT * FROM JP_ContractLineT WHERE M_Product_ID=? ").append(" AND (AD_Org_ID = ? OR AD_Org_ID = 0) AND JP_ContractType = ? AND IsSOTrx = ? AND DocBaseType = ? AND M_PriceList_ID = ? ").append(" AND JP_ContractContentT_ID IS NULL AND IsActive='Y'");
                            if (contractContentTemplate.getDocBaseType().equals("SOO") || contractContentTemplate.getDocBaseType().equals("POO")) {
                                sql.append(" AND OrderType = ? ");
                            }
                            sql.append(" ORDER BY AD_Org_ID DESC ");
                            pstmt2 = null;
                            rs2 = null;
                            try {
                                pstmt2 = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                                pstmt2.setInt(1, eLine.getM_Product_ID());
                                pstmt2.setInt(2, eLine.getAD_Org_ID());
                                pstmt2.setString(3, contractContentTemplate.getJP_ContractType());
                                pstmt2.setString(4, "Y");
                                pstmt2.setString(5, contractContentTemplate.getDocBaseType());
                                pstmt2.setInt(6, contractContentTemplate.getM_PriceList_ID());
                                if (contractContentTemplate.getDocBaseType().equals("SOO") || contractContentTemplate.getDocBaseType().equals("POO")) {
                                    pstmt2.setString(7, contractContentTemplate.getOrderType());
                                }
                                if (!(rs2 = pstmt2.executeQuery()).next()) break block26;
                                mContractLineT2 = new MContractLineT(this.getCtx(), rs2, this.get_TrxName());
                            }
                            catch (Exception e) {
                                try {
                                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    DB.close(rs2, pstmt2);
                                    rs2 = null;
                                    pstmt2 = null;
                                    throw throwable;
                                }
                                DB.close(rs2, (Statement)pstmt2);
                                rs2 = null;
                                pstmt2 = null;
                                break block27;
                            }
                            DB.close((ResultSet)rs2, (Statement)pstmt2);
                            rs2 = null;
                            pstmt2 = null;
                            return mContractLineT2;
                        }
                        DB.close((ResultSet)rs2, (Statement)pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                    }
                    return null;
                }
                if (eLine.getC_Charge_ID() > 0) {
                    block29: {
                        ResultSet rs3;
                        CPreparedStatement pstmt3;
                        block28: {
                            MContractLineT mContractLineT3;
                            int i = 0;
                            while (i < lineTemplates.length) {
                                if (eLine.getC_Charge_ID() == lineTemplates[i].getC_Charge_ID()) {
                                    return lineTemplates[i];
                                }
                                ++i;
                            }
                            StringBuffer sql = new StringBuffer("SELECT * FROM JP_ContractLineT WHERE C_Charge_ID=? ").append(" AND (AD_Org_ID = ? OR AD_Org_ID = 0) AND JP_ContractType = ? AND IsSOTrx = ? AND DocBaseType = ? AND M_PriceList_ID = ? ").append(" AND JP_ContractContentT_ID IS NULL AND IsActive='Y'");
                            if (contractContentTemplate.getDocBaseType().equals("SOO") || contractContentTemplate.getDocBaseType().equals("POO")) {
                                sql.append(" AND OrderType = ? ");
                            }
                            sql.append(" ORDER BY AD_Org_ID DESC ");
                            pstmt3 = null;
                            rs3 = null;
                            try {
                                pstmt3 = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                                pstmt3.setInt(1, eLine.getC_Charge_ID());
                                pstmt3.setInt(2, eLine.getAD_Org_ID());
                                pstmt3.setString(3, contractContentTemplate.getJP_ContractType());
                                pstmt3.setString(4, "Y");
                                pstmt3.setString(5, contractContentTemplate.getDocBaseType());
                                pstmt3.setInt(6, contractContentTemplate.getM_PriceList_ID());
                                if (contractContentTemplate.getDocBaseType().equals("SOO") || contractContentTemplate.getDocBaseType().equals("POO")) {
                                    pstmt3.setString(7, contractContentTemplate.getOrderType());
                                }
                                if (!(rs3 = pstmt3.executeQuery()).next()) break block28;
                                mContractLineT3 = new MContractLineT(this.getCtx(), rs3, this.get_TrxName());
                            }
                            catch (Exception e) {
                                try {
                                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    DB.close(rs3, pstmt3);
                                    rs3 = null;
                                    pstmt3 = null;
                                    throw throwable;
                                }
                                DB.close(rs3, (Statement)pstmt3);
                                rs3 = null;
                                pstmt3 = null;
                                break block29;
                            }
                            DB.close((ResultSet)rs3, (Statement)pstmt3);
                            rs3 = null;
                            pstmt3 = null;
                            return mContractLineT3;
                        }
                        DB.close((ResultSet)rs3, (Statement)pstmt3);
                        rs3 = null;
                        pstmt3 = null;
                    }
                    return null;
                }
                int i = 0;
                while (i < lineTemplates.length) {
                    if (eLine.getM_Product_ID() == lineTemplates[i].getM_Product_ID() && eLine.getC_Charge_ID() == lineTemplates[i].getC_Charge_ID()) {
                        return lineTemplates[i];
                    }
                    ++i;
                }
                StringBuffer sql = new StringBuffer("SELECT * FROM JP_ContractLineT WHERE M_Product_ID IS NULL AND C_Charge_ID IS NULL ").append(" AND (AD_Org_ID = ? OR AD_Org_ID = 0) AND JP_ContractType = ? AND IsSOTrx = ? AND DocBaseType = ? AND M_PriceList_ID = ? ").append(" AND JP_ContractContentT_ID IS NULL AND IsActive='Y'");
                if (contractContentTemplate.getDocBaseType().equals("SOO") || contractContentTemplate.getDocBaseType().equals("POO")) {
                    sql.append(" AND OrderType = ? ");
                }
                sql.append(" ORDER BY AD_Org_ID DESC ");
                pstmt = null;
                rs = null;
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, eLine.getAD_Org_ID());
                    pstmt.setString(2, contractContentTemplate.getJP_ContractType());
                    pstmt.setString(3, "Y");
                    pstmt.setString(4, contractContentTemplate.getDocBaseType());
                    pstmt.setInt(5, contractContentTemplate.getM_PriceList_ID());
                    if (contractContentTemplate.getDocBaseType().equals("SOO") || contractContentTemplate.getDocBaseType().equals("POO")) {
                        pstmt.setString(6, contractContentTemplate.getOrderType());
                    }
                    if (!(rs = pstmt.executeQuery()).next()) break block30;
                    mContractLineT = new MContractLineT(this.getCtx(), rs, this.get_TrxName());
                }
                catch (Exception e) {
                    try {
                        this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block31;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return mContractLineT;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return null;
    }

    protected void createContractLineFromTemplate(MContractContent contractContent, MContractContentT template) throws Exception {
        MContractLineT[] m_ContractLineTemplates = template.getContractLineTemplates();
        int i = 0;
        while (i < m_ContractLineTemplates.length) {
            MContractLine contractLine = new MContractLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)m_ContractLineTemplates[i], (PO)contractLine);
            contractLine.setAD_Org_ID(contractContent.getAD_Org_ID());
            contractLine.setAD_OrgTrx_ID(contractContent.getAD_OrgTrx_ID());
            contractLine.setDateOrdered(contractContent.getDateOrdered());
            contractLine.setJP_ContractContent_ID(contractContent.getJP_ContractContent_ID());
            this.setContractLineFromTemplate(contractLine, m_ContractLineTemplates[i]);
            try {
                contractLine.saveEx(this.get_TrxName());
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"CopyFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractLineT_ID") + "_" + m_ContractLineTemplates[i].getLine() + " >>> " + e.getMessage());
            }
            ++i;
        }
    }

    private void setContractLineFromTemplate(MContractLine contrcatLine, MContractLineT contractLineT) {
        MContractProcessRef contractProcessRef;
        MContractProcessList[] contractProcessLists;
        int JP_ContractProcRef_Inv_ID;
        MContractProcessRef contractProcessRef2;
        MContractProcessList[] contractProcessLists2;
        int JP_ContractProcRef_InOut_ID;
        int JP_ContractCalRef_Inv_ID;
        int JP_ContractCalRef_InOut_ID;
        contrcatLine.setJP_ContractLineT_ID(contractLineT.getJP_ContractLineT_ID());
        contrcatLine.setDatePromised(this.calculateDate(contrcatLine.getParent().getDateAcct(), contractLineT.getDeliveryTime_Promised()));
        contrcatLine.setJP_BaseDocLinePolicy(contractLineT.getJP_BaseDocLinePolicy());
        contrcatLine.setJP_DerivativeDocPolicy_InOut(contractLineT.getJP_DerivativeDocPolicy_InOut());
        contrcatLine.setJP_DerivativeDocPolicy_Inv(contractLineT.getJP_DerivativeDocPolicy_Inv());
        if (contrcatLine.getJP_BaseDocLinePolicy() != null) {
            this.setBaseDocLineProcPeriod(contrcatLine, contractLineT);
        }
        if ((JP_ContractCalRef_InOut_ID = contractLineT.getJP_ContractCalRef_InOut_ID()) > 0 && !Util.isEmpty((String)contrcatLine.getParent().getJP_CreateDerivativeDocPolicy())) {
            this.setDerivativeInOutLineProcPeriod(contrcatLine, contractLineT);
        }
        if ((JP_ContractCalRef_Inv_ID = contractLineT.getJP_ContractCalRef_Inv_ID()) > 0 && !Util.isEmpty((String)contrcatLine.getParent().getJP_CreateDerivativeDocPolicy())) {
            this.setDerivativeInvoiceLineProcPeriod(contrcatLine, contractLineT);
        }
        if ((JP_ContractProcRef_InOut_ID = contractLineT.getJP_ContractProcRef_InOut_ID()) > 0 && (contractProcessLists2 = (contractProcessRef2 = MContractProcessRef.get(this.getCtx(), JP_ContractProcRef_InOut_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
            contrcatLine.setJP_ContractProcess_InOut_ID(contractProcessLists2[0].getJP_ContractProcess_ID());
        }
        if ((JP_ContractProcRef_Inv_ID = contractLineT.getJP_ContractProcRef_Inv_ID()) > 0 && (contractProcessLists = (contractProcessRef = MContractProcessRef.get(this.getCtx(), JP_ContractProcRef_Inv_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
            contrcatLine.setJP_ContractProcess_Inv_ID(contractProcessLists[0].getJP_ContractProcess_ID());
        }
    }
}

